source parray.tcl
source stooop.tcl
namespace import stooop::*

### check basic cloning operation with array members

# expected output:

## a::(1,y) = 1
## a::(2,y) = 1
## a::1x(0) = 0
## a::2x(0) = 0
## A::(3,y) = 1
## A::(4,y) = 1
## A::3x(0) = 0
## A::4x(0) = 0

class a {}
proc a::a {this} {
    variable ${this}x
    set a::${this}x(0) 0
    set a::($this,y) 1
}
proc a::a {this copy} {
    variable ${this}x
    array set a::${this}x [array get a::${copy}x]
    set a::($this,y) $a::($copy,y)
}
new [new a]
printArrays a:: a::1x a::2x

class A {
    proc A {this} {
        variable ${this}x
        set A::${this}x(0) 0
        set A::($this,y) 1
    }
    proc A {this copy} {
        variable ${this}x
        array set A::${this}x [array get A::${copy}x]
        set A::($this,y) $A::($copy,y)
    }
}
new [new A]
printArrays A:: A::3x A::4x
