source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that variable arguments in derived class work with base class constructor constant arguments

# expected output:

## a::a 1 {1 2} 3
## b::b 1 x y {1 2} 3
## a::(1,_derived) = b
## a::(1,m) = {1 2} 3

## A::A 2 {1 2} 3
## B::B 2 x y {1 2} 3
## A::(2,_derived) = B
## A::(2,m) = {1 2} 3

class a {}
proc a::a {this p} {
    puts "a::a $this $p"
    set a::($this,m) $p
}
proc a::~a {this} {}
class b {}
proc b::b {this p args} a {$args} {
    puts "b::b $this $p $args"
}
proc b::~b {this} {}
new b {x y} {1 2} 3
printArrays a::

class A {
    proc A {this p} {
        puts "A::A $this $p"
        set A::($this,m) $p
    }
    proc ~A {this} {}
}
class B {
    proc B {this p args} A {$args} {
        puts "B::B $this $p $args"
    }
    proc ~B {this} {}
}
new B {x y} {1 2} 3
printArrays A::
