source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that variable arguments in derived class work with base class constructor constant arguments

# expected output:

## a::a 1 x y z
## b::b 1 x y {1 2} 3
## a::(1,_derived) = b
## a::(1,m) = z

## A::A 2 x y z
## B::B 2 x y {1 2} 3
## A::(2,_derived) = B
## A::(2,m) = z

class a {}
proc a::a {this p args} {
    puts "a::a $this $p $args"
    set a::($this,m) [lindex $args 0]
}
proc a::~a {this} {}
class b {}
proc b::b {this p args} a {$p z} {
    puts "b::b $this $p $args"
    set b::($this,n) [lindex $args 0]
}
proc b::~b {this} {}
new b {x y} {1 2} 3
printArrays a::

class A {
    proc A {this p args} {
        puts "A::A $this $p $args"
        set A::($this,m) [lindex $args 0]
    }
    proc ~A {this} {}
}
class B {
    proc B {this p args} A {$p z} {
        puts "B::B $this $p $args"
        set B::($this,n) [lindex $args 0]
    }
    proc ~B {this} {}
}
new B {x y} {1 2} 3
printArrays A::
