source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that construction, copy and deletion work transparently for variable context

# expected output:
## q(0) = 0
## q(0) = 0
## q(0) = 0
## q(0) = 1
## q(0) = 1
## q(0) = 1

class a {}
proc a::a {this p} {
    upvar $p q
    printArrays q
}
proc a::a {this copy} {
    upvar d q
    printArrays q
}
proc a::~a {this} {
    upvar d q
    printArrays q
}
set d(0) 0
set o [new a d]
new $o
delete $o

class A {
    proc A {this p} {
        upvar $p q
        printArrays q
    }
    proc A {this copy} {
        upvar d q
        printArrays q
    }
    proc ~A {this} {
        upvar d q
        printArrays q
    }
}
set d(0) 1
set o [new A d]
new $o
delete $o
