source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## a::(1,_derived) = b
## a::(1,m) = x y
## b::(1,n) = z
## b::~b 1
## a::~a 1

## A::A 2
## B::B 2
## A::(2,_derived) = B
## A::(2,m) = x y
## B::(2,n) = z
## B::~B 2
## A::~A 2

class a {}
proc a::a {this p} {
    puts "a::a $this"
    set a::($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p q} a {$p} {
    puts "b::b $this"
    set b::($this,n) $q
}
proc b::~b {this} {
    puts "b::~b $this"
}
set o [new b {x y} z]
printArrays a:: b::
delete $o
printArrays a:: b::

class A {
    proc A {this p} {
        puts "A::A $this"
        set A::($this,m) $p
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p q} A {$p} {
        puts "B::B $this"
        set B::($this,n) $q
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
set o [new B {x y} z]
printArrays A:: B::
delete $o
printArrays A:: B::
