source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## a::~a 1
## a::a 2
## b::b 2
## b::~b 2
## a::~a 2
## a::a 3
## b::b 3
## c::c 3
## c::~c 3
## b::~b 3
## a::~a 3

## A::A 4
## A::~A 4
## A::A 5
## B::B 5
## B::~B 5
## A::~A 5
## A::A 6
## B::B 6
## C::C 6
## C::~C 6
## B::~B 6
## A::~A 6

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
class c {}
proc c::c {this} b {} {
    puts "c::c $this"
}
proc c::~c {this} {
    puts "c::~c $this"
}
delete [new a]
delete [new b]
delete [new c]

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
class C {
    proc C {this} B {} {
        puts "C::C $this"
    }
    proc ~C {this} {
        puts "C::~C $this"
    }
}
delete [new A]
delete [new B]
delete [new C]
