if {[catch {package require stooop 3.0}]} {
set rcsId {$Id: stooop.tcl,v 3.22 1997/08/19 21:07:11 jfontain Exp $}

package provide stooop 3.0

catch {rename proc _proc}

namespace eval ::stooop {
    namespace export class virtual
}

if {[llength [info commands ::stooop::new]]==0} {

    namespace eval ::stooop {
        namespace export new delete classof
        if {![info exists newId]} {
            variable newId 0
        }
    }

    _proc ::stooop::new {classOrId args} {
        variable newId
        variable class

        if {[scan $classOrId %d dummy]==0} {
            set class([set id [incr newId]]) $classOrId
            uplevel ::${classOrId}::$classOrId $id $args
        } else {
            if {[catch {set class([set id [incr newId]]) $class($classOrId)}]} {
                error "invalid object identifier $classOrId"
            }
            uplevel ::$class($classOrId)::_copy $id $classOrId
        }
        return $id
    }

    _proc ::stooop::delete {args} {
        variable class

        foreach id $args {
            _delete $class($id) $id
            unset class($id)
        }
    }

    _proc ::stooop::_delete {class id} {
        uplevel 2 ::${class}::~$class $id
        foreach name [array names ::${class}:: $id,*] {
            unset ::${class}::($name)
        }
    }

    _proc ::stooop::classof {id} {
        variable class

        return $class($id)
    }

    _proc ::stooop::copy {class from to} {
        set index [string length $from]
        foreach name [array names ::${class}:: $from,*] {
            set ::${class}::($to[string range $name $index end]) [set ::${class}::($name)]
        }
    }

}

_proc ::stooop::class {args} {
    variable declaring
    variable declared

    set declaring [lindex $args 0]
    if {[string match *::* $declaring]} {
        error "class $declaring name must not be qualified"
    }
    uplevel namespace eval ::$declaring [list "::variable {}\n[lindex $args end]"]
    set declared($declaring) {}
    unset declaring
}

_proc ::stooop::virtual {keyword name arguments args} {
    variable declaring

    if {![regexp {^(::)?proc$} $keyword]} {
        error "virtual operator works only on proc, not $keyword"
    }
    if {[catch {set declaring} class]} {
        if {![regexp {^(.+)::(.+)$} $name dummy class procedure]} {
            error "$name is not a valid member procedure name"
        }
    } else {
        set procedure $name
    }
    if {[string compare $class $procedure]==0} {
        error "cannot make class $class constructor virtual"
    }
    if {[string compare ~$class $procedure]==0} {
        error "cannot make class $class destructor virtual"
    }
    if {[string compare [lindex $arguments 0] this]!=0} {
        error "cannot make static procedure $procedure of class $class virtual"
    }
    variable pureVirtual
    set pureVirtual [expr {[llength $args]==0}]
    proc $name $arguments [lindex $args 0]
    unset pureVirtual
}

_proc proc {procedure arguments args} {
    if {
        [catch {set ::stooop::declaring} class]&&
        (![regexp {^([^:]+)::(.+)$} $procedure dummy class procedure]||![info exists ::stooop::declared($class)])
    } {
        uplevel _proc [list $procedure $arguments] $args
        return
    }

    if {[llength $args]==0} {
        error "missing body for ${class}::$procedure"
    }
    if {[string match *::* $procedure]} {
        error "${class}::$procedure procedure member part $procedure must not be qualified"
    }
    if {[string compare $class $procedure]==0} {
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class constructor first argument must be this"
        }
        if {[string compare [lindex $arguments 1] copy]==0} {
            if {[llength $arguments]!=2} {
                error "class $class copy constructor must have 2 arguments exactly"
            }
            if {[catch {info body ::${class}::$class}]} {
                error "class $class copy constructor defined before constructor"
            }
            eval ::stooop::constructorDeclaration $class 1 \{$arguments\} $args
        } else {
            eval ::stooop::constructorDeclaration $class 0 \{$arguments\} $args
            ::stooop::generateDefaultCopyConstructor $class
        }
    } elseif {[string compare ~$class $procedure]==0} {
        if {[llength $arguments]!=1} {
            error "class $class destructor must have 1 argument exactly"
        }
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class destructor argument must be this"
        }
        if {[catch {info body ::${class}::$class}]} {
            error "class $class destructor defined before constructor"
        }
        ::stooop::destructorDeclaration $class $arguments [lindex $args 0]
    } else {
        if {[catch {info body ::${class}::$class}]} {
            error "class $class member procedure $procedure defined before constructor"
        }
        ::stooop::memberProcedureDeclaration $class $procedure $arguments [lindex $args 0]
    }
}

_proc ::stooop::constructorDeclaration {class copy arguments args} {
    variable bases
    variable variable

    set number [llength $args]
    if {($number%2)==0} {
        error "bad $class constructor declaration, a base class, contructor arguments or body may be missing"
    }

    if {[string compare [lindex $arguments end] args]==0} {
        set variable($class) {}
    }
    if {!$copy} {
        set bases($class) {}
    }
    foreach {base baseArguments} [lrange $args 0 [expr {$number-2}]] {
        if {!$copy} {
            if {[lsearch -exact $bases($class) $base]>=0} {
                error "class $class directly inherits from class $base more than once"
            }
            lappend bases($class) $base
            catch {::${base}::$base}
        }
        regsub -all \n $baseArguments {} constructorArguments($base)
    }

    set constructorBody \
"::variable {}
"
    if {[llength $bases($class)]>0} {
        foreach base $bases($class) {
            if {[string compare $class $base]==0} {
                error "class $class cannot be derived from itself"
            }
            if {[catch {info body ::${base}::$base}]} {
                error "class $class constructor defined before base class $base constructor"
            }
        }
        if {[info exists variable($class)]} {
            foreach base $bases($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                if {[info exists variable($base)]&&([string first {$args} $constructorArguments($base)]>=0)} {
                    append constructorBody \
"::set _list \[::list $constructorArguments($base)\]
::eval ::${base}::$base \$this \[::lrange \$_list 0 \[::expr {\[::llength \$_list\]-2}\]\] \[::lindex \$_list end\]
::unset _list
::set ::${base}::(\$this,_derived) $class
"
                } else {
                    append constructorBody \
"::${base}::$base \$this $constructorArguments($base)
::set ::${base}::(\$this,_derived) $class
"
                }
            }
        } else {
            foreach base $bases($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                append constructorBody \
"::${base}::$base \$this $constructorArguments($base)
::set ::${base}::(\$this,_derived) $class
"
            }
        }
    }
    if {$copy} {
        append constructorBody \
"::catch {::set ::${class}::(\$this,_derived) \[::set ::${class}::(\$[::lindex $arguments 1],_derived)\]}
"
    }
    append constructorBody [lindex $args end]
    if {$copy} {
        _proc ::${class}::_copy $arguments $constructorBody
    } else {
        _proc ::${class}::$class $arguments $constructorBody
    }
}

_proc ::stooop::destructorDeclaration {class arguments body} {
    variable bases

    set body \
"::variable {}
$body
"
    for {set index [expr {[llength $bases($class)]-1}]} {$index>=0} {incr index -1} {
        set base [lindex $bases($class) $index]
        append body \
"::stooop::_delete $base \$this
"
    }
    _proc ::${class}::~$class $arguments $body
}

_proc ::stooop::memberProcedureDeclaration {class procedure arguments body} {
    variable pureVirtual

    if {[info exists pureVirtual]} {
        if {$pureVirtual} {
            _proc ::${class}::$procedure $arguments \
"::variable {}
::eval \$::${class}::(\$this,_derived)::$procedure \[::lrange \[::info level 0\] 1 end\]
"
        } else {
            _proc ::${class}::_$procedure $arguments \
"::variable {}
$body
"
            _proc ::${class}::$procedure $arguments \
"::variable {}
if {!\[::catch {::info body \$::${class}::(\$this,_derived)::$procedure}\]} {
::return \[::eval \$::${class}::(\$this,_derived)::$procedure \[::lrange \[::info level 0\] 1 end\]\]
}
::eval ::${class}::_$procedure \[::lrange \[::info level 0\] 1 end\]
"
        }
    } else {
        _proc ::${class}::$procedure $arguments \
"::variable {}
$body
"
    }
}

_proc ::stooop::generateDefaultCopyConstructor {class} {
    variable bases

    foreach base $bases($class) {
        append body \
"::${base}::_copy \$this \$sibling
"
    }
    append body \
"::stooop::copy $class \$sibling \$this
"
    _proc ::${class}::_copy {this sibling} $body
}
}
namespace import stooop::*

class graphic {
    proc graphic {this canvas item} {
        set graphic::($this,canvas) $canvas
        set graphic::($this,item) $item
        $canvas bind $item <Button1-Motion> "graphic::moveTo $this %x %y"
        $canvas bind $item <ButtonRelease-1> "capture $this"
    }

    proc ~graphic {this} {
        $graphic::($this,canvas) delete $graphic::($this,item)
    }

    virtual proc add {this object}

    virtual proc moveBy {this x y} {
        $graphic::($this,canvas) move $graphic::($this,item) $x $y
    }

    virtual proc moveTo {this x y} {
        set coordinates [$graphic::($this,canvas) coords $graphic::($this,item)]
        $graphic::($this,canvas) move $graphic::($this,item) [expr {$x-[lindex $coordinates 0]}] [expr {$y-[lindex $coordinates 1]}]
    }
}

class picture {
    proc picture {this canvas} graphic {
        $canvas [$canvas create rectangle 0 0 100 80 -outline red -width 3]
    } {
        set picture::($this,graphics) {}
    }

    proc ~picture {this} {}

    proc add {this object} {
        if {$object==$this} {
            return 0
        }
        set coordinates [$graphic::($this,canvas) coords $graphic::($object,item)]
        set x [lindex $coordinates 0]
        set y [lindex $coordinates 1]
        set box [$graphic::($this,canvas) bbox $graphic::($this,item)]
        if {($x>=[lindex $box 0])&&($x<=[lindex $box 2])&&($y>=[lindex $box 1])&&($y<=[lindex $box 3])} {
            if {[lsearch -exact $picture::($this,graphics) $object]<0} {
                lappend picture::($this,graphics) $object
            }
            return 1
        }
        return 0
    }

    proc moveBy {this x y} {
        foreach object $picture::($this,graphics) {
            graphic::moveBy $object $x $y
        }
        graphic::_moveBy $this $x $y
    }

    proc moveTo {this x y} {
        set coordinates [$graphic::($this,canvas) coords $graphic::($this,item)]
        picture::moveBy $this [expr {$x-[lindex $coordinates 0]}] [expr {$y-[lindex $coordinates 1]}]
    }
}

class oval {
    proc oval {this canvas} graphic {
        $canvas [$canvas create oval 0 0 22 12 -fill green]
    } {}

    proc ~oval {this} {}

    proc add {this object} {return 0}
}

class rectangle {
    proc rectangle {this canvas} graphic {
        $canvas [$canvas create rectangle 0 0 20 10 -fill cyan]
    } {}

    proc ~rectangle {this} {}

    proc add {this object} {return 0}
}

set graphics {}

proc capture {moved} {
    global graphics

    foreach object $graphics {
        if {[graphic::add $object $moved]} {
            return 1
        }
    }
    return 0
}


bind . <q> exit

set canvas [canvas .canvas -highlightthickness 0 -width 500 -height 300]
pack $canvas -fill both -expand 1

label .create -text Create:
button .picture -text Picture -command {lappend graphics [new picture $canvas]}
button .rectangle -text Rectangle -command {lappend graphics [new rectangle $canvas]}
button .oval -text Oval -command {lappend graphics [new oval $canvas]}
button .exit -text Exit -command exit

button .clear -text Clear -command {
    eval delete $graphics
    set graphics {}
}

pack .create .picture .rectangle .oval -side left
pack .exit .clear -side right

