/*
 * tkMain.c --
 *
 *      This file contains a generic main program for Tk-based applications.
 *      It can be used as-is for many applications, just by supplying a
 *      different Tcl_AppInit procedure for each specific application.
 *      Or, it can be used as a template for creating new main programs
 *      for Tk applications.
 *
 * Copyright (c) 1990-1994 The Regents of the University of California.
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */
       
static char sccsid[] = "@(#) tkMain.c 1.109 95/01/04 09:34:58";
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>
#ifdef NO_STDLIB_H
#   include "compat/stdlib.h"
#else
#   include <stdlib.h>
#endif
#include <tclExtend.h>

#ifdef NEED_MATHERR
extern int matherr();
int *tclDummyMathPtr = (int *) matherr;
#endif

/*
 * Declarations for various library procedures and variables (don't want
 * to include tkInt.h or tkPort.h here, because people might copy this
 * file out of the Tk source directory to make their own modified versions).
 * Note: don't declare "exit" here even though a declaration is really
 * needed, because it will conflict with a declaration elsewhere on
 * some systems.
 */
       
extern int              isatty _ANSI_ARGS_((int fd));
extern int              read _ANSI_ARGS_((int fd, char *buf, size_t size));
extern char *           strrchr _ANSI_ARGS_((CONST char *string, int c));
       
/*
 * Global variables used by the main program:
 */

#ifndef NO_X11
static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
#endif
static Tcl_Interp *interp;	/* Interpreter for this application. */
char *tcl_RcFileName = NULL;	/* Name of a user-specific startup script
				 * to source if the application is being run
				 * interactively (e.g. "~/.wishrc").  Set
				 * by Tcl_AppInit.  NULL means don't source
				 * anything ever. */
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */
static char updateCmd[] = "dp_update";
static char exitCmd[] = "exit";
static char errorExitCmd[] = "exit 1";

/*
 * Command-line options:
 */

#ifndef NO_X11
static int synchronize = 0;
static char *display = NULL;
static char *geometry = NULL;
#endif
static char *fileName = NULL;
static char *name = NULL;
	/* for tcl-dp */
static int hasWindows = 1;
static int isDaemon = 0;

static Tk_ArgvInfo argTable[] = {
#ifndef NO_X11
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,
	"Initial geometry for window"},
    {"-display", TK_ARGV_STRING, (char *) NULL, (char *) &display,
	"Display to use"},
    {"-name", TK_ARGV_STRING, (char *) NULL, (char *) &name,
	"Name to use for application"},
    {"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
#endif
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

static void		Prompt _ANSI_ARGS_((Tcl_Interp *interp, int partial));
static void		StdinProc _ANSI_ARGS_((ClientData clientData,
			    int mask));

	/* For expect and Debug */
extern char *exp_argv0;	
static int debug_v=-1;
static char debug_init[] = "trap {exp_debug 1} SIGINT";
EXTERN char **Dbg_ArgcArgv _ANSI_ARGS_((int argc,char *argv[],int copy));


/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	Main program for supertcl.
 *
 * Results:
 *	None. This procedure never returns (it exits the process when
 *	it's done
 *
 * Side effects:
 *	This procedure initializes the wish world and then starts
 *	interpreting commands;  almost anything could happen, depending
 *	on the script being interpreted.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;				/* Number of arguments. */
    char **argv;			/* Array of argument strings. */
{
    char *args, *p, *msg, *argv0, *class;
    char buf[20];
    char *execName;
    int code;
    size_t length;
	/* for command line processing */
    FILE * cmdFileID=NULL; 
    int argcsave, cmdLineCmds=0;
    char **argvsave, **argvroot;

    interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(interp);
#endif

     exp_argv0 = argv[0];	/* Needed by expect */
     argcsave = argc;
     argvroot = argvsave = (char **)ckalloc((argc+1)*sizeof(char *));
     while (argcsave-- >= 0) 
	  *argvsave++ = NULL;
     argvsave = argvroot;
    /*
     * Parse command-line arguments.  A leading "-file" argument is
     * ignored (a historical relic from the distant past).  If the
     * next argument doesn't start with a "-" then strip it off and
     * use it as the name of a script file to process.  Also check
     * for other standard arguments, such as "-geometry", anywhere
     * in the argument list.
     */
                                       
    argv0 = argv[0];
    while (argc > 1) {
	 if ((argv[1][0] == '-') && (argv[1][1] == 'D') ) {
	    debug_v = atoi(argv[2]);
	    argc -= 2;
	    argv += 2;
	 } else if ((argv[1][0] == '-') && (argv[1][1] == 'c') ) {
	    cmdLineCmds = 1;
	    *argvsave++ = argv[2];
	    argc -= 2;
	    argv += 2;
	 } else if ((argv[1][0] == '-') && (argv[1][1] == '\0') ||
	 	    (argv[1][0] != '-') ) {
	    fileName = argv[1];
/* fprintf(stderr,"filename: %s\n", fileName); */

	    if (argv[1][0] == '-')
	        cmdFileID = stdin;
	    argc --;
	    argv ++;
	    break;
	 }
    }
    if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
        != TCL_OK) {
        fprintf(stderr, "%s\n", interp->result);
        exit(1);
    }
#ifdef NO_X11
    hasWindows = 0;
#endif
    /*
     * If executable is called "dptcl", assume -notk
     */
    execName = strrchr(argv[0], '/');
    if (execName != NULL) {
	execName++;
    } else {
	execName = argv[0];
    }
    if (strcmp(execName,"dptcl") == 0) {
	hasWindows = 0;
    }
    if (name == NULL) {
	if (fileName != NULL) {
	    p = fileName;
	} else {
	    p = execName;
	}
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
    }
    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".  Also set the "geometry" variable from the geometry
     * specified on the command line.
     */
    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", (fileName != NULL) ? fileName : argv[0],
	    TCL_GLOBAL_ONLY);
#ifndef NO_X11
    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }
    /*
     * If a display was specified, put it into the DISPLAY
     * environment variable so that it will be available for
     * any sub-processes created by us.
     */
    if (display != NULL) {
	Tcl_SetVar2(interp, "env", "DISPLAY", display, TCL_GLOBAL_ONLY);
    }
    /*
     * Initialize the Tk application.
     */
    if (hasWindows) {
        class = ckalloc((unsigned) (strlen(name) + 1));
        strcpy(class, name);
        class[0] = toupper((unsigned char) class[0]);
        mainWindow = Tk_CreateMainWindow(interp, display, name, class);
        ckfree(class);
	if (mainWindow == NULL) {
	    fprintf(stderr, "%s\n", interp->result);
	    exit(1);
	}
	if (synchronize) {
	    XSynchronize(Tk_Display(mainWindow), True);
	}
	Tk_GeometryRequest(mainWindow, 200, 200);
    }
#else
    hasWindows = 0;
#endif
    /*
     * Set the "tcl_interactive" variable.
     */
    tty = isatty(0);
    Tcl_SetVar(interp, "tcl_interactive",
	    ((fileName != NULL || cmdLineCmds) && tty) ? "0" : "1", TCL_GLOBAL_ONLY);
    /*
     * Invoke application-specific initialization.
     */
    if (Tcl_AppInit(interp) != TCL_OK) {
	fprintf(stderr, "Tcl_AppInit failed: %s\n", interp->result);
    }
    /*
     * Invoke the script specified on the command line, if any.
     */
    if (cmdLineCmds) {
        argv = argvroot;
	while (argv[0] != NULL) {	/* try to evaluate commands */
	        code = Tcl_Eval(interp, argv[0]);
		if (code != TCL_OK) 
			goto error;
	        argv ++;
	}     
	if (fileName == NULL)
	    Tcl_Eval(interp, exitCmd);	
    } 
    if (fileName != NULL) {
	if (cmdFileID == NULL ) {
	    code = Tcl_VarEval(interp, "source ", fileName, (char *) NULL);
	    if (code != TCL_OK)
	        goto error;
	} else
	    exp_interpret_cmdfile(interp, cmdFileID);
	tty = 0;
    } else if (!cmdLineCmds) {
	/*
	 * Commands will come from standard input, so set up an event
	 * handler for standard input.  If the input device is aEvaluate the
	 * .rc file, if one has been specified, set up an event handler
	 * for standard input, and print a prompt if the input
	 * device is a terminal.
	 */
	if (tcl_RcFileName != NULL) {
	    Tcl_DString buffer;
	    char *fullName;
	    FILE *f;
    
	    fullName = Tcl_TildeSubst(interp, tcl_RcFileName, &buffer);
	    if (fullName == NULL) {
		fprintf(stderr, "%s\n", interp->result);
	    } else {
		f = fopen(fullName, "r");
		if (f != NULL) {
		    code = Tcl_EvalFile(interp, fullName);
		    if (code != TCL_OK) {
			fprintf(stderr, "%s\n", interp->result);
		    }
		    fclose(f);
		}
	    }
	    Tcl_DStringFree(&buffer);
	}
	Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
	if (tty) {
	    Prompt(interp, 0);
	}
    }
    fflush(stdout);
    Tcl_DStringInit(&command);
    Tcl_ResetResult(interp);
#ifndef NO_X11
    /*
     * Set the geometry of the main window, if requested.
     */
    if (hasWindows && geometry != NULL) {
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    fprintf(stderr, "%s\n", interp->result);
	}
    }
#endif
    /*
     * Loop infinitely, waiting for commands to execute.  When there
     * are no windows left, Tk_MainLoop returns and we exit.
     */
    if (hasWindows) {
	(void) Tcl_Eval(interp, updateCmd);
        Tk_MainLoop();
    } else {
        while (1) {
            (void)Tk_DoOneEvent(0);
	}
    }

    /*
     * Don't exit directly, but rather invoke the Tcl "exit" command.
     * This gives the application the opportunity to redefine "exit"
     * to do additional cleanup.
     */

    Tcl_Eval(interp, exitCmd);
    exit(1);

error:
    msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
	msg = interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_Eval(interp, errorExitCmd);
    return 1;			/* Needed only to prevent compiler warnings. */
}

/*
 *----------------------------------------------------------------------
 *
 * StdinProc --
 *
 *	This procedure is invoked by the event dispatcher whenever
 *	standard input becomes readable.  It grabs the next line of
 *	input characters, adds them to a command being assembled, and
 *	executes the command if it's complete.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Could be almost arbitrary, depending on the command that's
 *	typed.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
static void
StdinProc(clientData, mask)
    ClientData clientData;		/* Not used. */
    int mask;				/* Not used. */
{
#define BUFFER_SIZE 4000
    char input[BUFFER_SIZE+1];
    static int gotPartial = 0;
    char *cmd;
    int code, count;

    count = read(fileno(stdin), input, BUFFER_SIZE);
    if (count <= 0) {
	if (!gotPartial) {
	    if (tty) {
		Tcl_Eval(interp, exitCmd);
		exit(1);
	    } else {
		Tk_DeleteFileHandler(0);
	    }
	    return;
	} else {
	    count = 0;
	}
    }
    cmd = Tcl_DStringAppend(&command, input, count);
    if (count != 0) {
	if ((input[count-1] != '\n') && (input[count-1] != ';')) {
	    gotPartial = 1;
	    goto prompt;
	}
	if (!Tcl_CommandComplete(cmd)) {
	    gotPartial = 1;
	    goto prompt;
	}
    }
    gotPartial = 0;

    /*
     * Disable the stdin file handler while evaluating the command;
     * otherwise if the command re-enters the event loop we might
     * process commands from stdin before the current command is
     * finished.  Among other things, this will trash the text of the
     * command being evaluated.
     */

    Tk_CreateFileHandler(0, 0, StdinProc, (ClientData) 0);
    code = Tcl_RecordAndEval(interp, cmd, 0);
    Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
    Tcl_DStringFree(&command);
    if (*interp->result != 0) {
	if ((code != TCL_OK) || (tty)) {
	    printf("%s\n", interp->result);
	}
    }

    /*
     * Output a prompt.
     */

    prompt:
    if (tty) {
	Prompt(interp, gotPartial);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * Prompt --
 *
 *	Issue a prompt on standard output, or invoke a script
 *	to issue the prompt.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	A prompt gets output, and a Tcl script may be evaluated
 *	in interp.
 *
 *----------------------------------------------------------------------
 */

static void
Prompt(interp, partial)
    Tcl_Interp *interp;			/* Interpreter to use for prompting. */
    int partial;			/* Non-zero means there already
					 * exists a partial command, so use
					 * the secondary prompt. */
{
    char *promptCmd;
    int code;

    promptCmd = Tcl_GetVar(interp,
	partial ? "tcl_prompt2" : "tcl_prompt1", TCL_GLOBAL_ONLY);
    if (promptCmd == NULL) {
	defaultPrompt:
	if (!partial) {
	    fputs("% ", stdout);
	}
    } else {
	code = Tcl_Eval(interp, promptCmd);
	if (code != TCL_OK) {
	    Tcl_AddErrorInfo(interp,
		    "\n    (script that generates prompt)");
	    fprintf(stderr, "%s\n", interp->result);
	    goto defaultPrompt;
	}
    }
    fflush(stdout);
}

int
Tcl_AppInit(interp)
Tcl_Interp *interp;
{
	if (debug_v != -1) {   /* turn on Debug if it need */
	    Tcl_Eval(interp, debug_init);
	    if (debug_v == 1)
	    	Dbg_On(interp,0);
	}
	/* Initialise extensions */
	if (TclX_Init(interp) == TCL_ERROR) {
		/* TclX_Init is called instead of Tcl_Init */
		return TCL_ERROR;
	}
	if (Exp_Init(interp) == TCL_ERROR) {	/* Expect */
		return TCL_ERROR;
	}
	if (Itcl_Init(interp) == TCL_ERROR) {	/* incr tcl  */
		return TCL_ERROR;
	}
	if (Tdp_Init(interp) == TCL_ERROR) {	/* incr tcl  */
		return TCL_ERROR;
	}
	/* This information is returned by the infox (tclX) command. */
	tclAppName = "SuperTcl";
	tclAppLongname = "Tcl-TclX-Tdp-Expect-Itcl";
	tclAppVersion = "0.5";
	
	tcl_RcFileName = "~/.tclshrc";
        return TCL_OK;
}
