
/**********************************************************************
 * GIFPlot 0.0
 * 
 * Dave Beazley
 * 
 * Department of Computer Science        Theoretical Division (T-11)        
 * University of Utah                    Los Alamos National Laboratory     
 * Salt Lake City, Utah 84112            Los Alamos, New Mexico  87545      
 * beazley@cs.utah.edu                   beazley@lanl.gov                   
 *
 * Copyright (c) 1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 **************************************************************************/
/*************************************************************************
 * font.c
 *
 * Some functions for drawing text.  We're not going for a full-fledged
 * FONT system here.  Just something simple that can be used for a few
 * annotations
 **************************************************************************/

#define FONT
#include "gifplot.h"

static char Char_A[80] = "\
...x....\
...x....\
..x.x...\
..x.x...\
.x...x..\
.xxxxx..\
x.....x.\
x.....x.\
x.....x.\
........";

static char Char_B[80] = "\
xxxxxx..\
x.....x.\
x.....x.\
x.....x.\
xxxxxx..\
x.....x.\
x.....x.\
x.....x.\
xxxxxx..\
........";

static char Char_C[80] = "\
..xxxx..\
.x....x.\
x.......\
x.......\
x.......\
x.......\
x.......\
.x....x.\
..xxxx..\
........";

static char Char_D[80] = "\
xxxxx...\
x....x..\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x....x..\
xxxxx...\
........";
static char Char_E[80] = "\
xxxxxxx.\
x.......\
x.......\
x.......\
xxxxx...\
x.......\
x.......\
x.......\
xxxxxxx.\
........";
static char Char_F[80] = "\
xxxxxxx.\
x.......\
x.......\
x.......\
xxxxx...\
x.......\
x.......\
x.......\
x.......\
........";
static char Char_G[80] = "\
.xxxxx..\
x.....x.\
x.......\
x.......\
x...xxx.\
x.....x.\
x.....x.\
x.....x.\
.xxxxx..\
........";
static char Char_H[80] = "\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
xxxxxxx.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
........";
static char Char_I[80] = "\
xxxxxxx.\
...x....\
...x....\
...x....\
...x....\
...x....\
...x....\
...x....\
xxxxxxx.\
........";
static char Char_J[80] = "\
......x.\
......x.\
......x.\
......x.\
......x.\
......x.\
x.....x.\
.x...x..\
..xxx...\
........";
static char Char_K[80] = "\
x.....x.\
x....x..\
x...x...\
x..x....\
xxx.....\
x..x....\
x...x...\
x....x..\
x.....x.\
........";
static char Char_L[80] = "\
x.......\
x.......\
x.......\
x.......\
x.......\
x.......\
x.......\
x.......\
xxxxxxx.\
........";
static char Char_M[80] = "\
x.....x.\
xx...xx.\
xx...xx.\
x.x.x.x.\
x.x.x.x.\
x..x..x.\
x..x..x.\
x.....x.\
x.....x.\
........";
static char Char_N[80] = "\
x.....x.\
xx....x.\
x.x...x.\
x.x...x.\
x..x..x.\
x...x.x.\
x...x.x.\
x....xx.\
x.....x.\
........";
static char Char_O[80] = "\
.xxxxx..\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
.xxxxx..\
........";
static char Char_P[80] = "\
xxxxxx..\
x.....x.\
x.....x.\
x.....x.\
xxxxxx..\
x.......\
x.......\
x.......\
x.......\
........";
static char Char_Q[80] = "\
.xxxxx..\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x...x.x.\
x....x..\
.xxxx.x.\
........";
static char Char_R[80] = "\
xxxxxx..\
x.....x.\
x.....x.\
x.....x.\
xxxxxx..\
x..x....\
x...x...\
x....x..\
x.....x.\
........";
static char Char_S[80] = "\
.xxxxx..\
x.....x.\
x.......\
x.......\
.xxxxx..\
......x.\
......x.\
x.....x.\
.xxxxx..\
........";
static char Char_T[80] = "\
xxxxxxx.\
...x....\
...x....\
...x....\
...x....\
...x....\
...x....\
...x....\
...x....\
........";
static char Char_U[80] = "\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
.xxxxx..\
........";
static char Char_V[80] = "\
x.....x.\
x.....x.\
.x...x..\
.x...x..\
..x.x...\
..x.x...\
...x....\
...x....\
...x....\
........";
static char Char_W[80] = "\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x.....x.\
x..x..x.\
x..x..x.\
x.x.x.x.\
.x...x..\
........";
static char Char_X[80] = "\
x.....x.\
x.....x.\
.x...x..\
..x.x...\
...x....\
..x.x...\
.x...x..\
x.....x.\
x.....x.\
........";
static char Char_Y[80] = "\
x.....x.\
x.....x.\
.x...x..\
..x.x...\
...x....\
...x....\
...x....\
...x....\
...x....\
........";
static char Char_Z[80] = "\
xxxxxxx.\
......x.\
.....x..\
....x...\
...x....\
..x.....\
.x......\
x.......\
xxxxxxx.\
........";
static char Char_0[80] = "\
.xxxxx..\
x....xx.\
x...x.x.\
x..x..x.\
x..x..x.\
x.x...x.\
x.x...x.\
xx....x.\
.xxxxx..\
........";
static char Char_1[80] = "\
...x....\
..xx....\
...x....\
...x....\
...x....\
...x....\
...x....\
...x....\
..xxx...\
........";
static char Char_2[80] = "\
..xxxx..\
.x....x.\
x.....x.\
.....x..\
....x...\
...x....\
..x.....\
.x......\
xxxxxxx.\
........";
static char Char_3[80] = "\
.xxxxx..\
x.....x.\
......x.\
......x.\
...xxx..\
......x.\
......x.\
x.....x.\
.xxxxx..\
........";
static char Char_4[80] = "\
....xx..\
...x.x..\
..x..x..\
.x...x..\
xxxxxxx.\
.....x..\
.....x..\
.....x..\
.....x..\
........";
static char Char_5[80] = "\
xxxxxxx.\
x.......\
x.......\
x.......\
xxxxxx..\
......x.\
......x.\
x.....x.\
.xxxxx..\
........";
static char Char_6[80] = "\
....xxx.\
..xx....\
.x......\
x.......\
x.xxx...\
xx...x..\
x.....x.\
.x...x..\
..xxx...\
........";
static char Char_7[80] = "\
xxxxxxx.\
x.....x.\
.....x..\
....x...\
...x....\
..x.....\
.x......\
x.......\
x.......\
........";
static char Char_8[80] = "\
.xxxxx..\
x.....x.\
x.....x.\
x.....x.\
.xxxxx..\
x.....x.\
x.....x.\
x.....x.\
.xxxxx..\
........";
static char Char_9[80] = "\
..xxxx..\
.x....x.\
x.....x.\
x....xx.\
.xxxx.x.\
......x.\
......x.\
....xx..\
.xxx....\
........";
static char Char_MINUS[80] = "\
........\
........\
........\
........\
.xxxxxx.\
........\
........\
........\
........\
........";
static char Char_PLUS[80] = "\
........\
........\
...x....\
...x....\
.xxxxx..\
...x....\
...x....\
........\
........\
........";
static char Char_EQUAL[80] = "\
........\
........\
........\
.xxxxx..\
........\
.xxxxx..\
........\
........\
........\
........";
static char Char_LPAREN[80] = "\
....x...\
...x....\
..x.....\
.x......\
.x......\
.x......\
..x.....\
...x....\
....x...\
........";
static char Char_RPAREN[80] = "\
...x....\
....x...\
.....x..\
......x.\
......x.\
......x.\
.....x..\
....x...\
...x....\
........";
static char Char_QUOTE[80] = "\
..x.x...\
..x.x...\
........\
........\
........\
........\
........\
........\
........\
........";
static char Char_COLON[80] = "\
........\
........\
...xx...\
...xx...\
........\
...xx...\
...xx...\
........\
........\
........";
static char Char_PERIOD[80] = "\
........\
........\
........\
........\
........\
........\
........\
...xx...\
...xx...\
........";
static char Char_COMMA[80] = "\
........\
........\
........\
........\
........\
........\
...xx...\
...xx...\
....x...\
...x....";

static char Char_SLASH[80] = "\
........\
......x.\
.....x..\
....x...\
...x....\
..x.....\
.x......\
x.......\
........\
........";

static char Char_SPACE[80] = "\
........\
........\
........\
........\
........\
........\
........\
........\
........\
........";

static char  *Font[128];
static int    InitFont = 0;

static void initfonts(void) {

  int i;
  for (i = 0; i < 128; i++)
    Font[i] = (char *) 0;
  
  Font['A'] = Font['a'] = Char_A;
  Font['B'] = Font['b'] = Char_B;
  Font['C'] = Font['c'] = Char_C;
  Font['D'] = Font['d'] = Char_D;
  Font['E'] = Font['e'] = Char_E;
  Font['F'] = Font['f'] = Char_F;
  Font['G'] = Font['g'] = Char_G;
  Font['H'] = Font['h'] = Char_H;
  Font['I'] = Font['i'] = Char_I;
  Font['J'] = Font['j'] = Char_J;
  Font['K'] = Font['k'] = Char_K;
  Font['L'] = Font['l'] = Char_L;
  Font['M'] = Font['m'] = Char_M;
  Font['N'] = Font['n'] = Char_N;
  Font['O'] = Font['o'] = Char_O;
  Font['P'] = Font['p'] = Char_P;
  Font['Q'] = Font['q'] = Char_Q;
  Font['R'] = Font['r'] = Char_R;
  Font['S'] = Font['s'] = Char_S;
  Font['T'] = Font['t'] = Char_T;
  Font['U'] = Font['u'] = Char_U;
  Font['V'] = Font['v'] = Char_V;
  Font['W'] = Font['w'] = Char_W;
  Font['X'] = Font['x'] = Char_X;
  Font['Y'] = Font['y'] = Char_Y;
  Font['Z'] = Font['z'] = Char_Z;
  Font['0'] = Char_0;
  Font['1'] = Char_1;
  Font['2'] = Char_2;
  Font['3'] = Char_3;
  Font['4'] = Char_4;
  Font['5'] = Char_5;
  Font['6'] = Char_6;
  Font['7'] = Char_7;
  Font['8'] = Char_8;
  Font['9'] = Char_9;
  Font['.'] = Char_PERIOD;
  Font[','] = Char_COMMA;
  Font['='] = Char_EQUAL;
  Font['-'] = Char_MINUS;
  Font['+'] = Char_PLUS;
  Font['\"'] = Char_QUOTE;
  Font['('] = Char_LPAREN;
  Font[')'] = Char_RPAREN;
  Font[':'] = Char_COLON;
  Font['/'] = Char_SLASH;
  Font[' '] = Char_SPACE;
  InitFont = 1;
}

/* -----------------------------------------------------------------------
   void FrameBuffer_drawchar(FrameBuffer *f, int x, int y, Pixel fgcolor, Pixel bgcolor, char chr, int orientation)

   Draws a character at location x, y with given color and orientation parameters.
   Orientation can either be HORIZONTAL or VERTICAL
   ----------------------------------------------------------------------- */
void FrameBuffer_drawchar(FrameBuffer *f, int x, int y, int fgcolor,
			  int bgcolor, char chr, int orientation) {

  Pixel c, bc,*p,*p1;
  char *ch;
  int i,j;
  int xpixels,ypixels;

  if (!InitFont) initfonts();
  
  c =  (Pixel) fgcolor;
  bc = (Pixel) bgcolor;
  xpixels = f->width;
  ypixels = f->height;

  if (orientation == HORIZONTAL) {
    if ((x < f->xmin) || (x > f->xmax-8) ||
	(y < f->ymin) || (y > f->ymax-10)) return;
  
    ch = Font[chr];
    if (!ch) return;
    p = &f->pixels[y+9][x];
    for (i = 0; i < 10; i++) {
      p1 = p;
      for (j = 0; j< 8; j++) {
	if (*(ch++) == 'x') *p= c;
	else if (bgcolor >= 0)
	  *p = bc;
	p++;
      }
      p = (p1 - xpixels);
    }
  } else {
    if ((x < f->xmin+10) || (x >= f->xmax) ||
	(y < f->ymin) || (y > f->ymax-8)) return;
  
    ch = Font[chr];
    if (!ch) return;
    p = &f->pixels[y][x-9];
    for (i = 0; i < 10; i++) {
      p1 = p;
      for (j = 0; j< 8; j++) {
	if (*(ch++) == 'x') *p= c;
	else if (bgcolor >= 0)
	  *p = bc;
	p+=xpixels;
      }
      p = p1 + 1;
    }
  }    
}

/* ----------------------------------------------------------------------
   void FrameBuffer_drawstring(FrameBuffer *f, int x, int y, int fgcolor,
                               int bgcolor, char *text, int orientation)

   Draws an ASCII string on the framebuffer.   Can be oriented either horizontally
   or vertically.  
   ---------------------------------------------------------------------- */

void FrameBuffer_drawstring(FrameBuffer *f, int x, int y, int fgcolor, int bgcolor, char *text, int orientation) {

  char *c;
  int  x1, y1;
  int xpixels, ypixels;
  
  x1 = x;
  y1 = y;
  xpixels = f->width;
  ypixels = f->height;
  c = text;
  while (*c) {
    if (*c == '\n') {
      if (orientation == HORIZONTAL) {
	x1 = x; y1= y1- 10*xpixels;
      } else {
	y1 = y; x1= x1 + 10*ypixels;
      }
    } else {
      FrameBuffer_drawchar(f, x1,y1,fgcolor, bgcolor,*c, orientation);
      if (orientation == HORIZONTAL) {
	x1+=8;
	if (x1 >= (xpixels-8)) {
	  x1 = x; y1= y1- 10;}
	if (y1 < 0) return;
      } else {
	y1 += 8;
	if (y1 >= (ypixels-8)) {
	  y1 = y; x1 = x1 + 10;}
	if (x1 > (xpixels-10)) return;
      }
    }
    c++;
  }
}


  
  
  
  
  

