import sg
import matlab

Server = matlab.Server()

class SineGordon:
	def __init__(self,name,npoints,dt,min,max):
		self.data = sg.new(npoints,dt,min,max)
		self.name = name
		self.npoints = npoints;
		self.matrix = Server.Double2Matrix(name,npoints+1,1,sg.get_u(self.data))
		self.figure = Server.NewFigure(name,self.matrix)
		self.figure.Axes(0,npoints,-15,15);
		self.snapshots = {}
		self.snaplist = []
	def __del__(self):
		del self.figure
		sg.delete(self.data)
	def run(self,nsteps,freq):
		count = nsteps/freq;
		for i in range(0,count):
			sg.sg(self.data,freq)
			self.figure.Plot()
			s = sg.new_snapshot(self.data)
			self.snaplist.append(s)
			n = sg.totalsteps_get(self.data)
			self.snapshots[n] = s
	def kink(self,vel,pos, k = 0):
		sg.kink(self.data,vel,pos,k)
		self.figure.Plot()
	def antikink(self,vel,pos,k = -1):
		sg.antikink(self.data,vel,pos,k)
		self.figure.Plot()
	def show(self,n):
		s = self.snapshots[n]
		d = sg.get_u(s)
		f = Server.Plot("T"+str(n),self.npoints+1,1,d)
		f.Axes(self.figure.xmin,self.figure.xmax,self.figure.ymin,self.figure.ymax)
		return f
	def Axes(self,minx,maxx,miny,maxy):
		self.figure.Axes(minx,maxx,miny,maxy)

def initcond(name,npoints,dt):
	run = SineGordon(name,npoints,dt,0,100)
	run.kink(0.9,10)
	run.antikink(0.9,20)
	run.kink(-0.9,80)
	run.antikink(-0.9,90)
	return run



	
			
		
	