#include "engine.h"

Engine  *ep;
char    ml_output[1024];

/* Command to open up matlab */

void init(char *c) {
	if (!(ep = engOpen(c))) {
	  fprintf(stderr,"Unable to open matlab.\n");
	  return;
          }
	engOutputBuffer(ep,ml_output,1024);
}

/* Command to evaluate a command */

char *matlab(char *c) {
	engEvalString(ep, c);
	return &ml_output[0];
}
Matrix *GetMatrix(char *name) {
	return(engGetMatrix(ep,name));
}

int PutMatrix(Matrix *m) {
	return(engPutMatrix(ep,m));
}

/* Access parts of a matrix */

double getr(Matrix *mat, int i, int j) {
  double *pr;
  int m;

  pr = mxGetPr(mat);
  m = mxGetM(mat);

  return pr[m*j + i];
}

void setr(Matrix *mat, int i, int j, double val) {
  double *pr;
  int m;
  pr = mxGetPr(mat);
  m = mxGetM(mat);
  
  pr[m*j + i] = val;
}


/* Access parts of a matrix */

double geti(Matrix *mat, int i, int j) {
  double *pi;
  int m;

  pi = mxGetPi(mat);
  m = mxGetM(mat);

  return pi[m*j + i];
}

void seti(Matrix *mat, int i, int j, double val) {
  double *pi;
  int m;
  pi = mxGetPi(mat);
  m = mxGetM(mat);
  
  pi[m*j + i] = val;
}

