# Python class for MATLAB

import ml

# This class manages the Matlab server


class Figure:
	def __init__(self,name,number,matrix,server):
		self.name = name
		self.number = number
		self.matrix = matrix
		self.server = server
		self.xmin = 0;
		self.xmax = 1;
		self.ymin = 0;
		self.ymax = 1;
		ml.matlab("axis([0 1 0 1])")
		ml.matlab("title '" + name + "'")
	def __del__(self):
		ml.matlab("delete("+str(self.number)+");")
		self.server.FreeFigure(self.number)
	def Plot(self):
		ml.PutMatrix(self.matrix)
		ml.matlab("figure("+str(self.number)+")")
		ml.matlab("cla; plot("+ml.mxGetName(self.matrix)+");")
	def Title(self,name):
		ml.matlab("figure("+str(self.number)+")")
		ml.matlab("title '" + name + "'");
	def Axes(self, xmin, xmax, ymin, ymax):
		ml.matlab("figure("+str(self.number)+")")
		ml.matlab("axis(["+str(xmin)+" "+str(xmax)+" "+str(ymin)+" "+str(ymax)+"])");
		self.xmin = xmin
		self.ymin = ymin
		self.xmax = xmax
		self.ymax = ymax
	def Set(self,ptr):
		ml.mxSetPr(self.matrix,ptr)
		self.Plot()
	def Diff(self,f2):
		f1 = self
		npts1 = ml.mxGetM(f1.matrix)
		npts2 = ml.mxGetM(f2.matrix)
		if npts1 > npts2:
			min = npts2
			m1 = f2.matrix
			m2 = f1.matrix	
			stride = npts1/npts2
		else:
			min = npts1
			m1 = f1.matrix
			m2 = f2.matrix
			stride = npts2/npts1
		newmat = self.server.NewMatrix("diff",min,1);
		j = 0;
		for i in range(0,min):
			v1 = ml.getr(m1,i,0)
			v2 = ml.getr(m2,j,0)
			ml.setr(newmat,i,0,(v1-v2))
			j = j + stride
		f = self.server.NewFigure("Diff",newmat)
		f.Axes(f1.xmin,f1.xmax,f2.ymin,f2.ymax)
		f.Plot()
		return f

class Server:
	def __init__(self):
		ml.init("matlab42");
		self.figureno = 1
		self.matrixlist = []
		self.dict = {}
		self.reuse = []
	def __del__(self):
		for i in self.matrixlist:
			ml.mxFreeMatrix(i)
	def eval(self,cmd):
		s = ml.matlab(cmd)
		return s
	def NewMatrix(self,name,m,n):
		mat = ml.mxCreateFull(m,n,0)
		ml.mxSetName(mat,name)
		self.matrixlist.append(mat)
		self.dict[name] = mat
		return mat
	def PutMatrix(self,m):
		ml.PutMatrix(m)
	def GetMatrix(self,name):
		m = ml.GetMatrix(name)
		return m
	def NewFigure(self,name,matrix):
		if len(self.reuse) > 0 :
			a = self.reuse[0]
			self.reuse.remove(a)
		else:
			a = self.figureno
			self.figureno = self.figureno + 1
		ml.matlab("figure("+str(a)+"); hold on;")
		f = Figure(name,a,matrix,self)
		return f
	def Double2Matrix(self,name,m,n,a):
		mat = self.NewMatrix(name,m,n)
		ml.mxSetPr(mat,a)
		return mat
	def Plot(self,name,m,n,a):
		mat = self.Double2Matrix(name,m,n,a)
		f = self.NewFigure(name,mat)
		f.Plot()
		return f
	def PlotList(self,name,l):
		m = len(l)
		mat = self.NewMatrix(name,m,1)
		for i in range(0,m):
			ml.setr(mat,i,0,l[i])
		f = self.NewFigure(name,mat)
		f.Plot()
		return f
	def FreeFigure(self,num):
		self.reuse.append(num)



