%{
#include "engine.h"

#define SWIG_RcFileName  "pde.tcl"

%}

%include wish.i
//%include tclsh.i

%section "Matlab commands"

extern void init(char *);
/* Initialize the matlab application */

extern char *matlab(char *command);
/* Execute a matlab comman */

extern Matrix *GetMatrix(char *name);
/* Retrieve a matrix from Matlab */

extern int PutMatrix(Matrix *matrix);
/* Give a matrix back to matlab */

extern double getr(Matrix *matrix, int i, int j);
/* Get real element (i,j) from matrix */

extern void setr(Matrix *matrix, int i, int j, double val);
/* Set real matrix element (i,j) to val */

extern double geti(Matrix *matrix, int i, int j);
/* Gets imaginary element (i,j) from matrix */

extern double seti(Matrix *matrix, int i, int j, double val);
/* Sets imaginary element (i,j) from matrix */

%section "Matrix Data Structure Manipulation"

Matrix *mxCreateFull(int m, int n, int ComplexFlag);
/* Creates a full (dense) matrix.
   ConflexFlag is 0 = REAL or 1 = COMPLEX */

void mxFreeMatrix(Matrix *m);
/* Frees a matrix */

int mxGetM(Matrix *mat);
/* Return number of rows */

int mxGetN(Matrix *mat);
/* Return number of columns */

void mxSetM(Matrix *mat, int m);
/* Sets number of rows */

void mxSetN(Matrix *mat, int n);
/* Sets number of columns */

char *mxGetName(Matrix *mat);
/* Gets matrix name */

void mxSetName(Matrix *mat, char *name);
/* Sets matrix name */

double *mxGetPi(Matrix *mat);
/* Get pointer to imaginary part */

double *mxGetPr(Matrix *mat);
/* Get pointer to real part */

void mxSetPi(Matrix *mat, double *pi);
/* Set imaginary pointer */

void mxSetPr(Matrix *mat, double *pr);
/* Set real pointer */

double mxGetScalar(Matrix *mat);
/* Returns (1,1) element */

int mxIsComplex(Matrix *mat);
/* Tests if matrix is complex */

int mxIsDouble(Matrix *mat);
/* Tests if matrix is type double */

%section "PDE Commands"

extern double get_u(int i,int j);
/* Get grid values */

extern void solve(int npoints, double tolerance);
/* Solve system using gauss-seidel */


