// This file tests SWIG's handling of "const".
// This is problematic because scripting languages don't know anything about const
// and C++ is completely anal about it.

%module constant

%inline %{
	
const char *foo() {
	return "Hello World";
};

void bar(const char *s) {
	printf("Received %s\n", s);
}

class Spam {
public:
	Spam() { };
	const char *foo() {
		return "Hello world";
	}
	void bar(const char *s) {
		printf("Received %s\n",s);
	}
};

%}

// Some typedef's involving char *

%inline %{
typedef const char *String;
typedef String Name;

Name get_name(Name n) {
	return n;
}

String get_string(String s) {
	return s;
}

%}

#ifdef STATIC
%include embed.i
#endif

