// Test SWIG's type-mapping support

%typemap(tcl,in) double {
	.. get a double ..
}

%typemap(tcl,out) double {
	.. set a double ..
}

%typemap(tcl,in) char ** {
	.. get a char ** ..
}

%typemap(tcl,out) char ** {
	.. set a char ** ..
}

%typemap(tcl,in) Vector & {
	.. get a vector ..
}

%typemap(tcl,out) Vector & {
	.. set a vector ..
}

%typemap(tcl,in) char **argv {
 	.. get an argv ..
}

%typemap(tcl,out) char **argv {
	.. set an argv ..
}

/* Now do some tests */

int foobar(double a, double b);
int parse_args(int argc, char **argv);
int parse_charpp(int argc, char **);

/* A C++ test */

class Foo {
public:
	double dmember(double);
	void   charpp(char **);
	Vector& get_vector();
	void set_vector(Vector&);
}

%typemap(tcl,in) double {
 get a double for class Bar
}

class Bar {
public:
       double dmember2(double);
}

// Delete double typemaps
%typemap(tcl,in) double;

void no_typemap(double);

// Some matrix typemaps

%typemap(tcl,in) double [4] {
	... get a double[4] ...
}

%typemap(tcl,in) double [4][4] {
	... get a double [4][4] ...
}

%typemap(memberin) double [4] {
	... set a double [4] member ...
}

%typemap(memberin) double [4][4] {
	... set a double [4][4] member ...

}

void atest1(double a[4]);
void atest2(double a[4][4]);
struct atest3 {
	double a[4];
	double b[4][4];
};

// Now some typemaps that match any array dimension

%typemap(tcl,in) double [ANY] {
	... getting a double [$dim0] ...

}

%typemap(tcl,in) double [ANY][8] {
	... getting a double [$dim0][8] ...
}

%typemap(tcl,in) double [7][ANY] {
	... getting a double [7][$dim1] ...
}

%typemap(memberin) double [ANY][ANY] {
	... setting a double [$dim0][$dim1] member ...
}

%typemap(memberin) double [ANY][] {
	... setting a double [$dim0][] member ...
}

void atest4(double a[6]);
void atest5(double a[13][8]);
void atest6(double a[7][17]);
struct atest7 {
	double a[5][6];
	double b[10][];
};


