/*
 * FILE : array_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1  (Beta 5)
 * 
 * Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */

/* Implementation : TCL 7.x */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
/*
 * $Header: /b2/dmb/SWIG/SWIG1.0b3/swig_lib/tcl/RCS/swigtcl.cfg,v 1.1 1996/05/22 19:47:45 beazley Exp $
 * 
 * swigtcl.cfg
 *
 * This file is modified from a platform independent file provided
 * by Sun.   With any luck this will allow SWIG generated wrapper
 * files to work on Unix, Windows, and Macintosh.
 *
 * Revision History
 * $Log: swigtcl.cfg,v $
 * Revision 1.1  1996/05/22 19:47:45  beazley
 * Initial revision
 *
 *
 * -- Dave Beazley, May 2, 1996.
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define EXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define EXPORT(a,b) a _export b
#	else
#	    define EXPORT(a,b) a b
#	endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
    return TRUE;
}
#endif

/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;

  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  sp = (SwigPtrType *) bsearch(_t,SwigPtrTable,SwigPtrN,sizeof(SwigPtrType),swigcmp);
	  if (sp) {
	    while ((sp >= SwigPtrTable) && (swigcmp(_t,sp) == 0)) sp--;
	    sp++;
	    name = sp->name;
	    len = sp->len;
	    while (swigcmp(_t,sp) == 0) {
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strncpy(temp_type,tp->name,255);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
#ifdef ALLOW_NULL
    if (strcmp (_c, "NULL") == 0)
      {
	*ptr = (void *) 0;
	return (char *) 0;
      }
#endif
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    Carray_Init


EXPORT(int,Carray_Init)(Tcl_Interp *);

  #include <limits.h>

  /* Create a new integer array */

  static int *int_array(int size) {
#ifdef __cplusplus
    return new int[size];
#else
    return (int *) malloc(size*sizeof(int));
#endif
  }

  /* Destroy an integer array */

  static void int_destroy(int *array) {
    if (array) {
#ifdef __cplusplus
      delete array;
#else
      free(array);
#endif
    }
  }

  /* Return an element */

  static int int_get(int *array, int index) {
    if (array) {
      return array[index];
    } else {
      return INT_MIN;
    }
  }
   
  /* Set an element */
  
  static int int_set(int *array, int index, int value) {
    if (array) {
      return (array[index] = value);
    } else {
      return INT_MIN;
    }
  }


  #include <float.h>

  /* Create a new float array */

  static float *float_array(int size) {
#ifdef __cplusplus
    return new float[size];
#else
    return (float *) malloc(size*sizeof(float));
#endif
  }

  /* Destroy an array */

  static void float_destroy(float *array) {
    if (array) {
#ifdef __cplusplus
      delete array;
#else
      free(array);
#endif
    }
  }

  /* Return an element */

  static float float_get(float *array, int index) {
    if (array) {
      return array[index];
    } else {
      return FLT_MIN;
    }
  }
   
  /* Set an element */
  
  static float float_set(float *array, int index, float value) {
    if (array) {
      return (array[index] = value);
    } else {
      return FLT_MIN;
    }
  }

  /* Create a new double array */

  static double *double_array(int size) {
#ifdef __cplusplus
    return new double[size];
#else
    return (double *) malloc(size*sizeof(double));
#endif
  }

  /* Destroy an array */

  static void double_destroy(double *array) {
    if (array) {
#ifdef __cplusplus
      delete array;
#else
      free(array);
#endif
    }
  }

  /* Return an element */

  static double double_get(double *array, int index) {
    if (array) {
      return array[index];
    } else {
      return FLT_MIN;
    }
  }
   
  /* Set an element */
  
  static double double_set(double *array, int index, double value) {
    if (array) {
      return (array[index] = value);
    } else {
      return FLT_MIN;
    }
  }


/* Create character string arrays */

static char **string_array(int size) {
  char **a;
  int i;
#ifdef __cplusplus
  a = new char *[size];
#else
  a = (char **) malloc(size*sizeof(char *));
#endif
  for (i = 0; i < size; i++)
    a[i] = 0;
  return a;
}

/* Destroy a string array */

static void string_destroy(char **array) {
  int i = 0;
  if (array) {
      while (array[i]) {
#ifdef __cplusplus
            delete array[i];
#else
            free(array[i]);
#endif
            i++;
      }          	
#ifdef __cplusplus
     delete array;
#else
     free(array);
#endif
   }      
}

/* Get an element */

static char *string_get(char **array_string, int index) {
  if (array_string) 
    if (array_string[index]) return (array_string[index]);
    else return "";
  else 
    return "";
}

/* Set an element */

static char *string_set(char **array_string, int index, char * val) {
  if (array_string) {
    if (array_string[index]) {
#ifdef __cplusplus
	delete array_string[index];
#else
        free(array_string[index]);
#endif
    }	
    if (strlen(val) > 0) {
#ifdef __cplusplus
      array_string[index] = new char[strlen(val)+1];
#else
      array_string[index] = (char *) malloc(strlen(val)+1);
#endif
      strcpy(array_string[index],val);
      return array_string[index];
    } else {
      array_string[index] = 0;
      return val;
    }
  } else return val;
}

static int _wrap_int_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. int_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (int *)int_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_int_p");
    return TCL_OK;
}
static int _wrap_int_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. int_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of int_destroy. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    int_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_int_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. int_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of int_get. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )int_get(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_int_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. int_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of int_set. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )int_set(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_double_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. double_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (double *)double_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static int _wrap_double_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. double_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of double_destroy. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    double_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_double_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. double_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of double_get. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (double )double_get(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_double_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double * _arg0;
    int  _arg1;
    double  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. double_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of double_set. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (double ) atof(argv[3]);
    _result = (double )double_set(_arg0,_arg1,_arg2);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_float_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. float_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (float *)float_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_float_p");
    return TCL_OK;
}
static int _wrap_float_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. float_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_float_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of float_destroy. Expected _float_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    float_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_float_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float  _result;
    float * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. float_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_float_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of float_get. Expected _float_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (float )float_get(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_float_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float  _result;
    float * _arg0;
    int  _arg1;
    float  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. float_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_float_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of float_set. Expected _float_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (float ) atof(argv[3]);
    _result = (float )float_set(_arg0,_arg1,_arg2);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_string_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char ** _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. string_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (char **)string_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_char_pp");
    return TCL_OK;
}
static int _wrap_string_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char ** _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. string_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of string_destroy. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    string_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_string_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char ** _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. string_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of string_get. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (char *)string_get(_arg0,_arg1);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int _wrap_string_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char ** _arg0;
    int  _arg1;
    char * _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. string_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of string_set. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = argv[3];
    _result = (char *)string_set(_arg0,_arg1,_arg2);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
EXPORT(int,Carray_Init)(Tcl_Interp *interp) {
	 if (interp == 0) 
		 return TCL_ERROR;
	 Tcl_CreateCommand(interp, "int_array", _wrap_int_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "int_destroy", _wrap_int_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "int_get", _wrap_int_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "int_set", _wrap_int_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_array", _wrap_double_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_destroy", _wrap_double_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_get", _wrap_double_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_set", _wrap_double_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_array", _wrap_float_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_destroy", _wrap_float_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_get", _wrap_float_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_set", _wrap_float_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_array", _wrap_string_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_destroy", _wrap_string_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_get", _wrap_string_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_set", _wrap_string_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
	 return TCL_OK;
}
