# DoubleList.tcl - itcl widget for displaying 2 lists with arrows between
#                  them for moving items back and forth.
#
# You can access the left and right lists as $w.left and $w.right,
# where $w is the name of the DoubleList widget.
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class DoubleList {
    inherit FrameWidget


    # move the selected elements from the left to the right list

    method move_right {} {
	$this.right append_list [$this.left remove_selected]
    }


    # move the selected elements from the right to the left list

    method move_left {} {
	$this.left append_list [$this.right remove_selected]
    }

    # move the selected elements from the right to the left list

    method move_up {} {
	$this.left move_up
    }


    # move the selected elements from the right to the left list

    method move_down {} {
	$this.left move_down
    }


    # make the lists empty

    method clear {} {
	$this.left clear
	$this.right clear
    }


    #  create a new object of this class

    constructor {config} {
	FrameWidget::constructor
	
	pack [Listbox $this.left \
		-title $left_title] \
		-side left -fill both -expand 1

	pack [frame $this.arrows -bd 1m] \
		-side left -fill y -ipadx 0.5m

	pack [label $this.arrows.fill -text " "] \
		-side top -fill x

	pack [button $this.arrows.right \
		-bitmap right_xbm \
		-command "$this move_right"] \
		-side top -fill y -expand 1

	pack [button $this.arrows.left \
		-bitmap left_xbm \
		-command "$this move_left"] \
		-side top -fill y -expand 1 -pady 1m

	if {$up_down} {
	    pack [button $this.arrows.up \
		-bitmap up_xbm \
		-command "$this move_up"] \
		-side top -fill y -expand 1

	    pack [button $this.arrows.down \
		-bitmap down_xbm \
		-command "$this move_down"] \
		-side top -fill y -expand 1 -pady 1m
	}

	pack [Listbox $this.right \
		-title $right_title] \
		-side right -fill both -expand 1

	set initialized_ 1

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }


    # public member variables

    # titles
    public left_title {}
    public right_title {}

    # flag: if true, also display up and down buttons for moving
    # list items vertically
    public up_down 1

    
    # passed on to tk
    public exportselection {1} {
	if {$initialized_} {
	    $this.left config -exportselection $exportselection
	    $this.right config  -exportselection $exportselection
	}
    }

    # choose the select mode: one of {single, browse, multiple, extended}
    public selectmode {single} {
	if {$initialized_} {
	    $this.left config -selectmode $selectmode
	    $this.right config -selectmode $selectmode
	}
    }


    # -- protected members --

    # flag: true after initialization
    protected initialized_ 0

}

# define the bitmaps we are using once
define_bitmaps
