# FrameWidget.tcl - itcl base class for widgets with their own frame
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class FrameWidget {

    # Create a frame with the same name as this object

    constructor {config} {
	set class [$this info class]
	::rename $this $this-tmp-
	frame $this -class $class -relief $relief -bd $bd
	::rename $this $this-win
	::rename $this-tmp- $this

	# set the class bindings
        bind $this <Destroy> {%W delete}

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }

    #  used to change public attributes

    method config {config} {}


    #  destroy window containing widget
    
    destructor {
	if {[winfo exists $this]} {
	    destroy $this
	}
    }


    # run the given tcl command while displaying the busy cursor
    # in the frame's parent top level window

    method busy {cmd} {
	global errorInfo errorCode

	if {[incr busy_count_] == 1} {
	    catch {focus {}}
	    blt_busy hold $this
	    update idletasks
	}

	# save any errors and report them later
	if {[set code [catch [list uplevel $cmd] msg]]} {
	    set info $errorInfo
	} 

	if {[incr busy_count_ -1] == 0} {
	    blt_busy release $this
	    catch {focus -lastfor $this}
	}

	if {$code} {
	    uplevel [list error $msg $info $code]
	}
    }

    # set the text of short help message to be displayed whenever
    # the mouse enters the widget w (see Toplevel.tcl)
    method add_short_help {w msg} {
	global [set var [winfo toplevel $this].shelp]
	bind $w <Enter> [list set $var $msg]
	bind $w <Leave> [list set $var ""]
    } 
    
    # -- public variables --

    # set the borderwidth on the frame
    public bd {0} {
	if {[winfo exists $this]} {
	    $this-win configure -bd $bd
	}
    }

    # set the relief on the frame
    public relief {flat} {
	if {[winfo exists $this]} {
	    $this-win configure -relief $relief
	}
    }
	

    # text of short help message to be displayed whenever
    # the mouse enters the widget (see Toplevel.tcl)
    public shelp {} {
	if {[winfo exists $this]} {
	    add_short_help $this $shelp
	}
    } 


    # -- protected variables --

    # count used for busy cursor
    protected busy_count_ {0}
}
