#include <tcl.h>
#include <tk.h>
#include "topmost.h"
#include "tkwin.h"


/*
 * Declarations for functions defined in this file.
 */

static int	topmostObjCmd _ANSI_ARGS_((ClientData clientData,
		    Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;		/* Library instance handle. */
    DWORD reason;		/* Reason this function is being called. */
    LPVOID reserved;		/* Not used. */
{
    return TRUE;
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * Topmost_Init --
 *
 *	This procedure initializes the topmost command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

EXPORT(int,Topmost_Init)(interp)
    Tcl_Interp *interp;
{
    Tcl_CreateObjCommand(interp, "topmost", topmostObjCmd, NULL, NULL);
    return Tcl_PkgProvide(interp, "topmost", "1.0");
}

/*
 *----------------------------------------------------------------------
 *
 * topmostObjCmd --
 *
 *	This function implements the tk "topmost" command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	Tries to place thew window supplied as an argument at the topmost
 *	level within the application or in the display.
 *
 *----------------------------------------------------------------------
 */

static int
topmostObjCmd(clientData, interp, objc, objv)
ClientData	clientData;
Tcl_Interp	*interp;
int		objc;
Tcl_Obj *CONST	objv[];
{
    Tk_Window	tkmain;
    Tk_Window	tkwin;
    char	*wpath;
    HWND	topw;
    int		ontop		= 1;
    int		was;

    Tcl_ResetResult(interp);
    if (objc < 2 || objc > 3)
    {
	Tcl_WrongNumArgs(interp, 1, objv, "window ?boolean?");
	return TCL_ERROR;
    }
    tkmain = Tk_MainWindow(interp);
    wpath = Tcl_GetStringFromObj(objv[1], NULL);
    if ((tkwin = Tk_NameToWindow(interp, wpath, tkmain)) == NULL)
    {
	return TCL_ERROR;
    }
    if (!Tk_IsTopLevel(tkwin)) {
	Tcl_AppendStringsToObj(Tcl_GetObjResult(interp), "window \"", wpath,
	    "\" isn't a top-level window", (char *)NULL);
	return TCL_ERROR;
    }
    if (!Tk_IsMapped(tkwin)) {
	Tcl_AppendStringsToObj(Tcl_GetObjResult(interp), "window \"", wpath,
	    "\" is not yet mapped", (char *)NULL);
	return TCL_ERROR;
    }
    topw = GetParent(Tk_GetHWND(Tk_WindowId(tkwin)));
    was = (GetWindowLong(topw, GWL_EXSTYLE) & WS_EX_TOPMOST) != 0;
    if (objc == 3)
    {
	if (Tcl_GetBooleanFromObj(interp, objv[2], &ontop) != TCL_OK)
	{
	    return TCL_ERROR;
	}
	SetWindowPos(topw, ontop ? HWND_TOPMOST : HWND_NOTOPMOST,
	    0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
    }
    Tcl_SetObjResult(interp, Tcl_NewBooleanObj(was));
    return TCL_OK;
}
