#ifndef BLOWFISH_H
#define BLOWFISH_H

/*
 * blowfish.h - declaration of types and procedures specific to Blowfish.
 *
 * CVS: $Id: blowfish.h,v 1.1.1.1 1996/10/07 19:08:44 aku Exp $
 */

#define MAXKEYBYTES      (56)		/* 448 bits, maximal size of a single key */
#define bf_N             (16)           /* number of rounds performed */
#define noErr             (0)
#define DATAERROR        (-1)
#define KEYBYTES          (8)
#define subkeyfilename   "Blowfish.dat"


/* AKU / 64bit processors already exist (DEC Alpha).
 */

#ifdef __alpha
#define UWORD_32bits  unsigned int
#else
#define UWORD_32bits  unsigned long
#endif

#define UWORD_16bits  unsigned short
#define UBYTE_08bits  unsigned char


/* AKU / map standard macro about byteorder
 *     /  (autoconf) to internal ones.
 *
 * - don't know how to check for VAX'en with autoconf -
 *   ORDER_BADC is therefore not used directly and old
 *   definitions do have priority over autoconf, enabling
 *   VAX compilation even if 'configure' did decide
 *   about a particular byteorder.
 */

#if ! (defined (ORDER_ABCD) || defined (ORDER_DCBA) || defined (ORDER_BADC))
#ifdef WORDS_BIGENDIAN
#define ORDER_ABCD
#else
#define ORDER_DCBA
#endif /* WORDS_BIGENDIAN */
#endif


/* choose a byte order for your hardware */
/* ABCD - big endian - motorola */
#ifdef ORDER_ABCD
union aword {
  UWORD_32bits word;
  UBYTE_08bits byte [4];
  struct {
    unsigned int byte0:8;
    unsigned int byte1:8;
    unsigned int byte2:8;
    unsigned int byte3:8;
  } w;
};
#endif	/* ORDER_ABCD */


/* DCBA - little endian - intel */
#ifdef ORDER_DCBA
union aword {
  UWORD_32bits word;
  UBYTE_08bits byte [4];
  struct {
    unsigned int byte3:8;
    unsigned int byte2:8;
    unsigned int byte1:8;
    unsigned int byte0:8;
  } w;
};
#endif	/* ORDER_DCBA */


/* BADC - vax */
#ifdef ORDER_BADC
union aword {
  UWORD_32bits word;
  UBYTE_08bits byte [4];
  struct {
    unsigned int byte1:8;
    unsigned int byte0:8;
    unsigned int byte3:8;
    unsigned int byte2:8;
  } w;
};
#endif	/* ORDER_BADC */


/* AKU / structure for a complete keyschedule.
 */

typedef struct Blowfish_keyschedule {
  UWORD_32bits bf_P [bf_N+2];  /* P-Boxes, 2 more than rounds executed */
  UWORD_32bits bf_S [4][256];  /* S-Boxes */
} Blowfish_keyschedule;


/* AKU / declared, but not realized! */
/* short opensubkeyfile(void);       */
/* unsigned long F(unsigned long x); */

/* AKU / unsigned long -> UWORD_32bits (more portable (64bit processors))
 *     / additional keyschedule-argument to all functions.
 */

/* Encrypt the specified 64bit block with the given keyschedule.
 */

extern void
Blowfish_encipher (Blowfish_keyschedule* keyschedule,
		   UWORD_32bits*         xl,
		   UWORD_32bits*         xr);

/* Decrypt the specified 64bit block with the given keyschedule.
 */

extern void
Blowfish_decipher (Blowfish_keyschedule* keyschedule,
		   UWORD_32bits*         xl,
		   UWORD_32bits*         xr);

/* Use the specified key (key, keybytes) to initialize the
 * keyschedule the last argument refers to.  The value of
 * 'keybytes' has to be lesser than or equal to MAXKEYBYTES.
 */

extern short
InitializeBlowfish (unsigned char         key [],
		    short                 keybytes,
		    Blowfish_keyschedule* keyschedule);

#endif /* BLOWFISH_H */
