#==============================================================================
#                                 Config.mk
#------------------------------------------------------------------------------
# Configuration file for Tcl sipp.  Edit the following variables to specify
# the location of required packages and other attribbutes.   
#
# For the macros that point to the Tcl/Tk/TclX include and library files, two
# sets of macros are provided.  The first set point to the installed location
# of the files.  The second set, which are commented out, point to the files
# in adjacent directories (e.g. ../tcl7.4), are used to get the include and
# library files from the distribution build directory.  Removing the '#' on
# these macros will cause them to override the first one.  They default to
# the prefix and exec_prefix specified to the tsipp configure program.
#
# IMPORTANT NOTE:
#     All paths should either be absoulte or relative to the src  directory
# below the directory containing this file (../../).
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version number of tsipp (Don't change this).
#
TSIPP_VERSION = 3.1b-b1

#------------------------------------------------------------------------------
# C compiler & ar commands to use. CC is normally specified on the make
# command line (make CC=gcc).
#
#CC  = cc
AR  = ar

#------------------------------------------------------------------------------
# Compiler debug/optimization/profiling flag to use.  Normally specified on
# the make command line (make CFLAGS=-g).
#
#CFLAGS=

#------------------------------------------------------------------------------
# EXtra flags:
#   o XCFLAGS - Extra compiler flags on all compiles and links
#   o XLDFLAGS - Extra compiler flags to specify at link time.
#   o XLDLIBS - Extra libraries to use at link time.
#
#XCFLAGS =
#XLDFLAGS =
#XLDLIBS =

#------------------------------------------------------------------------------
# If your compiling using installed header files, these are the prefix and
# exec_prefix locations used for Tcl/Tk/TclX.  They default to the location
# your specified for tsipp, which defaults to /usr/local

TCL_PREFIX = ${prefix}
TCL_EXEC_PREFIX = ${exec_prefix}

TCL_PREFIX = /usr/local
TCL_EXEC_PREFIX = ${TCL_PREFIX}

#------------------------------------------------------------------------------
# Directories containing the Tcl include file and library.  Either a
# combination of -L and -ltcl or an absolute path to the library maybe
# used to specified the library location.
#
TCLINCLDIR = ${TCL_PREFIX}/include
TCLLIB     = -L${TCL_EXEC_PREFIX}/lib${ARCH} -ltcl

#TCLDIR     = ../../tcl7.4
#TCLINCLDIR = ${TCLDIR}
#TCLLIB     = ${TCLDIR}/libtcl.a

#------------------------------------------------------------------------------
# Directories containing the TclX include file and library.    Either a
# combination of -L and -ltclx or an absolute path to the library maybe
# used to specified the library location.  Also, the tclxlibs.mk file generated
# by the TclX configure script.
#
TCLXINCLDIR = ${TCL_PREFIX}/include
TCLXLIB     = -L${TCL_EXEC_PREFIX}/lib${ARCH} -ltclx
TCLXLIBSMK  = ${TCL_EXEC_PREFIX}/lib${ARCH}/tclxlibs.mk

#TCLXDIR     = ../../tclX7.4a
#TCLXINCLDIR = ${TCLXDIR}/src
#TCLXLIB     = ${TCLXDIR}/src/libtclx.a
#TCLXLIBSMK  = ${TCLXDIR}/src/tclxlibs.mk

#------------------------------------------------------------------------------
# These options need to be defined if you want to build tksipp, a version of
# the Tk shell wish with the SIPP command set for rendering to photo images.
# You must have compiled Extended Tcl with the TK_BUILD=WISHX option set in
# its configuration file. (If you have wishx, you did).  TKSIPP_BUILD turns
# on building of tksipp if set to "BUILD".  Comment it out to disable building
# of TSIPP Tk features.
#
# Directories containing the Tk include file and the Tk and TkX library. 
# Either a combination of -L and -ltcl or an absolute path to the library maybe
# used to specified the library location.  Also, the tkxlibs.mk file generated
# by the TclX configure script.
#
TKSIPP_BUILD = BUILD

TKINCLDIR    = ${TCL_PREFIX}/include
TKLIB        = -L${TCL_EXEC_PREFIX}/lib${ARCH} -ltk
TKXLIB       = -L${TCL_EXEC_PREFIX}/lib${ARCH} -ltkx
TKXLIBSMK    = ${TCL_EXEC_PREFIX}/lib${ARCH}/tkxlibs.mk

#TKDIR        = ../../tk4.0
#TKINCLDIR    = ${TKDIR}
#TKLIB        = ${TKDIR}/libtk.a
#TKXLIB       = ${TCLXDIR}/tksrc/libtkx.a
#TKXLIBSMK    = ${TCLXDIR}/tksrc/tkxlibs.mk

#------------------------------------------------------------------------------
# Define the URTDEF, URTINCLDIR and URTLIBDIR if you are building with the Utah
# Raster Toolkit (URT).  A subset of the URT library is included in this
# distribution.  An installed version of the library can be used if URTLOCAL
# is not defined.  Comment these out if you don't want the URT toolkit.
#
# URTDEF defines a flag that enables RLE code in TSIPP.
# URTLOCAL will compile the copy of RLE that comes with TSIPP.
# URTINCL is the directory containing the URT RLE file (rle.h).
# URTLIB is the linker flags or file path to get URT RLE library (librle.a).
#
URTDEF     = -DTSIPP_HAVE_RLE
URTLOCAL   =  BUILD
URTINCLDIR = ../librle
URTLIB     = 

#------------------------------------------------------------------------------
# TSIPP master diectory path.  A directory containing the tsipp version number
# is built under here.
#
MASTERDIR=${prefix}/tsipp

#------------------------------------------------------------------------------
# Public bin and lib directories where symbolic links to the external files
# in the master directory are placed
#
BINDIR=${prefix}/bin
LIBDIR=${prefix}/lib

#------------------------------------------------------------------------------
# o TSIPP_MAN_CMD_SECTION - Section for tsipp command manual pages.
#
TSIPP_MAN_CMD_SECTION=1

#------------------------------------------------------------------------------
# o MAN_DIR_SEPARATOR - The separator character used in the directory name
#   of the cat* and man* manual directories.  This is usually empty or 
#   a period. i.e "/usr/man/man1" or "/usr/man/man.1".
#
MAN_DIR_SEPARATOR=

#------------------------------------------------------------------------------
# Arguments to use in when generating the demo pictures when you do a
# "make demo".  The following arguments may be specified for this flag:
#
#     o -mode rmode - The rendering mode.  The value of rmode is one of PHONG,
#        GOURAUD, FLAT or LINE.  Default is PHONG.
#     o -oversample factor - The oversampling factor.  The default is 2 for
#        most images, a couple are 3.  You might want to set this to 1 to speed
#        up the rendering.
#     o -size isize - The size of the image to render.  The result will be an
#        image isize X isize pixels.  The default is 256 pixels.
#     o -ppm - Force PPM (or PBM for LINE mode) format images to be rendered.
#        The default is to render RLE images if Tcl-SIPP was built with the 
#        Utah Raster Toolkit RLE library and a PPM images if RLE is not
#        available.
#        
DEMOARGS=
