#==============================================================================
#                               testprocs.tcl
#------------------------------------------------------------------------------
# Procedures used by tests.  Also does some general setup.
#------------------------------------------------------------------------------
# Copyright 1992-1995 Mark Diekhans
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Mark Diekhans makes
# no representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.
#------------------------------------------------------------------------------
# $Id: testprocs.tcl,v 5.1 1995/01/01 20:27:46 markd Exp $
#==============================================================================



#
# Run code and check the result.
#
proc test {test_name contents_of_test expect_result_code passing_results} {
    global errorInfo
    set result_code [catch {uplevel $contents_of_test} answer]

    if {("$answer" != "$passing_results") || 
            ($result_code != $expect_result_code)} { 
	puts stdout [replicate - 60]
	puts stdout "$test_name: FAILED:"
        puts stdout "$contents_of_test"
	puts stdout "---- Returned: ($result_code)"
        puts stdout "$answer"
	puts stdout "---- Result should have been: ($expect_result_code)"
	puts stdout "$passing_results"
	puts stdout "---- $test_name FAILED" 
    }
}

#
# Function to set up an object to render.
#

proc Ellipsoid {} {
    SippLightSourceCreate { 1.0  1.0 1.0} {0.9 1.0 0} DIRECTION
    SippLightSourceCreate {-1.0 -1.0 0.5} {1   1   1} DIRECTION 

    set shader [SippShaderBasic 0.5 0.6 0.2 {0.6 0.3 0.5}]
    set elipOH [SippEllipsoid {1.0 2.0 3.0} 15 $shader WORLD]
    SippObjectScale $elipOH 0.5

    SippObjectAddSubobj WORLD $elipOH

    set camera [SippCameraCreate {10.0 0.0 0.0} {0.0 0.0 0.0} {0.0 0.0 1.0}]
    SippCameraUse $camera
    SippShaderUnref $shader
    SippObjectUnref $elipOH
}

#
# Check if a file exists and what it size is.  Outputs a warning if its
# not the exact size, but within 4000 bytes.  I don't know why we get the
# variation in RLE file size, but the pictures look the same.
#
proc CheckFile {filename size} {
    if {![file exists $filename]} {        
        error "$filename does not exist"
    }
    set actualSize [file size $filename]
    if {$actualSize < ($size - 4000) || $actualSize > ($size + 4000)} {
        error "Wrong file size, expected close to: $size, got: $actualSize"
    }
}

#
# Matrices used in some tests.
#

global identityMat testMat1 testMat2

set identityMat [list {1.0 0.0 0.0 0.0} \
                      {0.0 1.0 0.0 0.0} \
                      {0.0 0.0 1.0 0.0} \
                      {0.0 0.0 0.0 1.0}]

set testMat1 [list {2.0 0.0 0.0 0.0} \
                   {0.0 3.0 0.0 0.0} \
                   {0.0 5.0 1.0 0.0} \
                   {0.0 7.0 0.0 1.0}]

set testMat2 [list {2.0 0.0 0.0 0.0} \
                   {4.0 6.0 0.0 0.0} \
                   {7.0 5.0 1.0 0.0} \
                   {1.0 7.0 0.0 1.0}]

#
# We will need the library.
#

loadlibindex ../tclsrc/tsipp.tlib
