/* 
 * tkSippAppInit.c --
 *
 *  Tk-SIPP initialization and main.
 *
 *-----------------------------------------------------------------------------
 * Copyright 1992-1995 Mark Diekhans
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Mark Diekhans makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tkSippAppInit.c,v 5.5 1995/07/01 22:17:06 markd Exp $
 *-----------------------------------------------------------------------------
 */

#include "../src/tSippInt.h"
#include "tk.h"

/*
 * The following variable is a special hack that insures the tcl
 * version of matherr() is used when linking against shared libraries
 */
EXTERN int matherr _ANSI_ARGS_((struct exception *));
int *tclDummyMathPtr = (int *) matherr;


/*=============================================================================
 * Tcl_AppInit --
 *
 *   Tk SIPP aplication initialization. 
 *-----------------------------------------------------------------------------
 */
int
Tcl_AppInit(interp)
    Tcl_Interp *interp;
{
    Tk_Window main;

    main = Tk_MainWindow(interp);

    if (TclX_Init(interp) == TCL_ERROR)
	return TCL_ERROR;

    if (main != NULL) {
        if (TkX_Init(interp) == TCL_ERROR)
            return TCL_ERROR;
    }

    /*
     * Initialize SIPP, and the Tcl-SIPP & Tk-SIPP commands.
     */
    if (TkSipp_Init (interp) == TCL_ERROR)
        return TCL_ERROR;

    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a startup file.
     */
    tcl_RcFileName = "~/.tsipprc";
    return TCL_OK;
}


/*=============================================================================
 * main --
 *
 *   Main program entry point.
 *
 *-----------------------------------------------------------------------------
 */
int
main (argc, argv)
    int    argc;
    char **argv;
{
    TkX_Main (argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}
