proc MAIN {argc argv} {
    global xf env menu

    wm withdraw .
    set xf(version) "1.21 Beta"
    
    if {$argc > 2} {
	puts stderr "Syntax: X-Files \[left_startupdir \[right_startupdir\]\]"
	exit
    }
    if [info exists env(XF_HOME)] {
        set xf(xf_home) [string trimright $env(XF_HOME) /]/
    } {
        set xf(xf_home) [TildeSubst $xf(xf_home)]
    }
    set xf(user_home) [TildeSubst "~/.x-files/"]
    if [catch {eval "exec $xf(MKDIR) -m 0644 $xf(user_home)"}] {
	MakeDirProc $xf(user_home)
    }
    ReadResources
    SetUnixCommands

    frame .xfiles
    pack .xfiles -side top
    set xf(trashdir) [TildeSubst [option get .xfiles trash_dir {}]]
    if {![file exists $xf(trashdir)]} {
        if [catch {eval "exec $xf(MKDIR) -m 0777 $xf(trashdir)"}] {
	    MakeDirProc $xf(trashdir)
	}
        exec chmod a+t $xf(trashdir)
    }
    set xf(actionbuttons_file) [LoadConfigFile xf "xfiles.buttons"]
    set xf(extensions_file) [LoadConfigFile xf "xfiles.extensions"]
    set xf(headers_file) [LoadConfigFile xf "xfiles.headers"]
    set xf(user_pophelp_file) [LoadConfigFile xf "xfiles.user_pophelp" 0]
    set xf(main_pophelp_file) "$xf(xf_home)xfiles.main_pophelp"
    foreach s [list "left" "right"] {
        NullSelect xf $s
        set xf(fsmode_$s) 0
        SetPaths xf $s [option get .xfiles startup_dir_$s {}]
	set xf(hiddens_$s) [option get .xfiles hidden_files_$s {}]
    }
    if {$argc > 0} {
	SetPaths xf "left" [lindex $argv 0]
    }
    if {$argc > 1} {
	SetPaths xf "right" [lindex $argv 1]
    }
    set xf(mailchk) [option get .xfiles mail_check {}]
    set xf(mailmsgbox) [option get .xfiles mail_message_box {}]
    set xf(r_mail_on_ack) [option get .xfiles read_on_ack {}]
    set xf(memenable) [option get .xfiles mem_label {}]
    set xf(timeenable) [option get .xfiles time_label {}]
    set xf(turbomode) [option get .xfiles turbo_file_operations {}]
    set xf(safedelete) [option get .xfiles safe_deletion {}]
    set xf(helpmode) 0
    set xf(editmode) 0
    set xf(editbutton) .xfright.bf(0).b(0) 
    set xf(clearselect) 0
    set xf(linz1) [option get .xfiles button_line_1 {}]
    set xf(linz2) [option get .xfiles button_line_2 {}]
    set xf(linz3) [option get .xfiles button_line_3 {}]
    set xf(linz4) [option get .xfiles button_line_4 {}]
    set xf(linz5) [option get .xfiles button_line_5 {}]
    set xf(linz6) [option get .xfiles button_line_6 {}]
    set xf(linz7) [option get .xfiles button_line_7 {}]
    set xf(linz8) [option get .xfiles button_line_8 {}]
    set xf(buttonset1) [option get .xfiles button_set_1 {}]
    set xf(buttonset2) [option get .xfiles button_set_2 {}]
    set xf(buttonset3) [option get .xfiles button_set_3 {}]
    set xf(buttonset4) [option get .xfiles button_set_4 {}]
    set xf(bitsi) [option get .xfiles protection_bits {}]
    set xf(reg) "<UNREGISTERED>"
    set xf(reversi) [option get .xfiles pack_order_reverse {}]
    set xf(mb) 1
    set xf(links) [option get .xfiles show_link_dest {}]
    set xf(outwin_num) 0
    set xf(X) 200
    set xf(Y) 200
    set xf(autoupdate) [option get .xfiles auto_update {}]
    set xf(leftautoud) [file mtime $xf(pathileft)]
    set xf(rightautoud) [file mtime $xf(pathiright)]
    set xf(noinfo) 0
    for {set a 0} {$a < 6} {incr a} {
        set menu($a) ""
    }	
    MenuBar xf
    FileWindow xf .ff
    frame .xfleft -relief sunken -bd 2
    frame .xfright -relief sunken -bd 2
    ButtonFrame 0 {L} {.xfleft}
    ButtonFrame 1 {R} {.xfright}
    ButtonFrame 2 {L} {.xfleft}
    ButtonFrame 3 {R} {.xfright}
    ButtonFrame 4 {L} {.xfleft}
    ButtonFrame 5 {R} {.xfright}
    ButtonFrame 6 {L} {.xfleft}
    ButtonFrame 7 {R} {.xfright}
    ButtonFrame 8 {L} {.xfleft}
    ButtonFrame 9 {R} {.xfright}
    ButtonFrame 10 {L} {.xfleft}
    ButtonFrame 11 {R} {.xfright}
    ButtonFrame 12 {L} {.xfleft}
    ButtonFrame 13 {R} {.xfright}
    ButtonFrame 14 {L} {.xfleft}
    ButtonFrame 15 {R} {.xfright}

    if !$xf(reversi) {
	set b "bottom"
    } {
	set b "top"
    }
    pack .ff -side $b -expand true -fill both
    pack .xfleft -side left -expand true -fill both
    pack .xfright -side right -expand true -fill both

    for {set i 0} {$i < 8} {incr i} {
        if {$xf(linz[expr $i+1])} {
            pack .xfleft.bf([expr 2 * $i]) -side bottom -expand true -fill x
            pack .xfright.bf([expr 2 * $i +1]) -side bottom -expand true -fill x
        }
    }
    
    $xf(pathEnt_left) xview moveto 1
    $xf(pathEnt_left) icursor end
    $xf(pathEnt_right) xview moveto 1
    $xf(pathEnt_right) icursor end
    Bindings
    wm minsize . 40 25
    wm title . "X-Files $xf(version)"
    wm deiconify .

    if {$xf(mailmsgbox) == 1} {
	.xfmenu.butt.m.mail entryconfigure Read* -state disabled
    }
    if [catch {set xf(mailtime) [file mtime $env(MAIL)]}] {
	.xfmenu.butt.m entryconfigure Mail* -state disabled
	unset xf(mailchk) xf(mailmsgbox)
    } {
	set xf(mailatime) [file atime $env(MAIL)]
	if $xf(mailchk) {
	    MailChk
	} {
	    .xfmenu.butt.m.mail entryconfigure Messa* -state disabled
	    .xfmenu.butt.m.mail entryconfigure Read* -state disabled
	}
    }
    if [file exists /proc/meminfo] {
        .xfmenu.butt.m.sub1 entryconfigure Mem* -state normal
    } {
	set xf(memenable) 0
        .xfmenu.butt.m.sub1 entryconfigure Mem* -state disabled
    }
    titletime
    titlemem
    after 1000 [list CheckErrorSize]
    unset xf(reversi)
    if $xf(autoupdate) {AutoUD}
    
}

proc ReadResources {} {
    global xf

    set res1 [catch {option readfile $xf(xf_home)xfilesrc startupFile} err1]
    set res2 [catch {option readfile $xf(user_home)xfilesrc userDefault}]
    if !$res2 {
	set xf(rcfile) $xf(user_home)xfilesrc
    } {
	set xf(rcfile) $xf(xf_home)xfilesrc
    }

    if {$res1 && $res2} {
	puts stderr "Could not read either $xf(xf_home)xfilesrc or $xf(user_home)xfilesrc. Exiting...\n"
	exit
    } elseif $res1 {
	puts stdout "X-Files startup warning: $err1\n"
    }
}
proc SetUnixCommands {} {
    global xf env

    if [catch {set type _$env(HOSTTYPE)}] {
	set type ""
    }

    if [file exists $xf(user_home)xfiles.commands$type] {
	source "$xf(user_home)xfiles.commands$type"
    } {
	set xf(COPY) {cp -r}
	set xf(MOVE) {mv -f}
	set xf(DEL) {rm -rf}
	set xf(MKDIR) {mkdir -p}
	set xf(LISTZIP) {unzip -l}
	set xf(TOZIP) {zip -rq}
	set xf(DELZIP) {zip -dq}
	set xf(FROMZIP) {unzip -oqq}
	set xf(ZIPOUTP) {unzip -pqq}
	set xf(LISTTAR) {tar tvf}
	set xf(TOTAR) {tar -rf}
	set xf(FROMTAR) {tar -xf}
	set xf(TAROUTP) {tar Oxf}
	if [catch {exec tar --help} foo] {
	    catch {eval exec tar} foo
	}
	if [regexp -nocase -- {--delete} $foo] {
	    set xf(DELTAR) {tar --delete -f}
	    set xf(notardel) 0
	} {
	    set xf(DELTAR) {tar -f}
	    set xf(notardel) 1
	}
	if [catch {exec df --help} foo] {
	    set xf(DISKFREE) df
	} {
	    if [regexp -nocase -- {--no-sync} $foo] {
		set xf(DISKFREE) {df --no-sync}
	    } {
		set xf(DISKFREE) df
	    }
	}
	set xf(df_1k) 0
	if ![catch {eval exec df -k}] {
	    append xf(DISKFREE) " -k"
	    set xf(df_1k) 1
	}
	if ![catch {eval exec df -T}] {
	    append xf(DISKFREE) " -T"
	    set xf(df_1k) 1
	}
	if [catch {eval exec du -sk}] {
	    set xf(DIRSIZE) {du -s}
	    set xf(du_1k) 0
	} {
	    set xf(DIRSIZE) {du -sk}
	    set xf(du_1k) 1
	}
	set fh [open $xf(user_home)xfiles.commands$type w]
	foreach i [list COPY MOVE DEL MKDIR LISTZIP TOZIP DELZIP \
		FROMZIP ZIPOUTP LISTTAR TOTAR FROMTAR TAROUTP DELTAR \
		notardel DISKFREE df_1k DIRSIZE du_1k] {
	    puts $fh "set xf($i) \{$xf($i)\}"
	}
	close $fh
    }
}

proc CheckErrorSize {} {
    global xf
    if {[file exists $xf(user_home)ErrorLog] \
	    && [file size $xf(user_home)ErrorLog] > [expr 100*1024]} {
	if [AskWin "The size of the X-Files 'ErrorLog'-file is over 100 kb.\nRemove it NOW ?"] { 
	    exec rm $xf(user_home)ErrorLog
	}
    }
}

proc FormatNumber {number} {
    set l [string length $number]
    set i 0
    set n 0
    while {$i<$l} {
	incr n
	set o $i
	incr i 3
	set foo($n) [string range $number [expr $l-$i] [expr $l-$o-1]]
    }
    for {set a $n} {$a > 0} {incr a -1} {
	append res "$foo($a) "
    }
    return $res
}	

proc ProtEditor {s} {
    global prot res xf

    if {[string compare {} $xf(selekted$s)] == 0} {
	InfoChange xf $s "No files selected!"
	bell
	after 4000 [list DefaultInfo xf $s]
	return
    }
    set xf(clearselect) 1
    catch {destroy .prot_edit}
    set pe [toplevel .prot_edit]
    wm withdraw .prot_edit
    wm title $pe "X-Files ProtEditor"
    wm geometry $pe +300+300
    wm minsize $pe 184 147
    
    frame $pe.top -bd 3 -relief ridge -bg "#bcbcbc"
    label $pe.top.l -bg "#c0c0c0"
    pack $pe.top.l -side left -fill x
    pack $pe.top -side top -fill x
    update idletasks

    frame $pe.m
    frame $pe.m.1
    frame $pe.m.2
    frame $pe.m.3
    frame $pe.m.4

    label $pe.m.1.u -text "user:"
    label $pe.m.1.g -text "group:"
    label $pe.m.1.a -text "all:"
    pack $pe.m.1.a $pe.m.1.g $pe.m.1.u -side bottom -pady 1
    pack $pe.m.1 -side left -fill y

    label $pe.m.2.l -text "read" -width 6
    checkbutton $pe.m.2.u -variable prot(ur) -onvalue 4 -pady 0
    checkbutton $pe.m.2.g -variable prot(gr) -onvalue 4 -pady 0
    checkbutton $pe.m.2.a -variable prot(ar) -onvalue 4 -pady 0
    pack $pe.m.2.a $pe.m.2.g $pe.m.2.u $pe.m.2.l -side bottom
    pack $pe.m.2 -side left -fill y

    label $pe.m.3.l -text "write" -width 6
    checkbutton $pe.m.3.u -variable prot(uw) -onvalue 2 -pady 0
    checkbutton $pe.m.3.g -variable prot(gw) -onvalue 2 -pady 0
    checkbutton $pe.m.3.a -variable prot(aw) -onvalue 2 -pady 0
    pack $pe.m.3.a $pe.m.3.g $pe.m.3.u $pe.m.3.l -side bottom
    pack $pe.m.3 -side left -fill y

    label $pe.m.4.l -text "execute" -width 6
    checkbutton $pe.m.4.u -variable prot(ue) -pady 0
    checkbutton $pe.m.4.g -variable prot(ge) -pady 0
    checkbutton $pe.m.4.a -variable prot(ae) -pady 0
    pack $pe.m.4.a $pe.m.4.g $pe.m.4.u $pe.m.4.l -side bottom
    pack $pe.m.4 -side left -fill y

    pack $pe.m -side top -fill both

    frame $pe.b -bd 3 -relief ridge
    button $pe.b.ok -text "OK" -width 6 \
            -command {\
            set user [expr $prot(ur)+$prot(uw)+$prot(ue)];\
            set group [expr $prot(gr)+$prot(gw)+$prot(ge)];\
            set all [expr $prot(ar)+$prot(aw)+$prot(ae)];\
            set res $user$group$all}

    button $pe.b.cancel -text "Cancel" -width 6 \
            -command {set res {}}
    pack $pe.b.ok -side left
    pack $pe.b.cancel -side right
    pack $pe.b -side top -fill x
    
    focus $pe.b.cancel
    bind $pe <Control-c> {set res ""}
    bind $pe <Escape> {set res ""}
    bind $pe <Return> {.prot_edit.b.ok invoke}

    wm deiconify .prot_edit
  
    set changed 0
    foreach f $xf(selekted$s) {
	SetChecks prot $xf(pathi$s) $f
	$pe.top.l config -text "File: $f"
	tkwait variable res
	
        if [string compare {} $res] {
	    set changed 1
            eval exec chmod $res $xf(pathi$s)$f
        }
    }
    destroy $pe
    unset prot
    if $changed {
	UpdateListbox xf $s
    }
}

proc SetChecks {arr path file} {
    upvar $arr prot

    set mode [BitsProc $path$file]
    if {[string compare [string index $mode 1] "r"] == 0} {
        set prot(ur) 4
    } {
	set prot(ur) 0
    }
    if {[string compare [string index $mode 2] "w"] == 0} {
        set prot(uw) 2
    } {
	set prot(uw) 0
    }
    if {[string compare [string index $mode 3] "x"] == 0} {
        set prot(ue) 1
    } {
	set prot(ue) 0
    }
    if {[string compare [string index $mode 4] "r"] == 0} {
        set prot(gr) 4
    } {
	set prot(gr) 0
    }
    if {[string compare [string index $mode 5] "w"] == 0} {
        set prot(gw) 2
    } {
	set prot(gw) 0
    }
    if {[string compare [string index $mode 6] "x"] == 0} {
        set prot(ge) 1
    } {
	set prot(ge) 0
    }
    if {[string compare [string index $mode 7] "r"] == 0} {
        set prot(ar) 4
    } {
	set prot(ar) 0
    }
    if {[string compare [string index $mode 8] "w"] == 0} {
        set prot(aw) 2
    } {
	set prot(aw) 0
    }
    if {[string compare [string index $mode 9] "x"] == 0} {
        set prot(ae) 1
    } {
	set prot(ae) 0
    }
}
proc LoadConfigFile {arr file {nhf 1}} {
    upvar $arr xf

    if [file exists $xf(user_home)$file] {
	if $nhf {
	    if [catch {uplevel #0 source $xf(user_home)$file} err] {
		puts stderr "Error while reading $xf(user_home)$file: $err"
	    } {
		return $xf(user_home)$file
	    }
	} {
	    return $xf(user_home)$file
	}
    }
    if [file exists $xf(xf_home)$file] {
	if $nhf {
	    if [catch {uplevel #0 source $xf(xf_home)$file} err] {
		puts stderr "Error while reading $xf(xf_home)$file: $err"
	    } {
		return $xf(xf_home)$file
	    }
	} {
	    return $xf(xf_home)$file
	}
    }
    puts stderr "Could not read $file either in ~/.x-files/ or in $xf(xf_home), exiting..."
    exit
}

proc MakeSaveDir {} {
    global xf

    if ![file exists $xf(user_home)] {
	if [catch {eval exec $xf(MKDIR) $xf(user_home)}] {
	    MakeDirProc $xf(user_home)
	}
    }
}

proc MakeDirProc {dir {parent {}}} {
    if {[string compare {} $dir] == 0} {return}
    set dir [string trimright $dir /]/
    regexp {^[^/]*/} $dir alku
    append parent $alku
    regsub {^[^/]*/} $dir {} loppu
    if ![file exists $parent] {
	exec mkdir $parent
    }
    MakeDirProc $loppu $parent
}
proc TildeSubst {path} {
    global env

    if {[string match "\." $path] || [string match "\./" $path]} {
	return [string trimright [pwd] /]/
    } 
    if [string match ~* $path] {
        set dir [pwd]/
        regexp {^[^/]*} $path polku
        if [catch {cd $polku} err] {
            MessageBox "Invalid pathname: $path\nError: $err"
            return [string trimright $env(HOME) /]/
        }
        set tmp [pwd]
	catch {cd $dir}
        regsub {^[^/]*} $path $tmp temp
        return [string trimright $temp /]/
    }
    return [string trimright $path /]/
}

proc GetParentDir {dir} {
    set result [file dirname [string trimright $dir /]]/
    if [string match $result //] {
        set result /
    }
    return $result
}

proc Bindings {} {
    global xf
    bind . <Enter> {
	set xf(X) %X
	set xf(Y) %Y
	if $xf(helpmode) {
	    . config -cursor question_arrow
	}
        if ![string match {*button_edit*} %W] {
            focus %W
        }
    }
    bind . <Tab> {}
    bind . <Control-c> {Confirm_exit}
    bind . <Control-z> {wm iconify .}
    bind Button <space> {continue}
    bind Menubutton <space> {continue}
    bind . <space> {
	if [string match {*left*} %W] {
	    set ent $xf(pathEnt_left)
	} {
	    set ent $xf(pathEnt_right)
	}
	if [string match $ent %W] {
	    $ent delete [expr [string length [$ent get]]-1] end
	}
	focus $ent
	$ent select range 0 end
	break
    }
    bind all <Motion> {set xf(X) %X ; set xf(Y) %Y}
    bind all <Button-1> {
	if {$xf(helpmode) == 1 } {
	    if {$xf(editmode) > 0} {
		set xf(editbutton) [focus]
	    }
            HelpInfo %x %y %W
	    tkButtonUp %W
        } 
    }
    
    bind all <Control-h> {
	.xfmenu.help.m invoke 1
    }
    
    bind all "+" {if {$xf(helpmode) == 1} { MainHelp }}
    
    bind all <Control-d> {Xf_variable_dumb}
    
    bind . <Key> {
	set xf(butsetindic) ""
	switch %K {
	    F1 {ButtonLines 1 1}
	    F2 {ButtonLines 2 1}
	    F3 {ButtonLines 3 1}
	    F4 {ButtonLines 4 1}
	    F5 {ButtonLines 5 1}
	    F6 {ButtonLines 6 1}
	    F7 {ButtonLines 7 1}
	    F8 {ButtonLines 8 1}
	    F9 {
		set xf(butsetindic) "Set 1 (F9)"
		ButtonLineSets $xf(buttonset1)
	    }
	    F10 {
		set xf(butsetindic) "Set 2 (F10)"
		ButtonLineSets $xf(buttonset2)
		break
	    }
	    F11 {
		set xf(butsetindic) "Set 3 (F11)"
		ButtonLineSets $xf(buttonset3)
	    }
	    F12 {
		set xf(butsetindic) "Set 4 (F12)"
		ButtonLineSets $xf(buttonset4)
	    }
	    default {}
	}
    }
    bind $xf(pathEnt_left) <Key> {
	if [%W select present] {
	    if {![string compare %K space]} {
		focus $xf(pathEnt_right)
		$xf(pathEnt_right) select range 0 end
		%W xview moveto 1
		%W icursor end
		break
	    }
	    if {![string compare %K Delete] || ![string compare %K BackSpace]} {
		%W delete sel.first sel.last
                if {[string compare {} $xf(pathileft)] == 0} {
		    %W insert 0 "/"
		}
		%W xview moveto 1
		%W icursor end
		break
	    } {
		%W select clear
	    }
	}
	if {![string compare %K Tab]} {
	    DirComplete xf "left"
	    break
	}
    }
    bind $xf(pathEnt_right) <Key> {
	if [%W select present] {
	    if {![string compare %K space]} {
		focus $xf(pathEnt_left)
		$xf(pathEnt_left) select range 0 end
		%W xview moveto 1
		%W icursor end
		break
	    }
	    if {![string compare %K Delete] || ![string compare %K BackSpace]} {
		%W delete sel.first sel.last
                if {[string compare {} $xf(pathiright)] == 0} {
		    %W insert 0 "/"
		}
		%W xview moveto 1
		%W icursor end
		break
	    } {
		%W select clear
	    }
	}
	if {![string compare %K Tab]} {
	    DirComplete xf "right"
	    break
	}
    }
    bind $xf(pathEnt_left) <Return> {
	%W select clear
	BindReturn xf "left"
    }	
    bind $xf(pathEnt_right) <Return> {
	%W select clear
	BindReturn xf "right"
    }	
    bind $xf(pathEnt_left) <Button-1> {
        if $xf(helpmode) {
            HelpInfo %x %y %W
	    break
        }
    }
    bind $xf(pathEnt_right) <Button-1> {
        if $xf(helpmode) {
            HelpInfo %x %y %W
	    break
        }
    }
    bind $xf(pathEnt_left) <Button-3> {
        ListFlash xf "left"
        NullSelect xf "left"
	UpdateListbox xf "left"
    }
    bind $xf(pathEnt_right) <Button-3> {
        ListFlash xf "right"
        NullSelect xf "right"
	UpdateListbox xf "right"
    }
    bind $xf(pathEnt_left) <Leave> {
	$xf(pathEnt_left) select clear
    }	
    bind $xf(pathEnt_right) <Leave> {
	$xf(pathEnt_right) select clear
    }
    bind $xf(pathEnt_left) <Enter> {
	if $xf(helpmode) {
	    %W config -cursor question_arrow
	} {
	    SetArrowPointer %W
	}
	focus %W
	%W xview moveto 1
	%W icursor end
    }	
    bind $xf(pathEnt_right) <Enter> {
	if $xf(helpmode) {
	    %W config -cursor question_arrow
	} {
	    SetArrowPointer %W
	}
	focus %W
	%W xview moveto 1
	%W icursor end
    }	
    foreach k [list left.dirup left.dirroot middle.all_left middle.no_left \
	    middle.copyleft middle.swap middle.copyright middle.all_right \
	    middle.no_right right.dirup right.dirroot] {
        bind .ff.top.$k <Button-1> {
            if $xf(helpmode) {
                HelpInfo %x %y %W
                tkButtonUp %W
		break
            }
        } 
	bind .ff.top.$k <Enter> {
	    focus %W
	    if $xf(helpmode) {
		%W config -cursor question_arrow
	    } {
		SetArrowPointer %W
	    }
	}
	bind .ff.top.$k <Button-2> {tkButtonDown %W}
	bind .ff.top.$k <Button-3> {tkButtonDown %W}
	bind .ff.top.$k <ButtonRelease-2> {tkButtonUp %W}
	bind .ff.top.$k <ButtonRelease-3> {tkButtonUp %W}
    }
    
    foreach k [list left.dirHistory right.dirHistory] {
        bind .ff.top.$k <Button-1> {
            if $xf(helpmode) {
                HelpInfo %x %y %W
                tkButtonUp %W
		break
            }
        } 
	bind .ff.top.$k <Button-2> {
	    if {$tkPriv(inMenubutton) != ""} {
		tkMbPost $tkPriv(inMenubutton) %X %Y
	    }
	}
	bind .ff.top.$k <Button-3> {
	    if {$tkPriv(inMenubutton) != ""} {
		tkMbPost $tkPriv(inMenubutton) %X %Y
	    }
	}
    }
    
    foreach k [list middle.hideleft middle.hideright] {
        bind .ff.top.$k <Button-1> {
            if $xf(helpmode) {
                HelpInfo %x %y %W
                tkButtonUp %W
		break
            }
        } 
	bind .ff.top.$k <Button-2> {tkCheckRadioInvoke %W}
	bind .ff.top.$k <Button-3> {tkCheckRadioInvoke %W}
    }

    bind Button <Return> {[focus] invoke}

    bind Listbox <Escape> {}
    bind Listbox <Key-Up> {
	%W yview scroll -1 units
    }
    bind Listbox <Key-Down> {
	%W yview scroll 1 units
    }
    bind Listbox <space> {
	if [string match {*left*} %W] {
	    set ent $xf(pathEnt_left)
	} {
	    set ent $xf(pathEnt_right)
	}
	focus $ent
	$ent select range 0 end
	break
    }
    bind Listbox <Button-1> {
	set xf(b1r) 1
        if $xf(helpmode) {
            HelpInfo %x %y %W
	    break
        } {
            tkCancelRepeat 
            %W activate @%x,%y
            tkListboxBeginToggle %W [%W index @%x,%y]
        }
    }
    bind Listbox <ButtonRelease-1> {
	if [string match {*left*} %W] {
	    set s "left"
	    set o "right"
	} {
	    set s "right"
	    set o "left"
	}
	tkCancelRepeat 
	set a [%W index active]
	set n [%W nearest %y]
	if {$a <= $n} {
	    set alku $a
	    set loppu $n
	} {
	    set alku $n
	    set loppu $a
	}

	for {set i $alku} {$i <= $loppu} {incr i} {
	    if {$i == 0 && [string match {\.\.*} [$xf(fuf).${s}list get 0]]} {
		$xf(fuf).${s}list selection clear 0
		SetArrowPointer .
		continue
	    }
	    set ind [lsearch -exact $xf(selekted${s}_int) $i]
	    if ![%W select includes $i] {
		if {$ind > -1} {
		    AddSelSize xf $s $i "-"
		    set xf(selekted${s}_int) [lreplace $xf(selekted${s}_int) $ind $ind]
		    set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
		}
	    } {
		if {$ind == -1} {
		    set xf(selekted${s}_int) [lsort -integer [lappend xf(selekted${s}_int) $i]]
		    AddSelSize xf $s $i "+"
		}
	    }
	}
	if $xf(b1r) { 
	    DefaultInfo xf $s
	}
	set xf(b1r) 1
	%W activate @%x,%y
    }
    bind Listbox <B1-Motion> {
	if !$xf(helpmode) {
	    set tkPriv(x) %x
	    set tkPriv(y) %y
	    tkListboxMotion %W [%W index @%x,%y]
	}
    }
    bind Listbox <Double-Button-1> {
	set xf(b1r) 0
	if [string match {*left*} %W] {
	    set s "left"
	} {
	    set s "right"
	}
	SetWaitPointer .
	FileClick xf $s %y 
	FileOK xf $s "L"
        unset xf(item$s)
        SetArrowPointer .
    }
    bind Listbox <Button-2> {
	set xf(b2r) 1
	tkCancelRepeat
	%W scan mark %x %y
	set tkPriv(x) %x
	set tkPriv(y) %y
	set tkPriv(mouseMoved) 0
	%W activate @%x,%y
	after 300 [list set xf(b2r) 0]
    }
    bind Listbox <B2-Motion> {
	set xf(b2r) 0
	if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {
	    set tkPriv(mouseMoved) 1
	}
	if $tkPriv(mouseMoved) {
	    %W scan dragto %x %y
	}
    }
    bind Listbox <Double-Button-2> {}
    bind Listbox <ButtonRelease-2> {
	if {$xf(b2r)} {	    
	    if [string match {*left*} %W] {
		set s "left"
		set o "right"
	    } {
		set s "right"
		set o "left"
	    }
	    SetWaitPointer .
	    set i [%W nearest %y]
	    if [%W select includes active] {
		AddSelSize xf $s [%W index active] "-"
		set ind [lsearch -exact $xf(selekted$s) [GetFileName $s [%W get active]]]
		if {$ind > -1} {
		    set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
		    set xf(selekted${s}_int) [lreplace $xf(selekted${s}_int) $ind $ind]
		}
                CorrectColor $o xf {} {}
		ShowSelSize xf $s
	    }
	    FileClick xf $s %y 
	    %W select set $i
	    update idletasks
	    after 500 [list %W selection clear $i]
	    
	    FileOK xf $s "M"
            unset xf(item$s)
	}
    }
    bind Listbox <Button-3> {
	if [string match {*left*} %W] {
	    set popup $xf(fuf).leftlist.popup_menu
	} {
	    set popup $xf(fuf).rightlist.popup_menu
	}
	tk_popup $popup %X %Y
    }
    bind Listbox <Return> {break}

    bind Listbox <KeyPress> {
	if [string match {*left*} %W] {
	    set s "left"
	} {
	    set s "right"
	}
	ListKey %W %A $xf(pathi$s) $xf(fsmode_$s) 
    }
    foreach j [list "left" "right"] {
        bind $xf(infoEnt_$j) <Enter> {
	    focus %W
            if $xf(helpmode) {
                %W config -cursor "question_arrow"
            } {
                SetArrowPointer %W
            }
        }
        bind $xf(infoEnt_$j) <Button-1> {
            if $xf(helpmode) {
                HelpInfo %x %y %W
		break
            }
        }
    }

}

proc ListKey {W a path fsmode} {
    global dirpit_left dirpit_right

    if [string compare {} $a] {
        if [string match *left* $W] {
            set dirpit $dirpit_left
        } elseif [string match *right* $W] {
            set dirpit $dirpit_right
        }        
        if {[string match "/" $path] && $fsmode == 0} {
            set others [$W get $dirpit end]
        } {
            set others [$W get [expr $dirpit+1]  end]
        }
	set flag 1
	set pad 1
	set i 0
	while {$flag} {
	    set loc [lsearch $others $a*]
	    if {$loc > -1} {
		set flag 0
		$W yview [expr $loc+$dirpit+$pad]
	    } {
		scan $a %c i
		if {$i > 126} {
		    set flag 0
		    $W yview moveto 1
		} {
		    set pad 0
		    set a [format %c [incr i]]
		    set loc [lsearch $others $a*]
		}
	    }
	}
    }
}
proc SetWaitPointer {W} {
    $W config -cursor watch
    update idletasks
}
proc SetArrowPointer {W} {
    $W config -cursor top_left_arrow
    update idletasks
}
proc FileWindow {arr parent args} {
    upvar $arr xf
    
    if $xf(reversi) {
	set t "bottom"
    } {
	set t "top"
    }
    frame $parent
    frame $parent.top 
    frame $parent.files
    frame $parent.bottom
    
    set xf(fuf) $parent.files
    FileEntries xf $parent.top -relief sunken -exportselection true 
    if $xf(bitsi) {
	set wi 47
    } {
	set wi 40
    }

    FileFrame xf $parent.files "left" -width $wi -height 25 -setgrid true \
	    -selectmode extended \
	    -exportselection false -relief ridge
    FileFrame xf $parent.files "right" -width $wi -height 25 -setgrid true \
	    -selectmode extended \
	    -exportselection false -relief ridge 
    FileInfo xf $parent.bottom 
    pack $parent.top -side $t -fill x
    pack $parent.bottom -side bottom -fill x
    pack $parent.files.left $parent.files.right -side left -expand true \
	    -fill both 
    pack $parent.files -side top -expand true -fill both 
    UpdateListbox xf "left"
    UpdateListbox xf "right" 

}

proc ListFlash {arr s} {
    upvar $arr xf

    set color [$xf(fuf).${s}list cget -bg]
    $xf(fuf).${s}list config -bg "#f0f0f0"
    update idletasks
    $xf(fuf).${s}list config -bg $color
    update idletasks
}

proc InfoChange {arr s string} {
    upvar $arr xf

    if !$xf(noinfo) {
	set xf(infoA$s) ""
	$xf(infoEnt_$s) config -justify left
	$xf(infoEnt_$s) config -bg "#10106a"
	set xf(infoA$s) $string
	update idletasks
    }
}

proc DirComplete {arr s} {
    upvar $arr xf

    if {[string compare {} $xf(pathi$s)] == 0} {
	set xf(pathi$s) "/"
	$xf(pathEnt_$s) xview moveto 1
	$xf(pathEnt_$s) icursor end
        ListFlash xf $s
	bell
	return
    }
    set tail [file tail $xf(pathi$s)]
    if {[string compare {} $tail] == 0} {
        ListFlash xf $s
	bell
	$xf(pathEnt_$s) xview moveto 1
	$xf(pathEnt_$s) icursor end
	return
    }
    if {[string match /* $xf(pathi$s)] && ![string match /*/* $xf(pathi$s)]} {
	set dir "/"
    } elseif [string match /*/* $xf(pathi$s)] {
	set dir [file dirname $xf(pathi$s)]/
    } elseif  [string compare {/*} $xf(pathi$s)] {
	set dir "/"
	set tail $xf(pathi$s)
    }
    set files [glob -nocomplain $dir$tail*]
   
    if {[llength [split $files]] == 1} {
	if [file isdirectory $files] {
	    set xf(pathi$s) $dir[file tail $files]/
	    $xf(pathEnt_$s) xview moveto 1
	    $xf(pathEnt_$s) icursor end
	}
    } {
	if {[llength [split $files]] > 1} {
	    foreach f $files {
		if [file isdirectory $f] {
		    lappend dirs [file tail $f]
		}
	    }
	    unset files
	    set l [expr [string length $tail] -1]
	    set miss 0
	    set dir1 [lindex $dirs 0]
	    while {!$miss} {
		incr l
		if {$l == [string length $dir1]} {
		    break
		}
		set new [string range $dir1 0 $l]
		foreach d $dirs {
		    if ![string match $new* $d] {
			set miss 1
			incr l -1
			break
		    }
		}
	    }
	    set xf(pathi$s) $dir[string range $dir1 0 $l]
	    $xf(pathEnt_$s) xview moveto 1
	    $xf(pathEnt_$s) icursor end
            ListFlash xf $s
	    bell
	} {
	    set xf(pathi$s) $dir$tail
	    $xf(pathEnt_$s) xview moveto 1
	    $xf(pathEnt_$s) icursor end
            ListFlash xf $s
	    bell
	}
    }
}
proc SelectionSize {arr s} {
    upvar $arr xf
    global stop_calc

    set stop_calc 0
    if [string match {*left*} $s] {
	set s "left"
	set o "right"
    } {
	set s "right"
	set o "left"
    }
    set xf(selekted${s}_int) [$xf(fuf).${s}list curselection]
    set xf(selsum$s) 0
    set xf(selekted$s) {}
    if {[string compare {} $xf(selekted${s}_int)] == 0} {
	DefaultInfo xf $s
	return
    }
    foreach f $xf(selekted${s}_int) {
	if $stop_calc {
	    NullSelect xf $s
	    DefaultInfo xf $s
	    return
	}
	set fileitem [$xf(fuf).${s}list get $f]
	lappend xf(selekted$s) [GetFileName $s $fileitem]
	
	regexp {([0-9]*()$)} $fileitem size
	if {[string compare {} $size] == 0} {
	    set size 1024
	}
	set xf(selsum$s) [expr $xf(selsum$s) + $size]
        update
    }
    CorrectColor $o xf {} {}
    ShowSelSize xf $s
    SetArrowPointer .
    
}

proc AddSelSize {arr s ind mark} {
    upvar $arr xf
    
    set fileitem [$xf(fuf).${s}list get $ind]
    if [string match $mark "+"] {
	set xf(selekted$s) [linsert $xf(selekted$s) \
                [lsearch -exact $xf(selekted${s}_int) $ind] \
		[GetFileName $s $fileitem]]
    }

    regexp {([0-9]*()$)} $fileitem size
    if {[string compare {} $size] == 0} {
        set size 1024
    }
    set xf(selsum$s) [expr $xf(selsum$s) $mark $size]
}

proc ShowSelSize {arr s} {
    upvar $arr xf

    InfoChange xf $s "Selected [llength $xf(selekted${s}_int)] \
	    objects: [FormatNumber [expr $xf(selsum$s)/1024]] kb"
}
proc BindReturn {arr s} {
    upvar $arr xf
    History xf $s
    set xf(item$s) [TildeSubst $xf(pathi$s)]
    FileOK xf $s {} 
    unset xf(item$s)
    focus $xf(fuf).${s}list
}
proc FileEntries {arr parent args } {
    upvar $arr xf
    global menu
    frame $parent.left 
    frame $parent.middle
    frame $parent.right
    
    set menuimage [image create bitmap -data "#define Menubutton_width 11
      #define Menubutton_height 14
      static unsigned char Menubutton_bits[] = {
	  0x00, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	  0xfe, 0x03, 0xfc, 0x01, 0xf8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00,
	  0xfe, 0x03, 0xfe, 0x03};"]
    
    button $parent.left.dirup -text .. -padx 0 -pady 0 -command {dirUp xf "left"}
    button $parent.left.dirroot -text / -padx 2 -pady 0 -command {dirRoot xf "left"}
    menubutton $parent.left.dirHistory -padx 0 -pady 0 -relief raised \
	    -menu $parent.left.dirHistory.menu -image $menuimage
    
    
    button $parent.right.dirup -text .. -padx 0 -pady 0 -command {dirUp xf "right"}
    button $parent.right.dirroot -text / -padx 2 -pady 0 \
	    -command {dirRoot xf "right"}
    menubutton $parent.right.dirHistory -padx 0 -pady 0 -relief raised \
	    -menu $parent.right.dirHistory.menu -image $menuimage
    
    pack $parent.left.dirroot $parent.left.dirup $parent.left.dirHistory \
	    -side left
    pack $parent.right.dirroot $parent.right.dirup -side right
    
    set xf(ml) [menu $parent.left.dirHistory.menu -tearoff 0]
    set xf(mr) [menu $parent.right.dirHistory.menu -tearoff 0]
    set e_left [eval {entry $parent.left.e  \
	    -textvariable xf(pathileft) } $args]
    set e_right [eval {entry $parent.right.e \
	    -textvariable xf(pathiright)} $args]
    
    pack $parent.left.e -side left -expand true -fill x
    pack $parent.right.e -side right -expand true -fill x
    pack $parent.right.dirHistory -side right
    set xf(pathEnt_left) $e_left
    set xf(pathEnt_right) $e_right
    checkbutton $parent.middle.hideleft -text H -padx 1 -pady 1 \
	    -variable xf(hiddens_left) \
	    -indicatoron false -command {SetWaitPointer .;NullSelect xf "left";FileList left $xf(pathileft);DefaultInfo xf "left"}\
	    -selectcolor palevioletred1
    
    button $parent.middle.all_left -text A -padx 1 -pady 0 \
	    -command {SelectAll xf "left"}
    button $parent.middle.no_left -text N -padx 1 -pady 0 \
	    -command {UnselectAll xf "left";DefaultInfo xf "left"}
    button $parent.middle.copyleft -text << -padx 0 -pady 0 \
            -command {Copyleft xf "left"} -cursor left_side
    button $parent.middle.swap -text <> -padx 0 -pady 0 -command {Swap_sides xf} -cursor exchange
    button $parent.middle.copyright -text >> -padx 0 -pady 0 \
	    -command {CopyRight xf "right"} -cursor right_side
    button $parent.middle.all_right -text A -padx 1 -pady 0 \
	    -command {SelectAll xf "right"}
    button $parent.middle.no_right -text N -padx 1 -pady 0 \
	    -command {UnselectAll xf "right";DefaultInfo xf "right"}
    checkbutton $parent.middle.hideright -text H -padx 1 -pady 1 \
	    -variable xf(hiddens_right) \
	    -indicatoron false -command {SetWaitPointer .;NullSelect xf "right";FileList "right" $xf(pathiright);\
            DefaultInfo xf "right"} -selectcolor palevioletred1
    
    pack $parent.middle.hideleft $parent.middle.all_left \
	    $parent.middle.no_left $parent.middle.copyleft \
	    $parent.middle.swap $parent.middle.copyright \
	    $parent.middle.no_right $parent.middle.all_right \
	    $parent.middle.hideright \
	    -side left -anchor center
    pack $parent.left -in $parent -side left -expand true -fill x
    pack $parent.right -in $parent -side right -expand true -fill x
    pack $parent.middle -in $parent -side top -expand true \
	    -fill y -anchor center
    
}
proc History {arr s} {
    upvar $arr xf
    global menu
    
    for {set i 0} {$i < 6} {incr i} {  
	if [string match $xf(backup_$s) $menu($i)] {
	    if {$i == 0} {
		return
	    }
	    
	    catch {$xf(ml) delete 0 end}
	    catch {$xf(mr) delete 0 end}
	    
	    for {set a $i} {$a > 0} {incr a -1} {
		set aa [expr $a-1] 
		set menu($a) $menu($aa)
	    }
	    set menu(0) $xf(backup_$s)
	    for {set a 0} {$a < 6} {incr a} {
		if {$menu($a) != ""} {
		    $xf(ml) add command -label $menu($a) \
			    -command [list Menudir xf "left" $menu($a)]
		    $xf(mr) add command -label $menu($a) \
			    -command [list Menudir xf "right" $menu($a)]
		}
	    }	
            return
	}
    }
    catch {$xf(ml) delete 0 end}
    catch {$xf(mr) delete 0 end}
    for {set i 5} {$i > 0} {incr i -1} {
        set ii [expr $i-1]
        set menu($i) $menu($ii)
    }
    set menu(0) $xf(backup_$s)
    for {set i 0} {$i < 6} {incr i} {
        if {$menu($i) != ""} {
            $xf(ml) add command -label $menu($i) \
                    -command [list Menudir xf "left" $menu($i)]
            $xf(mr) add command -label $menu($i) \
                    -command [list Menudir xf "right" $menu($i)]
        }
    }	
    
}
proc Menudir {arr s path} {
    upvar $arr xf

    if {[string compare \/ $path] == 0} {
	regsub ^/ $path {} todir
    } {
	set todir $path
    }
    ChangeDir $s $todir
}
proc UpdateListbox {arr s {pos {}} {delay {}} {newfiles {}}} {
    upvar $arr  xf
    global dirpit_left dirpit_right
    
    if [string match $s left] {
	set dirpit $dirpit_left
        set o "right"
    } {
	set dirpit $dirpit_right
        set o "left"
    }

    if {[string compare {} $pos] == 0} {
        set pos [expr [lindex [$xf(fuf).${s}list yview] 0]+0.0001]
    }
    FileList $s $xf(pathi$s) {} {} files dirs
    if {[string compare {} $xf(selekted${s}_int)] == 0} {
        if {[string compare {} $delay]} {
            after $delay [list DefaultInfo xf $s]
        } {
            DefaultInfo xf $s
        }
    } {
        if [string compare {} $newfiles] {
	    set files [concat \.\./ $dirs $files]
            foreach n $newfiles {
                lappend nfint [lsearch $files $n*]
            }
	    set change 0
	    set index 0
	    foreach f $xf(selekted${s}_int) {
		if {$f == [expr [lindex $nfint $change]-$change]} {
		    incr change
		}
		set new [expr $f+$change]
                if {[lsearch -exact $xf(selekted${s}_int) $new] < 0} {
		    incr change
                    set new [expr $f+$change]
                }

		$xf(fuf).${s}list select set $new
	    }
            set xf(selekted${s}_int) [$xf(fuf).${s}list curselection]
        } {
	    foreach f $xf(selekted${s}_int) {
		$xf(fuf).${s}list select set $f
	    }
	}
        CorrectColor $o xf {} {}
        if [string compare {} $delay] {
            after $delay [list ShowSelSize xf $s]
        } {
            ShowSelSize xf $s
        }
    }
    $xf(fuf).${s}list yview moveto $pos
    
}
proc SelectAll {arr s} {
    upvar $arr xf

    SetWaitPointer .
    InfoChange xf $s "Calculating..."
    $xf(fuf).${s}list select set 0 end
    if {[$xf(fuf).${s}list selection includes 0] && \
            [string match {\.\.*} [$xf(fuf).${s}list get 0]]} {
	$xf(fuf).${s}list selection clear 0
    }
    after idle [list SelectionSize xf $s]
}
proc UnselectAll {arr s} {
    upvar $arr xf

    $xf(fuf).${s}list selection clear 0 [$xf(fuf).${s}list index end]
    $xf(fuf).${s}list config -selectbackground [option get .xfiles selectBg_$s {}]
    update idletasks
    NullSelect xf $s    
}

proc NullSelect {arr s} {
    upvar $arr xf

    set xf(selekted${s}_int) {}
    set xf(selekted$s) {}
    set xf(selsum$s) 0
}
proc CopyVars {afrom ato sfrom sto} {
    
    upvar $ato result $afrom array
    foreach i [list pathi backup_ parent_ selekted selsum hiddens_ fsmode_ devicefree] {
        set result(${i}$sto) $array(${i}$sfrom)
    }
}
proc Copyleft {arr s} {
    upvar $arr xf

    History xf "left"
    set pos [expr [lindex [$xf(fuf).rightlist yview] 0]+0.0001]

    CopyVars xf xf "right" "left"
    set xf(selektedleft_int) $xf(selektedright_int)
    CorrectColor "left" xf {} {}
    UpdateListbox xf "left" $pos
}
proc Swap_sides {arr} {
    upvar $arr xf

    set temp(?) ?
    CopyVars xf temp "right" ""
    CopyVars xf xf "left" "right"
    CopyVars temp xf "" "left"
    unset temp

    set selekt $xf(selektedright_int)
    set xf(selektedright_int) $xf(selektedleft_int)
    set xf(selektedleft_int) $selekt

    if [string match [lindex [.ff.top.middle.hideright config -state] end] disabled] {
	.ff.top.middle.hideright config -state normal
	.ff.top.right.dirHistory config -state normal	
	set g 1
	for {set f $g} {$f < 16} {incr f 2} {
	    for {set b 0} {$b < 6} {incr b} {
		.xfright.bf($f).b($b) config -state normal 
	    }
	}
	.ff.top.middle.hideleft config -state disabled
	.ff.top.left.dirHistory config -state disabled
	set g 0	
	for {set f $g} {$f < 16} {incr f 2} {
	    for {set b 0} {$b < 6} {incr b} {
		.xfleft.bf($f).b($b) config -state disabled 
	    }
	}
    } elseif [string match [lindex [.ff.top.middle.hideleft config -state] end] disabled] {
	.ff.top.middle.hideleft config -state normal
	.ff.top.left.dirHistory config -state normal
	set g 0	
	for {set f $g} {$f < 16} {incr f 2} {
	    for {set b 0} {$b < 6} {incr b} {
		.xfleft.bf($f).b($b) config -state normal 
	    }
	}
	.ff.top.middle.hideright config -state disabled
	.ff.top.right.dirHistory config -state disabled
	set g 1
	for {set f $g} {$f < 16} {incr f 2} {
	    for {set b 0} {$b < 6} {incr b} {
		.xfright.bf($f).b($b) config -state disabled
	    }
	}
    }
    set posr [expr [lindex [$xf(fuf).rightlist yview] 0]+0.0001]
    set posl [expr [lindex [$xf(fuf).leftlist yview] 0]+0.0001]

    UpdateListbox xf "left" $posr
    UpdateListbox xf "right" $posl
}
proc CopyRight {arr s} {
    upvar $arr xf

    History xf "right"
    set pos [expr [lindex [$xf(fuf).leftlist yview] 0]+0.0001]
    
    CopyVars xf xf "left" "right"
    set xf(selektedright_int) $xf(selektedleft_int)
    CorrectColor "right" xf {} {}
    UpdateListbox xf "right" $pos

}
proc dirUp {arr s} {
    upvar $arr xf
    global stop_calc

    set stop_calc 1
    if {$xf(fsmode_$s) == 0} {
	if [string match $xf(pathi$s) $xf(parent_$s)] {
	    return
	}
	History xf $s
    } {
	if [string match $xf(pathi$s) /] {
	    AfterVirtual xf $s
	    FileList $s $xf(pathi$s)
	    DefaultInfo xf $s
	    return
	}
    }
    $xf(fuf).${s}list config \
	    -selectbackground [option get .xfiles selectBg_$s {}]
    SetPaths xf $s $xf(parent_$s)
    NullSelect xf $s
    FileList $s $xf(pathi$s)
    if {[string match $xf(pathi$s) /] || [string compare {} $xf(selekted${s}_int)]} {
	DefaultInfo xf $s
    }	
    
}
proc dirRoot {arr s} {
    upvar $arr xf
    global stop_calc

    set stop_calc 1
    if [string match $xf(pathi$s) $xf(parent_$s)] {
        return
    }
    if [string match $xf(fsmode_$s) 0] {
	History xf $s
    }
    SetPaths xf $s /
    $xf(fuf).${s}list config \
	    -selectbackground [option get .xfiles selectBg_$s {}]
    NullSelect xf $s
    FileList $s $xf(pathi$s)
    DefaultInfo xf $s

}
proc FileFrame {arr parent s args} {
    upvar $arr xf
    if { [string compare $s "left"] == 0 } {
	set o "right" 
    } {
	set o "left" 
    }
    frame $parent.$s
    eval {listbox $parent.${s}list -yscrollcommand \
	    [list $parent.$s.sy set]} $args 
    scrollbar $parent.$s.sy -orient vertical -command \
	    [list $parent.${s}list yview] -relief ridge
    pack $parent.$s.sy -side $o -fill y   
    pack $parent.${s}list -in $parent.$s -side $s -expand true -fill both
    set popup [menu $parent.${s}list.popup_menu -tearoff 0 \
	    -relief ridge -bd 4 -bg grey80]
    $popup add command -label "Copy" -command [list PopupOps xf $s "cp"]
    $popup add command -label "Move" -command [list PopupOps xf $s "mv"]
    $popup add separator
    $popup add cascade -label "Delete" -menu $popup.sub
    set popup.sub [menu $popup.sub -tearoff 0]
    $popup.sub add command -label "Yes!" -command [list PopupOps xf $s "rm"]\
	    -activebackground "#ff0000" -background "#ffa0a0"
    set flag 1
    set a 1
    while {[string compare {} [option get .xfiles popup_user_item_$a {}]]} {
	set xf(popup_user$a) [option get .xfiles popup_user_item_$a {}]
	if $flag {
	    set popup.user [menu $popup.user -tearoff 0]
	    $popup add separator
	    $popup add cascade -label "User" -menu $popup.user \
		    -font [option get .ff.files.${s}list.popup_menu.user font {}]
	    set flag 0
	}
	$popup.user add command -label [lindex $xf(popup_user$a) 0] \
		-command [list PopupOps xf $s "$a" [lindex $xf(popup_user$a) 1]]
	unset xf(popup_user$a)
	incr a
    }


}

proc PopupOps {arr s op {command {}}} {
    upvar $arr xf

    switch $op {
	cp -
	mv -
	rm {
	    if {[string compare {} $xf(selekted$s)] == 0} {
		InfoChange xf $s "No files selected!"
		bell
		after 4000 [list DefaultInfo xf $s]
		return
	    } {
		FileOps $op $s
	    }
	}
        default {
            Executer xf [lrange $command 0 end] $xf(selekted$s) $s "\[Pop-menu\]"
        }
    }
    if $xf(clearselect) {
        UnselectAll xf $s
        update idletasks
        set xf(clearselect) 0
    }
}
proc FileInfo {arr parent args} {
    upvar $arr xf
    
    set xf(infoEnt_left) [entry $parent.infoleft -relief sunken -bd 2\
	    -textvariable xf(infoAleft) -state disabled -justify left\
	    -bg "#404040" -fg "#ffff60" -highlightthickness 0 \
	    -exportselection 0]
    set xf(infoEnt_right) [entry $parent.inforight -relief sunken -bd 2\
	    -textvariable xf(infoAright) -state disabled -justify left \
	    -bg "#404040"  -fg "#ffff60" -highlightthickness 0 \
	    -exportselection 0]
    
    pack $parent.infoleft -side left -expand true -fill x
    pack $parent.inforight -side right -expand true -fill x
    
}
proc FileList { s dir {files {}} {dirs {}} {f {}} {d {}}} { 
    global xf dirpit_left dirpit_right vfs
    upvar $f nf $d nd
    set lippu 0
    switch $xf(fsmode_$s) {
	0 { 
	    $xf(pathEnt_$s) config -state normal -relief sunken
	    $xf(fuf).${s}list config  -bg [option get $xf(fuf).${s}list background {}]

	    if {![file executable $dir] || ![file readable $dir]} { 
		SetArrowPointer .
		$xf(fuf).${s}list delete 0 end
		$xf(fuf).${s}list insert 0 ../
		$xf(pathEnt_$s) xview moveto 1
		$xf(pathEnt_$s) icursor end
		DefaultInfo xf $s
		MessageBox "You have no permissions here!"
		return
	    }

	    if {!$xf(hiddens_$s)} {
		set files [lsort [glob -nocomplain -- $dir*]]
		if [string compare $dir /] {
		    set lippu 1 
		}	
	    } {
		set files [lsort [glob -nocomplain -- $dir{.*,*}]]
		if [string compare $dir /] {
		    set lippu 1 
		}	
	    }
	    
	    set dirs {}
	    set others {}
	    foreach f $files {
                if $xf(bitsi) {
                } {
                    set bits ""
                }
		switch [file type $f] {
		    file {
			if $xf(bitsi) {
			    set bits [BitsProc $f]
			    lappend others [format "%-25s %10s %9d" \
				    [file tail $f] $bits [file size $f]]
			} {
			    lappend others [format "%-29s %9d" \
				    [file tail $f] [file size $f]]
			}
		    }
		    directory {
			if {[string compare "\." [file tail $f]] && \
				[string compare "\.\." [file tail $f]]} {
			    if $xf(bitsi) {
				set bits [BitsProc $f]
				lappend dirs [format "%-25s %10s %9s" \
					[file tail $f]/ $bits "<Dir>"]
			    } {
				lappend dirs [format "%-29s %9s" \
					[file tail $f]/ "<Dir>"]
			    }
			}
		    }
		    link {
			if $xf(bitsi) {
			    set bits [BitsProc $f]
			    lappend others [format "%-25s %10s %9s" \
				    [file tail $f] $bits [file size $f]]
			} {
			    if $xf(links) {
				lappend others [format "%-29s %9d" \
					"[file tail $f]@   -> [file readlink $f]" [string length $f]]
			    } {
				lappend others [format "%-29s %9d" \
					"[file tail $f]@" [string length $f]]
			    }
			}
		    }
		    characterSpecial -
		    blockSpecial {
			if $xf(bitsi) {
			    set bits [BitsProc $f]
			    lappend others [format "%-25s %10s %9s" \
				    [file tail $f] $bits "-Dev-"]
			} {
			    lappend others [format "%-29s %9s" \
				    [file tail $f] "-Dev-"]
			}
		    }
		    default {
			if $xf(bitsi) {
			    set bits [BitsProc $f]
			    lappend others [format "%-25s %10s %9d" \
				    [file tail $f] $bits [file size $f]]
			} {
			    lappend others [format "%-29s %9d" \
				    [file tail $f] [file size $f]]
			}
		    }
		}
	    }
	}
	1 -
	2 { 
	    $xf(fuf).${s}list config -bg #eeeece
	    $xf(pathEnt_$s) config -state disabled -relief flat
	    set others [lsort $vfs($dir)]
	    set dirs [lsort $vfs(${dir}dirs)]
	    set lippu 1
	}
    }
    $xf(pathEnt_$s) delete 0 end
    $xf(pathEnt_$s) insert 0 $dir
    $xf(pathEnt_$s) xview moveto 1
    $xf(pathEnt_$s) icursor end

    set dirpit_$s [llength $dirs]

    set nf $others
    set nd $dirs
    
    $xf(fuf).${s}list delete 0 end
    if $lippu {
	$xf(fuf).${s}list insert 0 ../
    }
    eval $xf(fuf).${s}list insert end [concat $dirs $others]
    . config -cursor top_left_arrow

}

proc SetPaths {arr s path} {
    upvar $arr xf

    set xf(pathi$s) [TildeSubst $path]
    set xf(backup_$s) $xf(pathi$s)
    set xf(parent_$s) [GetParentDir $xf(pathi$s)]
}

proc BitsProc {f} {
    
    switch [file type $f] {
	file {
	    append d "-"
	    file stat $f arr
	    set m [expr $arr(mode) - 16384]
	}
	directory {
	    append d "d"
	    file stat $f arr
	    set m $arr(mode)
	}
	link {
	    append d "l"
	    file lstat $f arr
	    set m [expr $arr(mode) - 24576]
	}
	characterSpecial {
	    append d "c"
	    file stat $f arr
	    set m [expr $arr(mode) + 8192]
	}
	blockSpecial {
	    append d "b"
	    file stat $f arr
	    set m [expr $arr(mode) - 8192]
	}
	socket {
	    append d "s"
	    file stat $f arr
	    set m [expr $arr(mode) - 32768]
	}
    }
    set m [expr double($m)/2]
    set res ""
    for {set i 1} {$i < 10} {incr i} {
	if [string match *.5 $m] {
	    switch $i {
		1 -
		4 -
		7 {
		    set l "x"
		}
		2 -
		5 -
		8 {
		    set l "w"
		}
		3 -
		6 -
		9 {
		    set l "r"
		}
	    }
	    append tmp $l $res
	} {
	    append tmp "-" $res
	}
	set res $tmp
	set tmp ""
	set m [expr double(int($m))/2]
    }
    append d $res
    return $d
}
proc Mount {s dev} {
    global xf

    set fstab [open /etc/fstab r]
    set con [split [read $fstab] \n]
    close $fstab
    set ind [lsearch $con $dev*]
    if {$ind == -1} {
	MessageBox "There has to be a line \"$dev\t<mountpoint>\t<filesys>\tdefaults,exec,user 0 0\" in the file /etc/fstab"
	return
    }
    cd /
    catch {exec umount $dev} err
    if [string match {*device is busy*} $err] {
	MessageBox "Somebody is accessing $dev\nUnable to unmount..."
	return
    }
    catch {exec mount $dev} err
    if [string match {*not a valid block device*} $err] {
	MessageBox "The device cannot be mounted! If floppy or cd-rom, please insert the disk and try again."
	return
    }
    set dir [lindex [lindex $con $ind] 1]
    History xf $s
    SetPaths xf $s $dir/
    NullSelect xf $s
    FileList $s $xf(pathi$s)
    DefaultInfo xf $s
}    
proc VirtualTar {tarfile {s {}} {upd 0}} {
    global xf

    if [CheckVirtuals $tarfile $s $upd] {
	return
    }
    if [catch {set filelist [eval "exec $xf(LISTTAR) $tarfile"]} filelist] {
	SwitchTar xf
	if [catch {set filelist [eval "exec $xf(LISTTAR) $tarfile"]} filelist] {
	    MessageBox "Error opening tar-file\n[file tail $tarfile] !"
	    return 
	} 
    }
    set filelist [split $filelist \n]
    set xf(fsmode_$s) 2
    VirtualFs xf $tarfile $s 2 $filelist
}

proc SwitchTar {arr} {
    upvar $arr xf
    if [string match *z* $xf(TOTAR)] {
	set xf(TOTAR) {tar -rf}
	set xf(DELTAR) {tar --delete -f}
	set xf(FROMTAR) {tar -xf}
	set xf(TAROUTP) {tar Oxf}
	set xf(LISTTAR) {tar tvf}
    } {
	set xf(TOTAR) {tar -rzf}
	set xf(DELTAR) {tar --delete -zf}
	set xf(FROMTAR) {tar -xzf}
	set xf(TAROUTP) {tar Oxzf}
	set xf(LISTTAR) {tar tzvf}
    }
}
proc VirtualZip {zipfile {s {}} {upd 0}} {
    global xf

    if [CheckVirtuals $zipfile $s $upd] {
	return
    }

    if [catch {set filelist [eval exec $xf(LISTZIP) $zipfile]} err] {
	MessageBox "Error opening zip-file\n[file tail $zipfile] !"
	return 
    } {
	set xf(fsmode_$s) 1
	set filelist [split $filelist \n]
	set k [lsearch $filelist {\ ------*}]
	set filelist [lreplace $filelist 0 $k]
	set filelist [lreplace $filelist [expr [llength $filelist]-2] end]
	VirtualFs xf $zipfile $s 0 $filelist
    }
}

proc CheckVirtuals {file s upd} {
    global xf

    if {[string compare {} $s] == 0} {
	after 100 [list InfoChange xf $file "No files selected!"]
	bell
	after 4000 [list DefaultInfo xf $file]
	return 1 
    }
    if {$upd == 0} {
	if {$xf(fsmode_left) || $xf(fsmode_right)} {
	    MessageBox "Sorry, you are already using virtual filesystem!"
	    return 1
	}
    }
    if ![file readable $file] {
	MessageBox "Unable to open file\n$file\nCheck permissions."
	return 1
    }
    if ![file writable $file] {
	MessageBox "You will not be able to write to\n$file\nNo write permission."
    }
    return 0
}

proc VirtualFs {arr filename s place filelist} {
    upvar $arr xf
    global vfs

    if [info exists vfs] {
	unset vfs
    }
    set n 0
    foreach l $filelist {
	regsub {\./} [lindex $l end] {} new
        set list($new) [lindex $l $place]
        incr n
    }
    unset filelist
    set vfs(/) {}
    set vfs(/dirs) {}
    
    if $xf(bitsi) {
	set w 36
    } {
	set w 29
    }
    foreach item [lsort [array names list]] {
        if [string match */ $item] {
            ProcessVFsDir vfs /$item $w
        } {
            set temp [string trimright $item /]
	    regexp {[^/]*$} $temp file
            if [string match */* $temp] {
                set dir [file dirname $temp]/
		lappend vfs(/$dir) [format "%-${w}s %9d" $file $list($item)]
            } {
		lappend vfs(/) [format "%-${w}s %9d" $file $list($item)]
            }
        }
    }
    if ![info exists xf(virtualfile)] {
	set xf(virtualfile) $xf(pathi$s)[string trimleft $filename "\./"]
 	BeforeVirtual xf $s
	FileList $s $xf(pathi$s) $vfs(/) $vfs(/dirs)
    }
}
proc ProcessVFsDir {arr dir w} {
    upvar $arr vfs

    if [string match $dir "/"] {
        set path ""
    } {
        set dir [string trimright $dir /]
        set path [file dirname $dir]/
        if [string match "//" $path] {
            set path "/"
        }
        set dir [file tail $dir]/
    }

    if [info exists vfs(${path}dirs)] {
        lappend vfs(${path}dirs) [format "%-${w}s %9s" $dir "<Dir>"]
        if {[info exists vfs(${path}$dir)] == 0} {
            set vfs(${path}$dir) {}
        }
        set vfs(${path}${dir}dirs) {}
    } {
        ProcessVFsDir vfs $path $w
        lappend vfs(${path}dirs) [format "%-${w}s %9s" $dir "<Dir>"]
        if {[info exists vfs(${path}$dir)] == 0} {
            set vfs(${path}$dir) {}
        }
        set vfs(${path}${dir}dirs) {}
    }
}

proc BeforeVirtual {arr s} {
    upvar $arr xf

    set xf(pathfs) $xf(pathi$s)
    set xf(pathi$s) "/"
    $xf(pathEnt_$s) xview moveto 1
    $xf(pathEnt_$s) icursor end
    set xf(parent_$s) $xf(pathfs)
    set xf(backup_$s) $xf(pathfs)

    NullSelect xf $s

    if {$xf(fsmode_$s) == 2 && $xf(notardel)} {
	$xf(fuf).${s}list.popup_menu entryconfigure Mov* -state disabled
	$xf(fuf).${s}list.popup_menu entryconfigure Del* -state disabled
    }
    .xfmenu.butt.m entryconfigure Prot* -state disabled
    .xfmenu.butt.m entryconfigure Show* -state disabled
    if [string match $s left] {
	set g 0	
    } {
	set g 1
    }
    for {set f $g} {$f < 16} {incr f 2} {
	for {set b 0} {$b < 6} {incr b} {
	    .xf$s.bf($f).b($b) config -state disabled 
	}
    }
    foreach z [list $s.dirHistory middle.hide$s middle.copyleft middle.copyright] {
	.ff.top.$z config -state disabled
    }
}

proc AfterVirtual {arr s} {
    upvar $arr xf
    global vfs
    
    unset vfs
    SetPaths xf $s $xf(pathfs)

    NullSelect xf $s

    if {$xf(fsmode_$s) == 2 && $xf(notardel)} {
	$xf(fuf).${s}list.popup_menu entryconfigure Mov* -state normal
	$xf(fuf).${s}list.popup_menu entryconfigure Del* -state normal
    }
    .xfmenu.butt.m entryconfigure Prot* -state normal 
    .xfmenu.butt.m entryconfigure Show* -state normal 
    set xf(fsmode_$s) 0
    if [string match $s left] {
	set g 0	
    } {
	set g 1
    }
    for {set f $g} {$f < 16} {incr f 2} {
	for {set b 0} {$b < 6} {incr b} {
	    .xf$s.bf($f).b($b) config -state normal 
	}
    }

    foreach z [list right.dirHistory middle.hideleft middle.copyleft middle.copyright \
	    middle.hideright left.dirHistory] {
	.ff.top.$z config -state normal
    }
    unset xf(virtualfile)
    unset xf(pathfs)
}

proc VirtualOutput {arr mode vf file} {
    upvar $arr xf
    switch $mode {
	1 {OutputWindow [eval "exec $xf(ZIPOUTP) $vf $file"]}
	2 {OutputWindow [eval "exec $xf(TAROUTP) $vf $file"]}
    }
    SetArrowPointer .
}
proc FileOK {arr s button} {
    upvar $arr xf
    global vfs stop_calc
    
    if {[string compare $s "left"] == 0} {
	set o "right"
    } {
	set o "left"
    }
    
    if [string match $xf(item$s) $xf(backup_$s)] {
	set xf(pathi$s) $xf(item$s)
	$xf(pathEnt_$s) xview moveto 1
	$xf(pathEnt_$s) icursor end
	return
    }
    
    if {[regexp {^\.\./?} $xf(item$s)]} {
        dirUp xf $s
	DefaultInfo xf $s
	return
    }

    if [string match {/} $xf(item$s)] {
	dirRoot xf $s
	DefaultInfo xf $s
	return
    }
    set pathway $xf(pathi$s)$xf(item$s)

    if [string match $xf(fsmode_$s) 0] { 
	if [file isdirectory $pathway] {
	    set stop_calc 1
	    $xf(fuf).${s}list config \
		    -selectbackground [option get .xfiles selectBg_$s {}]
	    History xf $s
            NullSelect xf $s
	    SetPaths xf $s $pathway 

	    FileList $s $xf(pathi$s)
	    DefaultInfo xf $s
	    return
	} {
	    if [file exists $pathway] {
		QuickExe xf $xf(item$s) $button $xf(pathi$o) $s
		return
	    }
	}
    } {
	if [string match */ $pathway] {
	    set stop_calc 1
	    $xf(fuf).${s}list config \
		    -selectbackground [option get .xfiles selectBg_$s {}]
	    SetPaths xf $s $pathway
            NullSelect xf $s
	    FileList $s $xf(pathi$s) $vfs($pathway) $vfs($xf(pathi$s)dirs) 
	    return
	} {
	    VirtualOutput xf $xf(fsmode_$s) $xf(virtualfile) \
		    [string trimleft $pathway /]
	    DefaultInfo xf $s
	    return
	}
    }
    if [file isdirectory $xf(item$s)] {
	set stop_calc 1
	History xf $s
	SetPaths xf $s $xf(item$s)
        NullSelect xf $s

	FileList $s $xf(item$s)
	DefaultInfo xf $s
	return	
    }
    if [file exists [string trimright $xf(item$s) /]] {
	SetPaths xf $s [GetParentDir $xf(item$s)]
        NullSelect xf $s
        FileList $s $xf(pathi$s)
        DefaultInfo xf $s
	QuickExe xf [file tail [file dirname $xf(item$s)]] $button $xf(pathi$o) $s
	return
    } {
	set stop_calc 1
	set xf(pathi$s) $xf(backup_$s)
	$xf(pathEnt_$s) xview moveto 1
	$xf(pathEnt_$s) icursor end
	set xf(parent_$s) [GetParentDir $xf(pathi$s)]
	FileList $s $xf(pathi$s)
	InfoChange xf $s "Invalid path or filename!"
        bell
	after 4000 [list DefaultInfo xf $s]
	return
    }	
}
proc FileClick {arr s y } {
    upvar $arr xf

    set l $xf(fuf).${s}list
    set xf(item$s) [GetFileName $s [$l get [$l nearest $y]]]
    $l selection clear [$l index [$l nearest $y]]

}

proc GetFileName {s item} {
    global xf

    set aa {}
    set bb {}
    set cc {}
    regsub -- {-Dev-} $item 0 item
    if {$xf(bitsi) && !$xf(fsmode_$s)} {
        regexp -nocase -- {((.*)/|(.*)\ \ \ .[-rwx]+)} $item match aa bb cc
    } {
        regexp -nocase -- {((.*)/|(.*)\ \ \ [0-9]+)} $item match aa bb cc
    }    
    if [string compare {} $cc] {
        set ind [string first "@   -> " $cc]
        if {$ind > -1} {
            return [string trimright [string range $cc 0 [expr $ind -1]]]
        } {
	    set cc [string trimright $cc]
	    if {[string match *@ $cc] \
		    && [string match [file type $xf(pathi$s)[string trimright $cc @]] link]} {
		return [string trimright $cc @]
	    } {
		return $cc
	    }
        }
    } {
        set ind [string first "@   -> " $aa]
        if {$ind > -1} {
            return [string trimright [string range $aa 0 [expr $ind -1]]]
        } {
	    set aa [string trimright $aa]
	    if {[string match *@ $aa] \
		    && [string match [file type $xf(pathi$s)[string trimright $aa @]] link]} {
		return [string trimright $aa @]
	    } {
		return $aa
	    }
	}
    }
}
proc DefaultInfo {arr s} {
    upvar $arr xf

    if [string match $s "left"] {
	set o "right"
    } {
	set o "left"
    }

    if {[string compare {} [$xf(fuf).${s}list curselection]] != 0} {
        CorrectColor $o xf {} {}
	ShowSelSize xf $s
	return
    } 

    switch $xf(fsmode_$s) {
	1 -
	2 {
	    $xf(infoEnt_$s) config -justify center -bg "#404040" -fg "#ffff60"
	    set xf(infoA$s) "In file: [file tail $xf(virtualfile)]"
	    return
	}
    }
    set xf(infoA$s) ""
    $xf(infoEnt_$s) config -justify right -bg "#404040" -fg "#ffff60"

    set fs [string match {*-T*} $xf(DISKFREE)]
    if [catch {set foo [eval exec $xf(DISKFREE) $xf(pathi$s)]}] {
	if [catch {cd $xf(pathi$s);set pwd [pwd]/}] {
	    set pwd $xf(pathi$s)
	}
	set dfsize [GetDiskFree $pwd $xf(DISKFREE) fs]
    } {
	set dfsize [GetDFSize $foo fs]
    }
    if {$dfsize == -1} {
	set xf(infoA$s) "Unable to obtain free space information!      "
	set xf(devicefree$s) 99999999
    } {
	if {$xf(df_1k) == 0} {
	    set dfsize [expr $dfsize / 2]
	}
	set xf(devicefree$s) $dfsize
	if {[string compare "msdos" $fs] == 0} {
	    set xf(mdos_$s) 1
	} {
	    set xf(mdos_$s) 0
	}
	set xf(infoA$s) [format "%-28s%17s %-17s" $fs [FormatNumber $xf(devicefree$s)] "kb free"]
	CorrectColor $s xf {} {}
    }

}
proc GetDFSize {line var} {
    global env
    upvar $var fs

    if [string match {*hp*} $env(HOSTTYPE)] {
	set df_l_ind 3
    } {
	set df_l_ind 2
    }
    if $fs {
	set fs [lindex $line [expr [llength $line] - 5 -1]]
    } {
	set fs ""
    }
    return [lindex $line [expr [llength $line] - $df_l_ind -1]]
}

proc GetDiskFree {path cmd var} {
    upvar $var fs

    if [catch {set foo [eval exec $cmd]} err] {
	set freespace -1
	tkerror $err
    } {
	set lines [split $foo \n]
	set freespace -1
	if [string match Filesystem* [lindex $lines 0]] {
	    set a 1
	    set df_sz_ind end
	    set df_l_ind 2
	} {
	    set a 0
	    set df_sz_ind 0
	    set df_l_ind 3
	}		
	set l 0
	for {set i $a} {$i < [llength $lines]} {incr i} {
	    set df [lindex $lines $i]
	    set try [lindex $df $df_sz_ind]
	    if {[string compare {} $try] == 0} {
		continue
	    }
	    if [regexp ^($try) $path tmp] {
		if {[string length $tmp] > $l} {
		    set l [string length $tmp]
		    set freespace [GetDFSize $df fs]
		}
	    }   
	}
    }
    return $freespace
}
proc CorrectColor {s var index op} {
    upvar $var xf
    
    if [string match $s left] {
	set o "right"
    } {
	set o "left"
    }
    if {$xf(selsum$o)/1024 > $xf(devicefree$s)} {
	$xf(fuf).${o}list config -selectbackground red
    } {
	$xf(fuf).${o}list config \
		-selectbackground [option get .xfiles selectBg_$o {}]
    }  
    
}
proc DialogWin {string {xoffset -50} {yoffset -50} {select 1} \
           {X {}} {Y {}} {abort {}}} {
    global prompt ret xf

    set old_focus [focus]
    set f .prompt
    catch {destroy $f}
    toplevel $f -borderwidth 5
    wm title $f "X-Files Request"
    if {[string compare {} $X] == 0} {
	set x [expr $xf(X) + $xoffset]
	set y [expr $xf(Y) + $yoffset]
    } {
	set x [expr $X + $xoffset]
	set y [expr $Y + $yoffset]
    }
    wm geometry $f "+$x+$y"       
    frame $f.m -relief flat -bd 2
    message $f.m.msg -width 150  -justify center -text $string
    set b [frame $f.buttons -bd 3 -relief ridge]
    pack $f.m.msg -side top -fill x
    frame $f.m.fake 
    pack $f.buttons -side bottom -fill x
    pack $f.m.fake -side bottom -fill x -ipady 5
    pack $f.m -side top
    set ind 1
    while {[info exists prompt($ind.label)]} {
        frame $f.m.$ind
        entry $f.m.$ind.e -textvariable prompt($ind.result)
	if [string compare {} $prompt($ind.label)] {
	    label $f.m.$ind.l -text $prompt($ind.label)
	    pack $f.m.$ind.l -side left
	    pack $f.m.$ind.e -side right -fill x
	} {
	    pack $f.m.$ind.e -side top -fill x 
	}
        pack $f.m.$ind -side top -fill x
        $f.m.$ind.e xview moveto 1
        $f.m.$ind.e icursor end
        bind $f.m.$ind.e <Return> [list focus $f.m.[incr ind].e]
    }
    incr ind -1
    bind $f.m.$ind.e <Return> {set ret 1}
    bind $f <Control-c> {set ret 0}
    bind $f <Escape> {set ret 0}
    button $b.ok -width 6 -text OK -command {set ret 1}
    button $b.cancel -width 6 -text Cancel -command {set ret 0}
    pack $b.ok -side left -padx 10 -pady 4
    if [string compare {} $abort] {
        button $b.misc -width 6 -text $abort -command {set ret 2}
        pack $b.misc -side right -pady 4
	pack $b.cancel -side right -pady 4
    } {
	pack $b.cancel -side right -padx 10 -pady 4
    }
    
    tkwait visibility $f
    grab $f
    focus $f.m.1.e
    if {$select && [string compare {} $prompt(1.result)]} {
	$f.m.1.e select range 0 end
    }
    $f.m.1.e xview moveto 1
    $f.m.1.e icursor end
    tkwait variable ret
    grab release $f
    destroy $f
    focus $old_focus
    return $ret

} 
proc GetCharValue { fid } {
    set byte [read $fid 15]
    set pit [string length $byte]
    if {$pit > 0} {
	
	for {set i 0} {$i < $pit } {incr i} {
	    scan [string index $byte $i] "%c" resu
	    append t $resu 
	}

	if {$pit < 15} {
            append t 0
	    if {[catch {seek $fid [expr $pit - 14] current}]} {
		return -1
	    }
	}
	return $t
    } {
	if [eof $fid] {return -1} {return 0}
    }
}
proc String2Integer {s} {
    set pit [string length $s]
    for {set i 0} {$i < $pit } {incr i} {
	scan [string index $s $i] "%c" resu
	append tulo $resu
    }
    return $tulo
}
proc QuickExe {arr f b d s} {
    upvar $arr xf

    set cont 1
    set i "\[Extension\]"
    set pid -1
    SetWaitPointer .
    regexp (\[^.]*$) $f extension
    set extension [string tolower $extension]
    append extension $b
    global $extension
    if [catch {set tmp [set $extension]} eerror] {
	if ![file readable "$xf(pathi$s)$f"] {
	    MessageBox "Could not complete operation. File is not readable."
	    return $pid
	} {
	    if [catch {open "$xf(pathi$s)$f" RDONLY} fileId] {
		bell;tkerror $fileId
		SetArrowPointer .
		return $pid
	    } {
		set cont 0
		for {set i 0} {$i < 3} {incr i} {
		    append tmp3 [GetCharValue $fileId]
		}
	    set i 0		
		global H header hcomm
		while { $i < $H($b)} {
		    append header($b.$i) *
		    if { [string match $header($b.$i) $tmp3] } {
			Executer xf $hcomm($b.$i) $f $s "\[Header\]"
			break
		    }
		    incr i
		}
		if {$i == $H($b)} {
		    global txt$b
		    set cont 1
		    set tmp txt$b
		    set tmp [set $tmp]
		    set i "\[NoMatch\]"
		}   
		close $fileId
	    }
	}
    }
    if {$cont} {
	Executer xf $tmp $f $s $i
    }
    SetArrowPointer .
    return $pid
}

proc Executer {arr c f s {i ""}} {
    upvar $arr xf
    global prompt
    set both 0
    if {$s == "left"} {
	set d $xf(pathiright)
        set o "right"
    } {
	set d $xf(pathileft)
        set o "left"
    }
    set param [lindex $c 0]
    if [regexp N $param] {
    }
    
   if [regexp C $param] {
	if ![AskWin {Are You Sure ?}] {
	    return -1
	}
    }
    set c [lreplace $c 0 0 ]
    if {[regsub %d $c $d c] > 0} {
	set both 1
    }

    if [string match {*%o1*} $c] {
	set i 1
	while {[set paikka [string first %o$i $c]] >= 0} {
	    set tmp3 $c
	    set tmp3 [string range $tmp3 $paikka end]
	    set e [expr [string first ' $tmp3] -5]
	    regexp "%o$i'(.*)'" $tmp3 op op1
	    set op1 ${op1}'
	    set e [expr [string first %o$i $tmp3]+3]
	    set tmp3 [string range $tmp3 $e end]
	    set e [expr [string first ' $op1] -1]
	    
	    set opt($i) [string range $op1 0 $e]
	    set tmp3 [string range $tmp3 $e end]
	    incr i
	}
	foreach a [array names opt] {
	    regsub $opt($a) $c {} c
	    set prompt($a.label) $opt($a)
	}
	regsub -all {''} $c {} c
	
	if [DialogWin "Additional options"] {
	    foreach a [array names opt] {
		regsub %o$a $c $prompt($a.result) c
	    }
	    cd $xf(pathi$s)
	} {
	    InfoChange xf $s "Command aborted!" 
	    after 4000 [list DefaultInfo xf $s]
	    unset prompt
	    return -1
	}
	unset prompt
    } elseif [string match *%o* $c] {
	MessageBox "You have \"%o\"-specifier when you should have \"%o\?\", where \? is a number starting from 1."
	return
    }
    set tmp2 $c
    if {[set paikka [lsearch -exact $tmp2 %d]] >= 0} {
	set c [lreplace $c $paikka $paikka $d]
	set both 1
    }
    if {[set paikka [lsearch -exact $c %s]] >= 0} {
	set c [lreplace $c $paikka $paikka $s]
    } 

    if {[set paikka [lsearch -exact $c %f]] >= 0} {
        set xf(clearselect) 1
	set c [lreplace $c $paikka $paikka ]
	foreach files $f {
	    set c [linsert $c $paikka "$files"]
	    incr paikka
	}
	cd $xf(pathi$s)
    }
    
    update idletasks
    if {[set pid [eval $c]]== -1} {
	tkerror "CAN'T execute $c"
	return -1
    } {
	if [regexp W $param] {
	    OutputWindow $pid [lindex $f 0]
	}
	switch -exact -- [lindex $c 0] {
	    exec {set ci [lindex $c 1]}
	    ChangeDir {set ci "[lindex $c 0 ] [lindex $c 2]"}
	    default {set ci [lindex $c 0]}
	}
        InfoChange xf $s "$i Executed: $ci"
	if [string match $xf(pathileft) $xf(pathiright)] {
	    set both 1
	}
	if [regexp U $param] {
            if $both {
                after 100 [list UpdateListbox xf left]
                after 100 [list UpdateListbox xf right {} 4000]
            } {
                after 100 [list UpdateListbox xf $s]
            }
	} {
            after 4000 [list DefaultInfo xf $s]
        }

	return 1
	SetArrowPointer .
    }
}
proc ButtonFrame { i s bfpath } {
    global bargs xf

    frame $bfpath.bf($i) -width 300 -height 30 
    
    set refindex [expr $i*6]
    if [catch {
	for {set n 0} {$n <  6} {incr n} {
	    set realindex [expr $n+$refindex]
	    set realaction "BAction $realindex $s $bfpath $i"
	    eval {button $bfpath.bf($i).b($n) -comm $realaction \
		-width 3} $bargs($realindex)
	    pack $bfpath.bf($i).b($n) -expand true -fill both \
		    -side left
	    bind $bfpath.bf($i).b($n) <Button-2> "set xf(mb) 2 ; $bfpath.bf($i).b($n) invoke"
	    bind $bfpath.bf($i).b($n) <Button-3> "set xf(mb) 3 ; $bfpath.bf($i).b($n) invoke"
	}
    }  err] {tkerror $err ; return -1} { return 0}
}
proc BAction { i side bfpath framenumber} {
    global bcomm be xf bargs beparent bindex prompt
    if {$xf(editmode) > 0} {
	if {!$xf(helpmode)} {
	set xf(editbutton) [focus]
	}
	pack forget $beparent.menu.msg 
	$beparent.menu.toolmenu.m entryconfigure Put* -state normal

	regexp {(left|right).*\((.*)\).*\((.*)\)}\
		$xf(editbutton) nul be(side) y x
	unset nul be(side)
	set bindex [expr $y * 6 + $x]

	if {$xf(editmode) < 2} {
	    set bcommtmp $bcomm($bindex)
	    set bargstmp $bargs($bindex)
	    
	    set param [lindex $bcommtmp 0]
	    
	    if [regexp C $param] {
		set  be(confirm) C
	    } {
		set  be(confirm) ""
	    }
	    if [regexp D $param] {
		set  be(dialog) D
	    } {
		set be(dialog) ""
	    }
	    if [regexp W $param] {
		set be(win) W
	    } {
		set be(win) ""
	    }
	    if [regexp U $param] {
		set  be(update) U
	    } {
		set be(update) ""
	    }
	    
	    
	    if {[string match {&} [lindex $bcommtmp end]]} {
		set be(bg) "&" ; set bcommtmp [lreplace $bcommtmp end end]
	    } {
		set be(bg) ""
	    }

	    pack  $beparent.menu.toolmenu -side left
	    pack $beparent.entframe -side top -fill y -fill x
	    pack $beparent.middle -fill x -pady 10 -padx 3
	    $beparent.entframe.up.2.cmdentry delete 0 end
	    update idletasks

	    switch -glob -- [lindex $bcommtmp 1] {
		ChangeDir {
		    set be(cmd) [lrange $bcommtmp 1 2]
		    set be(cmdarg) [lindex $bcommtmp 3]
		} 
		Mount {
		    set be(cmd) [lrange $bcommtmp 1 2]
		    set be(cmdarg) [lindex $bcommtmp 3]
		} 
		exec {
		    set be(cmd) [lindex $bcommtmp 1]
		    set be(cmdarg) [lrange $bcommtmp 2 end]
		}  
		MessageBox {
		    set be(cmd) exec
		    set be(cmdarg) ""
		    set be(txt) ""
		    $beparent.entframe.up.3.button config -text ""
		}
		default {
		    set be(cmd) [lrange $bcommtmp 1 end]
		    set be(cmdarg) ""
		}
	    }
	    $beparent.entframe.up.2.cmdentry icursor end

	    set be(style) $bargstmp
	    set be(undoargs) $bargstmp
	    set be(undocomm) $bcommtmp
	    switch -glob -- $be(cmd) {
		
		ChangeDir* { set be(cmdtxt) ChDir ;\
			pack $beparent.entframe.up.2.cmdentry -side bottom ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		FileOps*cp* { set be(cmdtxt) Copy ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		CopyAs* { set be(cmdtxt) CopyAs ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		FileOps*rm* { set be(cmdtxt) Delete ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		*DirSize* { set be(cmdtxt) DirSize ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}

		Mount* { set be(cmdtxt) Mount ;\
			pack $beparent.entframe.up.2.cmdentry -side bottom ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		Grep* { set be(cmdtxt) Grep ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		exec { set be(cmdtxt) Execute ;\
			pack $beparent.entframe.up.2.cmdentry -side bottom;\
			pack $beparent.entframe.up.2.bg -side top -anchor nw}
		
		MkDir*  { set be(cmdtxt) MkDir ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		FileOps*mv* { set be(cmdtxt) Move ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		PatternSel*  { set be(cmdtxt) PatternSel ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		ProtEdit*  { set be(cmdtxt) ProtEdit ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}

		ReadFiles*  { set be(cmdtxt) ReadFiles ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		Rename*  { set be(cmdtxt) Rename ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		VirtualTar*  { set be(cmdtxt) VirtualTar ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		VirtualZip*  { set be(cmdtxt) VirtualZip ;\
			pack forget $beparent.entframe.up.2.cmdentry ;\
			pack forget  $beparent.entframe.up.2.bg}
		
		default { set be(cmdtxt) Execute ;\
			pack $beparent.entframe.up.2.cmdentry -side bottom;\
			pack $beparent.entframe.up.2.bg -side top -anchor nw}
		
		
	    }
	    
	    foreach arg {-relief -bd -fg -bg -activebackground -activeforeground\
		    -font} {
		SetButtonStyle "$arg" [$xf(editbutton) cget "$arg"]
	    }
	    
	    SetScale
	    set be(bd) [$xf(editbutton) cget {-bd}]
	    set be(txt) [$xf(editbutton) cget {-text}]
	    $beparent.entframe.up.1.txtentry icursor end
	    set be(relief) [$xf(editbutton) cget {-relief}]
	    set be(cursor) [$xf(editbutton) cget {-cursor}]
	    $beparent.bottom.undo config -state normal
	    $beparent.bottom.save config -state normal
	    $beparent.bottom.applyframe.apply config -state normal
	    update idletasks
	    if {$be(cursor) == ""} {
		set be(cursor) "Default"
	    }
	    catch {eval {$beparent.entframe.up.3.button config} $be(style)}
	}
	return 0
    } {
	
	if {$xf(helpmode) == "1" } {
	    
	    if {0} {
		catch {destroy .ahpop} err
		regsub "exec" "Command: $bcomm($i) " "" resp
		set actionhelp [menu .ahpop -bg "#303080" \
			-tearoff 0 -disabledforeground "#f0f0b0" -relief ridge]
		$actionhelp add command -state disabled -label \
			"This is action-button."
		$actionhelp add command -state disabled -label \
			$resp
		set ahwidget $bfpath.bf($framenumber).b([expr {$i-$framenumber*6}]) 
		tk_popup $actionhelp [expr {[winfo rootx $ahwidget] + 10}]\
			[expr {[winfo rooty $ahwidget] + 10}]
	    }
	} {
	    
	    if { $side == "L"} {
		set s "left"
		set side "right"
	    } {
		set s "right"
		set side "left"
	    }
	    
	    switch $xf(mb) {
		1 {set selekted $xf(selekted$s)}
		2 {lappend selekted $xf(selekted$s) $xf(selekted$side)}
		3 {set selekted $xf(selekted$side)}
	    }
	    set f_ops 0
	    if {[string match *FileOps* $bcomm($i)] \
		    || [string match *Rename* $bcomm($i)] \
		    || [string match *ReadFiles* $bcomm($i)] \
		    || [string match *CopyAs* $bcomm($i)] \
		    || [string match *ProtEdit* $bcomm($i)] \
		    || [string match *Virtual* $bcomm($i)] \
		    || [string match *DirSize* $bcomm($i)]} {
		set f_ops 1
		if {[string compare {} $selekted] == 0} {
		    InfoChange xf $s "No files selected!"
		    bell
		    after 4000 [list DefaultInfo xf $s]
		    return
		}
	    }
	    switch $xf(mb) {
		1 {
		    Executer xf $bcomm($i) $xf(selekted$s) $s "\[A_Button\]"
		}
		2 {
		    if $f_ops {
			Executer xf $bcomm($i) $xf(selekted$s) $s "\[A_Button\]"
			Executer xf $bcomm($i) $xf(selekted$side) $side "\[A_Button\]"
		    } {
			set files {}
			foreach d $xf(selekted$s) {
			    set dirri $xf(pathi$s)
			    lappend files [append dirri $d]
			}
			foreach d $xf(selekted$side) {
			    set dirri $xf(pathi$side)
			    lappend files [append dirri $d]
			}
			Executer xf $bcomm($i) $files $s "\[A_Button\]"  
			unset files
		    }
		}
		
		3 {
		    Executer xf $bcomm($i) $xf(selekted$side) $side "\[A_Button\]"
		}
	    }
	    if $xf(clearselect) {
		switch $xf(mb) {
		    1 {UnselectAll xf $s}
		    2 {UnselectAll xf left; UnselectAll xf right; DefaultInfo xf $side}
		    3 {UnselectAll xf $side}
		}
		update idletasks
		set xf(clearselect) 0
	    }
	    set xf(mb) 1
	    return 1
	}
    }
}
proc MessageBox { string {xoffset -50} {yoffset -50}} {
    global xf res

    set f [toplevel .messages -borderwidth 5]
    set x [expr $xf(X) + $xoffset]
    set y [expr $xf(Y) + $yoffset]
    wm geometry $f "+$x+$y"       
    wm title $f "X-Files Message"
    frame $f.mf -relief sunken -bd 2 -bg "#cacaca"
    message $f.mf.msg -width 200  -justify left -text $string
    
    label $f.mf.pic -bitmap info
    set b [frame $f.buttons -bd 10]
    pack $f.mf.pic -side left -padx 10
    pack $f.mf.msg -side right
    pack $f.mf -fill both
    pack $f.buttons -side bottom -fill x
    
    bind $f <Return> {set res 1}
    bind $f <Control-c> {set res 0}
    bind $f <Escape> {set res 0}
    button $b.ok -text OK -command {set res 1}
    pack $b.ok -side top
    
    focus $b.ok
    tkwait visibility $f
    grab $f
    tkwait variable res
    grab release $f
    destroy $f

} 
proc AskWin { string {xoffset -50} {yoffset -50} \
        {text {}}} {

    global ret xf
    set f [toplevel .prompt -borderwidth 5]
    set x [expr $xf(X) + $xoffset]
    set y [expr $xf(Y) + $yoffset]
    wm geometry $f "+$x+$y"       
    wm title $f "Query"
    set b [frame $f.buttons -bd 10]
    set mf [frame $f.messages -relief sunken -bd 2]
    label $mf.pic -bitmap question
    message $mf.msg -width 110  -justify left -text $string \
	    -font *helvetica-bold-r-*-*-14*

    pack $mf.pic $mf.msg -side left -pady 5 -padx 5

    pack $f.messages $f.buttons -side top -fill x -expand true
    
    bind $f <Control-c> {set ret  0}
    button $b.ok -width 6 -text OK -command {set ret 1}
    button $b.cancel -width 6 -text Cancel -command {set ret 0}
    pack $b.ok -side left
    pack $b.cancel -side right
    if [string compare {} $text] {
        button $b.misc -width 6 -text $text -command {set ret 2}
        pack $b.misc -side right
    }
    
    tkwait visibility $f
    grab $f
    focus $b.cancel
    tkwait variable ret
    grab release $f
    destroy $f
    return $ret
}
proc ChangeDir { s dirname } {
    global xf env

    if ![file exists $dirname] {
	MessageBox "This button has an invalid path. Use the \"Config / Edit buttons...\" to fix the problem!"
	return
    }

    History xf $s
    SetPaths xf $s $dirname
    NullSelect xf $s
    
    $xf(fuf).${s}list config \
	    -selectbackground [option get .xfiles selectBg_$s {}]
    FileList $s $xf(pathi$s)
    DefaultInfo xf $s
}
proc FileOps { operation s } {
    global xf vfs

    if {[string compare $s left] == 0} {
        set o "right"
    } {
        set o "left"
    }	
    
    SetWaitPointer .
    switch $operation {
	cp { set op "Copying" }
	rm { set op "Deleting" }
	mv { set op "Moving" }
    }
    set newfiles $xf(selekted$s)

    switch  $xf(fsmode_$s) {
	0 {
	    cd $xf(pathi$s)
	    regsub -all {/} $xf(selekted$s) {} files
	    if $xf(turbomode) {
		FO_Nor_Turbo xf $s $o $files $xf(selekted${s}_int) \
			$xf(fuf).${s}list $operation $op
	    } {
		FO_Nor_Noturbo xf $s $o $files $xf(selekted${s}_int) \
			$xf(fuf).${s}list $operation $op
	    }
	}
	1 { 
	    FO_Zip xf vfs $s $o $xf(selekted$s) $xf(selekted${s}_int) \
		    $xf(fuf).${s}list $operation $op
	}
	2 { 
	    FO_Tar xf $s $o $xf(selekted$s) $xf(selekted${s}_int) \
		    $xf(fuf).${s}list $operation $op
	}
    }
    
    if !$xf(turbomode) {
	NullSelect xf $s
	switch $operation {
	    mv {
		UpdateListbox xf $o {} {} $newfiles
		DefaultInfo xf $s
	    }
	    cp {
		UpdateListbox xf $o {} {} $newfiles
		DefaultInfo xf $s
	    }
	    rm {
		DefaultInfo xf $s
		UpdateListbox xf $o
	    }
	}
    } {
	UnselectAll xf $s
	switch $operation {
	    mv {
		UpdateListbox xf $s
		UpdateListbox xf $o {} {} $newfiles
	    }
	    cp {
		UpdateListbox xf $o {} {} $newfiles
		DefaultInfo xf $s
	    }
	    rm {
		UpdateListbox xf $s
		if [string match $xf(pathi$s) $xf(pathi$o)] {
		    UpdateListbox xf $o
		} {
		    DefaultInfo xf $o
		}
	    }
	}
    }
    SetArrowPointer .

}

proc FO_Nor_Noturbo {arr s o filelist intlist list operation op} { 
    upvar $arr xf

    set n [llength $filelist]
    set index 1
    set safeflag 1
    foreach file $filelist {
        InfoChange xf $s "$op: $index / $n"
        if {$operation == "rm" } {
            if {$xf(safedelete)} {
                if {[string match $xf(pathi$s) $xf(trashdir)]} {
                    MessageBox "Disable SafeDelete and try again!"
                    return
                }
                if $safeflag {
                    ClearTrashDir xf
                    .xfmenu.butt.m.del entryconfigure Undo* -state normal
                    set xf(safedel_from) $xf(pathi$s)
                    set safeflag 0
                }
                eval exec $xf(MOVE) "$file" $xf(trashdir)
            } {
                eval exec $xf(DEL) "$file"
            }
        } {
            switch $xf(fsmode_$o) {
                0 {
		    if [string match $operation "cp"] {
			eval exec $xf(COPY) "$file" $xf(pathi$o)
		    } {
			eval exec $xf(MOVE) "$file" $xf(pathi$o)
		    }
                }
                1 {
                    FO_Nor_Virt xf $s $o "$file" "zip"
                }
                2 {
                    FO_Nor_Virt xf $s $o "$file" "tar"
                }
            }
        }
        set item [lindex $intlist 0]
        switch $operation {
            cp {
                $list selection clear $item		
                $xf(fuf).${o}list insert end $file
            }
            mv {
                $list selection clear [expr $item-$index+1] 
                $xf(fuf).${o}list insert end $file
                $list delete [expr $item-$index+1]
            }
            rm {
                $list selection clear [expr $item-$index+1]
                $list delete [expr $item-$index+1]
            }
        }
        set intlist [lreplace $intlist 0 0]
        incr index
    }
    switch $xf(fsmode_$o) {
        1 {
            VirtualZip $xf(virtualfile) $o 1
        }
        2 {
            VirtualTar $xf(virtualfile) $o 1
        }
    }
}

proc FO_Nor_Turbo {arr s o filelist intlist list operation op} {
    upvar $arr xf

    InfoChange xf $s "$op..."
    if {$operation == "rm" } {
        if {$xf(safedelete)} {
            if [string match $xf(pathi$s) $xf(trashdir)] {
                MessageBox "Disable SafeDelete and try again!"
                return
            }
            ClearTrashDir xf
            .xfmenu.butt.m.del entryconfigure Undo* -state normal
            set xf(safedel_from) $xf(pathi$s)
            eval exec $xf(MOVE) "$filelist" $xf(trashdir)
        } {
            eval exec $xf(DEL) "$filelist"
        }
    } {
        switch $xf(fsmode_$o) {
            0 {
		if [string match $operation "cp"] {
		    eval exec $xf(COPY) "$filelist" $xf(pathi$o)
		} {
		    eval exec $xf(MOVE) "$filelist" $xf(pathi$o)
		}
            }
            1 {
                FO_Nor_Virt xf $s $o $filelist $operation "zip"
            }
            2 {
                FO_Nor_Virt xf $s $o $filelist $operation "tar"
            }
        }
    }
}
proc FO_Nor_Virt {arr s o filelist operation mode} {
    upvar $arr xf
    
    if [string match $mode "tar"] {
        set voper $xf(TOTAR) 
        set vproc "VirtualTar"
    } {
        set voper $xf(TOZIP)
        set vproc "VirtualZip"
    }
    eval exec $xf(DEL) /tmp/.xftemp/
    set temppi "/tmp/.xftemp[string trimright $xf(pathi$o) /]"
    if [catch {eval exec $xf(MKDIR) $temppi}] {
	MakeDirProc $temppi
    }
    
    if [string match $operation "cp"] {
        set oper $xf(COPY)
    } {
        set oper $xf(MOVE)
    }
    eval exec $oper $filelist $temppi/
    cd /tmp/.xftemp/
    set k 0
    if {[llength $filelist] > 1} {
        foreach d $filelist {
            set dirri [string trimleft $xf(pathi$o) /]
            set filelist [lreplace $filelist $k $k [append dirri $d]]
            incr k
        }
    } {
        set dirri [string trimleft $xf(pathi$o) /]
        set filelist [append dirri $filelist]
	set k 1
    }
    eval exec $voper $xf(virtualfile) $filelist
    
    cd $xf(pathfs)
    eval exec $xf(DEL) /tmp/.xftemp/
    if $k {
        $vproc $xf(virtualfile) $o 1
    }
    
}

proc FO_Zip {arr1 arr2 s o filelist intlist list operation op} {
    upvar $arr1 xf
    upvar $arr2 vfs

    set inpath [string trimleft $xf(pathi$s) /]
    set n 0
    set rmflag 0
    foreach i [list files dirs files_num dirs_num] {
        set $i {}
    }
    foreach f $filelist {
        if [string match */ $f] {
            lappend dirs_num [lindex $intlist $n]
            lappend dirs $f
        } {
            lappend files_num [lindex $intlist $n]
            lappend files $inpath$f
        }
        incr n
    }
    InfoChange xf $s "$op..."
    switch $operation {
        rm {
            if [string compare {} $files] {
                eval exec $xf(DELZIP) $xf(virtualfile) $files
            }
            DelZipDir xf vfs $dirs $inpath $xf(virtualfile)
            set rmflag 1
        }
        cp {
            if [string compare {} $files] {
                eval "exec $xf(FROMZIP)j $xf(virtualfile) $files -d $xf(pathi$o)"
            }
            if [string compare {} $dirs] {
                foreach d $dirs {
		    set oo $inpath
		    if [string compare {} $vfs(/$inpath$d)] {
			lappend dirrit [append oo $d "*"]
		    } {
			lappend dirrit [append oo $d]
		    }
                }
                eval "exec $xf(FROMZIP) $xf(virtualfile) $dirrit -d $xf(pathi$o)"
                set gg $xf(pathi$o)$inpath
                cd $gg
                set files [lsort [glob -nocomplain $gg{*,.*}]]
                set files [lreplace $files 0 1]
		if [string compare {} $inpath] {
		    eval "exec $xf(MOVE) $files $xf(pathi$o)"
		    cd $xf(pathfs)
		    eval "exec $xf(DEL) $xf(pathi$o)$inpath"
		}
            }
        }
        mv {
            if [string compare {} $files] {
                eval "exec $xf(FROMZIP)j $xf(virtualfile) $files -d $xf(pathi$o)"
            }
            if [string compare {} $files] {
                eval "exec $xf(DELZIP) $xf(virtualfile) $files"
            }
            if [string compare {} $dirs] {
                foreach d $dirs {
                    set oo $inpath
                    lappend dirrit [append oo $d "*"]
                }
                eval "exec $xf(FROMZIP) $xf(virtualfile) $dirrit -d $xf(pathi$o)"
                set gg $xf(pathi$o)$inpath
                cd $gg
                set files [lsort [glob -nocomplain $gg{*,.*}]]
                set files [lreplace $files 0 1]
		if [string compare {} $inpath] {
		    eval "exec $xf(MOVE) $files $xf(pathi$o)"
		    cd $xf(pathfs)
		    eval "exec $xf(DEL) $xf(pathi$o)$inpath"
		}
            }
            DelZipDir xf vfs $dirs $inpath $xf(virtualfile)
            set rmflag 1
        }
    }
    if $rmflag {
        Virt_If_Rmflag $files_num $dirs_num $inpath
    }
}

proc FO_Tar {arr s o filelist intlist list operation op} {
    upvar $arr xf

    set inpath [string trimleft $xf(pathi$s) /]
    set n 0
    set rmflag 0
    foreach i [list files files_num dirs_num] {
        set $i {}
    }
    foreach f $filelist {
        if [string match */ $f] {
            lappend dirs_num [lindex $intlist $n]
        } {
            lappend files_num [lindex $intlist $n]
        }
        incr n
        lappend files $inpath$f
    }
    InfoChange xf $s "$op..."
    switch $operation {
        rm {
            if {[AskWin "This might corrupt\n\
                    \"[file tail $xf(virtualfile)]\"\nProceed ?!"] == 1} {
                catch {eval exec $xf(DELTAR) $xf(virtualfile) $files}
                set rmflag 1
            }
        }
        cp {
            eval "exec $xf(FROMTAR) $xf(virtualfile) -C $xf(pathi$o) $files"
	    if {[string compare {} $inpath] != 0} { 
		cd $xf(pathi$o)
		eval exec $xf(MOVE) $files $xf(pathi$o)
		regexp {([^/]*)/} $inpath "" kuole
		eval exec $xf(DEL) $xf(pathi$o)$kuole/
	    }
        }
        mv {
            if {[AskWin "This might corrupt\n\
                    \"[file tail $xf(virtualfile)]\"\nProceed ?!"] == 1} {
                eval exec $xf(FROMTAR) $xf(virtualfile) -C $xf(pathi$o) $files
		if {[string compare {} $inpath] != 0} { 
		    cd $xf(pathi$o)
		    eval exec $xf(MOVE) $files $xf(pathi$o)
		    regexp {([^/]*)/} $inpath "" kuole
		    eval exec $xf(DEL) $xf(pathi$o)$kuole/
		}
		catch {eval exec $xf(DELTAR) $xf(virtualfile) $files}
		set rmflag 1
            }
        }
    }
    if $rmflag {
        Virt_If_Rmflag $files_num $dirs_num $inpath
    }
}

proc Virt_If_Rmflag {files_num dirs_num inpath} {
    global vfs

    set ll [llength $vfs(/${inpath}dirs)]
    foreach z [lsort -integer -decreasing $files_num] {
        set j [expr $z - $ll - 1]
        set vfs(/$inpath) [lreplace $vfs(/$inpath) $j $j]
    }
    foreach z [lsort -integer -decreasing $dirs_num] {
        set j [expr $z - 1]
        set vfs(/${inpath}dirs) [lreplace $vfs(/${inpath}dirs) $j $j]
    }
}

proc DelZipDir {arr1 arr2 dirs path zipfile} {
    upvar $arr1 xf $arr2 vfs

    if {[string compare {} $dirs] == 0} {
	return
    }
    foreach d $dirs {
	if [string compare {} $vfs(/${path}${d}dirs)] {
	    DelZipDir xf vfs $vfs(/${path}${d}dirs) $path$d $zipfile
	} elseif ![string compare {} $vfs(/${path}${d})] {
	    eval exec $xf(DELZIP) $zipfile $path$d
	}
	if [string compare {} $vfs(/${path}${d})] {
	    eval exec $xf(DELZIP) $zipfile $path$d*
	} 
    }
}

proc TrashCan {arr undo} {
    upvar $arr xf

    if $undo {
        set files [lsort [glob -nocomplain $xf(trashdir){*,.*}]]
	foreach c [list .. .] {
	    set i [lsearch -glob $files *$c]
	    set files [lreplace $files $i $i]
	}
	eval exec $xf(MOVE) "$files" $xf(safedel_from)
	if [string match $xf(pathileft) $xf(trashdir)] {
	    UnselectAll xf "left"
	    UpdateListbox xf "left"
	} elseif [string match $xf(pathileft) $xf(safedel_from)] {
	    UpdateListbox xf "left"
	}
	if [string match $xf(pathiright) $xf(trashdir)] {
	    UnselectAll xf "right"
	    UpdateListbox xf "right"
	} elseif [string match $xf(pathiright) $xf(safedel_from)] {
	    UpdateListbox xf "right"
	}
	DefaultInfo xf "left"
	DefaultInfo xf "right"
    } {
        ClearTrashDir xf
	if [string match $xf(pathileft) $xf(trashdir)] {
	    UpdateListbox xf "left"
	    DefaultInfo xf "right"
	} elseif [string match $xf(pathiright) $xf(trashdir)] {
	    UpdateListbox xf "right"
	    DefaultInfo xf "left"
	} {
	    DefaultInfo xf "left"
	    DefaultInfo xf "right"
	}
    }
    if [info exists xf(safedel_from)] {
	unset xf(safedel_from)
    }
    .xfmenu.butt.m.del entryconfigure Undo* -state disabled
}

proc ClearTrashDir {arr} {
    upvar $arr xf
    set files [lsort [glob -nocomplain $xf(trashdir){*,.*}]]
    foreach c [list .. .] {
	set i [lsearch -glob $files *$c]
	set files [lreplace $files $i $i]
    }
    eval exec $xf(DEL) $files
}

proc ReadFiles {s} {
    global xf
    
    if {[string compare {} $xf(selekted$s)] == 0} {
	InfoChange xf $s "No files selected !"
	bell
	after 4000 [list DefaultInfo xf $s]
    } {
	cd $xf(pathi$s)
	OutputWindow [eval exec cat -- $xf(selekted$s)] "" 
	UnselectAll xf $s
    }
}

proc Grep {s} {
    global xf prompt

    set prompt(1.label) "String:"
    set prompt(1.result) ""
    set prompt(2.label) "Pattern:"
    set prompt(2.result) "*"
    if [DialogWin "The <string> will be searched from files matching <pattern> in current directory and its subdirectories."] {
        if {[string compare {} $prompt(1.result)] == 0 || [string compare {} $prompt(2.result)] == 0} {
            MessageBox "You must give two arguments!"
            unset prompt
            return
        }
        cd $xf(pathi$s)
        set files [exec find . -name "$prompt(2.result)"]
	set result ""
        foreach f $files {
            if [catch {set txt [eval exec grep -n -e $prompt(1.result) $f]}] {
                continue
            }
            append result "$f:\n$txt\n\n"
        }
	if {[string compare {} $result] == 0} {
	    set result "*** No match ***"
	}
        OutputWindow $result
    }
    unset prompt
}
proc MkDir { s } {
    global prompt xf

    if [string match $s left] {
	set o "right"
    } {
	set o "left"
    }

    set xf(clearselect) 0
    set prompt(1.label) ""
    set prompt(1.result) $xf(pathi$s)
    if [DialogWin "Make directory:\n" -50 -50 0] {
        set dirri [string trimright $prompt(1.result) /]
        if [file exists "$dirri"] {
            MessageBox "A file or a directory of that name already exists."
        } {
            if [catch {eval exec $xf(MKDIR) "$dirri"}] {
		MakeDirProc "$dirri"
	    }
            UpdateListbox xf $s
	    DefaultInfo xf $o
        }
    }
    unset prompt
}
proc Rename {s} {
    global prompt xf

    if {[string compare {} $xf(selekted$s)] == 0} {
	InfoChange xf $s "No files selected !"
	bell
	after 4000 [list DefaultInfo xf $s]
    } {
	cd $xf(pathi$s)
	set ind 0
	set x $xf(X)
	set y $xf(Y)
	foreach t $xf(selekted$s) {
            set prompt(1.label) ""
	    set prompt(1.result) $t
	    switch [DialogWin "Rename\n$t\nto:" -50 -50 1 $x $y "Abort!"] {
		0 {continue}
		1 {
		    if [catch {eval exec $xf(MOVE) $xf(pathi$s)$t $xf(pathi$s)$prompt(1.result)} err] {
			tkerror $err
		    }
		    $xf(fuf).${s}list select clear [lindex $xf(selekted${s}_int) $ind]
		    AddSelSize xf $s [lindex $xf(selekted${s}_int) $ind] "-"
		    ShowSelSize xf $s
		    set xf(selekted${s}_int) [lreplace $xf(selekted${s}_int) $ind $ind]
		    set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
		    incr ind -1
		    UpdateListbox xf $s 
		}
		2 {
		    set xf(noinfo) 1
		    after 50 [list set xf(noinfo) 0]
		    after 150 [list InfoChange xf $s "Commmand aborted!"]
		    after 4000 [list DefaultInfo xf $s]
		    break
		}
	    }
	    incr ind
	}
    }
    unset prompt
}
proc CopyAs {s} {
    global prompt xf

    if [string match $s left] {
	set o "right"
    } {
	set o "left"
    }
    
    if {[string compare {} $xf(selekted$s)] == 0} {
	InfoChange xf $s "No files selected !"
	bell
	after 4000 [list DefaultInfo xf $s]
    } {
	cd $xf(pathi$s)
	set ind 0
	set x $xf(X)
	set y $xf(Y)
	foreach t $xf(selekted$s) {
            set prompt(1.label) ""
	    set prompt(1.result) $t
	    switch [DialogWin "Copy\n$t\nas:" -50 -50 1 $x $y "Abort!"] {
		0 {continue}
		1 {
		    if [catch {eval exec $xf(COPY) "$xf(pathi$s)$t" "$xf(pathi$o)$prompt(1.result)"} err] {
			tkerror $err
		    }
		    $xf(fuf).${s}list select clear [lindex $xf(selekted${s}_int) $ind]
		    AddSelSize xf $s [lindex $xf(selekted${s}_int) $ind] "-"
		    ShowSelSize xf $s
		    set xf(selekted${s}_int) [lreplace $xf(selekted${s}_int) $ind $ind]
		    set xf(selekted$s) [lreplace $xf(selekted$s) $ind $ind]
		    incr ind -1
		    UpdateListbox xf $o 
		}
		2 {
		    set xf(noinfo) 1
		    after 50 [list set xf(noinfo) 0]
		    after 150 [list InfoChange xf $s "Commmand aborted!"]
		    after 4000 [list DefaultInfo xf $s]
		    break
		}
	    }
	    incr ind
	}
    }
    unset prompt
}
proc PatternSelect {s} {
    global prompt dirpit_left dirpit_right xf
    
    set xf(clearselect) 0
    if [string match left $s] {
	set dirpit $dirpit_left
    } {
	set dirpit $dirpit_right
    }
    set files [$xf(fuf).${s}list get [expr $dirpit +1] end]

    set prompt(1.label) ""
    set prompt(1.result) "*"
    if [DialogWin "Select all files matching pattern:" -50 -50 0] {
	if {[string compare $prompt(1.result) {}] == 0} {
            unset prompt
	    return
	}
	set indeksi 0
	set len [llength $files]
	while {$indeksi != $len} {
	    set ind [lsearch -glob $files $prompt(1.result)*]
	    if {$ind == -1} {
		break
	    }
	    set indeksi [expr $indeksi+1+$ind]
	    scan [lindex $files $ind] {%s} result
	    if [string match "$prompt(1.result)" $result] {
		$xf(fuf).${s}list select set [expr $indeksi+$dirpit]
	    }
	    set files [lreplace $files 0 $ind]
	}
        InfoChange xf $s "Calculating..."
	after idle [list SelectionSize xf $s]
    }
    unset prompt
}
proc DirSize {s} {
    global xf
    
    set path $xf(pathi$s)
    cd $xf(pathi$s)
    set dirs {}
    foreach t $xf(selekted$s) {
	set t [string trimright [string trimright $t "<Dir>"]]
	if ![file isdirectory $path$t] {
	    break
	}
	lappend dirs $t
    }
    if {[string compare {} $dirs] == 0} {
	return
    }
    set res [eval exec $xf(DIRSIZE) $dirs]
    set n 0
    foreach line [split $res \n] {
	scan $line "%d %s" size name
	set name [string trimright $name /]/
	if $xf(du_1k) {
	    set size [expr $size * 1024]
	} {
	    set size [expr $size * 512]
	}
	set p [lindex $xf(selekted${s}_int) $n]
	$xf(fuf).${s}list delete $p
	if $xf(bitsi) {
            set bits [BitsProc $path$t]
	    $xf(fuf).${s}list insert $p [format "%-25s %10s %9d" $name $bits $size]
	} {
	    $xf(fuf).${s}list insert $p [format "%-29s %9d" $name $size]
	}
	incr n
    }
    set xf(selekted${s}_int) [lreplace $xf(selekted${s}_int) 0 $n]
    set xf(selekted$s) [lreplace $xf(selekted$s) 0 $n]
    after idle [list SelectionSize xf $s]
}
proc AutoUD {} {
    global xf

    foreach s [list "left" "right"] {
	set tmp [file mtime $xf(pathi$s)]
	if {$xf(${s}autoud) != $tmp} {
	    set xf(${s}autoud) $tmp
	    after 1000 [list UpdateListbox xf $s]
	}
    }
    if {$xf(autoupdate)} {
	after 5000 [list AutoUD]
    }
}
proc MenuBar {arr} {
    upvar $arr xf 

    frame .xfmenu -relief raised -borderwidth 1 
    pack .xfmenu -side top -fill x
    menubutton .xfmenu.file -text "File" -menu .xfmenu.file.m -underline 0 \
            -height 1

    set m [menu .xfmenu.file.m]
    $m add command -label "Exit program" -underline 0 \
            -command "Confirm_exit"
    pack .xfmenu.file -side left
    
    
    menubutton .xfmenu.config -text Config -menu .xfmenu.config.m \
	    -underline 0 -height 1 

    set m [menu .xfmenu.config.m]

    $m add command -label "Edit buttons..." \
            -underline 5 -command {ButtonEditorProc}
    $m add command -label "Edit extensions..." \
            -underline 5 -command {ExtEditor} 
    $m add command -label "Edit resources..." \
            -underline 5 -command [list ResourceEditor $xf(rcfile)] 

    pack .xfmenu.config -side left
    

    menubutton .xfmenu.butt -text Options -menu .xfmenu.butt.m -underline 0 \
            -height 1 
    
    set m [menu .xfmenu.butt.m]
    $m add check -label "Turbo File Operations" \
            -underline 1 -variable xf(turbomode)
    $m add check -label "Protection Bits" \
            -underline 0 -variable xf(bitsi) -command SetBit
    $m add check -label "AutoUpdate" \
            -underline 0 -variable xf(autoupdate) -command {if $xf(autoupdate) { \
            set xf(leftautoud) [file mtime $xf(pathileft)]; \
            set xf(rightautoud) [file mtime $xf(pathiright)]; \
            AutoUD}}
    $m add check -label "Show Link Destination" \
            -underline 0 -variable xf(links) \
	    -command Links

    $m add separator
    $m add cascade -label "Deleting" -menu $m.del \
            -underline 0
    $m add cascade -label "Mail Check" -menu $m.mail \
            -underline 0
    $m add cascade -label "Title" -menu $m.sub1 \
            -underline 0

    menu $m.sub1 -tearoff 0
    $m.sub1 add check -label "Mem/Swap" -variable xf(memenable)\
            -underline 0 -command titlemem
    $m.sub1 add check -label "Time" -variable xf(timeenable)\
            -underline 0 -command titletime

    menu $m.del -tearoff 0
    $m.del add check -label "SafeDelete" -underline 0 \
            -variable xf(safedelete)
    $m.del add command -label "Undo last deletion" -underline 0 \
            -command [list TrashCan xf 1] -state disabled
    $m.del add command -label "Empty trash" -underline 0 \
            -command [list TrashCan xf 0]

    menu $m.mail -tearoff 0
    $m.mail add check -label "Enabled" -underline 0\
	    -variable xf(mailchk)\
            -underline 0 -command {
	if {[info exists env(MAIL)] && [file exists $env(MAIL)]} {
	    MailChk
	} {
	    MessageBox "Sorry, I can't find Your mail spool!!"
	    .xfmenu.butt.m entryconfigure Mail* -state disabled
	}
	if $xf(mailchk) {set st "normal"} {set st "disabled"}
	.xfmenu.butt.m.mail entryconfigure Messa* -state $st
	.xfmenu.butt.m.mail entryconfigure Read* -state $st
    }
    $m.mail add check -label "MessageBox" -underline 0\
	    -variable xf(mailmsgbox) -command {
	if $xf(mailmsgbox) {set t "disabled"} {set t "normal"}; 
	.xfmenu.butt.m.mail entryconfigure Read* -state $t
    }
    $m.mail add check -label "Read Mail on Ack" -underline 0\
	    -variable xf(r_mail_on_ack)
    
    menubutton .xfmenu.lines -text "Buttons" -menu .xfmenu.lines.m \
	    -underline 0 -height 1
    
    set m [menu .xfmenu.lines.m -tearoff 1]
    $m add command -label "All" -command \
            {set xf(butsetindic) "";ButtonLineSets {1 2 3 4 5 6 7 8}} -underline 0
    $m add command -label "None" -command {set xf(butsetindic) "";ButtonLineSets} \
	    -underline 0
    $m add separator
    $m add cascade -label "Lines" -menu $m.sub1 \
            -underline 0

    $m add separator
    $m add radio -label "Set 1 (F9)" -variable xf(butsetindic)\
            -command {eval {ButtonLineSets $xf(buttonset1)}}
    $m add radio -label "Set 2 (F10)" -variable xf(butsetindic)\
            -command {eval {ButtonLineSets $xf(buttonset2)}}
    $m add radio -label "Set 3 (F11)" -variable xf(butsetindic)\
            -command {eval {ButtonLineSets $xf(buttonset3)}}
    $m add radio -label "Set 4 (F12)" -variable xf(butsetindic)\
            -command {eval {ButtonLineSets $xf(buttonset4)}}
    
    set m [menu $m.sub1 -tearoff 0]
    $m add check -label "Line 1 (F1)" -variable xf(linz1)\
            -command {ButtonLines 1}
    $m add check -label "Line 2 (F2)" -variable xf(linz2)\
            -command {ButtonLines 2}
    $m add check -label "Line 3 (F3)" -variable xf(linz3)\
            -command {ButtonLines 3}
    $m add check -label "Line 4 (F4)" -variable xf(linz4)\
            -command {ButtonLines 4}
    $m add check -label "Line 5 (F5)" -variable xf(linz5)\
            -command {ButtonLines 5}
    $m add check -label "Line 6 (F6)" -variable xf(linz6)\
            -command {ButtonLines 6}
    $m add check -label "Line 7 (F7)" -variable xf(linz7)\
            -command {ButtonLines 7}
    $m add check -label "Line 8 (F8)" -variable xf(linz8)\
	    -command {ButtonLines 8}


    pack .xfmenu.butt -side left
    pack .xfmenu.lines -side left
    frame .xfmenu.if
    pack .xfmenu.if -side left -expand true -fill x
    
    
    menubutton .xfmenu.help -text Help -menu .xfmenu.help.m -underline 0 \
            -height 1

    set m [menu .xfmenu.help.m]
    $m add check -label "Help mode" \
            -underline 1 -command HelpProc
    $m add separator
    $m add command -label "Main help" \
            -underline 0 -command [list MainHelp xf]
    $m add separator
    $m add command -label "About" -underline 0 \
            -command {Aboutti}
    
    pack .xfmenu.help -side right

    label .xfmenu.if.mem -fg "#6060a0" 
    button .xfmenu.if.time -fg "#6060a0" -relief flat \
	    -state disabled -disabledforeground "#6060a0"\
	    -highlightthickness 0 -command {
	set xf(mailnotice) 1
	after 2000 [list titlemail 0]
	if $xf(r_mail_on_ack) {eval exec xterm -e [option get .xfiles mail_reader {}] &}
    }
    pack .xfmenu.if.mem -side left
    pack .xfmenu.if.time -side right

}

proc ResourceEditor {rcfile} {
    global all RE_saved xf

    if [winfo exists .rcedit] {
	raise .rcedit
	return
    }
    set RE_saved 0
    set w [toplevel .rcedit]
    wm withdraw $w
    wm title $w "X-Files Resource Editor v0.4"
    wm resizable $w 0 0
    frame $w.top
    frame $w.left -bd 3 -relief raised
    frame $w.right -bd 3 -relief raised
    frame $w.bot -bd 3 -relief ridge

    set all(?) ?
    RE_GetOptions $rcfile
    RE_PackOptions $w
    pack $w.left -in $w.top -side left -fill y
    pack $w.right -in $w.top -side right -fill y
    pack $w.top -side top -fill both
    
    button $w.bot.close -text Close -width 8 -command RE_Close
    button $w.bot.save -text Save -width 8 -command RE_Save
    button $w.bot.add -text Add... -width 8 -command RE_Add
    button $w.bot.remove -text Remove -width 8 -command RE_Remove
    button $w.bot.edit -text "Edit Name..." -width 8 -command RE_Edit
    pack $w.bot.close -side right
    pack $w.bot.add $w.bot.remove $w.bot.edit $w.bot.save -side left
    pack $w.bot -side bottom -fill x

    bind $w <Escape> {RE_Close}
    bind $w <Control-c> {RE_Close}
    focus $w.bot.close
    trace variable all w RE_Upd
    wm deiconify $w

    tkwait visibility $w
    set la [llength $all(opt.all)]
    set lr [llength $all(opt.read)]

    if {$la != $lr} {
	if {$la > $lr} {
	    foreach l $all(opt.all) {
		if {[lsearch -exact $all(opt.read) $l] == -1} {
		    lappend diff $l
		}
	    }
	} {
	    foreach l $all(opt.read) {
		if {[lsearch -exact $all(opt.all) $l] == -1} {
		    lappend diff $l
		}
	    }
	}
	MessageBox "The resource file in \"~/.x-files/\"-directory is not up to date. I will now add the missing resources..."
	set i $all(size)
	foreach a $diff {
	    set all($i.name) *xfiles.$a:
	    set all($i.val) [option get .xfiles $a {}]
	    if {[string compare {} $all($i.val)] == 0} {
		MessageBox "Value for option '*xfiles.$a' is missing!!\nInform the system administrator to update 'xfilesrc'."
		continue
	    }
	    set all($i.comment) {}
            if {[regexp {^[01]$} $all($i.val)] && ![regexp {button_set} $all($i.name)]} {
		RE_PackItem "left" $i .rcedit
	    } {
		RE_PackItem "right" $i .rcedit
	    }
	    incr i
	}
	set all(size) $i
	MessageBox "If you need the comments, add them by hand from the file\n$xf(xf_home)xfilesrc"
    }
}

proc RE_Upd {arr index op} {
    global RE_upd
    set RE_upd 1
    trace vdelete all w RE_Upd
}
proc RE_GetOptions {rcfile} {
    global all

    set fid [open $rcfile r]
    gets $fid line
    while {[string compare {} $line]} {
	lappend all(comment) $line
	gets $fid line
    }
    set i 0
    set comment {}
    while {[gets $fid line] >= 0} {
        if [string match {!*} $line] {
            lappend comment $line
        }
        if ![string match {!*} $line] {
	    if {[string compare {} $line] == 0} {
		continue
	    }
            regexp {^([^:]*): (.*)$} $line g option value
            set option [string trim $option]:
            set value [string trim $value]
	    set all($i.name) $option
	    set all($i.val) $value
	    set all($i.comment) $comment
	    set comment {}

	    if {[string match {\*xfiles*} $option] \
		    && ![string match {*popup_user_item*} $option]} {
		regexp {^[^.]*.([^:]*):$} $option a b
		lappend all(opt.read) $b
	    }
	    incr i
        }
    }
    set all(opt.all) {startup_dir_left startup_dir_right trash_dir selectBg_left selectBg_right pack_order_reverse hidden_files_left hidden_files_right turbo_file_operations protection_bits auto_update show_link_dest safe_deletion mem_label time_label button_line_1 button_line_2 button_line_3 button_line_4 button_line_5 button_line_6 button_line_7 button_line_8 button_set_1 button_set_2 button_set_3 button_set_4 mail_check mail_reader mail_message_box read_on_ack}
    set all(size) $i
    close $fid
}

proc RE_PackOptions {w} {
    global all

    for {set i 0} {$i < $all(size)} {incr i} {
	if {[regexp {^[01]$} $all($i.val)] && ![regexp {button_set} $all($i.name)]} {
	    RE_PackItem "left" $i $w
	} {
	    RE_PackItem "right" $i $w
	}
    }
}
proc RE_PackItem {side i w} {
    global all
    frame $w.$side.$i -highlightthickness 1
    if [string match "left" $side] {
	label $w.$side.$i.l -text $all($i.name)
	checkbutton $w.$side.$i.c -variable all($i.val) \
		-command [list focus $w.$side.$i] -highlightthickness 0
	pack $w.$side.$i.c -side right
    } {
	label $w.$side.$i.l -text $all($i.name)
        entry $w.$side.$i.e -textvariable all($i.val) \
		-highlightthickness 0 -width 35
        pack $w.right.$i.e -side right
    }
    pack $w.$side.$i.l -side left
    pack $w.$side.$i -side top -fill x
    bind $w.$side.$i.l <3> [list RE_PopUp $w.$side.$i %X %Y]
    bind $w.$side.$i <3> {RE_PopUp %W %X %Y}
    bind $w.$side.$i.l <1> [list focus $w.$side.$i]
    bind $w.$side.$i <1> {focus %W}
}

proc RE_PopUp {W X Y} {
    global all
    focus $W
    catch {destroy $W.popup}
    regexp {.*\.(.*)\.(.*)$} $W g side ind
    set p [menu $W.popup -tearoff 0 -relief ridge -bd 4 -bg grey70 -disabledforeground #000000]
    $p add command -label "Edit comment..." -command [list RE_EditComment $ind]
    $p add separator
    foreach l $all($ind.comment) {
	$p add command -label $l -state disabled
    }
    tk_popup $p $X $Y
}
proc RE_EditComment {ind} {
    global all

    set tl [toplevel .rc_comment]
    wm geometry $tl +100+100
    wm title $tl "X-Files Resource Comment"
    frame $tl.tf
    text $tl.tf.text -width 50 -height 10
    frame $tl.bf
    button $tl.bf.ok -text Ok -command [list RE_CommentOK $ind]
    button $tl.bf.cancel -text Cancel -command {destroy .rc_comment}
    pack $tl.tf -side top
    pack $tl.bf -side bottom -fill x -expand true
    pack $tl.bf.ok -side left
    pack $tl.bf.cancel -side right
    pack $tl.tf.text -side top
    $tl.tf.text delete 0.0 end 
    foreach line $all($ind.comment) {
	$tl.tf.text insert end "$line\n"
    }
    focus $tl.bf.cancel
}
proc RE_CommentOK {ind} {
    global all RE_upd
    
    set text [split [string trim [.rc_comment.tf.text get 0.0 end]] \n]
    if {[string compare $text $all($ind.comment)] == 0} {
	return
    }
    set RE_upd 1
    set all($ind.comment) ""
    foreach l $text {
	lappend all($ind.comment) !![string trimleft $l !]
    }
    destroy .rc_comment    
}
proc RE_Add {} {
    global all add
    
    set add(result) "*"
    set add(choice) "e"
    if [RE_AddDialog "Give the name and type of the new resource." -100 -150] {
	if {[string match {\*xfiles*} $add(result)] && \
		![string match {*popup_user_item_*} $add(result)]} {
	    MessageBox "You cannot give an *xfiles option!!"
	    unset add
	    return
	}
	set i $all(size)
	incr all(size)
	if {[string compare "e" $add(choice)] == 0} {
	    set all($i.name) [string trimright $add(result) :]:
	    set all($i.val) ""
	    set all($i.comment) {}
	    RE_PackItem "right" $i .rcedit
	} {
	    set all($i.name) [string trimright $add(result) :]:
	    set all($i.val) ""
	    set all($i.comment) {}
	    RE_PackItem "left" $i .rcedit
	}
    }
    unset add
}
proc RE_AddDialog {string {xoffset -50} {yoffset -50}} {
    global add ret xf

    set d .prompt
    catch {destroy $d}
    toplevel $d -bd 3
    wm title $d "Query"
    set x [expr $xf(X) + $xoffset]
    set y [expr $xf(Y) + $yoffset]
    wm geometry $d "+$x+$y"
    frame $d.but -bd 2 -relief raised
    message $d.msg -justify left -text $string -aspect 300 \
	    -font *helvetica-bold-r-*-*-14* -relief flat -bd 6
    frame $d.y -relief ridge -bd 2
    label $d.y.l -text "Name:"
    entry $d.y.e -textvariable add(result) -highlightthickness 2
    pack $d.y.l $d.y.e -side left
    frame $d.d -relief ridge -bd 2
    frame $d.d.c
    radiobutton $d.d.c.c -variable add(choice) -value "c" -text "Checkbutton"
    radiobutton $d.d.c.e -variable add(choice) -value "e" -text "Entry field"
    pack $d.d.c.c $d.d.c.e -side top -anchor w
    label $d.d.l -text Type:
    pack $d.d.l $d.d.c -side left
    
    bind $d <Control-c> {set ret  0}
    bind $d <Escape> {set ret  0}
    bind $d.y.e <Return> {set ret 1}
    button $d.but.ok -width 6 -text OK -command {set ret 1}
    button $d.but.cancel -width 6 -text Cancel -command {set ret 0}
    pack $d.but.ok -side left -padx 5 -pady 5
    pack $d.but.cancel -side right -padx 5 -pady 5
    pack $d.msg $d.y $d.d $d.but -side top -fill x -expand true
    
    tkwait visibility $d
    grab $d
    $d.y.e xview moveto 1
    $d.y.e icursor end
    focus $d.y.e
    tkwait variable ret
    grab release $d
    destroy $d
    return $ret

}
proc RE_Remove {} {
    global all RE_upd

    set w [focus]
    if [string match *bot* $w] {
	MessageBox "Select an option first!"
	return
    }
    regexp {.*\.(.*)\.(.*)$} $w g side ind
    if {[string match *xfiles* $all($ind.name)] \
	    && ![string match *popup_user* $all($ind.name)]} {
	MessageBox "You are not allowed to remove an *xfiles -option!"
	return
    }
    if {[AskWin "Are You sure ?!"] == 0} {
	return
    }
    set RE_upd 1
    pack forget $w
    unset all($ind.name)
    unset all($ind.val)
    unset all($ind.comment)
    .rcedit.bot.remove flash
}
proc RE_Edit {} {
    global all xf RE_upd prompt

    set w [focus]
    if [string match *bot* $w] {
	MessageBox "Select an option first!"
	return
    }
    regexp {.*\.(.*)\.(.*)$} $w g side ind
    set prompt(1.label) "Name:"
    set prompt(1.result) [string trimright $all($ind.name) :]
    if [DialogWin "Edit option\n"] {
	if {[string compare {} $prompt(1.result)] == 0} {
	    MessageBox "Not a good name..."
	    unset prompt
	    return
	}
	set res [string trimright $prompt(1.result) :]:
	foreach n [array names all *name] {
	    if {[string compare $res $all($n)] == 0} {
		MessageBox "An option with that name already exists!"
		unset prompt
		return
	    }
	}
	set RE_upd 1
	set all($ind.name) $res
	$w.l config -text $all($ind.name)
    }
    update idletasks
    unset prompt
}
proc RE_Save {} {
    global all xf RE_upd RE_saved
    
    MakeSaveDir
    set xf(rcfile) $xf(user_home)xfilesrc
    set out [open $xf(rcfile) w]
    foreach l $all(comment) {
	puts $out $l
    }
    puts $out ""
    set i 0
    while {$i < $all(size)} {
	catch {
	    foreach x $all($i.comment) {
		puts $out $x
	    }   
	}
	catch {puts $out "$all($i.name) $all($i.val)"}
	catch {puts $out ""}
	incr i
    }
    close $out
    set RE_upd 0
    set RE_saved 1
    trace variable RE_upd w RE_Upd
    .rcedit.bot.save flash
}
proc RE_Close {} {
    global all RE_upd RE_saved xf argc argv

    if [info exists RE_upd] {
	if $RE_upd {
            set ret [AskWin "You have made changes! Close the editor without saving?" -100 -100 "Save"]
	    switch $ret {
                0 {return}
		2 {RE_Save}
		default {}
            }
        }
    } {
	set RE_upd 0
    }
    if {$RE_upd || $RE_saved} {
	if [AskWin "Do you wish to restart X-Files, so that the changes become effective now?" -100 -100] {
	    set home $xf(xf_home) 
	    catch {unset xf ee ea be all RE_upd}
	    foreach w [winfo children .] {
		catch {destroy $w}
	    }
	    set xf(xf_home) $home
	    uplevel #0 {MAIN $argc $argv}
	}
    }
    catch {destroy .rcedit}
    catch {unset all}
    catch {unset RE_upd}
}
proc HelpProc {} {
    global xf

    if {$xf(helpmode) == 1} {
	set xf(helpmode) 0 
	SetArrowPointer .
	foreach var [array names xf Help*] {
	    unset xf($var)
	}
    } { 
	source $xf(main_pophelp_file)
	source $xf(user_pophelp_file)
	set xf(helpmode) 1 
	. config -cursor question_arrow
    }
}

proc Links {} {
    global xf
    UpdateListbox xf left
    UpdateListbox xf right
}

proc SetBit {} {
    global xf

    if $xf(bitsi) {
	$xf(fuf).leftlist config -width 47
	$xf(fuf).rightlist config -width 47
	.xfmenu.butt.m entryconfigure Show* -state disabled
	wm minsize . 47 25
    } {
	$xf(fuf).leftlist config -width 40
	$xf(fuf).rightlist config -width 40
	.xfmenu.butt.m entryconfigure Show* -state normal
	wm minsize . 40 25
    }
    UpdateListbox xf "left"
    UpdateListbox xf "right"
}
proc ButtonLines {line {key 0}} {
    global xf

    set xf(butsetindic) ""
    set idx0 [expr ($line-1) * 2]
    set idx1 [expr $idx0 + 1]
    if {$key > 0} {
	if {!$xf(linz$line)} {
	    set xf(linz$line) 1 
	} {
	    set xf(linz$line) 0
	}
    }

    if {$xf(linz$line)} {
	pack .xfleft.bf($idx0) -side bottom -expand true -fill x
	pack .xfright.bf($idx1) -side bottom -expand true -fill x
    } {
	pack forget .xfleft.bf($idx0)
	pack forget .xfright.bf($idx1)
	.xfleft config -height 1
	.xfright config -height 1
    }
}
proc ButtonLineSets {{par ""}} {
    global xf
    for {set i 0} {$i < 8} {incr i} {
	set xf(linz[expr $i +1]) 0
	pack forget .xfleft.bf([expr 2 * $i])
	pack forget .xfright.bf([expr 2 * $i +1])
	.xfleft config -height 1
	.xfright config -height 1
    }
    foreach i $par {
	set xf(linz$i) 1
	pack .xfleft.bf([expr 2 * ($i-1)])\
		-side bottom -expand true -fill x
	pack .xfright.bf([expr (2 * ($i-1))+1])\
		-side bottom -expand true -fill x
    }    
}
proc MailChk {} {
    global xf env

    if {$xf(mailchk) == 1} {
	set tmp [file mtime $env(MAIL)]
	set tmp2 [file atime $env(MAIL)]
	if {$tmp != $xf(mailtime)} {
	    if {$xf(mailatime) == $tmp2} {
		if {$xf(mailmsgbox) == 1} {
		    if [AskWin "You have new mail !\nRead it now?"] {
			eval exec xterm -e [option get .xfiles mail_reader {}] &
		    }

		} {
		    set xf(mailnotice) 0
		    titlemail 20
		}
	    }
	    set xf(mailtime) $tmp
	}
	if {$xf(mailatime) < $tmp2} {
	    set xf(mailatime) $tmp2
	}

	after 10000 MailChk
    }
}
proc titlemail {t} {
    global xf
    if {$t > 0} {
	after 2000 {
	    if !$xf(mailnotice) {
		if $xf(timeenable) {
		    set dt [string range [exec date] 0 15]
		    .xfmenu.if.time config -text " < $dt > " -fg "#6060a0" \
			    -relief flat -state normal \
			    -disabledforeground "#6060a0"\
			    -highlightthickness 0\
			    -fg "#6060a0"
		    update idletasks
		} {
		    .xfmenu.if.time config -text "             "
		}
		after 1000 {
		    .xfmenu.if.time config -text "< New Mail >" \
			    -state normal -fg #ff3333
		    update idletasks
		}
	    }
	}
	incr t -1
	if $xf(mailnotice) {
	    titlemail 0
	} {
	    after 3000 [list titlemail $t]
	}
    } {
	if $xf(timeenable) {
	    set dt [string range [exec date] 0 15]
	    .xfmenu.if.time config -text " < $dt > " -fg "#6060a0" \
		    -relief flat -state disabled \
		    -disabledforeground "#6060a0" \
		    -highlightthickness 0
	    update idletasks
	} {
	   .xfmenu.if.time config -text ""
	    update idletasks
	}
    }
}
proc titletime {} {
    global xf
    
    if {$xf(timeenable) == 1} {
	set dt [string range [exec date] 0 15]
	.xfmenu.if.time config -text " < $dt > " -fg "#6060a0"
	after 30000 titletime
    } {
	.xfmenu.if.time config -text ""
    }
}
proc titlemem {} {
    global xf
    
    if {$xf(memenable) == "1"} {
	set ms [exec cat /proc/meminfo]
	set ind [expr [lsearch -glob $ms *ree:*] +1]
	set ms [split $ms \n]
	set mem [lindex [lindex $ms [lsearch -glob $ms Mem:*]] $ind]
	set swp [lindex [lindex $ms [lsearch -glob $ms Swap:*]] $ind]
	unset ms
	.xfmenu.if.mem config -text "< Mem: [FormatNumber $mem] Swap: [FormatNumber $swp] >"
	after 3000 titlemem
    } {
	.xfmenu.if.mem config -text ""
    }
}
proc Aboutti {} {
    global xf
    set w .about
    catch {destroy $w}
    set bg "#661d73"
    set abg "#772d83"
    set afg "#afffff"
    toplevel $w -bg $bg 
    wm title $w "About X-Files"
    wm iconname $w "About X-Files"
    wm geometry $w +300+300 

    frame $w.text -bg $bg -relief raised -bd 2
    frame $w.buttons -bg $bg 
    pack  $w.buttons -side bottom -expand y -fill x -pady 2m
    button $w.buttons.dismiss -bg $bg -fg "#afffff" -text Dismiss \
	    -activebackground $abg -activeforeground $afg -bd 2\
	    -padx 1 -pady 1 -command {image delete xfimage; destroy .about}
    pack $w.buttons.dismiss  -side left -expand 1
    
    catch {image delete xfimage}
    image create photo xfimage -file "$xf(xf_home)xflogo.gif"
    label $w.im -image xfimage -relief flat -bg $bg
    
    text $w.text.tx -bg $abg -fg $afg -height 12 -width 10

    
    $w.text.tx tag configure versioni -font *-times-bold-r-*-12-*\
	    -foreground "#ffafff" -justify center -spacing3 10
    $w.text.tx tag configure prog -font *-times-*-r-*-18-*\
	    -foreground "#efefa0" -underline 1
    $w.text.tx tag configure name -font -*-times-*-r-*-*-18-*-*-*-*-*-*-*\
	    -foreground "#dfdfff"
    $w.text.tx tag configure all -lmargin1 5 -spacing1 5


    $w.text.tx insert end "Version: $xf(version) $xf(reg)\n" versioni

    $w.text.tx insert end "Programming & Copyrights: \n" prog
    $w.text.tx insert end "Juha Forsten \n" name
    $w.text.tx insert end "Mikko Kiviniemi \n" name
    $w.text.tx insert end "\n"
    $w.text.tx insert end "Email: xf_adm@pinhead.tky.hut.fi\n"
    $w.text.tx insert end "WWW  : pinhead.tky.hut.fi/~xf_adm/\n"
    $w.text.tx insert end "\n"

    $w.text.tx tag add all 2.0 5.0
    
    pack $w.im -side top -padx .5m -pady .5m
    pack $w.text -side top -pady 10 -fill x
    pack $w.text.tx -fill x
    $w.text.tx configure -state disabled
}

proc Confirm_exit {} {
    if {[AskWin "Exit  X-Files ?!"] == 1} {exit}
}
proc Xf_variable_dumb { {file xf_vars.dumb}} {
    global xf tk_version tcl_version
    set tmp "TK-version: $tk_version"
    set tmp "$tmp\nTCL-version: $tcl_version\n"
    set tmp "$tmp\nX-Files variables & values:\n---------------------------\n\n"
    foreach idx [lsort [array names xf]] {
	set tmp  "$tmp xf($idx): $xf($idx)\n"
    } 
    OutputWindow $tmp
}

proc HelpInfo { x y hwidget } {
    global helppop xf
    if {[info exists xf(Help$hwidget)] == 1} { 
	if {[info exists xf(Help$hwidget)] == 1} {
	    catch {destroy $helppop}
	    set helppop [menu .help -bg "#303080" \
		    -tearoff 0 -disabledforeground "#f0f0b0" -relief ridge]
	    $helppop  add command -state disabled \
		    -font *Helvetica*-12-* \
		    -label [lindex $xf(Help$hwidget) 0]
	    set temp [lreplace $xf(Help$hwidget) 0 0 ]
	    $helppop add separator
	    foreach line $temp {
		$helppop  add command -state disabled \
			-label $line
	    }
	    
	    tk_popup $helppop \
		    [expr {[winfo rootx $hwidget] + 10}]\
		    [expr {[winfo rooty $hwidget] + 10}]
	}
    }		
}
    
proc MainHelp {arr} {
    upvar $arr xf
    set manual [open $xf(xf_home)xfiles.manual r]
    OutputWindow [read $manual]
    close $manual
}
proc ButtonEditorProc {} {
    global beparent be xf bcomm bargs bindex
    
    if [winfo exists .button_edit] {
	raise .button_edit
	return
    }
    if $xf(helpmode) {
	.xfmenu.help.m invoke 1
    }
    
    set xf(editmode) 1
    set be(editedi) 0
    source $xf(main_pophelp_file)
    source $xf(user_pophelp_file)

    set be(txt) {}
    set be(cmdtxt) Execute
    set be(cmdarg) {}
    set be(style) {-relief raised -bd 3}
    set be(editmode) "Advanced..."
    set be(font) default
    set be(colormode) {-fg}
    set be(confirm) 0
    set be(dialog) 0
    set be(win) 0
    set be(update) 0
    set be(bg) 0

    set beparent [toplevel .button_edit  -height 150 -width 500]
    wm geometry $beparent +100+100
    frame $beparent.entframe -relief groove -bd 3 -height 60 -width 500

    set bemfont "*helvetica-bold-r-*-*-12*"
    frame $beparent.menu -relief raised -borderwidth 1 
    menubutton $beparent.menu.toolmenu -text Tools \
	    -menu $beparent.menu.toolmenu.m\
	    -underline 0 -height 1 -font $bemfont
    menu $beparent.menu.toolmenu.m
    $beparent.menu.toolmenu.m add command -label "Put Button"  \
	    -underline 0 -command PutButton -state disabled
    $beparent.menu.toolmenu.m add separator
    $beparent.menu.toolmenu.m add command -label "Write Help"  \
	    -underline 0 -command {WriteHelp}

    message $beparent.menu.msg -text "Please, CLICK the ActionButton \
	    You want to edit.." -fg "#a00000" -width 400 -anchor center \
	    -justify center
    frame $beparent.entframe.up  
    frame $beparent.entframe.up.0 
    frame $beparent.entframe.up.1 
    frame $beparent.entframe.up.2 
    frame $beparent.entframe.up.separator -relief flat  -bd 2 -width 4
    frame $beparent.entframe.up.3 -relief sunken  -bd 1
    
    label $beparent.entframe.up.0.txtmsg -text "Button label:" 
    entry $beparent.entframe.up.1.txtentry -textvariable be(txt) -width 13
    
    frame $beparent.entframe.fc
    checkbutton $beparent.entframe.fc.chkcfr -text "Confirm" -bd 2 \
	    -relief ridge\
	    -onvalue "C" -offvalue "" -variable be(confirm)
    checkbutton $beparent.entframe.fc.chkdia -text "Dialog" -bd 2 -relief ridge\
	    -onvalue "D" -offvalue "" -variable be(dialog)
    checkbutton $beparent.entframe.fc.chkwin -text "OutputWin" -bd 2 \
	    -relief ridge\
	    -onvalue "W" -offvalue "" -variable be(win)
    checkbutton $beparent.entframe.fc.chkupd -text "Update" -bd 2 -relief ridge\
	    -onvalue "U" -offvalue "" -variable be(update)
    
    label $beparent.entframe.up.0.cmdmsg -text "Command:" 
    menubutton $beparent.entframe.up.1.cmdmb -textvariable be(cmdtxt) -menu \
	    $beparent.entframe.up.1.cmdmb.cmdmenu  -relief raised\
	    -indicatoron true -width 8 -justify left
    set cm [menu $beparent.entframe.up.1.cmdmb.cmdmenu -tearoff 1]
    
    $cm add radio -label Execute -variable be(cmdtxt) \
            -command [list BE_Hack exec pack pack] \
	    -value Execute
    
    $cm add separator

    $cm add radio -label ChangeDir -variable be(cmdtxt) \
            -command [list BE_Hack {ChangeDir %s} pack] \
            -value ChangeDir
    
    $cm add radio -label Copy -variable be(cmdtxt) \
            -command [list BE_Hack {FileOps cp %s}] \
	    -value Copy
    
    $cm add radio -label CopyAs -variable be(cmdtxt) \
            -command [list BE_Hack {CopyAs %s}] \
	    -value CopyAs
    
    $cm add radio -label Delete -variable be(cmdtxt) \
            -command [list BE_Hack {FileOps rm %s}] \
	    -value Delete 
    
    $cm add radio -label DirSize -variable be(cmdtxt) \
            -command [list BE_Hack {DirSize %s}] \
	    -value DirSize

    $cm add radio -label Grep -variable be(cmdtxt) \
            -command [list BE_Hack {Grep %s}] \
	    -value Grep
       
    $cm add radio -label MakeDir -variable be(cmdtxt) \
            -command [list BE_Hack {MkDir %s}] \
	    -value MakeDir    

    $cm add radio -label Mount -variable be(cmdtxt) \
            -command [list BE_Hack {Mount %s} pack] \
	    -value Mount
       
    $cm add radio -label Move -variable be(cmdtxt) \
            -command [list BE_Hack {FileOps mv %s}] \
	    -value Move
    
    $cm add radio -label PatternSel -variable be(cmdtxt) \
            -command [list BE_Hack {PatternSelect %s}] \
	    -value PatternSel
    
    $cm add radio -label ProtEdit -variable be(cmdtxt) \
            -command [list BE_Hack {ProtEditor %s}] \
	    -value ProtEdit    
   
    $cm add radio -label ReadFiles -variable be(cmdtxt) \
            -command [list BE_Hack {ReadFiles %s}] \
	    -value ReadFiles
   
    $cm add radio -label Rename -variable be(cmdtxt) \
            -command [list BE_Hack {Rename %s}] \
	    -value Rename
    
    $cm add radio -label VirtualTar -variable be(cmdtxt) \
            -command [list BE_Hack {VirtualTar %f %s}] \
	    -value VirtualTar

    $cm add radio -label VirtualZip -variable be(cmdtxt) \
            -command [list BE_Hack {VirtualZip %f %s}] \
	    -value VirtualZip

    checkbutton $beparent.entframe.up.2.bg -text "Background" -variable be(bg)\
	    -onvalue "&" -offvalue ""
    entry $beparent.entframe.up.2.cmdentry -textvariable be(cmdarg) -width 20
    
    frame $beparent.middle
    button $beparent.middle.advbutt -textvariable be(editmode)\
	    -width 10 -command ChEditMode
    
    message $beparent.entframe.up.3.label -aspect 200 \
	    -text "                                               "
    
    eval {menubutton $beparent.entframe.up.3.button -textvariable $be(txt) \
	    -width 6 -menu $beparent.entframe.up.3.button.stylemenu} $be(style)  

    set sm [menu $beparent.entframe.up.3.button.stylemenu -tearoff 1]
    
    $sm add radio -label Default -command {set be(style) {-relief raised -bd 3 \
	    -activebackground "#ececec" -cursor top_left_arrow }; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Flat -command {set be(style) {-relief flat \
	    -activebackground "#ececec" -cursor top_left_arrow}; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Ridge3 -command {set be(style) {-relief ridge -bd 3 \
	    -activebackground "#ececec" -cursor top_left_arrow}; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Groove3 -command {set be(style) {-relief groove -bd 3 \
	    -activebackground "#ececec" -cursor top_left_arrow}; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Sunken3 -command {set be(style) {-relief sunken -bd 3 \
	    -activebackground "#ececec" -cursor top_left_arrow }; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Raised2 -command {set be(style) {-relief raised -bd 2 \
	    -activebackground "#ececec" -cursor top_left_arrow}; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Raised1 -command {set be(style) {-relief raised -bd 1 \
	    -activebackground "#ececec" -cursor top_left_arrow}; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Warning -command {set be(style) {-relief raised -bd 3 \
	    -activebackground "#ffa0a0" -cursor pirate }; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    $sm add radio -label Trek -command {set be(style) {-relief raised -bd 3 \
	    -activebackground "#ececec" -cursor trek}; \
	    eval {$beparent.entframe.up.3.button config} $be(style) }
    
    frame $beparent.bottom -relief groove -bd 3 -height 50 -width 500
    
    
    frame $beparent.bottom.applyframe -relief sunken -bd 1 -height 34 -width 65
    button $beparent.bottom.applyframe.apply -text Apply -command {
	eval {ApplyProc $bindex}
    } -state disabled
    button $beparent.bottom.undo -text Undo -command UndoProc  -state disabled
    
    button $beparent.bottom.save -text Save -command {ApplyProc $bindex; ButtonSave}\
	    -state disabled
    button $beparent.bottom.close -text Close -command {
	BE_Close
    }
    
    frame $beparent.adv -relief raised -bd 2
    frame $beparent.adv.0 -relief ridge -bd 2
    frame $beparent.adv.0.opt
    frame $beparent.adv.0.args
    frame $beparent.adv.0.opt.0
    frame $beparent.adv.0.opt.1 
    frame $beparent.adv.1 -relief sunken -bd 2 -bg "#cacaca"
    frame $beparent.adv.1.0  -bg "#cacaca"
    frame $beparent.adv.1.0.sld -relief raised -bd 2
    frame $beparent.adv.1.1 -bg "#cacaca"
    label $beparent.adv.1.0.l1 -text RGB-sliders: -bg "#cacaca"
    label $beparent.adv.1.1.l2 -text Property: -bg "#cacaca"
    
    radiobutton $beparent.adv.1.1.rb1 -text "Text color" -value \
	    {-fg} -variable be(colormode)\
	    -indicatoron false -selectcolor "#dcdcdc" -width 10\
	    -command {SetScale}
    radiobutton $beparent.adv.1.1.rb2 -text "Backgound" -value \
	    {-bg} -variable be(colormode)\
	    -indicatoron false -selectcolor "#dcdcdc" -width 10\
	    -command {SetScale}
    radiobutton $beparent.adv.1.1.rb3 -text "Active Txt" -value \
	    {-activeforeground} -variable be(colormode)\
	    -indicatoron false -selectcolor "#dcdcdc" -width 10\
	    -command {SetScale}
    radiobutton $beparent.adv.1.1.rb4 -text "Active BG" -value \
	    {-activebackground} -variable be(colormode)\
	    -indicatoron false -selectcolor "#dcdcdc" -width 10\
	    -command {SetScale}
    
    frame $beparent.adv.1.1.cf -relief sunken -bd 1 -width 80 -height 45
    
    scale $beparent.adv.1.0.sld.rslider -orient vertical -from 255 -to 0\
	    -length 4c -fg "#af3030" -variable be(red) -command {ChColor ;\
	    set be(red) }
    scale $beparent.adv.1.0.sld.gslider -orient vertical -from 255 -to 0\
	    -length 4c -fg "#30af30" -variable be(green) -command {ChColor ;\
	    set be(green) }
    scale $beparent.adv.1.0.sld.bslider -orient vertical -from 255 -to 0\
	    -length 4c -fg "#3030af" -variable be(blue) -command {ChColor ;\
	    set be(blue) }
    
    label $beparent.adv.0.opt.0.cmblabel -text Cursor:
    menubutton $beparent.adv.0.opt.0.cmb  -textvariable be(cursor) -relief raised\
	    -menu $beparent.adv.0.opt.0.cmb.cm -indicatoron true -width 6
    set cm [menu $beparent.adv.0.opt.0.cmb.cm -tearoff 1]
    
    $cm add command -label "default " -command \
	    {set be(cursor) {default};\
	    SetButtonStyle -cursor top_left_arrow }
    $cm add command -label \x26\x3a -font cursor  -command \
	    {set be(cursor) {hand1};\
	    SetButtonStyle -cursor hand1 }
    $cm add command -label \x26\x3e -font cursor  -command \
	    {set be(cursor) {heart};\
	    SetButtonStyle -cursor heart }
    $cm add command -label \x26\x58 -font cursor  -command \
	    {set be(cursor) {pirate};\
	    SetButtonStyle -cursor pirate }
    $cm add command -label \x26\x56 -font cursor  -command \
	    {set be(cursor) {pencil};\
	    SetButtonStyle -cursor pencil }
    $cm add command -label \x26\x8e -font cursor  -command \
	    {set be(cursor) {trek};\
	    SetButtonStyle -cursor trek }
    
    label $beparent.adv.0.opt.1.rmblabel -text Relief:
    menubutton $beparent.adv.0.opt.1.rmb -textvariable be(relief) -relief raised\
	    -menu $beparent.adv.0.opt.1.rmb.rm -indicatoron true -width 6
    set cm [menu $beparent.adv.0.opt.1.rmb.rm -tearoff 1]
    
    $cm add command -label "Raised" -command \
	    {set be(relief) {raised };\
	    SetButtonStyle -relief raised }
    $cm add command -label "Sunken" -command \
	    {set be(relief) {sunken };\
	    SetButtonStyle -relief sunken }
    $cm add command -label "Groove" -command \
	    {set be(relief) {groove };\
	    SetButtonStyle -relief groove }
    $cm add command -label "Ridge" -command \
	    {set be(relief) {ridge };\
	    SetButtonStyle -relief ridge }
    $cm add command -label "Flat" -command \
	    {set be(relief) {flat };\
	    SetButtonStyle -relief flat }
    
    label $beparent.adv.0.opt.0.fmblabel -text Font:
    menubutton $beparent.adv.0.opt.0.fmb -textvariable be(font) -relief raised\
	    -menu $beparent.adv.0.opt.0.fmb.fm -indicatoron true -width 6
    set cm [menu $beparent.adv.0.opt.0.fmb.fm -tearoff 1]
    
    $cm add command -label "Default" -command \
	    {set be(font) {Default };\
	    SetButtonStyle \
	    -font -Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*}
    $cm add command -label "Fixed" -command \
	    {set be(font) {Fixed };\
	    SetButtonStyle -font fixed }
    $cm add command -label "Helvet" -command \
	    {set be(font) {Helvet};\
	    SetButtonStyle -font *helvetica* }
    $cm add command -label "Times" -command \
	    {set be(font) {Times };\
	    SetButtonStyle -font *courier* }
    $cm add command -label "Lucida" -command \
	    {set be(font) {Lucida};\
	    SetButtonStyle -font *lucida* }
    $cm add command -label "Utopia" -command \
	    {set be(font) {Term};\
	    SetButtonStyle -font *utopia* }
    
    label $beparent.adv.0.opt.1.bdlabel -text Borderwidth:
    scale $beparent.adv.0.opt.1.bds -from 0 -to 5 -orient horizontal\
	    -width 10 -length 70 -variable be(bd) -showvalue false -command\
	    {SetButtonStyle -bd} 
    
    label $beparent.adv.0.args.arglabel -text "Button arguments:"
    entry $beparent.adv.0.args.argentry -textvariable be(style) -width 24 
    
    wm title $beparent "ButtonEditor v0.9 "
    wm resizable $beparent 0 0

    pack  $beparent.menu -side top -fill x
    pack $beparent.entframe.up -side top  -fill both
    pack $beparent.entframe.up.0 -side left -fill both
    pack $beparent.entframe.up.1 -side left -fill both
    pack $beparent.entframe.up.2 -side left -fill both
    pack $beparent.entframe.up.3 -side right -fill both
    pack $beparent.entframe.up.separator -side right -fill both -padx 5
    pack $beparent.entframe.up.0.txtmsg -side top -anchor nw
    pack $beparent.entframe.up.0.cmdmsg -side bottom -anchor nw 
    pack $beparent.entframe.up.1.txtentry -side top -fill x
    pack $beparent.entframe.up.1.cmdmb -side bottom -fill x
    pack $beparent.entframe.up.2.bg -side top
    pack $beparent.entframe.up.2.cmdentry -side bottom
    pack $beparent.entframe.up.3.label -side top
    place $beparent.entframe.up.3.button -relx 0.5 -rely 0.5 -anchor center
    raise $beparent.entframe.up.3.button
    pack $beparent.entframe.fc.chkcfr -side left -fill x -expand true
    pack $beparent.entframe.fc.chkdia -side left -fill x -expand true
    pack $beparent.entframe.fc.chkwin -side left -fill x -expand true
    pack $beparent.entframe.fc.chkupd -side right -fill x -expand true
    pack $beparent.entframe.fc -fill x -side bottom -pady 5
        
    pack $beparent.middle.advbutt -pady 2 -side left
    pack $beparent.bottom -side bottom -fill x
    pack $beparent.bottom.applyframe -side left -padx 3 -pady 2
    pack $beparent.bottom.applyframe.apply -anchor center -padx 3 -pady 2
    pack $beparent.bottom.undo -side left -padx 3 -pady 2
    pack $beparent.bottom.save -side left -padx 3 -pady 2
    pack $beparent.bottom.close -side right -padx 3 -pady 2
    pack $beparent.adv.0 -side left -fill both -padx 5 -pady 5
    pack $beparent.adv.0.opt -side top -fill both
    pack $beparent.adv.0.args -side bottom -fill both
    pack $beparent.adv.0.opt.0 -side left -fill both -padx 4
    pack $beparent.adv.0.opt.1 -side right -fill both
    pack $beparent.adv.1 -side right -fill both -padx 5 -pady 5
    pack $beparent.adv.1.0 -side left -fill both
    pack $beparent.adv.1.0.sld -side bottom -fill both -padx 5 -pady 5
    pack  $beparent.adv.1.1 -side right -fill both
    
    pack $beparent.adv.0.opt.0.cmblabel -side top
    pack $beparent.adv.0.opt.0.cmb -side top
    pack $beparent.adv.0.opt.0.fmblabel -side top
    pack $beparent.adv.0.opt.0.fmb -side top
    pack $beparent.adv.0.opt.1.rmblabel -side top
    pack $beparent.adv.0.opt.1.rmb -side top
    pack $beparent.adv.0.opt.1.bdlabel -side top
    pack $beparent.adv.0.opt.1.bds -side top
    
    pack $beparent.adv.0.args.arglabel -side top
    pack $beparent.adv.0.args.argentry -side bottom -padx 2
    
    pack $beparent.adv.1.0.sld.rslider -side left
    pack $beparent.adv.1.0.sld.gslider -side left
    pack $beparent.adv.1.0.sld.bslider -side left
    pack $beparent.adv.1.0.l1 -side top
    pack $beparent.adv.1.1.l2 -side top
    pack $beparent.adv.1.1.rb1 -side top
    pack $beparent.adv.1.1.rb2 -side top
    pack $beparent.adv.1.1.rb3 -side top
    pack $beparent.adv.1.1.rb4 -side top
    pack $beparent.adv.1.1.cf -side bottom -fill x -padx 5 -pady 5
    pack $beparent.menu.msg -side top
    
    bind .button_edit <Return> {
	catch {focus .button_edit 
	SetButtonStyle {} {}
	ApplyProc $bindex}
    }
    bind .button_edit <Control-c> {
	BE_Close
    }
    bind .button_edit <Escape> {
	BE_Close
    }
    bind .button_edit.entframe.up.1.txtentry <KeyPress> {
	after 50 {eval {SetButtonStyle {-text} \
		[$beparent.entframe.up.1.txtentry get]}}
    }
    bind .button_edit <Control-d> {PrintCmdLine; break}
    
    proc BE_Close {} {
	global xf bargs bcomm bindex be
	
	if [info exists bindex] {
	    if {[set par "$be(dialog)$be(update)$be(confirm)$be(win)"] == ""} {
		set par N
	    }
	    if {$be(bg) == "&"} {
		set cmdarg "$be(cmdarg) $be(bg)"
	    } {
		set cmdarg $be(cmdarg)
	    }
	    
	    if {[string compare $bargs($bindex) $be(style)] != 0 \
		    || [string compare $bcomm($bindex) [format "%s%s%s" "$par " "$be(cmd) " "$cmdarg"]] != 0 \
		    || $be(editedi)} {
		set ret [AskWin "You have made changes! Close the editor without saving?" -50 -50 "Save"]
		switch $ret {
		    0 {return}
		    2 {ApplyProc $bindex ; ButtonSave}
		    default {}
		}
	    }
	}
	set xf(editmode) 0
	foreach var [array names xf Help*] {
	    unset xf($var)
	}
	
	set xf(editbutton) ""
	catch {unset bindex be}
	destroy .button_edit
    }

    proc ApplyProc {index} {
	global beparent xf be bargs bcomm
	if {[regexp %o1 $be(cmdarg)]} {
	    set be(dialog) D           
	} {                            
	    set be(dialog) ""          
	}
	if {[set par "$be(dialog)$be(update)$be(confirm)$be(win)"] == ""} {
	    set par N
	}
	if {$be(bg) == "&"} {
	    set cmdarg "$be(cmdarg) $be(bg)"
	} {
	    set cmdarg $be(cmdarg)
	}
	set bcomm($index) [format "%s%s%s" "$par " "$be(cmd) " "$cmdarg"]
	set bargs($index) $be(style)
	$xf(editbutton) flash
	eval {$xf(editbutton) config} $bargs($index)
	$xf(editbutton) flash
	set be(editedi) 1
    }

    proc PutButton {} {
	global beparent bindex xf be bargs bcomm 
	incr xf(editmode)
	. config -cursor cross 
	$beparent.menu.msg config -text "Where You want to PUT it ?!?"\
		-fg "#a00000" -width 400 -anchor center -justify center
	button $beparent.menu.cb -text Cancel -bg #ffacac -padx 1 -pady 1 \
		-command {
	    incr xf(editmode) -1 
	    set tmp $xf(editbutton)
	    set xf(editbutton) ""
	    set xf(editbutton) $tmp
	}
	pack $beparent.menu.msg -side left
	pack $beparent.menu.cb -side right -ipadx 0 -ipady 0 -padx 0 -pady 0
	tkwait variable xf(editbutton)
	pack forget $beparent.menu.msg
	if {$xf(editmode) > 1} {
	    regexp {(left|right)} $xf(editbutton) newside
	    regsub {(left|right)} $be(cmd) $newside be(cmd)
 
	    ApplyProc $bindex
	    incr xf(editmode) -1
	}
	catch "destroy $beparent.menu.cb"
	SetArrowPointer .
    }

    proc UndoProc {} {
	global beparent bindex xf be bargs bcomm
	focus $xf(editbutton)
	set bargs($bindex) $be(undoargs)
	set bcomm($bindex) $be(undocomm)
	eval {$xf(editbutton) config} $bargs($bindex)
	$xf(editbutton) invoke
    }
    
    proc ChEditMode {} {
	global be beparent
	if {$be(editmode) == "Advanced..."} {
	    set be(editmode) "Normal..."
	    pack $beparent.adv -side top -fill both
	    
	} {
	    set be(editmode) "Advanced..."
	    pack forget $beparent.adv
	}
    }
    
    proc SetButtonStyle { opt val} {
	global be beparent
	set a [regsub {-all} {--} -borderwidth $be(style) -bd tmp2]
	set a [regsub {-all} {--} -foreground $tmp2 -fg tmp2]
	set a [regsub {-all} {--} -background $tmp2 -bg tmp2]
	set be(style) $tmp2
	if {$opt == ""} {return 0}
	set pos [lsearch $be(style) $opt]
	set tmp $be(style)
	if {$pos < 0 } {
	    set be(style) [append tmp " $opt $val "] 
	} {
	    set be(style) [lreplace $tmp $pos [expr {$pos + 1}] $opt $val]
	}
	if [catch {eval {$beparent.entframe.up.3.button config} $be(style)}] {
	    if {[focus] == "$beparent.entframe.up.1.txtentry"} {
		SetButtonStyle -text {}
	    } {
		puts stderr "Error in but.args!"
	    }
	}
    }
    
    proc ChColor {} {
	global be beparent
	set color [format "#%02x%02x%02x" $be(red) $be(green) $be(blue)] 
	SetButtonStyle $be(colormode) $color
	$beparent.adv.1.1.cf  config -bg $color
    }
    
    proc SetScale {} {
	global beparent be
	set color [$beparent.entframe.up.3.button cget $be(colormode)]
	$beparent.adv.1.1.cf  config -bg $color
	if {[string range $color 0 0] != "#"} {
	    set tmpcol [winfo rgb $beparent $color]
	    set be(red) [expr round([lindex $tmpcol 0])]
	    set be(green) [expr round([lindex $tmpcol 1])]
	    set be(blue) [expr round([lindex $tmpcol 2])]
	} {
	    set red [string range $color 1 2]
	    set green [string range $color 3 4]
	    set blue [string range $color 5 6]
	    set be(red) [format %d "0x$red"]
	    set be(green) [format %d "0x$green"]
	    set be(blue) [format %d "0x$blue"]
	}
    }
    
    proc PrintCmdLine {} {
	global be
	set comm "\[list $be(cmd) $be(cmdarg) $be(bg)\]"
	set barg $be(style)
	puts "COMM: $comm \nBARGS: $barg"
    }
    
    proc ButtonSave {} {
	global be bcomm bargs xf xf(actionbuttons_file)
	set idx 0
	MakeSaveDir
	set xf(actionbuttons_file) "$xf(user_home)[file tail $xf(actionbuttons_file)]"
	set out [open $xf(actionbuttons_file) w] 
	while {[info exists bcomm($idx)] && [info exists bargs($idx)]} {
	    puts $out "set bargs($idx) \{$bargs($idx)\}"
	    puts $out "set bcomm($idx) \[list $bcomm($idx)\]"
	    incr idx
	}
	close $out
        .button_edit.bottom.save flash
	set be(editedi) 0
    }
    
    proc WriteHelp {} {
	global xf
	set tl [toplevel .write_help -height 150 -width 100]
	wm geometry $tl +100+100
	wm title $tl "X-Files Button Help"
	frame $tl.tf
	entry $tl.tf.entry -textvariable hl 
	pack $tl.tf.entry -side top -fill x
	text $tl.tf.text -width 40 -height 10
	frame $tl.bf
	button $tl.bf.ok -text Ok -command {WriteHelp_OK ; destroy .write_help}
	button $tl.bf.cancel -text Cancel -command {destroy .write_help}
	pack $tl.tf -side top
	pack $tl.bf -side bottom -fill x -expand true
	pack $tl.bf.ok -side left
	pack $tl.bf.cancel -side right
	pack $tl.tf.text -side top
	set eb $xf(editbutton)
	$tl.tf.entry delete 0 end  
	$tl.tf.text delete 0.0 end 
	if {[info exists xf(Help$eb)] == 1} {
	    set hl [lindex $xf(Help$eb) 0]
	    $tl.tf.entry insert 0 $hl
	    $tl.tf.entry icursor end
	    update idletasks
	    set temp [lreplace $xf(Help$eb) 0 0 ]
	    foreach line $temp {
		$tl.tf.text insert end "$line\n"
	    }
	}
	
	proc WriteHelp_OK {} {
	    global xf tl hline hl
	    set hbl ""
	    set eb $xf(editbutton)
	    set xf(Help$eb) ""
	    lappend xf(Help$eb) $hl
	    lappend xf(Help$eb) [split [string trim [.write_help.tf.text get 0.0 end]] \n] 
	    for {set i 0} {$i < 16} {incr i 2} {
		for {set j 0} {$j < 6} {incr j} {
		    set tleft ".xfleft.bf($i).b($j)"
		    if {[info exists xf(Help$tleft)] == 1} {
			set hbl [linsert $hbl end "$tleft"] 
		    }
		    set tright ".xfright.bf([expr $i + 1]).b($j)"
		    if {[info exists xf(Help$tright)] == 1} {
			set hbl [linsert $hbl end "$tright"]   
		    }
		}
	    }
	    MakeSaveDir
	    set xf(user_pophelp_file) "$xf(user_home)[file tail $xf(user_pophelp_file)]"
	    set out [open $xf(user_pophelp_file) w]
	    foreach b $hbl {
		puts $out "set xf(Help$b) \[list $xf(Help$b)\]"
	    }
	    close $out
	}
    }
}
proc BE_Hack {cmd {entry ""} {bg ""}}  {
    global be

    if {[string compare "pack" $entry] == 0} {
        pack .button_edit.entframe.up.2.cmdentry -side bottom
    } {
        pack forget .button_edit.entframe.up.2.cmdentry
    }
    if {[string compare "pack" $bg] == 0} {
        pack .button_edit.entframe.up.2.bg -side top
    } {
        pack forget .button_edit.entframe.up.2.bg
    }
    set be(cmd) $cmd
    set be(cmdarg) ""
}
proc ExtEditor {} {
    global xf ea ee 
    
    if [winfo exists .ext_edit] {
	raise .ext_edit
	return
    }
    set ee(top) [toplevel .ext_edit -bd 2]
    wm geometry $ee(top) +100+100
    wm resizable $ee(top) 0 0
    wm title $ee(top) "Extension Editor"

    frame $ee(top).top -relief groove -bd 3
    frame $ee(top).top.dummy
    frame $ee(top).top.dummy.1 
    frame $ee(top).top.dummy.1.radio 
    frame $ee(top).top.dummy.2
    frame $ee(top).top.dummy.line
    frame $ee(top).top.dummy.check 
    frame $ee(top).middle
    frame $ee(top).lists
    frame $ee(top).buttons -relief groove -bd 3
    frame $ee(top).buttons.dummy

    label $ee(top).top.dummy.1.l -text "Extension:"
    entry $ee(top).top.dummy.1.e -textvariable ea(ext) -width 12
    pack $ee(top).top.dummy.1.l -side left
    pack $ee(top).top.dummy.1.e -side left 
    radiobutton $ee(top).top.dummy.1.radio.l -text "Left mousebutton" \
	    -variable ea(button) -value "L"  -selectcolor palevioletred1 \
	    -bd 2 -relief ridge
    radiobutton $ee(top).top.dummy.1.radio.m -text "Middle mousebutton" \
	    -variable ea(button) -value "M"  -selectcolor palevioletred1 \
	    -bd 2 -relief ridge
    pack $ee(top).top.dummy.1.radio.l $ee(top).top.dummy.1.radio.m -side left
    pack $ee(top).top.dummy.1.radio -side right -anchor c
    pack $ee(top).top.dummy.1 -side top -fill x

    label $ee(top).top.dummy.2.l -text "Command:"
    set ea(cmdtxt) "Execute"
    menubutton $ee(top).top.dummy.2.mb -textvariable ea(cmdtxt) -menu $ee(top).top.dummy.2.mb.menu \
	    -width 9 -relief raised -indicatoron true
    set cm [menu $ee(top).top.dummy.2.mb.menu -tearoff 1]
    $cm add radio -label Execute -variable ea(cmdtxt) -value Execute
    $cm add radio -label VirtualZip -variable ea(cmdtxt) -value VirtualZip
    $cm add radio -label VirtualTar -variable ea(cmdtxt) -value VirtualTar
    entry $ee(top).top.dummy.2.e -textvariable ea(cmd)
    pack $ee(top).top.dummy.2.l -side left
    pack $ee(top).top.dummy.2.mb -side left
    pack $ee(top).top.dummy.2.e -side left -fill x -expand true
    pack $ee(top).top.dummy.2 -side top -fill x -pady 2

    pack $ee(top).top.dummy.line -side top -fill x -expand true -pady 5

    checkbutton $ee(top).top.dummy.check.c -text "Confirm" -variable ea(c) \
	-bd 2 -relief ridge -selectcolor palevioletred1 -width 13 -anchor w
    checkbutton $ee(top).top.dummy.check.d -text "Dialog" -variable ea(d) \
	-bd 2 -relief ridge -selectcolor palevioletred1 -width 13 -anchor w
    checkbutton $ee(top).top.dummy.check.w -text "OutputWin" -variable ea(w) \
	    -bd 2 -relief ridge -selectcolor palevioletred1 \
	    -width 13 -anchor w
    checkbutton $ee(top).top.dummy.check.u -text "Update" -variable ea(u) \
	-bd 2 -relief ridge -selectcolor palevioletred1 -width 13 -anchor w
    pack $ee(top).top.dummy.check.c $ee(top).top.dummy.check.d $ee(top).top.dummy.check.w \
	    $ee(top).top.dummy.check.u -side left -fill x -expand true
    pack $ee(top).top.dummy.check -side top -fill x -expand true
    pack $ee(top).top.dummy -side top -padx 10 -pady 5
    pack $ee(top).top -side top
    
    label $ee(top).middle.e -text "Ext" -width 10 -anchor center
    label $ee(top).middle.m -text "Button" -width 6 -anchor w
    label $ee(top).middle.c -text "Command" -width 9 -anchor w
    label $ee(top).middle.o -text "Opts" -width 6 -anchor w
    pack $ee(top).middle.e $ee(top).middle.m $ee(top).middle.c -side left
    pack $ee(top).middle.o -side right
    pack $ee(top).middle -side top -fill x -expand true
    
    button $ee(top).buttons.dummy.new -text "New" -width 6 -command EE_New
    button $ee(top).buttons.dummy.rm -text "Remove" -width 6 -command EE_Remove \
	    -cursor pirate
    button $ee(top).buttons.dummy.save -text "Save" -width 6 -command EE_Save
    button $ee(top).buttons.dummy.close -text "Close" -width 6 -command EE_Exit
    pack $ee(top).buttons.dummy.new $ee(top).buttons.dummy.rm $ee(top).buttons.dummy.save -side left
    pack $ee(top).buttons.dummy.close -side right 
    pack $ee(top).buttons.dummy -side top -fill x -padx 10 -pady 5
    pack $ee(top).buttons -side bottom -fill x

    scrollbar $ee(top).lists.s -orient vertical \
	    -command [list EE_Yview [list $ee(top).lists.ext $ee(top).lists.mb \
	    $ee(top).lists.cmd $ee(top).lists.opts]]
    listbox $ee(top).lists.ext -yscrollcommand [list $ee(top).lists.s set] -width 6 -exportselection false -selectbackground #dfdfaf -selectborderwidth 1
    listbox $ee(top).lists.mb -yscrollcommand [list $ee(top).lists.s set] -width 5 -exportselection false -selectbackground #dfdfaf -selectborderwidth 1
    listbox $ee(top).lists.cmd -yscrollcommand [list $ee(top).lists.s set] -selectbackground #dfdfaf -selectborderwidth 1
    listbox $ee(top).lists.opts -yscrollcommand [list $ee(top).lists.s set] -width 6 -exportselection false -selectbackground #dfdfaf -selectborderwidth 1
    pack $ee(top).lists.s -side left -fill y
    pack $ee(top).lists.ext $ee(top).lists.mb -side left -fill y
    pack $ee(top).lists.cmd -side left -fill both -expand true
    pack $ee(top).lists.opts -side left -fill y
    pack $ee(top).lists -side bottom -fill both -expand true

    foreach l [list $ee(top).lists.ext $ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts] {
	bind $l <B2-Motion> [list EE_Dragto %x %y $ee(top).lists.ext \
		$ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts]
	bind $l <Button-2> [list EE_Mark %x %y $ee(top).lists.ext \
		$ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts]
	bind $l <Button-1> [list EE_Select %y $ee(top).lists.ext \
		$ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts]
	bind $l <B1-Motion> [list EE_Select %y $ee(top).lists.ext \
		$ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts]
	bind $l <ButtonRelease-1> {break}
	bind $l <ButtonRelease-2> {break}
	bind $l <Shift-B1-Motion> {break}
	bind $l <Shift-Button-1>  {break}
	bind $l <Button-3> {break}
	bind $l <Double-Button-1> {break}
	bind $l <Enter> {break}
	bind $l <KeyPress> {break}
    }
    bind $ee(top).top.dummy.1.e <Return> {focus $ee(top).top.dummy.2.e}
    bind $ee(top).top.dummy.2.e <Return> {focus $ee(top)}
    bind $ee(top) <Control-c> EE_Exit
    bind $ee(top) <Escape> EE_Exit

    EE_Display 1 $xf(extensions_file)
    trace variable ea w EE_Update
    
    EE_Select 0 $ee(top).lists.ext $ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts
    
}
proc EE_Exit {} {
    global ee ea xf

    if [info exists ee(changed)] {
	if $ee(changed) {
            set ret [AskWin "You have made changes! Close the editor without saving?" -50 -50 "Save"]
	    switch $ret {
                0 {return}
		2 {
                    EE_Save
                }
		default {uplevel #0 {source $xf(extensions_file)}}
            }
        }
    }
    trace vdelete ea w EE_Update
    destroy $ee(top)
    unset ee
    unset ea
}

proc EE_Update {var index op} {
    global ea ee count

    set ee(changed) 1
    trace vdelete ea w EE_Update
    set ind [$ee(top).lists.ext curselection]
    if $ea(c) {
	set c "C"
    } {
	set c ""
    }
    if $ea(d) {
	set d "D"
    } {
	set d ""
    }
    if $ea(w) {
	set w "W"
    } {
	set w ""
    }
    if $ea(u) {
	set u "U"
    } {
	set u ""
    }

    switch $index {
	c -
	d -
	w -
	u {set ee(opts) [lreplace $ee(opts) $ind $ind [format "%s%s%s%s" $c $d $w $u]]}
	cmdtxt {
	    if ![string match $ea(cmdtxt) [lindex $ee(cmdtxt) $ind]] {
		switch $ea(cmdtxt) {
		    "Execute" {
                        set ee(cmd) [lreplace $ee(cmd) $ind $ind {}]
                        set ea(cmd) {}
                        focus $ee(top).top.dummy.2.e
                    }
		    "VirtualZip" {
                        set ee(cmd) [lreplace $ee(cmd) $ind $ind "VirtualZip %f"]
                        set ea(cmd) "%f"
                    }
		    "VirtualTar" {
                        set ee(cmd) [lreplace $ee(cmd) $ind $ind "VirtualTar %f"]
                        set ea(cmd) "%f"
                    }
		}
		set ee(cmdtxt) [lreplace $ee(cmdtxt) $ind $ind $ea(cmdtxt)]
	    }
	}
	cmd {
	    set ea(cmd) [string trimright $ea(cmd) "&"]
	    switch $ea(cmdtxt) {
		"Execute" {set ee(cmd) [lreplace $ee(cmd) $ind $ind $ea(cmd)]}
		"VirtualZip" {
                    set ea(cmd) "%f"
                    set ee(cmd) [lreplace $ee(cmd) $ind $ind \
			[format "%s %s" "VirtualZip" $ea(cmd)]]
                }
		"VirtualTar" {
                    set ea(cmd) "%f"
                    set ee(cmd) [lreplace $ee(cmd) $ind $ind \
			[format "%s %s" "VirtualTar" $ea(cmd)]]
                }
	    }
	}
	default {
	    set ee($index) [lreplace $ee($index) $ind $ind $ea($index)]
	}
    }
    switch $index {
	button -
	ext {
	    if {[string compare $ea(button) {}] && [string compare $ea(ext) {}]} {
		for {set i 0} {$i < [llength [$ee(top).lists.ext get 0 end]]} {incr i} {
		    set extmb  [format "%s%s" [string trimleft [lindex $ee(ext) $i] .] \
			    [lindex $ee(button) $i]]
		    lappend list $extmb
		}

		if {[set dp [lsearch -exact [lreplace $list $ind $ind] \
			[lindex $list $ind]]] >= 0} {
		    foreach l [list ext mb opts cmd] {
			$ee(top).lists.$l select clear 0 end
			$ee(top).lists.$l yview $dp
			$ee(top).lists.$l select anchor $dp
			$ee(top).lists.$l select set anchor $dp
		    }
		    set resp [AskWin "Overwrite the already existing combination ?"]
		    if {$resp == 1} {
			set ee(ext) [lreplace $ee(ext) $dp $dp $ea(ext)]
			set ee(button) [lreplace $ee(button) $dp $dp $ea(button)]
			set ee(cmdtxt) [lreplace $ee(cmdtxt) $dp $dp $ea(cmdtxt)]
			set ee(cmd) [lreplace $ee(cmd) $dp $dp $ea(cmd)]
			set ee(opts) [lreplace $ee(opts) $dp $dp \
				[format "%s%s%s%s" $c $d $w $u]]
			set ee(ext) [lreplace $ee(ext) $ind $ind]
			set ee(button) [lreplace $ee(button) $ind $ind]
			set ee(cmdtxt) [lreplace $ee(cmdtxt) $ind $ind]
			set ee(cmd) [lreplace $ee(cmd) $ind $ind]
			set ee(opts) [lreplace $ee(opts) $ind $ind]
			set ind $dp
			focus $ee(top).top.dummy.2.e
		    } {
			set ea(ext) {}
			set ea(button) {}
			set ee(ext) [lreplace $ee(ext) $ind $ind {}]
			set ee(button) [lreplace $ee(button) $ind $ind {}]
			focus $ee(top).top.dummy.1.e
		    }
		} {
		    set this [lindex $list $ind]
		    set list [lsort $list]
		    set nind [lsearch -exact $list $this]
		    if {$nind != $ind} {
			set ee(ext) [lreplace $ee(ext) $ind $ind]
			set ee(button) [lreplace $ee(button) $ind $ind]
			set ee(cmdtxt) [lreplace $ee(cmdtxt) $ind $ind]
			set ee(cmd) [lreplace $ee(cmd) $ind $ind]
			set ee(opts) [lreplace $ee(opts) $ind $ind]
			set ee(ext) [linsert $ee(ext) $nind $ea(ext)]
			set ee(button) [linsert $ee(button) $nind $ea(button)]
			set ee(cmdtxt) [linsert $ee(cmdtxt) $nind $ea(cmdtxt)]
			set ee(cmd) [linsert $ee(cmd) $nind $ea(cmd)]
			set ee(opts) [linsert $ee(opts) $nind [format "%s%s%s%s" $c $d $w $u]]
			set ind $nind
		    }
		}
	    }
	}
    }
    

    foreach l [list ext mb opts cmd] {
	$ee(top).lists.$l delete 0 end
    }

    for {set a 0} {$a < $count} {incr a} {
	$ee(top).lists.ext insert end [lindex $ee(ext) $a]
	$ee(top).lists.mb insert end [lindex $ee(button) $a]
	$ee(top).lists.opts insert end [lindex $ee(opts) $a]
	$ee(top).lists.cmd insert end [lindex $ee(cmd) $a]
    }
    foreach l [list ext mb opts cmd] {
	$ee(top).lists.$l see $ind
	$ee(top).lists.$l select anchor $ind
	$ee(top).lists.$l select set anchor $ind
    }
    trace variable ea w EE_Update

}

proc EE_Display {{open {}} {dotfile {}}} {
    global ee count

    if $open {    
	if [catch {
	    source $dotfile
	} err] {
	    MessageBox "Opening $dotfile failed: $err" 
	}
    }
    set extlist [lsort $extlist]

    set n 0
    foreach z $extlist {

	set pituus [expr [string length $z]-1]
	lappend ee(button) [string index $z $pituus]
	lappend ee(ext) [string range $z 0 [expr $pituus-1]]
	set opts [lindex [set $z] 0]
	if [string match $opts "N"] {
	    lappend ee(opts) {}
	} {
	    lappend ee(opts) $opts
	}

	switch [lindex [set $z] 1] {
	    "exec" {
		lappend ee(cmdtxt) "Execute"
		lappend ee(cmd) [string trimright [lrange [set $z] 2 end] &]
	    }
	    "VirtualZip" {
		lappend ee(cmdtxt) "VirtualZip"
		lappend ee(cmd) [string trimright [lrange [set $z] 1 2] &]
	    }
	    "VirtualTar" {
		lappend ee(cmdtxt) "VirtualTar"
		lappend ee(cmd) [string trimright [lrange [set $z] 1 2] &]
	    }
	}

	$ee(top).lists.ext insert end [lindex $ee(ext) $n]
	$ee(top).lists.mb insert end [lindex $ee(button) $n]
	$ee(top).lists.opts insert end [lindex $ee(opts) $n]
	$ee(top).lists.cmd insert end [lindex $ee(cmd) $n]
	incr n
    }
    set count $n
    unset extlist

}
proc EE_Dragto { x y args } {
    foreach w $args {
	$w scan dragto $x $y
    }
}
proc EE_Mark { x y args } {
    foreach w $args {
	$w scan mark $x $y
    }
}
proc EE_Yview { lists args } {
    foreach l $lists {
	eval {$l yview} $args
    }
}

proc EE_Select { y args } {
    global ee ea

    set ee(%y) $y
    foreach w $args {
	$w select clear 0 end
	$w select anchor [$w nearest $y]
	$w select set anchor [$w nearest $y]
    }
    set extl [lindex $args 0]
    set mbl [lindex $args 1]
    set cmdl [lindex $args 2]
    set optsl [lindex $args 3]
    set ind [$extl curselection]

    trace vdelete ea w EE_Update
    set ea(c) [string match *C* [lindex $ee(opts) $ind]]
    set ea(d) [string match *D* [lindex $ee(opts) $ind]]
    set ea(w) [string match *W* [lindex $ee(opts) $ind]]
    set ea(u) [string match *U* [lindex $ee(opts) $ind]]
    set ea(ext) [lindex $ee(ext) $ind]
    $ee(top).top.dummy.1.e icursor end
    set ea(button) [lindex $ee(button) $ind]
    set ea(cmdtxt) [lindex $ee(cmdtxt) $ind]

    switch [lindex $ee(cmdtxt) $ind] {
	"Execute" {
	    set ea(cmd) [string trimright [lindex $ee(cmd) $ind] &]
	}
	"VirtualZip" {
	    set ea(cmd) "%f"
	}
	"VirtualTar" {
	    set ea(cmd) "%f"
	}
    }
    $ee(top).top.dummy.2.e icursor end
    trace variable ea w EE_Update

}

proc EE_New {} {
    global ee ea count

    set ee(%y) [expr 10 * $count]
    set ee(changed) 1
    trace vdelete ea w EE_Update
    foreach x [list ext button opts cmd] {
	lappend ee($x) {}
	set ea($x) {}
    }
    set ea(cmdtxt) "Execute"
    lappend ee(cmdtxt) "Execute"
    incr count

    $ee(top).lists.ext insert end [lindex $ee(ext) $count]
    $ee(top).lists.mb insert end [lindex $ee(button) $count]
    $ee(top).lists.opts insert end [lindex $ee(opts) $count]
    $ee(top).lists.cmd insert end [lindex $ee(cmd) $count]

    foreach l [list ext mb opts cmd] {
	$ee(top).lists.$l yview moveto 1
	$ee(top).lists.$l select clear 0 end
	$ee(top).lists.$l select anchor $count
	$ee(top).lists.$l select set anchor $count
    }
    foreach x [list c d w u] {
	set ea($x) 0
    }
    focus $ee(top).top.dummy.1.e
    trace variable ea w EE_Update
}
proc EE_Remove {} {
    global ee count

    if {[AskWin "Are You sure ?!"] == 0} {
	return
    }
    set ee(changed) 1
    set ind [$ee(top).lists.ext curselection]
    foreach l [list ext mb opts cmd] {
	$ee(top).lists.$l delete $ind
    }
    set var [lindex $ee(ext) $ind][lindex $ee(button) $ind]
    global $var
    catch {unset $var}

    foreach x [list ext button cmd cmdtxt opts] {
	set ee($x) [lreplace $ee($x) $ind $ind]
    }
    incr count -1

    EE_Select $ee(%y) $ee(top).lists.ext $ee(top).lists.mb $ee(top).lists.cmd $ee(top).lists.opts
    
}
proc EE_Save {} {
    global ee xf

    MakeSaveDir
    set xf(extensions_file) "$xf(user_home)[file tail $xf(extensions_file)]"
    set out [open $xf(extensions_file) w]
    set  wrong 0

    for {set i 0} {$i < [llength [$ee(top).lists.ext get 0 end]]} {incr i} {

	set extmb  [format "%s%s" [string trimleft [lindex $ee(ext) $i] .] \
		[lindex $ee(button) $i]]
	if {![string match {*[LM]} $extmb] || [string match {[LM]} $extmb]} {
	    foreach l [list ext mb opts cmd] {
		$ee(top).lists.$l select clear 0 end
		$ee(top).lists.$l yview $i
		$ee(top).lists.$l select anchor $i
		$ee(top).lists.$l select set anchor $i
	    }
	    MessageBox "Not enough for input...\next+mb: $extmb"
	    close $out
	    exec rm $xf(extensions_file)
	    return
	}
	lappend list $extmb
	
	switch [lindex $ee(cmdtxt) $i] {
	    "Execute" {
		set cmdtxt " exec"
		if ![string match *W* [lindex $ee(opts) $i]] {
		    set bg " &"
		} {
		    set bg ""
		}
	    }
	    "VirtualZip" {set cmdtxt ""; set bg " %s"}
	    "VirtualTar" {set cmdtxt ""; set bg " %s"}    
	}
	set cmd [string trimright [lindex $ee(cmd) $i] " &"]
	if [string match [$ee(top).lists.opts get $i] ""] {
	    set opts "N"
	} {
	    set opts [lindex $ee(opts) $i]
	    if {[string match *%o1* $cmd] && ![string match *D* $opts]} {
		if [string match C* $opts] {
		    set opts CD[string trimleft $opts C]
		} {
		    set opts D$opts]
		}
	    }
	}
	set line [format "%s %s %s%s %s%s %s%s%s" "set" "$extmb" "\[" "list" \
		"$opts" "$cmdtxt" "$cmd" "$bg" "\]"]
	puts $out $line
    }
    puts $out ""
    puts $out [format "%s %s %s%s %s%s" "set" "extlist" "\[" "list" [lsort $list] "\]"]
    puts $out ""

    close $out
    set ee(changed) 0
    uplevel #0 {source $xf(extensions_file)}

    $ee(top).buttons.dummy.save flash

}
proc OutputWindow { txt {file ""}} {
    global xf
    
    incr xf(outwin_num)
    set n $xf(outwin_num)
    set w .$xf(outwin_num)
    set  xf(outwin_tagcol$n) "Yellow"
    catch {destroy $w}
    toplevel $w
    wm title $w "X-Files <Output Window: \#$xf(outwin_num)>"
    wm iconname $w "XF-OutWin"
    frame $w.buttons -relief sunken  -bd 2
    pack  $w.buttons -side bottom -fill x -pady 2
    button $w.buttons.close -text Close -command "destroy $w ;\
	    unset xf(outwin_search$n)"
    button $w.buttons.save -text "SaveToFile" \
	-command "SaveToFileProc $xf(outwin_num) [pwd] $file" 

    pack $w.buttons.save -side left -fill x -padx 10
 
    pack $w.buttons.close -side right -fill x -padx 10
    
    frame $w.tx
    text $w.tx.text -relief sunken -bd 2 -yscrollcommand "$w.tx.scroll set"\
	    -setgrid 1 -height 30
    scrollbar $w.tx.scroll -command "$w.tx.text yview"
    pack $w.tx.scroll -side right -fill y
    pack $w.tx.text -expand yes -fill both -side left
 
    $w.tx.text insert 0.0 $txt
    $w.tx.text tag configure "Yellow$n" -relief raised -borderwidth 1\
	    -background "#ffffaf"

    $w.tx.text tag configure "Red$n" -relief raised -borderwidth 1\
	    -background "#ffbfbf"
    
    $w.tx.text tag configure "Green$n" -relief raised -borderwidth 1\
	    -background "#bfffbf"
    
    $w.tx.text tag configure "Blue$n" -relief raised -borderwidth 1\
	    -background "#dfdfff"
    
    frame $w.entry -relief groove -bd 3
    label $w.entry.lab -text "Search string:"
    label $w.entry.co -fg #992222 -text ""
    entry $w.entry.e -textvariable xf(outwin_search$n) -width 14

    button $w.entry.search -text "Search" -bd 1\
	    -command "SearchProc2 $w" -pady 1 

    button $w.entry.searchall -text "SearchAll" -bd 1\
	    -command "SearchProc $w" -pady 1

    button $w.entry.ct -text "Clear" -bd 1 -command {\
	    set n $xf(outwin_num);
	    eval {.$xf(outwin_num).tx.text tag\
	    remove $xf(outwin_tagcol$n)$n 1.0 end}} -pady 1

    menubutton $w.entry.tc -textvariable xf(outwin_tagcol$n)\
	    -menu $w.entry.tc.menu -relief raised -bd 1 -bg "#ffffaf"\
	    -pady 1 -activebackground #ffffdf -indicatoron true
    set m [menu $w.entry.tc.menu -tearoff 1]
    $m add radio -label "Yellow" -variable xf(outwin_tagcol$n) -command\
	    "$w.entry.tc config -bg #ffffaf -activebackground #ffffdf"\
	    -activebackground "#ffffbf"
    $m add radio -label "Red" -variable xf(outwin_tagcol$n) -command\
	    "$w.entry.tc config -bg #ffbfbf -activebackground #ffdfdf"\
	    -activebackground "#ffcfcf"
    $m add radio -label "Green" -variable xf(outwin_tagcol$n) -command\
	    "$w.entry.tc config -bg #bfffbf -activebackground #dfffdf"\
	    -activebackground "#cfffcf"
    $m add radio -label "Blue" -variable xf(outwin_tagcol$n) -command\
	    "$w.entry.tc config -bg #dfdfff -activebackground #efefff"\
	    -activebackground "#cfcfff"
    pack $w.entry.lab -side left -padx 10
    pack $w.entry.e -side left -padx 0
    pack $w.entry.search -side left -fill x -padx 3\
	    -pady 0
    pack $w.entry.searchall -side left -fill x -padx 3\
	    -pady 0
    pack $w.entry.co -side left 
    pack $w.entry.ct -side right -fill x -padx 10 -pady 0
    pack $w.entry.tc -side right -fill x -padx 0 -pady 0
    



    pack $w.entry -fill both -side bottom
    pack $w.tx -side bottom -fill both -expand true
    
    bind $w.entry.e <Return> "SearchProc2 $w"
    bind $w <Control-s> "SearchProc2 $w"
    bind $w <Up> {catch {FixFocus %W};break}
    bind $w <Down> {catch {FixFocus %W};break}
    bind $w <Next> {catch {FixFocus %W};break}
    bind $w <Prior> {catch {FixFocus %W};break}

    proc FixFocus { w } {

	regexp {^.*([0-9])} $w b
	catch {focus $b.tx.text}
    }

    proc SaveToFileProc {num dir {f ""}} {

	if [winfo exists .fs] {
	    MessageBox "Cannot open more than one FileSelector !"
	    return
	}
	global xf
	set fname [FS $dir save $f]
	if {$fname == ""} {
	    return 0
	}
	if {![winfo exists .$num]} {
	    MessageBox "Can't save the file! Output Window\#$num don't exists any\
		    more !"
	    return -1
	} {
	    set stxt [.$num.tx.text get 0.0 end]
	    set sfileid [open $fname w 0600]
	    puts $sfileid $stxt
	    close $sfileid
	    UpdateListbox xf "right"
	    UpdateListbox xf "left"
	}
    }

    proc SearchProc {w} {
	global xf
	$w.entry.co config -text ""
	set n $xf(outwin_num)
	set i [string length $xf(outwin_search$n)]
	set tagcol $xf(outwin_tagcol$n)
	if {$xf(outwin_search$n) != ""} {
	    SetWaitPointer $w
	    SetWaitPointer $w.entry.e
	    set pos 1.0
	    set i 0
	    while 1 {
		set pos [$w.tx.text search -count length $xf(outwin_search$n) $pos end]
		if {$pos == ""} {
		    if {$i == 0} { 
			SetArrowPointer $w
			$w.entry.e config -cursor xterm
			MessageBox "String not found!"
			return
		    } 
		    break
		}
		$w.tx.text tag add "$tagcol$n" $pos "$pos + $length char"
		set pos [$w.tx.text index "$pos + $length char"]
		incr i
	    }
	    SetArrowPointer $w
	    $w.entry.e config -cursor xterm
	    $w.entry.co config -text "Found: $i"
	}
    }




    proc SearchProc2 {w} {
	global xf
	$w.entry.co config -text ""
	set n $xf(outwin_num)
	set i [string length $xf(outwin_search$n)]
	set tagcol $xf(outwin_tagcol$n)
	if {$xf(outwin_search$n) != ""} {
	    SetWaitPointer $w
	    SetWaitPointer $w.entry.e
	    set pos [$w.tx.text search $xf(outwin_search$n) insert]
	    
	    if {$pos != ""} {
		$w.tx.text mark set nemo $pos
		$w.tx.text see $pos
		tkTextSetCursor $w.tx.text "nemo + $i chars"
		$w.tx.text tag add  "$tagcol$n"  "insert - $i chars"\
			"nemo + $i chars"
		$w.tx.text mark unset nemo
		raise $w
		SetArrowPointer $w
		$w.entry.e config -cursor xterm
	    } {
		SetArrowPointer $w
		$w.entry.e config -cursor xterm
		MessageBox "String not found!"
	    }
	}
    }
    tkTextSetCursor $w.tx.text 0.0
    focus $w.buttons.close

}
proc FS { defdir mode {file ""}} {
    global filesel xf
    set filesel(result) {}
    set filesel(dir) $defdir
    set filesel(mode) $mode
    set filesel(file) $file
    if {$mode == "load"} {
	set filesel(modtxt) "Load File"
	set filesel(mc) "#c0c0e0"
    } {
	set filesel(modtxt) "Save File"
	set filesel(mc) "#e0c0c0"
    }
    set fs [toplevel .fs -borderwidth 5]
    wm geometry $fs +300+200
    wm title $fs FileSelector
    set topimage [image create bitmap -data "#define top_width 16
    #define top_height 16
    #define top_x_hot 8
    #define top_y_hot 5
    static unsigned char top_bits[] = {
	0xfe, 0xff, 0xfe, 0xff, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f,
	0xf8, 0x3f, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};"]

    set bottomimage [image create bitmap -data "#define bottom_width 16
	#define bottom_height 16
	#define bottom_x_hot 8
	#define bottom_y_hot 10
	static unsigned char bottom_bits[] = {
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x07, 0xc0, 0x07,
	    0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xf8, 0x3f, 0xf0, 0x1f, 0xe0, 0x0f,
	    0xc0, 0x07, 0x80, 0x03, 0xfe, 0xff, 0xfe, 0xff};"]
	    
    frame $fs.buttons -relief groove -bd 2 
    frame $fs.top
    frame $fs.lbframe
    label $fs.label -text $filesel(modtxt) -relief sunken -bd 0 -bg $filesel(mc)
    pack $fs.label -fill x
    frame $fs.top.pf
    label $fs.top.pf.lab -text "Path: "
    label $fs.top.pf.pathlabel -textvariable filesel(dir)
    frame $fs.top.ef
    label $fs.top.ef.lab -text "File: "
    entry $fs.top.ef.entry -textvariable filesel(file)
    pack $fs.top.ef.lab -side left -fill x
    pack $fs.top.ef.entry -side left -fill x -expand true
    $fs.top.ef.entry xview moveto 1
    $fs.top.ef.entry icursor end
    pack $fs.top.pf.lab -side left -fill x
    pack $fs.top.pf.pathlabel -side left -fill x
    pack $fs.top.pf -fill x
    pack $fs.top.ef -fill x 
    pack $fs.top -fill x
    frame $fs.lbframe.sb
    listbox $fs.lbframe.lb -yscrollcommand [list $fs.lbframe.sb.sy set]\
	    -width 30 -height 7 -selectmode browse -selectbackground #dfdfaf\
	    -selectborderwidth 2 -selectforeground #101000 -bg #cccccc \
	    -setgrid true -exportselection false
    scrollbar $fs.lbframe.sb.sy -orient vertical\
	    -command [list $fs.lbframe.lb yview]
    button $fs.lbframe.sb.t -image $topimage -padx 0 -pady 0\
	    -command {.fs.lbframe.lb yview 0} -bd 1
    button $fs.lbframe.sb.b -image $bottomimage -padx 0 -pady 0\
	    -command {.fs.lbframe.lb yview end} -bd 1
    pack $fs.lbframe.sb.t -side top -fill x
    pack $fs.lbframe.sb.sy -side top -fill y -expand true
    pack $fs.lbframe.sb.b -side top -fill x
    pack $fs.lbframe.sb -side right -fill y
    pack $fs.lbframe.lb -side left -expand true -fill both
    frame $fs.buttons.ok -relief sunken -bd 1 
    button $fs.buttons.ok.b -text OK!  -command {FS_ok_button}
    pack $fs.buttons.ok.b -padx 0 -pady 1
    button $fs.buttons.cancel -text Cancel -command {set filesel(result) {}}
    pack $fs.buttons.cancel -side right -pady 5 -padx 5
    pack $fs.buttons.ok -side left -pady 5 -padx 5
    pack $fs.buttons -side bottom -fill x
    pack $fs.lbframe -side top -expand true -fill both
  
    bind .fs <KeyPress> {
	focus .fs.top.ef.entry
	if {$filesel(file) == "" } {
	    if {%k != 107} {
		if {%k != 22} {
		    if {%k != 36} { 
			if {%k != 108} {
			    set filesel(file) %A
			}
		    }
		}  
	    }
	}
    }
    bind .fs.top.ef.entry <Return> {catch  {FS_ok_button}}
    bind .fs.lbframe.lb <Return> {catch {FS_ok2}}
    bind .fs <Escape> {focus .fs.top.ef.entry}
    bind .fs.lbframe.lb <Button-1> {
	tkListboxBeginSelect %W [%W index @%x,%y]
	FS_Sel %y
	break
    }
    bind .fs.lbframe.lb <ButtonRelease-1> {break}
    bind .fs.lbframe.lb <B1-Motion> {
	tkListboxBeginSelect %W [%W index @%x,%y]
	FS_Sel %y
	break
    }
    #bind .fs.lbframe.lb <Button-2> {FS_ok %y;break}
    bind .fs.lbframe.lb <Button-2> {break}
    bind .fs.lbframe.lb <ButtonRelease-2> {break}
    bind .fs.lbframe.lb  <Double-Button-1> { FS_ok %y; break}
    bind .fs <Prior> {focus .fs.lbframe.lb } 
    bind .fs <Next> {focus .fs.lbframe.lb }
    bind .fs <Up> {focus .fs.lbframe.lb }
    bind .fs <Down> {focus .fs.lbframe.lb }
    bind .fs <Home> {focus .fs.lbframe.lb }
    bind .fs <End> {focus .fs.lbframe.lb }
    bind .fs <Control-c> {set filesel(result) {}}
    
    proc FS_List { dir } {
	global filesel
	set files [glob -nocomplain $dir/{.*,*}]
	.fs.lbframe.lb delete 0 end
	set dirs {}
	set others {}
	foreach f [lsort $files] {
	    if [file isdirectory $f] then {
		if {[file tail $f] != "."} then {
		    if {$dir != "/"} then {
			lappend dirs [file tail $f]/
		    } {
			if {[file tail $f] != ".."} {
			    lappend dirs [file tail $f]/
			}
		    }	
		}	
	    } {
		lappend others [file tail $f]
	    }
	}
	set all [concat $dirs $others]
	foreach f $all {
	    .fs.lbframe.lb insert end $f
	}
	cd $dir
	set filesel(dir) [pwd]
    }
    
    proc FS_Sel { y } {
	global filesel
	set t .fs.lbframe.lb
	set sel [$t get [$t nearest $y]]
	if ![file isdirectory $sel] {
	    set filesel(file) $sel
	}
    }

    proc FS_ok { y } {
	global filesel
	set t .fs.lbframe.lb
	set sel [$t get [$t nearest $y]]
	set tmp "$filesel(dir)/$sel"
	if [file isdirectory $sel] {
	    set filesel(dir) $tmp
	    FS_List $filesel(dir)
	    #set filesel(file) ""
	    
	} {
	    if [file exists $tmp] {
		if [AskWin "File exists!\nOverwrite ?!"] {
		    set filesel(result) $tmp
		} {
		    return 0
		}
		
	    } {
		set filesel(result) $tmp
	    }
	}
    }

    proc FS_ok2 {} {
	global filesel
	set t .fs.lbframe.lb
	set sel [$t get [$t curselection]]
	set tmp "$filesel(dir)/$sel"
	if [file isdirectory $sel] {
	    set filesel(dir) $tmp
	    FS_List $filesel(dir)
	    set filesel(file) ""
	} {
	    if [file exists $tmp] {
		if [AskWin "File exists!\nOverwrite ?!"] {
		    set filesel(result) $tmp
		} {
		    return 0
		}
	    
	    } {
		set filesel(result) $tmp
	    }
	}
    }
    
    proc FS_ok_button {} {
	global filesel
	if {[string index $filesel(file) 0] == "/"} {
	    set tmp $filesel(file)
	} {
	    set tmp "$filesel(dir)/$filesel(file)"
	}
	if {$filesel(mode) == "load"} {
	    if [file exists $tmp] {
		if [file isdirectory $tmp] {
		    set filesel(dir) $tmp
		    FS_List $filesel(dir)
		    set filesel(file) ""
		} {
		    set filesel(result) "$filesel(dir)/$filesel(file)"
		}
	    } {
		set temp $filesel(dir)
		set filesel(dir) "Not Found!"
		after 1500 [list set filesel(dir) $temp] 
	    }
	} {
	    if [file isdirectory $tmp] {
		set filesel(dir) $tmp
		FS_List $filesel(dir)
		set filesel(file) ""
	    } {
		if [file exists $tmp] {
		    if [AskWin "File exists!\nOverwrite ?!"] {
			set filesel(result) $tmp
		    } {
			return 0
		    }
		} {
		    set filesel(result) $tmp
		}
	    }
	}
    }
    FS_List $filesel(dir) 
    tkwait variable filesel(result)
    destroy .fs
    return $filesel(result)
}

proc tkerror {err} {
    global xf 

    if [string match {*left*} [focus]] {
	set s "left"
    } {
	set s "right"
    }

    SetArrowPointer .
    $xf(pathEnt_$s) xview moveto 1
    $xf(pathEnt_$s) icursor end
    DefaultInfo xf $s
    set e [toplevel .er]
    set error(ok) 0
    frame $e.up -relief sunken -bd 2  -bg "#cacaca"
    wm geometry $e +[expr $xf(X) - 50]+[expr $xf(Y) - 50]
    wm title $e "X-Files Error"
    
    message $e.up.msg -text $err -aspect 400
    
    frame $e.buttons -relief raised -bd 0
    frame $e.buttons.dum -relief sunken -bd 1  
    button $e.buttons.dum.ok -text OK! -command {set error(ok) 1}
    button $e.buttons.mail -text Mail -command {ERR_Mail; .er.buttons.mail flash}
    button $e.buttons.save -text Save -command {ERR_Save; .er.buttons.save flash}
    
    pack $e.up.msg -side right -fill both -expand 1
    pack $e.up -side top -fill both -expand 1 -padx 4
    
    pack $e.buttons.dum -side left -padx 10 -pady 5
    pack $e.buttons.dum.ok -padx 4 -pady 4
    pack $e.buttons.save $e.buttons.mail -side right
    pack $e.buttons -side bottom -fill x

    focus $e.buttons.dum.ok
    tkwait visibility $e
    grab $e
    tkwait variable error(ok)
    grab release $e
    destroy .er

}    

proc ERR_Msg {{m ""}} { 
    global errorInfo xf be ee env tk_version errorCode

    set m "$m\n*****************************************************"
    catch {set m  "$m\nDATE: [exec date]"}
    set m "$m\n*****************************************************"

    set m "$m\n\nTK_ERRORMSG:"
    set m "$m\n-------------------\n"
    set m "$m\n[set errorCode]\n"
    set m "$m\n[set errorInfo]"

    set n "\nENV_VARS:"
    set n "$n\n-------------------\n"

    foreach idx [list USER USERNAME HOSTNAME TERM HOSTTYPE PATH HOME SHELL OSTYPE XF_HOME] {
	catch {set n "$n\n$idx:  $env($idx)"}
    } 
    set m "$m\n$n"

    set m "$m\n\nXF_VARS:"
    set m "$m\n-------------------\n"
    set m "$m\ntk_version:  [set tk_version]"
    foreach idx [lsort [array names xf]] {
	set m  "$m\n$idx:  $xf($idx)"
    } 
    set m "$m\n"

    set m "$m\n\nBE_VARS:"
    set m "$m\n-------------------\n"
    foreach idx [lsort [array names be]] {
	set m  "$m\n$idx:  $be($idx)"
    } 
    set m "$m\n"
    
    set m "$m\n\nEE_VARS:"
    set m "$m\n-------------------\n"
    foreach idx [lsort [array names ee]] {
	set m  "$m\n$idx:  $ee($idx)"
    } 
    set m "$m\n"
   
    return $m
}

proc ERR_Mail {} {
    set stream [open "|mail xf_adm@pinhead.tky.hut.fi" w]
    puts $stream [ERR_Msg "BUG-MAIL:"]
    close $stream

}

proc ERR_Save {} {
    global xf
    MakeSaveDir
    set fileid [open $xf(user_home)ErrorLog {WRONLY APPEND CREAT}]
    puts $fileid [ERR_Msg "BUG-SAVE:"]
    close $fileid
}


set dirpit_left 0
set dirpit_right 0

MAIN $argc $argv
