#-----------------dv-----Datenlade/Sicherungsroutinen-----------------------

#-----------------------------------------------------------------------------
# datageterr {} gibt eine Lesefehler Fehlermeldung aus
#               filename : Datei, in der Fehler auftrat 
#               line     : Zeile, in der Fehler auftrat
#-----------------------------------------------------------------------------

proc datageterr {filename line} {
   
  # aktuelle Diagrammkennung
  #
  global diagdata
  set dp $diagdata(diagram)

  # Ladeanzeige zerstoeren
  #
  destroyloadview $dp\_main.loadview

  # Fehler ausgeben
  #
  error "Bad format in file \"$filename\" at line $line"

}

#-----------------------------------------------------------------------------
# selectdata {} ruft eine Fileselectionbox auf und laedt die ausgewaehlte
#               Datei als Daten ein
#               dp   : pfad des zu ladenden diagramms
#               fpath: filepfad
#               fname: filename
#-----------------------------------------------------------------------------
#
proc selectdata {dp fpath fname } {

  # Diagramm und -Auswahlboxvariablen sichtbar machen 
  #
  global diagdata
  global fsBox

  # focus sichern
  #
  savefocus
 
  # Voreinstellungen fuer Filenamen kopieren
  #
  set fsBox(path) $fpath
 
  # Fileselectionbox aufrufen
  #
  FSBox {Load Data: Select Filename} $fname {}

  # alten focus einstellen
  #
  setoldfocus
 
  if {$fsBox(name) != ""} {

    busy { 
          # Es wurde ein Filename ausgewaehlt =>
          # Puffer loeschen
          #
          diagdatadelete .buffer

          # aktuellen Filepfad/Namen in Puffer kopieren
          #
          set diagdata(.buffer.filepath) $fsBox(path)
          set diagdata(.buffer.filename) $fsBox(name)

          # ausgewaehltes file in Puffer Laden
          #
          diagdataget .buffer

          # Daten erfolgreich geladen(ansonsten wuerde die Routine in die
          # Hauptschleife verzeigen) =>
          # Puffer in aktuellen Datensatz kopieren 
          #
          diagdatacopy .buffer $dp

          # Datenspalten in korrespondierenden Datensatz kopieren 
          #
          set db $diagdata($dp.diagrambuf)
          copyallcols $dp $db
   
          # Daten je nach Domain transformieren
          #
          $diagdata($dp.transform) $db $dp
  
          # refresh durchfuehren
          #
          refreshwindows $dp .

    } ; # busy
  } ; # if Filename ausgewaehlt
}

#-----------------------------------------------------------------------------
# concatdata {} ruft eine Filesectionbox auf und laedt die Spalten der 
#               ausgewaehlten Datei zu den bereits geladenen Daten 
#               dp    : Pfad des aktuellen Diagramms
#               fpath : Filepfad
#               fname : Filename
#-----------------------------------------------------------------------------
#
proc concatdata {dp fpath fname} { 

  # Diagramm und -Auswahlboxvariablen sichtbar machen
  #
  global diagdata
  global fsBox
 
  # Focus sichern
  #
  savefocus
 
  # Voreinstellungen fuer Filenamen kopieren
  #
  set fsBox(path) $fpath
 
  # Fileselectionbox aufrufen
  #
  FSBox {Concat Data: Select Filename} $fname {}
 
  # alten Focus einstellen
  #
  setoldfocus
 
  if {$fsBox(name) != ""} {
 
    busy {
       # Es wurde ein Filename ausgewaehlt => 
       # alte Pufferdaten loeschen
       #
       diagdatadelete .buffer

       # aktuellen Filepfad/Namen kopieren
       #
       set diagdata(.buffer.filepath) $fsBox(path)
       set diagdata(.buffer.filename) $fsBox(name)

       # FilePfad/Namen in Diagrammdatensatz
       #
       set diagdata($dp.filepath)    $fsBox(path)
       set diagdata($dp.filename)    $fsBox(name)

       # ausgewaehltes file in Puffer Laden
       #
       diagdataget .buffer
   
       if {$diagdata(.buffer.status) == "defined"} {
           # Daten wurden erfolgreich eingeladen =>
           # Pufferdaten an aktuellen Datensatz anhaengen
           #
           set db $diagdata($dp.diagrambuf)
           concattabels $dp .buffer ;# Daten an aktuellen Datensatz haengen
           appendallcols $db .buffer;# Datenspalten in korrespondierenden
                                    ;# Datensatz

           # Daten je nach Domain transformieren
           #
           $diagdata($dp.transform) $db $dp
  
           # refresh durchfuehren
           #
           refreshwindows $dp .

       } ; # daten definiert
    } ; # busy
  } ; # filename gewaehlt
} 

#-----------------------------------------------------------------------------
# noconfigerr {} gibt Fehlermeldung "keine Konfigurationsdatei" aus 
#                filename : Datei, in der Fehler auftrat
#-----------------------------------------------------------------------------
#
proc noconfigerr {filename} {
 
  # aktuelle Diagrammkennung
  #
  global diagdata
  set dp $diagdata(diagram)

  # Ladeanzeige zerstoeren
  #
  destroyloadview $dp\_main.loadview
 
  # Fehler ausgeben
  #
  error " \"$filename\" is no valid configuration file"
}

#-----------------------------------------------------------------------------
# configgeterr  {} gibt eine Lesefehler Fehlermeldung aus
#               filename : Datei, in der Fehler auftrat
#               line     : Zeile, in der Fehler auftrat
#-----------------------------------------------------------------------------
#
proc configgeterr {filename line} {
 
  # akutelle Diagrammkennung
  #
  global diagdata
  set dp $diagdata(diagram) 

  # Ladeanzeige zerstoeren
  #
  catch {destroyloadview $dp\_main.loadview}
 
  # Fehler ausgeben
  #
  error "Bad format in file \"$filename\" at line $line"
}

#----------------------------------------------------------------------------
# selectconfig {} ruft eine Filesectionbox auf und laedt die ausgewaehlte
#                 Datei als Konfiguration
#                 dp   : Pfad des Diagramms
#----------------------------------------------------------------------------
#
proc selectconfig {dp} {

  # Diagramm und -Auswahlboxvariablen sichtbar machen 
  #
  global configbuffer diagdata fsBox

  # focus sichern
  #
  savefocus

  # Voreinstellungen  fuer  ConfigurationsPfad kopieren
  #
  set fsBox(path) $diagdata($dp.configpath)

  # Fileselectionbox aufrufen
  #
  FSBox {Load Configuration: Select Filename} $diagdata($dp.configname) {}

  # alten focus einstellen
  #
  setoldfocus

  if {$fsBox(name) != ""} {
     # Es wurde eine Konfiguration ausgewaehlt
     #  => aktuellen Filepfad/Namen kopieren
     #
     busy {
       set diagdata($dp.configpath) $fsBox(path)
       set diagdata($dp.configname) $fsBox(name)
   
       # Konfigurationspuffer loeschen
       #
       catch {unset configbuffer}
   
       # ausgewaehlte Konfiguration in den Puffer "configbuffer" laden
       #
       diagconfigget $dp configbuffer
  
       # Konfiguration korrekt geladen,(ansonsten wuerde die Routine
       # diagconfigget in die Hauptschleife verzweigen) => 
       # Konfiguration in die Diagrammdatensaetze kopieren 
       #
       diagconfigcopy configbuffer diagdata

       # refresh ausfuehren
       #
       refreshwindows $dp .
 
    } ;# busy
  }
}  

#-----------------------------------------------------------------------------
# saveconfig {dp} ruft eine Fileselectionbox auf und sichert die aktuelle 
#               Konfiguration in die Datei mit dem gewaehlten Namen
#               dp : Pfad des Diagramms , in dem der aktuelle
#                    KonfigurationsPfad und der aktuelle KonfigurationsName
#                    steht 
#-----------------------------------------------------------------------------
#
proc saveconfig {dp} {

  global diagdata
  global fsBox

  # focus sichern
  #
  savefocus

  # Voreinstellungen fuer ConfigurationsPfad kopieren
  #
  set fsBox(path) $diagdata($dp.configpath)

  # Fileselectionbox aufrufen
  #
  FSBox {Save Configuration: Select Filename} $diagdata($dp.configname) {}

  # alten focus einstellen
  #
  setoldfocus

  if {$fsBox(name) != ""} {
     # Es wurde eine Konfiguration ausgewaehlt
     #
     append file [string trimright $fsBox(path) /] / $fsBox(name)
     if {[file exists $file]} {
     
        # ausgewahlter Filename existiert bereits =>
        # Sicherheitsabfrage stellen 
        #
        if {[tk_dialog .confirmation "Warning"\
            "Warning: File \"$fsBox(name)\" already exists"\
             warning 1 Overwrite Cancel] == 1} {
           # "Cancel" wurde gewaehlt => Speichervorgang abbrechen
           #	
           return
        } ; # "Overwrite" gedrueckt
     } ; # file existiert bereits 

     #  aktuellen Filepfad/Namen kopieren
     #
     set diagdata($dp.configpath) $fsBox(path)
     set diagdata($dp.configname) $fsBox(name)
 
     # In ausgewaehltes file schreiben 
     #
     busy "diagconfigput $fsBox(path) $fsBox(name)"
  }
}


#-----------------------------------------------------------------------------
# savestartconfig {} sichert die aktuelle Konfiguration in die
#                    Start-Knofiguration ~./dvconfig - beim Aufruf des Haupt-
#                    programms und beim Reset wird diese Datei geladen
#----------------------------------------------------------------------------- 
#                   
proc savestartconfig {} {

   # Diagramm und Umgebungsvariablen sichtbar machen 
   #
   global diagdata env

   append file [string trimright $env(HOME) /] / .dvconfig
   if {[file exists $file]} {
      # eine Startconfiguration existiert bereits
      #
      if {[tk_dialog .confirmation "Warning"\
       "Warning: Startconfiguration file \".dvconfig\" already exists"\
        warning 1 Overwrite Cancel] == 1} {
        # "Cancel" wurde gewaehlt => Speichervorgang abbrechen
        #
        return
      }
   }

   # Startkonfiguration in ~/.dvconfig  abspeichern
   #
   busy "diagconfigput [glob ~] .dvconfig"
}

#-----------------------------------------------------------------------------
# deletestartconfig {} loescht die Start-Konfiguration ~./dvconfig nach
#                      einer Rueckfrage
#-----------------------------------------------------------------------------
#
proc deletestartconfig {} {

    # Diagrammvariablen sichtbar machen
    #
    global diagdata

    # File/Pfad-namen zusammenbauen
    #
    append file [glob ~] / .dvconfig

    if {[file exists $file]} {
        # eine Startconfiguration existiert
        #
        if {[tk_dialog .confirmation "Dialog"\
         "Really delete Startconfiguration file \".dvconfig\" ?"\
          questhead 1 Delete Cancel] == 1} {
          # "Cancel" wurde gewaehlt => Speichervorgang abbrechen
          #
          return
        } {
           # Delete wurde gewaehlt => Startconfigfile loeschen
           #
           catch {exec rm $file}
        }
    }
}


#-----------------------------------------------------------------------------
# resetconfig {dp} stellt den Daten-Ursprungszustand wieder her, d.h. loescht
#                  alle Konfigurationen und initialisiert ein neus Diagramm
#                  dp : Pfad des Diagramms, dass neu initialisiert wird
#-----------------------------------------------------------------------------
#
proc resetconfig {dp} {

   # Diagrammvariablen und Statusvariablen sichtbar machen
   #
   global diagdata status

   # Diagrammvariablenarray loeschen
   #
   unset diagdata

   # alle Fenster ausser das "." und "$dp_main" Fenster schliessen
   #
   set widgets [winfo children .]
   while {$widgets != ""} {
      set widget [lvarpop widgets]

      set top [winfo toplevel $widget]
      if {$top != "." && $top != "$dp\_main"} {
         destroy $top
         set widgets [winfo children .]
      }
   }

   # Initialisierung 
   #
   diagdatainit $dp

   # Fensterrefresh durchfuehren
   #
   refreshwindows $dp .
} 

#-----------------------------------------------------------------------------
# quitprog {}  verlaesst das Programm
#-----------------------------------------------------------------------------
#
proc quitprog {} {

   if {[tk_dialog .confirmation "Dialog"\
       "Really quit DataVision?"\
        questhead 0 "Yes, quit" Cancel] == 1} {
        # "Cancel" wurde gewaehlt => Programm nicht verlassen
        #
        return
      } {
        # Quit wurde gewaehlt => Programm verlassen
        #
        destroy .
   }
}
