# man2html1.tcl --
#
# This file defines procedures that are used during the first pass of the
# man page to html conversion process. It is sourced by main in man2html.tcl.
#
# Copyright (c) 1996 by Sun Microsystems, Inc.



# Global variables used by these scripts:
#
# state -	state variable that controls action of text proc during
#		pass 1.
#		
# manFile -	name of the current man page file, e.g. 'array.n'.
#
# package -	package directory name. Man pages are assumed to be in
#		$package/doc directory.
#
# NAME_file -	array indexed by command NAME and containing its file name.
#		Used for inserting hyperlinks and creating the contents file. 
#		Created during pass 1.
#
# NAME_chg -	array indexed by command NAME and containing an asterick 
#		(*) if page has change bars. Created during pass 1.
#
# KEY_file -	array indexed by KEYWORD and containing file names used
#		for hyperlinks. Created during pass 1.
#
# inVS -	In change bar section. Set to 1 if the VS macro is ever 
#		called, else set to 0. 
#
# names -	list of commands documented by the current page. Set by 
#		the text procedure and read by macro VS. Used to create
#		the NAME_chg array.


# text --
#
# This procedure adds entries to the hypertext arrays NAME_file
# and KEY_file.
#
# Arguments:
#   string -	Text to index.

proc text string {
    global state manFile NAME_file KEY_file package names

    switch $state {
	NAME {
	    set names {}
 	    foreach i [split $string ","] {
 		set name [string trim $i]
 		lappend NAME_file($name) $package/$manFile
 		lappend names $name
 	    }
	}
	KEY {
 	    foreach i [split $string ","] {
 		lappend KEY_file([string trim $i]) $package/$manFile
 	    }
	}
	DASH -
	OFF {}
	default {
	    puts stderr "text: unknown state: $state"
	}
    }
}


# macro --
#
# This procedure is invoked to process macro invocations that start
# with "." (instead of ').
#
# Arguments:
#   name -	The name of the macro (without the ".").
#   args -	Any additional arguments to the macro.

proc macro {name args} {
    switch $name {
	SH {
	    global state

	    switch $args {
		NAME {
		    if {$state == "INIT" } {
			set state NAME
		    }
		}
		DESCRIPTION {}
		INTRODUCTION {}
		KEYWORDS {set state KEY}
		default {set state OFF}
	    }
	
	}
	TP {
	}
	TH {
	    global state
	    set state INIT
	    if {[llength $args] != 5} {
		set args [join $args " "]
		puts stderr "Bad .TH macro: .$name $args"
	    }
	}
	VS {
	    global NAME_chg names
	    if [info exists names] {
		foreach name $names {
		    set NAME_chg($name) *
		}
		unset names
	    }
	}
    }
}



# dash --
#
# This procedure is invoked to handle dash characters ("\-" in
# troff).  It only function in pass 1 is to terminate the NAME state.
#
# Arguments:
#   None.

proc dash {} {
    global state
    if {$state == "NAME"} {
	set state DASH
    }
}




# tab, font, char, macro2 newline --
#
# These procedures do nothing during the first pass. 
#
# Arguments:
#   None.

proc tab {} {}
proc font type {}
proc char name {}
proc macro2 {args} {}
proc newline {} {}



# do --
#
# This is the toplevel procedure that searches a man page
# for hypertext links.  It builds a data base consisting of
# two arrays: NAME_file and KEY_file. It runs the man2tcl 
# program to turn the man page into a script, then it evals 
# that script. The script is save in a file for evaluation
# in pass 2.
#
# Arguments:
#   fileName -	    Name of the file to scan.

proc do fileName {
    global manFile inVS

    set manFile [file tail $fileName]
    puts "  Pass 1 -- $fileName"
    update
    if [catch {
	eval [man2tcl [glob $fileName]]
#	eval [set pcode [man2tcl [glob $fileName]]]
#	set fp [open $fileName.tcl w]
#	puts $fp $pcode
#	close $fp
	
    } msg] {
	global errorInfo
	puts stderr $msg
	puts "in"
	puts $errorInfo
	return
    }
}



# doPass1 --
#
# This is the toplevel procedure for pass 1 processing of a package. 
# Given a directory as argument, add link info to the hyperlink database 
# arrays: NAME_file and KEY_file.
#
# Arguments:
#   dir -   Name of the directory containing man pages.

proc doPass1 dir {
    foreach f [lsort [glob [file join $dir/*.\[13n\]]]] {
	do $f
	update
    }
}




