# jalert.tcl - notification panel
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:alert ?options? - alert box
# options include
#   -title (default "Alert")
#   -text (default "Alert!" - not really optional)
######################################################################

proc j:alert { args } {
  j:parse_args {
    {title "Alert"}
    {text "Alert!"}
  }
  set w .alert
  
  set title [uplevel 1 [list j:ldb $title]]
  set text [uplevel 1 [list j:ldb $text]]
  
  set old_focus [focus]			;# so we can restore original focus
  
  toplevel .alert
  
  wm title .alert $title
  wm transient .alert .
  
  message .alert.msg -width 300 -anchor w -text $text
  j:buttonbar .alert.b -default ok -buttons {{ok OK {destroy .alert}}}
  
  pack .alert.msg -side top -fill both -expand yes -padx 10 -pady 10
  pack [j:rule .alert -width 200] -side top -fill x
  pack .alert.b -side bottom -fill both
  
  j:dialogue .alert			;# position in centre of screen
  
  j:default_button .alert.b.ok .alert
  update

  grab .alert
  focus .alert
  tkwait window .alert
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
}






