# jdoc_ui.tcl - gui procedures for jdoc (also bindings)
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

##############################################################################
# jdoc:mkmenus - menu bar
##############################################################################

proc jdoc:mkmenus {} {
  frame .menu -borderwidth 2 -relief raised
  
  jdoc:mkmenu:doc
  jdoc:mkmenu:document
  jdoc:mkmenu:sections
  jdoc:mkmenu:help
  
  pack .menu -in . -side top -fill x
  
  tk_menuBar .menu .menu.doc .menu.document .menu.sections .menu.help
}

##############################################################################
# jdoc:mkmenu:doc - doc menu
##############################################################################

proc jdoc:mkmenu:doc {} {
  j:menu:menubutton .menu.doc .menu.doc.m {Doc Viewer}
  pack .menu.doc -in .menu -side left
  
  j:menu:commands .menu.doc.m .t {
    jdoc:cmd:about
    j:cmd:global_pref_panel
    jdoc:cmd:doc_prefs
    -
    j:cmd:prompt_tcl
    j:cmd:prompt_unix
  }
}

##############################################################################
# jdoc:mkmenu:document - document menu
##############################################################################

proc jdoc:mkmenu:document {} {
  j:menu:menubutton .menu.document .menu.document.m {Document}
  pack .menu.document -in .menu -side left

  j:menu:commands .menu.document.m .t {
    jdoc:cmd:load
    jdoc:cmd:save_as
    jdoc:cmd:print_postscript
    -
    jdoc:cmd:find
    -
    jdoc:cmd:quit
  }
}

##############################################################################
# jdoc:mkmenu:sections - sections menu
##############################################################################

proc jdoc:mkmenu:sections {} {
  j:menu:menubutton .menu.sections .menu.sections.m {Sections}
  pack .menu.sections -in .menu -side left
}

##############################################################################
# jdoc:mkmenu:help - help menu
##############################################################################

proc jdoc:mkmenu:help {} {
  j:menu:menubutton .menu.help .menu.help.m {Help}
  pack .menu.help -in .menu -side right
  
  j:menu:docs .menu.help.m {
    {{Help on Doc Viewer} {jdoc.jdoc}}
    -
    {{Help on jstools} {jstools.jdoc}}
  }
}

##############################################################################
# jdoc:mkbuttons - buttons at bottom
##############################################################################

proc jdoc:mkbuttons {} {
  j:command:buttonbar .b .t {
    jdoc:cmd:quit
    jdoc:cmd:load
    jdoc:cmd:print_postscript
    jdoc:cmd:find
  }
  pack .b -in . -side bottom -fill x
}

##############################################################################
# jdoc:mktext - text widget
##############################################################################

proc jdoc:mktext {} {
  global J_PREFS
  if {[lsearch [array names J_PREFS] {scrollbarside}] == -1} {
    set J_PREFS(scrollbarside) right ;# make sure it's defined
  }
  text .t -yscrollcommand {.s set} \
    -width 70 -height 18 -borderwidth 4 \
    -setgrid true -wrap word
  scrollbar .s -command {.t yview}
  pack .s -in . -side $J_PREFS(scrollbarside) -fill y
  pack .t -in . -side $J_PREFS(scrollbarside) -fill both -expand y
  jdoc:configure_text .t
  
  focus .t
  catch {focus default .t}			;# caught for Tk 4.0
  tk_bindForTraversal .t
  j:command:bind .t .t [j:command:list]
}






