# jedit_bindings.tcl - bindings for command accelerators for jedit
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# jedit:mkbindings - set keyboard shortcuts and special map additions
#   widgets and t are often the same, but needn't be - widgets could
#   also include entry widgets
######################################################################

proc jedit:mkbindings {widgets t} {
  global WORD_END JEDIT_CLOSE_BRACKET
  
  jedit:register_commands	;# make sure command procs are autoloaded
  
  j:command:bind $widgets $t [j:command:list]
  
  # following is kludge; some X servers require one keysym, some
  #   require another.  this is ugly, because it means the user
  #   can't redefine these bindings and they aren't taken from 
  #   the nls database.
  
  catch {
    bind $t <Meta-quoteright>	{jedit:cmd:sabbrev %W}
  }
  catch {
    bind $t <Meta-apostrophe>	{jedit:cmd:sabbrev %W}
  }
  catch {
    bind $t <Meta-minus>	{jedit:cmd:hyphen %W}
  }
  catch {
    bind $t <Meta-hyphen>	{jedit:cmd:hyphen %W}
  }
  
  # set up bindings for word-end punctuation (for abbrevs):
  
  foreach key $WORD_END {
    foreach map {basic vi-insert emacs-normal edt-normal} {
      j:tkb:mkmap $t $map $map [format {
        {%s			jedit:self_insert_punct}
      } $key]
    }
  }
  foreach key $JEDIT_CLOSE_BRACKET {
    foreach map {basic vi-insert emacs-normal edt-normal} {
      j:tkb:mkmap Text $map $map [format {
        {%s			jedit:flash_paren}
      } $key]
    }
  }
  
  # set up bindings for gesture commands
  
  bind $t <ButtonPress-3> {j:tmb:start_gesture %W %x %y %t ;}
  bind $t <ButtonRelease-3> {j:tmb:end_gesture %W %x %y %t ;}
  
  j:tk4 {
    bind $t <ButtonPress-3> +break
    bind $t <ButtonRelease-3> +break
  }
  
  # set up bindings for a few other special characters:
  
  foreach map {basic vi-insert emacs-normal edt-normal} {
    j:tkb:mkmap $t $map $map [format {
      {Tab			jedit:tabkey}
    } $key]
    j:tkb:mkmap $t $map $map [format {
      {space			jedit:spacebar}
    } $key]
    j:tkb:mkmap $t $map $map [format {
      {Return			jedit:returnkey}
    } $key]
  }
  
  # additional application-specific Emacs-style keyboard bindings:
  
  j:tkb:mkmap $t emacs-normal emacs-normal {
    {Control-s			jedit:cmd:find_forward}
    {Control-r			jedit:cmd:find_backward}
  }
  j:tkb:mkmap $t emacs-escape emacs-normal {
    {percent			jedit:cmd:find}
    {slash			jedit:cmd:dabbrev}
  }
  j:tkb:mkmap $t emacs-control-x emacs-normal {
    {Control-s			jedit:cmd:save}
    {Control-w			jedit:cmd:saveas}
    {Control-f			jedit:cmd:load}
    {Control-v			jedit:cmd:load}
    {Control-c			jedit:cmd:quit}
  }
  
  # additional application-specific vi-style keyboard bindings:
  
  j:tkb:mkmap $t vi-command vi-command {
    {slash			jedit:cmd:find_forward}
    {question			jedit:cmd:find_backward}
    {n				jedit:cmd:find_again}
  }
  
  # create a vi-Z map for the "ZZ" command:
  
  j:tkb:mkmap $t vi-command vi-command {
    {Z				j:tkb:new_mode vi-Z}
  }
  
  j:tkb:mkmap $t vi-Z vi-command {
    {DEFAULT			j:tb:no_op}
    {Shift-DEFAULT		j:tb:no_op}
    {Control-DEFAULT		j:tb:no_op}
    {Meta-DEFAULT		j:tb:no_op}
    {Z				jedit:cmd:done}
  }
}

