# jedit_prefs.tcl - preferences commands and procs for jedit
#   (jedit:prefs:menus is in jedit_menus.tcl, for convenience.)
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

# TO DO
#   MAKE ALL THIS PER-WINDOW!
#   file_modes panel
#   word-end punctuation (and heuristics) sd be mode-specific
######################################################################

j:ldb:set_defaults {
  {JEbutton:done {Done}}
  {JEbutton:save {Save}}
  {JEbutton:default {Default}}
  {JEbutton:choose {Choose...}}
  {JEpref:textbg {Normal background:}}
  {JEpref:textfg {Normal foreground:}}
  {JEpref:textsb {Selected background:}}
  {JEpref:textsf {Selected foreground:}}
  {JEpref:textiw {Insert width:}}
  {JEpref:textsbw {Selection border width:}}
  {JEpref:textbw {Text border width:}}
  {JEpref:undolevels {Undo levels:}}
  {JEtitle:modeprefs {Mode\255Specific Preferences}}
  {JElabel:prefs_for_mode... {Preferences for mode "$mode"}}
  {JEpref:show...menu {Show $menu Menu}}
  {JEpref:buttonbar {Show Buttonbar}}
  {JEpref:savestate {Save/Load Visual State} 10}
    {LONG-JEpref:savestate {Save/Load Highlighting and Position} 10}
  {JEpref:autobreak {Break Lines on <space>} 0}
    {LONG-JEpref:autobreak {Break long lines with <Space>} 0}
  {JEpref:autoindent {Indent Lines on <Return>} 0}
    {LONG-JEpref:autoindent {Preserve indentation with <Return>} 0}
  {JEpref:parenflash {Flash Matching Brackets} 6}
    {LONG-JEpref:parenflash
    {Flash matching braces, brackets, and parentheses} 6}
  {JEpref:sabbrev {Static Abbreviation} 1}
    {LONG-JEpref:sabbrev {Expand static abbreviations with <Space>} 1}
  {JEpref:dabbrev {Dynamic Abbreviation} 1}
    {LONG-JEpref:dabbrev {Expand dynamic abbreviations with <Tab>} 1}
  {JEpref:wrap_none {Don't Wrap Lines} 2}
  {JEpref:wrap_char {Wrap Lines Anywhere} 11}
    {LONG-JEpref:wrap_char {Wrap Lines at Character Boundaries} 11}
  {JEpref:wrap_word {Wrap Lines at Words} 14}
    {LONG-JEpref:wrap_word {Wrap Lines at Word Boundaries} 14}
  {JEpref:font {Font:}}
  {JEpref:width {Width:}}
  {JEpref:height {Height:}}
}

######################################################################
# editor-wide preferences panel
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

j:command:register jedit:cmd:edit_prefs {Editor Preferences...}
proc jedit:cmd:edit_prefs { t args } {
  global JEDIT_PREFS
  
  set old_focus [focus]			;# so we can restore original focus
  
  set w .edit_prefs
  toplevel $w
  wm title $w "Editor Preferences"
  
  j:colour_chooser $w.textbg \
    -variable JEDIT_PREFS(textbg) \
    -label [j:ldb JEpref:textbg]
  j:colour_chooser $w.textfg \
    -variable JEDIT_PREFS(textfg) \
    -label [j:ldb JEpref:textfg]
  j:colour_chooser $w.textsb \
    -variable JEDIT_PREFS(textsb) \
    -label [j:ldb JEpref:textsb]
  j:colour_chooser $w.textsf \
    -variable JEDIT_PREFS(textsf) \
    -label [j:ldb JEpref:textsf]
  
  label $w.textiw-label \
    -text [j:ldb JEpref:textiw] \
    -anchor w
  scale $w.textiw \
    -from 1 -to 25 \
    -orient horizontal \
    -command {set JEDIT_PREFS(textiw)}
  $w.textiw set $JEDIT_PREFS(textiw)
  
  label $w.textsbw-label \
    -text [j:ldb JEpref:textsbw] \
    -anchor w
  scale $w.textsbw \
    -from 0 -to 25 \
    -orient horizontal \
    -command {set JEDIT_PREFS(textsbw)}
  $w.textsbw set $JEDIT_PREFS(textsbw)
  
  label $w.textbw-label \
    -text [j:ldb JEpref:textbw] \
    -anchor w
  scale $w.textbw \
    -from 0 -to 50 \
    -orient horizontal \
    -command {set JEDIT_PREFS(textbw)}
  $w.textbw set $JEDIT_PREFS(textbw)
  
  label $w.undolevels-label \
    -text [j:ldb JEpref:undolevels] \
    -anchor w
  scale $w.undolevels \
    -from 0 -to 10 \
    -orient horizontal \
    -command {set JEDIT_PREFS(undolevels)}
  $w.undolevels set $JEDIT_PREFS(undolevels)
  
  j:buttonbar $w.b -default save -buttons [format {
    {
      save JEbutton:save {
        j:write_prefs -array JEDIT_PREFS -directory $env(HOME)/.tk \
          -file jedit-defaults
        %s.b.done invoke
      }
    } {
      done JEbutton:done {
        jedit:apply_all_prefs [jedit:text_to_top %s]
        destroy %s
      }
    }
  } $w $t $w]
  
  pack \
    $w.textbg \
    [j:rule $w] \
    $w.textfg \
    [j:rule $w] \
    $w.textsb \
    [j:rule $w] \
    $w.textsf \
    [j:rule $w] \
    $w.textiw-label $w.textiw \
    [j:filler $w] \
    $w.textsbw-label $w.textsbw \
    [j:filler $w] \
    $w.textbw-label $w.textbw \
    [j:rule $w] \
    $w.undolevels-label $w.undolevels \
    [j:rule $w] \
    $w.b \
    -fill x
  
  j:dialogue $w
  j:default_button $w.b.save $w
  focus $w
  tkwait window $w
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
}

######################################################################
# jedit:cmd:mode_prefs - mode-specific preferences panel
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

j:command:register jedit:cmd:mode_prefs {Mode Preferences...}
proc jedit:cmd:mode_prefs { t args } {
  global JEDIT_MODEPREFS env tk_strictMotif
  
  set old_focus [focus]			;# so we can restore original focus
  
  set mode [jedit:get_mode $t]
  
  set window [jedit:text_to_top $t]

  toplevel .mode_prefs
  wm title .mode_prefs [j:ldb JEtitle:modeprefs]
  
  label .mode_prefs.mode -text [j:ldb JElabel:prefs_for_mode...]
  
  pack .mode_prefs.mode -expand y -fill x
  
  j:buttonbar .mode_prefs.b -default save -buttons [format {
    {
      save JEbutton:save {
        set tmp_mode %s
        j:write_prefs -array JEDIT_MODEPREFS -prefix $tmp_mode \
          -directory $env(HOME)/.tk/jeditmodes \
          -file ${tmp_mode}-defaults
        .mode_prefs.b.done invoke
      }
    } {
      done JEbutton:done {
        set tmp_mode %s
        if {$JEDIT_MODEPREFS($tmp_mode,textwidth) < 20} {
          set JEDIT_MODEPREFS($tmp_mode,textwidth) 20
        }
        if {$JEDIT_MODEPREFS($tmp_mode,textheight) < 4} {
          set JEDIT_MODEPREFS($tmp_mode,textheight) 4
        }
        # noreread is a kludge!
        jedit:apply_all_prefs %s noreread
        destroy .mode_prefs
      }
    }
  } $mode $mode $window]
  
  frame .mode_prefs.ui_prefs
  lower .mode_prefs.ui_prefs
  frame .mode_prefs.other_prefs
  lower .mode_prefs.other_prefs
  frame .mode_prefs.window_prefs
  lower .mode_prefs.window_prefs
  pack \
    [j:rule .mode_prefs] \
    [jedit:prefs:menus .mode_prefs.menus $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:buttonbar .mode_prefs.buttonbar $mode] \
    -in .mode_prefs.ui_prefs -fill x -expand 1
  pack \
    [j:rule .mode_prefs] \
    [jedit:prefs:io .mode_prefs.io $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:autokeys .mode_prefs.autokeys $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:abbrevs .mode_prefs.abbrevs $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:wrap .mode_prefs.wrap $mode] \
    -in .mode_prefs.other_prefs -fill x -expand 1
  pack \
    [jedit:prefs:font .mode_prefs.font $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:size .mode_prefs.size $mode] \
    -in .mode_prefs.window_prefs -fill x -expand 1
  pack \
    .mode_prefs.b \
    [j:rule .mode_prefs] \
    .mode_prefs.window_prefs \
    [j:rule .mode_prefs] \
    -fill x -side bottom -expand 1
  pack \
    .mode_prefs.ui_prefs \
    -side left -fill both -expand 1
  pack \
    [j:rule .mode_prefs] \
    -side left -fill y
  pack \
    .mode_prefs.other_prefs \
    -side left -fill both -expand 1
  
  j:dialogue .mode_prefs		;# position in centre of screen

  focus .mode_prefs
  j:default_button .mode_prefs.b.save \
    .mode_prefs.font.bot.e \
    .mode_prefs.size.we \
    .mode_prefs.size.he \
    .mode_prefs

  j:tab_ring \
    .mode_prefs.font.bot.e \
    .mode_prefs.size.we \
    .mode_prefs.size.he
  
  bind .mode_prefs <Key-Tab> {focus .mode_prefs.font.bot.e}
  tkwait window .mode_prefs
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
}

proc jedit:prefs:buttonbar { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.cb -anchor w \
    -text [j:ldb JEpref:buttonbar] \
    -variable JEDIT_MODEPREFS($mode,buttonbar)
  pack $w.cb -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:io { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.cb -anchor w \
    -text [j:ldb JEpref:savestate] \
    -variable JEDIT_MODEPREFS($mode,savestate)
  pack $w.cb -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:autokeys { w mode } {
  global JEDIT_MODEPREFS 
  
  frame $w
  checkbutton $w.autobreak_cb -anchor w \
    -text [j:ldb JEpref:autobreak] \
    -variable JEDIT_MODEPREFS($mode,autobreak)
  checkbutton $w.autoindent_cb -anchor w \
    -text [j:ldb JEpref:autoindent] \
    -variable JEDIT_MODEPREFS($mode,autoindent)
  checkbutton $w.parenflash_cb -anchor w \
    -text [j:ldb JEpref:parenflash] \
    -variable JEDIT_MODEPREFS($mode,parenflash)
  pack \
    $w.autobreak_cb \
    $w.autoindent_cb \
    $w.parenflash_cb \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:abbrevs { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.sabbrev_cb -anchor w \
    -text [j:ldb JEpref:sabbrev] \
    -variable JEDIT_MODEPREFS($mode,sabbrev)
  checkbutton $w.dabbrev_cb -anchor w \
    -text [j:ldb JEpref:dabbrev] \
    -variable JEDIT_MODEPREFS($mode,dabbrev)
  pack \
    $w.sabbrev_cb \
    $w.dabbrev_cb \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:wrap { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  radiobutton $w.none -anchor w \
    -text [j:ldb JEpref:wrap_none] \
    -variable JEDIT_MODEPREFS($mode,textwrap) -value none
  radiobutton $w.char -anchor w \
    -text [j:ldb JEpref:wrap_char] \
    -variable JEDIT_MODEPREFS($mode,textwrap) -value char
  radiobutton $w.word -anchor w \
    -text [j:ldb JEpref:wrap_word] \
    -variable JEDIT_MODEPREFS($mode,textwrap) -value word
  pack \
    $w.none \
    $w.char \
    $w.word \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:font { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  
  frame $w.top
  label $w.top.l -text [j:ldb JEpref:font]
  button $w.top.default \
    -width 8 \
    -text [j:ldb JEbutton:default] \
    -command "set JEDIT_MODEPREFS($mode,textfont) {default}"
  button $w.top.choose \
    -text [j:ldb JEbutton:choose] \
    -command "set JEDIT_MODEPREFS($mode,textfont) \[j:prompt_font\]"
  
  frame $w.bot
  entry $w.bot.e -width 50 \
    -textvariable JEDIT_MODEPREFS($mode,textfont)
  
  pack $w.top.l -side left
  pack $w.top.choose -side right -padx 10 -pady 5
  pack $w.top.default -side right -pady 5
  
  pack $w.bot.e -side left -padx 10 -pady 5
  
  pack \
    $w.top \
    $w.bot \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:size { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  label $w.wl -text [j:ldb JEpref:width]
  entry $w.we -width 5 \
    -textvariable JEDIT_MODEPREFS($mode,textwidth)
  label $w.hl -text [j:ldb JEpref:height]
  entry $w.he -width 5 \
    -textvariable JEDIT_MODEPREFS($mode,textheight)
  
  pack $w.wl -side left -fill x -pady 5
  pack $w.we -side left -pady 5
  pack $w.hl -side left -fill x -pady 5
  pack $w.he -side left -pady 5
  
  return $w
}






