######################################################################
# ~/.tk/edittkmodes/sh-mode.tcl - mode for editing /bin/sh code
######################################################################

j:ldb:set_defaults {
  {menu:sh_mode1 {sh} 0}
  {menu:sh_mode2 {Funcs} 2}
  {mode:sh:hash {Comment with #} 0}
    {SHORT-mode:sh:hash {#}}
  {mode:sh:hashes {Comment with ###} 1}
    {SHORT-mode:sh:hashes {###}}
  {mode:sh:uncomment {Uncomment} 0}
  {mode:sh:border {Make Border} 5 <Meta-Key-3>}
    {SHORT-mode:sh:border {Border}}
  
  {sh_pref:hilight_comments {Hilight Comments}}
  
  {{Help on sh Mode} {Help on `sh' Mode}}
}

proc mode:sh:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix sh \
    -directory ~/.tk/jeditmodes -file sh-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 0}
    {autoindent 1}
    {parenflash 1}
    {savestate 0}
    {buttonbar 1}
    {buttons {
      jedit:cmd:save
      mode:sh:hash
      mode:sh:hashes
      mode:sh:uncomment
      mode:sh:border
    }}
    {docs {
      -
      {{Help on sh Mode} {jeditmodes/sh-mode.jdoc}}
    }}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,font 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
    {sh_hilight_comments 0}
  }
  
  # There should be a mode-specific preferences panel for this:
  global TCL_MODE
  set TCL_MODE(indent) 2		;# number of chars per nesting level
  
  ######################################################################
  # tags
  
  catch {
    $t tag configure comment \
      -foreground {#4000ff} \
      -font -*-times-medium-i-normal-*-*-120-*
  }
}

######################################################################
# make Tcl menu
######################################################################

proc mode:sh:mkmenu1 { menu t } {
  global JEDIT_MODEPREFS
  j:menu:menubutton $menu $menu.m menu:sh_mode1
  
  j:menu:checkbuttons $menu.m [list \
    [list sh_pref:hilight_comments JEDIT_MODEPREFS(sh,sh_hilight_comments)] \
  ]
  j:menu:commands $menu.m $t {
    -
    mode:sh:hash
    mode:sh:hashes
    mode:sh:uncomment
    mode:sh:border
  }
  
  bind $t <Meta-Key-3> "mode:sh:border $t"
}

######################################################################
# make Funcs menu (mostly done by mode:sh:mkfuncsmenu)
######################################################################

proc mode:sh:mkmenu2 {menu t} {
  j:menu:menubutton $menu $menu.m menu:sh_mode2
  
  $menu.m configure -postcommand "mode:sh:mkfuncsmenu $menu $t"
}

######################################################################
# adjust indentation based on nesting
######################################################################

proc mode:sh:autoindent { t } {
  global TCL_MODE
  
  set indentlevel 0
  set current [$t get {insert linestart} {insert}]
  set prevline [$t get {insert -1lines linestart} {insert -1lines lineend}]
  set antepenult [$t get {insert -2lines linestart} {insert -2lines lineend}]
  
  set indent ""
  regexp "^  *" $prevline indent
  set indentlevel [string length $indent]
  
  set anteindent ""
  regexp "^  *" $antepenult anteindent
  set antelevel [string length $anteindent]
  
  set close "^\[ \t\]*\}"			;# brace at beginning of line
  if {[regexp $close $prevline]} {
    if {$indentlevel == $antelevel && $indentlevel >= $TCL_MODE(indent)} {
      # change current indentation level:
      incr indentlevel -$TCL_MODE(indent)
      # and adjust previous line's indentation:
      $t delete {insert -1lines linestart} \
        "insert -1lines linestart +$TCL_MODE(indent)chars"
    }
  }
  set comment "\{\[ \t;\]*#\[^\}\]*$"		;# brace followed by comment
  if {[regexp "\{$" $prevline] || [regexp $comment $prevline]} {
    incr indentlevel $TCL_MODE(indent)
  }
  if {[string match {*[\]} $prevline]} {	;# line continued
    if {![string match {*[\]} $antepenult]} {
      incr indentlevel $TCL_MODE(indent)
    }
  } else {
    if {[string match {*[\]} $antepenult]} {
      # last line was a continuation, but this one isn't
      incr indentlevel -$TCL_MODE(indent)
    }
  }
  if {$indentlevel < 0} {set indentlevel 0}
  
  for {set i 0} {$i < $indentlevel} {incr i} {
    $t insert insert " "
  }
}

######################################################################
# highlight comments in previous line
######################################################################

proc mode:sh:post_returnkey_hook { t } {
  set lineno [lindex [split [$t index insert] .] 0]
  if {$lineno == 1} {return 0}
  mode:sh:tag_line [expr {$lineno - 1}] $t
}

######################################################################
# parse/tag all lines
######################################################################

proc mode:sh:post_read_hook { filename t } {
  set lastline [lindex [split [$t index end] .] 0]
  for {set i 1} {$i < $lastline} {incr i} {
    mode:sh:tag_line $i $t
  }
}

######################################################################
# remember insert so we can scan pasted lines
######################################################################

proc mode:sh:pre_paste_hook { t } {
  global pre_paste_line
  set pre_paste_line [lindex [split [$t index insert] .] 0]
}

######################################################################
# scan all the pasted lines
######################################################################

proc mode:sh:post_paste_hook { t } {
  global pre_paste_line
  set post_paste_line [lindex [split [$t index insert] .] 0]
  for {set i $pre_paste_line} {$i < $post_paste_line} {incr i} {
    mode:sh:tag_line $i $t
  }
}

######################################################################
# remember insert so we can scan pasted lines
######################################################################

proc mode:sh:pre_xpaste_hook { t } {
  global pre_paste_line
  set pre_paste_line [lindex [split [$t index insert] .] 0]
}

######################################################################
# scan all the pasted lines
######################################################################

proc mode:sh:post_xpaste_hook { t } {
  global pre_paste_line
  set post_paste_line [lindex [split [$t index insert] .] 0]
  for {set i $pre_paste_line} {$i < $post_paste_line} {incr i} {
    mode:sh:tag_line $i $t
  }
}
  
######################################################################
# find all the functions and add them to mode2 menu
#   this is the -command parameter for .menu.mode2
######################################################################

proc mode:sh:mkfuncsmenu {menu t} {
  set lines [lindex [split [$t index end] .] 0]
  set linelist {}
  
  for {set line 0} {$line <= $lines} {incr line} {
    if [regexp {^[a-zA-Z0-9_]+ *\(\) *\{} [$t get $line.0 "$line.0 lineend"]] {
      lappend linelist $line
    }
  }
  
  $menu.m delete 0 last
  
  $menu.m add command -label "Top" -command "
    $t mark set insert 0.0
    $t yview -pickplace insert
  "
  $menu.m add separator
  
  foreach line $linelist {
    set text [$t get $line.0 "$line.0 lineend"]
    regsub {^([a-zA-Z0-9_]+) *\(\).*} $text {\1} text
    $menu.m add command -label "$text" -command "
      $t mark set insert $line.0
      $t yview -pickplace insert
    "
  }
  
  $menu.m add separator
  $menu.m add command -label "End" -command "
    $t mark set insert end
    $t yview -pickplace insert
  "
  
  update
}

######################################################################
# highlight comments
######################################################################
#### THIS IS TOO SLOW!
proc mode:sh:tag_line { lineno t } {
  global JEDIT_MODEPREFS
  if {!$JEDIT_MODEPREFS(sh,sh_hilight_comments)} {return 0}
  
  # make sure there's no highlighting already:
  $t tag remove comment "$lineno.0" "$lineno.0 lineend"

  set line [$t get "$lineno.0" "$lineno.0 lineend"]
  
  # if entire line is comment:
  if [regexp -indices "^\[ ;\t]*(#.*)" $line foo indices] {
    set first "$lineno.0 +[lindex $indices 0]chars"
    set last "$lineno.0 lineend"
    $t tag add comment $first $last
    return 0
  }
  # if comment immediately follows whitespace
  if [regexp -indices "(\[ \t\]#.*)" $line foo indices] {
    set first "$lineno.0 +[lindex $indices 0]chars"
    set last "$lineno.0 lineend"
    $t tag add comment $first $last
    return 0
  }
}

######################################################################
# apply a prefix to selected lines (or current line)
######################################################################

proc mode:sh:prefix { prefix t } {
  jedit:guarantee_selection $t
  jedit:text_regsub $t \
    [format {(^|%s)} "\n"] \
    [format {\1%s} $prefix]
}

######################################################################
### command procedures:
######################################################################

j:command:register mode:sh:hashes {Comment with ###}
proc mode:sh:hashes { t args } {
  jedit:guarantee_selection $t
  mode:sh:prefix "### " $t
}

j:command:register mode:sh:hash {Comment with #}
proc mode:sh:hash { t args } {
  jedit:guarantee_selection $t
  mode:sh:prefix "# " $t
}

j:command:register mode:sh:uncomment {Uncomment}
proc mode:sh:uncomment { t args } {
  jedit:guarantee_selection $t
  jedit:text_regsub $t \
    [format {(^|%s)#* } "\n"] \
    {\1}
}

j:command:register mode:sh:border {Make Border}
proc mode:sh:border { t } {
  j:text:insert_string $t \
    "######################################################################\n"
}







