# jentrybasic.tcl - support for basic Entry bindings
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# NOTE:
#   the "jentryemacs.tcl" and "jentryvi.tcl" libraries contain actual
#   procedures for emulation-specific actions.  "basic" bindings,
#   however, don't use anything that isn't general (and therefore
#   in jentrytext.tcl), so this file just has j:eb:basic_init in it.
######################################################################

######################################################################
# j:eb:basic_init - initialise info for basic Entry bindings
######################################################################

proc j:eb:basic_init { e } {
  global j_teb
  set j_teb(cutbuffer) {}
  set j_teb(dragscroll,txnd) 0
  set j_teb(dragscroll,delay) 50
  set j_teb(scanpaste_time) 0
  set j_teb(scanpaste_paste) 1
    
  set j_teb(keymap,$e) basic
  
  j:eb:key_bind $e
  j:eb:mouse_bind $e
  
  j:ekb:mkmap Entry basic basic {
    {Control-slash		j:eb:select_all}
    {Control-backslash		j:eb:clear_selection}
    
    {Delete			j:ekb:delete_left}
    {BackSpace			j:ekb:delete_left}
    {Return			j:eb:no_op}
    
    {Up				j:ekb:up}
    {Down			j:ekb:down}
    {Left			j:ekb:left}
    {Right			j:ekb:right}
    
    {Home			j:ekb:bol}
    {End			j:ekb:eol}
    
    {Next			j:ekb:scroll_down}
    {Prior			j:ekb:scroll_up}
    
    {Control-v			j:ekb:paste_selection}
    {Control-i			j:ekb:self_insert}
    {Control-j			j:ekb:self_insert}
    {Control-h			j:ekb:delete_left}
    
    {Control-DEFAULT		j:eb:beep}
    {DEFAULT			j:ekb:self_insert}
    {Shift-DEFAULT		j:ekb:self_insert}
  }
}

# deprecated alias for backward compatibility:

proc j:eb:basic_bind { W args } {
  j:eb:basic_init $W
}
