# jentryvi.tcl - support for vi Entry bindings
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:eb:vi_init - initialise info for vi Entry bindings
######################################################################

proc j:eb:vi_init { e } {
  global j_teb
  set j_teb(cutbuffer) {}
  set j_teb(dragscroll,txnd) 0
  set j_teb(dragscroll,delay) 50
  set j_teb(scanpaste_time) 0
  set j_teb(scanpaste_paste) 1
  
  set j_teb(keymap,$e) vi-insert	;# annoying to start in command mode!
  
  j:eb:key_bind $e
  j:eb:mouse_bind $e
  
  j:ekb:mkmap Entry vi-command vi-command {
    {Control-slash		j:eb:select_all}
    {Control-backslash		j:eb:clear_selection}
    
    {Delete			j:ekb:left}
    {BackSpace			j:ekb:left}
    {space			j:ekb:right}
    {minus			j:eb:beep}
    {plus			j:eb:beep}
    {Return			j:eb:beep}
    
    {Up				j:eb:beep}
    {Down			j:eb:beep}
    {Left			j:ekb:left}
    {Right			j:ekb:right}
    
    {Control-p			j:eb:beep}
    {Control-n			j:eb:beep}

    {k				j:eb:beep}
    {j				j:eb:beep}
    {h				j:ekb:left}
    {l				j:ekb:right}

    {Control-k			j:eb:beep}
    {Control-j			j:eb:beep}
    {Control-h			j:ekb:left}
    {Control-l			j:ekb:right}
    
    {Control-b			j:eb:beep}
    {Control-f			j:eb:beep}

    {x				j:ekb:delete_right}
    {X				j:ekb:delete_left}
    {b				j:ekb:word_left}
    {B				j:ekb:word_right}
    {e_XXX			j:ekb:vi:word_end}
    {w				j:ekb:word_right}
    {W				j:ekb:word_right}
    {G				j:eb:beep}
    
    {i				j:ekb:vi:insert}
    {a				j:ekb:vi:append}
    {I				j:ekb:vi:insert-bol}
    {A				j:ekb:vi:append-eol}
    {o				j:eb:beep}
    {O				j:eb:beep}
    
    {asciicircum		j:ekb:bol}
    {dollar			j:ekb:vi:eol}
    {Home			j:ekb:bol}
    {End			j:ekb:vi:eol}
    
    {Escape			j:eb:beep}
    {Control-bracketleft	j:eb:beep}
    
    {Control-DEFAULT		j:eb:beep}
    {DEFAULT			j:eb:beep}
    {Shift-DEFAULT		j:eb:beep}
  }
  
  j:ekb:mkmap Entry vi-insert vi-insert {
    {Control-slash		j:eb:select_all}
    {Control-backslash		j:eb:clear_selection}
    
    {Delete			j:ekb:delete_left}
    {BackSpace			j:ekb:delete_left}
    {Return			j:eb:no_op}
    
    {Control-i			j:ekb:self_insert}
    {Control-j			j:ekb:self_insert}
    {Control-h			j:ekb:delete_left}
    
    {Control-w			j:ekb:delete_left_word}
    {Control-u			j:ekb:vi:delete_left_line}
    
    {Escape			j:ekb:vi:command}
    {Control-bracketleft	j:ekb:vi:command}
    
    {Control-v			j:ekb:new_mode vi-literal}
    
    {Control-DEFAULT		j:eb:beep}
    {DEFAULT			j:ekb:self_insert}
    {Shift-DEFAULT		j:ekb:self_insert}
  }
  
  j:ekb:mkmap Entry vi-literal vi-insert {
    {DEFAULT			j:ekb:self_insert}
    {Shift-DEFAULT		j:ekb:self_insert}
    {Control-DEFAULT		j:ekb:self_insert}
    {Meta-DEFAULT		j:ekb:self_insert}
  }
}

######################################################################
###  VI COMMANDS
######################################################################

proc j:ekb:vi:command { W K A } {
  j:ekb:left $W "" ""
  j:ekb:new_mode vi-command $W $K $A
}

proc j:ekb:vi:insert { W K A } {
  j:ekb:new_mode vi-insert $W $K $A
}

proc j:ekb:vi:eol { W K A } {
  $W icursor [expr {[$W index end] - 1}]
  j:ek:see_insert $W
}

proc j:ekb:vi:append { W K A } {
  global j_teb
  # BOGUS - crosses newline boundaries
  j:ekb:right $W $K $A
  j:ekb:vi:insert $W $K $A
}

proc j:ekb:vi:insert-bol { W K A } {
  global j_teb
  # BOGUS - bgg of line, not bgg of printable line
  j:ekb:bol $W $K $A
  j:ekb:vi:insert $W $K $A
}

proc j:ekb:vi:append-eol { W K A } {
  global j_teb
  j:ekb:eol $W $K $A
  j:ekb:vi:insert $W $K $A
}

######################################################################
# used for Control-u in insert mode:

proc j:ekb:vi:delete_left_line { W K A } {
  $W delete 0 insert
}

######################################################################
# deprecated alias for backward compatibility:
######################################################################

proc j:eb:vi_bind { W } {
  j:eb:vi_init $W
}

######################################################################
# NOT YET WRITTEN:
######################################################################

# \
proc NOT_YET_WRITTEN: {} {}

proc j:ekb:vi:word_end { W K A } {}
proc j:ekb:vi:bol { W K A } {}
proc j:ekb:vi:dd { W K A } {}
proc j:ekb:vi:dw { W K A } {}
proc j:ekb:vi:d-eol { W K A } {}
proc j:ekb:vi:cc { W K A } {}
proc j:ekb:vi:cw { W K A } {}
proc j:ekb:vi:c-eol { W K A } {}
