# install as ~/.tk/jdocrc.tcl - sample jdoc customisation
#   reconfigures hypertext links to look like buttons
#   under Tk4, centres titles
######################################################################

# append code to the end of the jdoc:configure_text procedure
#   this will happen after auto_load of jdoc_util.tcl, because
#   this file is sourced in by the "j:jstools_init jdoc" command
#   in the jdoc:init procedure defined there.  (Translation: it's
#   kinda tricky, but it works.)

set configure_text_body [info body jdoc:configure_text]
append configure_text_body {
  $t tag configure jdoc:xref:link -underline 0 -borderwidth 1 -relief raised
  $t tag configure jdoc:xref:manpage -underline 0 -borderwidth 1 -relief raised
  j:tk4 {
    foreach level {0 1 2 3 4 5} {
      $t tag configure richtext:font:heading$level -justify center
    }
  }
}

proc jdoc:configure_text { { t .t } } $configure_text_body
