#include "global.h"
#include "header-aout.h"


class Symbols Symbols;
char *Symbols_Name = NULL;

class Breakpoints Breakpoints;


//***********************************************************************************************
//
// Symbols management
//
//***********************************************************************************************


Symbol::Symbol(U32 addr, U32 name, int type)
{
	Addr = addr;
	Name = name;
	Type = type;
	Next = NULL;
}

Symbol::~Symbol(void)
{
	delete Next;
}

Symbols::Symbols(void)
{
	First = NULL;
}

Symbols::~Symbols(void)
{
	delete First;
}

void Symbols::Clear(void)
{
	if (First != NULL)
		delete First;

	First = NULL;
}

void Symbols::Add(U32 addr, U32 name, int type)
{
class Symbol *ptr;
char *p;

	// skip GCC info
	if (strcmp(&Symbols_Name[name],"gcc2_compiled.") == 0)	return;
	if (strcmp(&Symbols_Name[name],"___gnu_compiled_c") == 0)	return;
	if (strcmp(&Symbols_Name[name],"___gnu_compiled_cplusplus") == 0)	return;
	if (strcmp(&Symbols_Name[name],"__etext") == 0)	return;
	if (strcmp(&Symbols_Name[name],"_etext") == 0)	return;
	if (strcmp(&Symbols_Name[name],"__end") == 0)	return;
	if (strcmp(&Symbols_Name[name],"__edata") == 0)	return;
	if (strcmp(&Symbols_Name[name],"__bss_start") == 0)	return;
	if (strcmp(&Symbols_Name[name],"_edata") == 0)	return;
	if (strcmp(&Symbols_Name[name],"_end") == 0)	return;
	for (p=&Symbols_Name[name]; *(p+1) != '\0'; p++)
		if (p[0]=='.' && p[1]=='o' && p[2]=='\0')
			return;


	if (First == NULL)
		First = new Symbol(addr, name, type);
	else {
		for(ptr = First; ptr->Next != NULL; ptr=ptr->Next)
			;

		ptr->Next = new Symbol(addr, name, type);
	}
}

char * Symbols::GetName(U32 addr)
{
class Symbol *ptr;

	for(ptr = First; ptr != NULL; ptr=ptr->Next)
		if (ptr->Addr == addr)
			return &Symbols_Name[ptr->Name];

	return NULL;
}

U32 Symbols::GetAddr(char *name)
{
class Symbol *ptr;

	for(ptr = First; ptr != NULL; ptr=ptr->Next)
		if (strcmp(&Symbols_Name[ptr->Name], name) == 0)
			return ptr->Addr;

	return (U32) 0;
}


//***********************************************************************************************
//
// Breakpoints management
//
//***********************************************************************************************


Breakpoint::Breakpoint(U32 addr)
{
	Addr = addr;
	Next = NULL;
}

Breakpoint::~Breakpoint(void)
{
	// does nothing because use during add/del process
}

Breakpoints::Breakpoints(void)
{
	First = NULL;
}

Breakpoints::~Breakpoints(void)
{
	delete First;
}

void Breakpoints::Clear(void)
{
	if (First != NULL)
		delete First;

	First = NULL;
}

void Breakpoints::Add(U32 addr)
{
class Breakpoint *ptr;

	for (ptr = First; ptr != NULL; ptr=ptr->Next)
		if (ptr->Addr == addr) {
			// do nothing if already exists
			return;
		}

	if (First == NULL)
		First = new Breakpoint(addr);
	else {
		for (ptr = First; ptr->Next != NULL; ptr=ptr->Next)
			;

		ptr->Next = new Breakpoint(addr);
	}
}


void Breakpoints::Del(U32 addr)
{
class Breakpoint *ptr, *tmp;


	if (First == NULL)
		return;

	if (First->Addr == addr) {
		tmp = First->Next;	
		delete First;
		First = tmp;
		return;
	}

	for (ptr = First; ptr->Next != NULL; ptr=ptr->Next)
		if (ptr->Next->Addr == addr) {
			tmp = ptr->Next->Next;
			delete ptr->Next;
			ptr->Next = tmp;
			return;
		}
}


//***********************************************************************************************
//
// Load a file
//
//***********************************************************************************************

static char err[200];

char *Load_File(char *name, U32 *dataAddr, U32 *start, U32 *entry)
{
struct tagHeader Header;
U8 *mem;
FILE *in;
long length;
int i,j,syms;
struct nlist sym;
U32 addr, data, text;


	if ((in = fopen(name,"r")) == NULL) {
		sprintf(err,"load : Can't open '%s'.",name);
		return err;
	}

	// compute length of file
	fseek(in, 0L, 2); // SEEK_END
	length = ftell(in);
	fseek(in, 0L, 0); //SEEK_SET

	// alloc memory for file
	mem = new U8[length+10];	

	
	// load file in mem
	i = 0;
	while (feof(in) == 0)
		mem[i++] = getc(in);

	fclose(in);
	

	// fill header struct
	Header.Magic           = Peek(0x00000000 , LONG , mem);
	Header.Text_Size       = Peek(0x00000004 , LONG , mem);
	Header.Data_Size       = Peek(0x00000008 , LONG , mem);
	Header.Bss_Size        = Peek(0x0000000C , LONG , mem);
	Header.Syms_Size       = Peek(0x00000010 , LONG , mem);
	Header.Entry_Addr      = Peek(0x00000014 , LONG , mem);
	Header.Text_Reloc_Size = Peek(0x00000018 , LONG , mem);
	Header.Data_Reloc_Size = Peek(0x0000001C , LONG , mem);

	// check if 68000 code

	if ((Header.Magic & 0x0000FFFF) != 0x010B  &&
		(Header.Magic & 0x0000FFFF) != 0x00CC) {
		fprintf(stderr,"[warning] load : '%s' is maybye not 680x0 executable.\n",name);
		// return err;
	}

	addr  = 0;
	addr += Header.Text_Size+Header.Data_Size+Header.Syms_Size;
	addr += Header.Text_Reloc_Size+Header.Data_Reloc_Size;


	// setup symbols names
	if (Symbols_Name != NULL)
		delete Symbols_Name;
	Symbols_Name = new char[Peek(addr , LONG , mem)+1];
	memcpy(Symbols_Name, &mem[addr+4], Peek(addr , LONG , mem));

	// load symbols
	syms = Header.Syms_Size / sizeof(struct nlist);
	addr  = 0;
	addr += Header.Text_Size+Header.Data_Size+Header.Text_Reloc_Size+Header.Data_Reloc_Size;

	Symbols.Clear();
	Breakpoints.Clear();
	text = data = 0xFFFFFFFF;   // to find the minimum
	for (j = 0; j < syms; j++) {	
		sym.n_un.n_strx = Peek(addr   , LONG , mem);
		sym.n_type      = Peek(addr+4 , BYTE , mem);
		sym.n_other     = Peek(addr+5 , BYTE , mem);
		sym.n_desc      = Peek(addr+6 , WORD , mem);
		sym.n_value     = Peek(addr+8 , LONG , mem);
		addr += sizeof(struct nlist);

		switch (sym.n_type & N_TYPE) {
			case N_BSS:
				break;

			case N_DATA:
				if (sym.n_value < data)
					data = sym.n_value;
	     	   	Symbols.Add(sym.n_value, sym.n_un.n_strx-4, DATA_TYPE);
			   	break;

			case N_TEXT:
				if (sym.n_value < text)
					text = sym.n_value;
     	   		Symbols.Add(sym.n_value, sym.n_un.n_strx-4, TEXT_TYPE);
			   	break;

			default :
		   		break;	/* ignore all other types */
		}
	}

	// load text section into memory
	memcpy(&Memory[text], &mem[sizeof(struct tagHeader)], Header.Text_Size);

	// load data section into memory
	addr = Header.Text_Size;
	if (*dataAddr == 0)
		*dataAddr = data;
	memcpy(&Memory[*dataAddr], &mem[addr], Header.Data_Size);

	// free temporary memory
	delete mem;

	// set up entry point
	*entry = Header.Entry_Addr;
	*start = text;

	return NULL;
}
