#include "global.h"
#include "exec.proto.h"
#include "dis.proto.h"


class tagOpcode Opcode_List[] =
   {
/*
** Group 0 : immediate logic + bit functions + MOVEP
*/
	// match 0000 0000 ssmm mrrr
	{68000, 0xFFFF, 0x003C, "ori       #%s,CCR", fn_ori_ccr, dis_ilogic_ccr},
	{68000, 0xFFFF, 0x007C, "ori       #%s,SR",  fn_ori_sr, dis_ilogic_sr},
	{68000, 0xFF00, 0x0000, "ori.%c     #%s,%s", fn_ori, dis_immediate},
	// match 0000 0010 ssmm mrrr
	{68000, 0xFFFF, 0x023C, "andi      #%s,CCR", fn_andi_ccr, dis_ilogic_ccr},
	{68000, 0xFFFF, 0x027C, "andi      #%s,SR",  fn_andi_sr, dis_ilogic_sr},
	{68000, 0xFF00, 0x0200, "andi.%c    #%s,%s", fn_andi, dis_immediate},
	// match 0000 0100 ssmm mrrr
	{68000, 0xFF00, 0x0400, "subi.%c    #%s,%s", fn_subi, dis_immediate},
	// match 0000 0110 ssmm mrrr
	{68000, 0xFF00, 0x0600, "addi.%c    #%s,%s", fn_addi, dis_immediate},
	// match 0000 1010 ssmm mrrr
	{68000, 0xFFFF, 0x0A3C, "eori      #%s,CCR", fn_eori_ccr, dis_ilogic_ccr},
	{68000, 0xFFFF, 0x0A7C, "eori      #%s,SR",  fn_eori_sr, dis_ilogic_sr},
	{68000, 0xFF00, 0x0A00, "eori.%c    #%s,%s", fn_eori, dis_immediate},
	// match 0000 1100 ssmm mrrr
	{68000, 0xFF00, 0x0C00, "cmpi.%c    #%s,%s", fn_cmpi, dis_immediate},
	// match 0000 1110 ssmm mrrr
//	{68010, 0xFF00, 0x0C00, "moves.%c   %s,%s", fn_moves, dis_moves},
	// match 0000 rrr1 oo00 1rrr
	{68000, 0xF138, 0x0108, "movep.%c   %s,%s", fn_movep, dis_movep},
	// match 0000 rrr1 ttmm mrrr (dyn) or 0000 1000 ttmm mrrr (stat)
	{68000, 0xF0C0, 0x0000, "btst.%c    %s,%s", fn_btst, dis_bitfn},
	{68000, 0xF0C0, 0x0040, "bchg.%c    %s,%s", fn_bchg, dis_bitfn},
	{68000, 0xF0C0, 0x0080, "bclr.%c    %s,%s", fn_bclr, dis_bitfn},
	{68000, 0xF0C0, 0x00C0, "bset.%c    %s,%s", fn_bset, dis_bitfn},

/*
** Group 1 2 3 : MOVE
*/
	// match 00ss xxxx xxxx xxxx
	{68000, 0xF000, 0x1000, "move%s.%c%s   %s,%s", fn_move, dis_move},
	{68000, 0xF000, 0x2000, "move%s.%c%s   %s,%s", fn_move, dis_move},
	{68000, 0xF000, 0x3000, "move%s.%c%s   %s,%s", fn_move, dis_move},



/*
** Group 4 : MISC
*/
	//match 0100 0000 xxxx xxxx
	{68000, 0xFFC0, 0x40C0, "move      %s,%s", 	fn_move_sr, dis_move_sr},
	{68000, 0xFF00, 0x4000, "negx.%c    %s", 	fn_negx, dis_std_unary_size},
	//match 0100 0010 xxxx xxxx
//	{68010, 0xFFC0, 0x42C0, "move      CCR,%s", fn_move_ccr, dis_move_ccr},
	{68000, 0xFF00, 0x4200, "clr.%c     %s", 	fn_clr, dis_std_unary_size},
	//match 0100 0100 xxxx xxxx
	{68000, 0xFFC0, 0x44C0, "move      %s,CCR", fn_move_ccr, dis_std_unary},
	{68000, 0xFF00, 0x4400, "neg.%c     %s", 	fn_neg, dis_std_unary_size},
	//match 0100 0110 xxxx xxxx
	{68000, 0xFFC0, 0x46C0, "move      %s,%s", 	fn_move_sr, dis_move_sr},
	{68000, 0xFF00, 0x4600, "not.%c     %s", 	fn_not, dis_std_unary_size},
	//match 0100 1000 xxxx xxxx
	{68020, 0xFFF8, 0x4808, "link      a%d,#%s",fn_link, dis_link},
	{68000, 0xFFC0, 0x4800, "nbcd.b    %s", 	fn_nbcd, dis_std_unary},
	{68000, 0xFFF8, 0x4840, "swap      d%d", 	fn_swap, dis_swap},
	{68000, 0xFFC0, 0x4840, "pea       %s", 	fn_pea, dis_std_unary},
	{68000, 0xFFB8, 0x4880, "ext.%c     d%d", 	fn_ext, dis_ext},
	//match 0100 1010 xxxx xxxx
	{68000, 0xFFFF, 0x4AFC, "illegal", 			fn_illegal, dis_direct},
	{68000, 0xFFC0, 0x4AC0, "tas       %s", 	fn_tas, dis_std_unary},
	{68000, 0xFF00, 0x4A00, "tst.%c     %s", 	fn_tst, dis_std_unary_size},
	//match 0100 1D00 1smm mrrr
	{68000, 0xFB80, 0x4880, "movem.%c   %s,%s", fn_movem, dis_movem},
	//match 0100 1110 xxxx xxxx
	{68000, 0xFFFF, 0x4E70, "reset", 			fn_reset, dis_direct},
	{68000, 0xFFFF, 0x4E71, "nop", 				fn_nop, dis_direct},
	{68000, 0xFFFF, 0x4E72, "stop      #%s", 	fn_stop, dis_stop},
	{68000, 0xFFFF, 0x4E73, "rte", 				fn_rte, dis_direct},
	{68000, 0xFFFF, 0x4E75, "rts", 				fn_rts, dis_direct},
	{68000, 0xFFFF, 0x4E76, "trapv", 			fn_trapv, dis_direct},
	{68000, 0xFFFF, 0x4E77, "rtr", 				fn_rtr, dis_direct},
	{68020, 0xFFFE, 0x4E7A, "movec     %s,%s", 	fn_movec, dis_movec},
	{68000, 0xFFF8, 0x4E50, "link      a%d,#%s",fn_link, dis_link},
	{68000, 0xFFF8, 0x4E58, "unlink    a%d", 	fn_unlink, dis_unlink},
	{68000, 0xFFF0, 0x4E40, "trap      #%d", 	fn_trap, dis_trap},
	{68000, 0xFFF0, 0x4E60, "move      %s,%s", 	fn_move_usp, dis_move_usp},
	{68000, 0xFFC0, 0x4E80, "jsr       %s", 	fn_jsr, dis_std_unary},
	{68000, 0xFFC0, 0x4EC0, "jmp       %s", 	fn_jmp, dis_std_unary},

	//match 0100 xxx1 xxxx xxxx
	{68000, 0xF1C0, 0x4180, "chk       %s,d%d", fn_chk, dis_std_ea_dn},
	{68000, 0xF1C0, 0x41C0, "lea       %s,a%d", fn_lea, dis_lea},
	

/*
** Group 5 : DB.. + S.. + ADDQ + SUBQ
*/
	{68000, 0xF0F8, 0x50C8, "db%s      %s,%s",   fn_dbcc, dis_dbcc},
	{68000, 0xF0C0, 0x50C0, "s%s       %s",		 fn_set, dis_scc},
	{68000, 0xF100, 0x5000, "addq.%c    #%s,%s", fn_addq, dis_arith_q},
	{68000, 0xF100, 0x5100, "subq.%c    #%s,%s", fn_subq, dis_arith_q},


/*
** Group 6 : B..
*/
	{68000, 0xF000, 0x6000, "b%s       %s", fn_bcc, dis_bcc},


/*
** Group 7 : MOVEQ
*/
	{68000, 0xF100, 0x7000, "moveq     #%s,d%d", fn_moveq, dis_moveq},


/*
** Group 8 : SBCD + DIV + OR
*/
	{68000, 0xF1F0, 0x8100, "sbcd.b    %s,%s",  fn_sbcd, dis_sbcd_abcd},
	{68000, 0xF1C0, 0x80C0, "divu      %s,d%d", fn_divu, dis_std_ea_dn},
	{68000, 0xF1C0, 0x81C0, "divs      %s,d%d", fn_divs, dis_std_ea_dn},
	{68000, 0xF000, 0x8000, "or.%c      %s,%s", fn_or, dis_std_ea_dn_swap},


/*
** Group 9 : SUB
*/
	{68000, 0xF0C0, 0x90C0, "suba.%c    %s,a%d", fn_suba, dis_suba_adda},
	{68000, 0xF130, 0x9100, "subx.%c    %s,%s",  fn_subx, dis_subx_addx},
	{68000, 0xF000, 0x9000, "sub.%c     %s,%s",  fn_sub, dis_std_ea_dn_swap},


/*
** Group A : trap LineA
*/

	{68000, 0xF000, 0xA000, "dc.w      0x%04x", fn_lineA, dis_lineAF},
	
/*
** Group B : CMP + EOR
*/
	{68000, 0xF0C0, 0xB0C0, "cmpa.%c    %s,%s", fn_cmpa, dis_cmpa},
	{68000, 0xF138, 0xB108, "cmpm.%c    (a%d)+,(a%d)+", fn_cmpm, dis_cmpm},
	{68000, 0xF100, 0xB000, "cmp.%c     %s,%s", fn_cmp, dis_std_ea_dn_swap},
	{68000, 0xF100, 0xB100, "eor.%c     %s,%s", fn_eor, dis_std_ea_dn_swap},


/*
** Group C : EXG + ABCD + MUL + AND
*/
	{68000, 0xF1F8, 0xC140, "exg       %s,%s",   fn_exg, dis_exg},
	{68000, 0xF1F8, 0xC148, "exg       %s,%s",   fn_exg, dis_exg},
	{68000, 0xF1F8, 0xC188, "exg       %s,%s",   fn_exg, dis_exg},
	{68000, 0xF1F0, 0xC100, "abcd.b    %s,%s",   fn_abcd, dis_sbcd_abcd},
	{68000, 0xF1C0, 0xC0C0, "mulu      %s,d%d",  fn_mulu, dis_std_ea_dn},
	{68000, 0xF1C0, 0xC1C0, "muls      %s,d%d",  fn_muls, dis_std_ea_dn},
	{68000, 0xF000, 0xC000, "and.%c     %s,%s",  fn_and, dis_std_ea_dn_swap},


/*
** Group D : ADD
*/
	{68000, 0xF0C0, 0xD0C0, "adda.%c    %s,a%d", fn_adda, dis_suba_adda},
	{68000, 0xF130, 0xD100, "addx.%c    %s,%s",  fn_addx, dis_subx_addx},
	{68000, 0xF000, 0xD000, "add.%c     %s,%s",  fn_add, dis_std_ea_dn_swap},


/*
** Group E : shifts
*/
	// match 1110 cccD ssIt trrr
	{68000, 0xFFC0, 0xE0C0, "asr.w     %s", 	 fn_asr_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE1C0, "asl.w     %s", 	 fn_asl_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE2C0, "lsr.w     %s", 	 fn_lsr_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE3C0, "lsl.w     %s", 	 fn_lsl_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE4C0, "roxr.w    %s", 	 fn_roxr_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE5C0, "roxl.w    %s", 	 fn_roxl_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE6C0, "ror.w     %s", 	 fn_ror_mem, dis_std_unary},
	{68000, 0xFFC0, 0xE7C0, "rol.w     %s", 	 fn_rol_mem, dis_std_unary},
	{68000, 0xF118, 0xE000, "asr.%c     %s,d%d", fn_asr, dis_shift},
	{68000, 0xF118, 0xE100, "asl.%c     %s,d%d", fn_asl, dis_shift},
	{68000, 0xF118, 0xE008, "lsr.%c     %s,d%d", fn_lsr, dis_shift},
	{68000, 0xF118, 0xE108, "lsl.%c     %s,d%d", fn_lsl, dis_shift},
	{68000, 0xF118, 0xE010, "roxr.%c    %s,d%d", fn_roxr, dis_shift},
	{68000, 0xF118, 0xE110, "roxl.%c    %s,d%d", fn_roxl, dis_shift},
	{68000, 0xF118, 0xE018, "ror.%c     %s,d%d", fn_ror, dis_shift},
	{68000, 0xF118, 0xE118, "rol.%c     %s,d%d", fn_rol, dis_shift},

/*
** Group F : trap LineF
*/

	{68000, 0xF000, 0xF000, "dc.w      0x%04x", fn_lineF, dis_lineAF},
	

	{68000, 0x0000, 0x0000, "", NULL, NULL}
};



//int Opcode_Group[] = { 0, 17, 18, 19, 20, 50, 54, 55, 56, 60, 63, 64, 68, 75, 78, 94, 95 };
//int Opcode_Group[] = { 0, 17, 18, 19, 20, 52, 56, 57, 58, 62, 65, 66, 70, 77, 80, 96, 97 };
//                     0  1   2   3   4   5   6   7   8   9   A   B   C   D   E   F   end
int Opcode_Group[] = { 0, 17, 18, 19, 20, 52, 56, 57, 58, 62, 65, 66, 70, 77, 80, 96, 97 };
