#include "global.h"


U32 Result;		// global variable used to transmit result of a peek in interface memory


//***********************************************************************************************
//
// Check memory
//
//***********************************************************************************************

int CheckMemory(int addr, int size, char rw, U32 poke)
{
class Part *ptr;


	for (ptr=MemoryMap.First; ptr!=NULL; ptr=ptr->Next) {
		// look if address in given area
		if (addr>=ptr->Start && addr<=ptr->End) {
			if ((ptr->Type == SRAM) && (rw=='w')) {
				// try to write in supervisor memory
				if ((CPU.SR->Value & 0x2000) == 0) {
					Exception(EXCEP_BUS);
					return TRUE;
				}
			}

			// if address in interface memory : call associated procedure
			if (ptr->Type == INTERFACE) {
				sprintf(what,"%s %s %s %d %d", ptr->Name,
								rw=='r'?"read":"write",
								size==BYTE?"byte":size==WORD?"word":"long", addr, poke);
				Tcl_Eval(output, what);
				if (sscanf(output->result,"%i",&Result) == 0) {
					sprintf(what,
						".info.text insert end \"WARNING : Problems in procedure '%s'.\n\"",
						ptr->Name);
					Tcl_Eval(output, what);
				}
				// cast result to wanted size
				switch (size) {
					case BYTE:	Result &= 0x000000FF;
					case WORD:	Result &= 0x0000FFFF;
				}
				return TRUE;
			}
			return FALSE;	// to be processed
		}
	}
	
	Exception(EXCEP_BUS);	// if not in memory : bus error
	return TRUE;
}


//***********************************************************************************************
//
// Peek & Poke routines
//
//***********************************************************************************************

U32 Peek(int offset, int size, unsigned char *base)
{
	Result = 0;

	if (CheckMemory(offset,size,'r',0))
		return Result;

	switch (size) {
		case BYTE:	Result  = base[offset];
					break;

		case WORD:	if ((offset & 0x00000001) && (CurrentModel == 68000)) {
						Exception(EXCEP_ADDR);		// data in Word Alignement on 68000
						return 0L;
					}
								  Result  = base[offset];
					Result <<= 8; Result |= base[offset+1] & 0x000000FF;
					break;

		case LONG:	if ((offset & 0x00000001) && (CurrentModel == 68000)) {
						Exception(EXCEP_ADDR);		// data in Word Alignement on 68000
						return 0L;
					}
								  Result  = base[offset];
					Result <<= 8; Result |= base[offset+1] & 0x000000FF;
					Result <<= 8; Result |= base[offset+2] & 0x000000FF;
					Result <<= 8; Result |= base[offset+3] & 0x000000FF;
	}

	return Result;
}

//
// Little routine to get the value of a byte of memory.
// Used for display & memout : result is 16 bits = 0xFF00 -> not real memory
//												   0x00?? -> value of memory
//

U16 GetPeek(int offset)
{
class Part *ptr;
int result=0;

	for (ptr=MemoryMap.First; ptr!=NULL; ptr=ptr->Next)
		if (offset>=ptr->Start && offset<=ptr->End) {
			if (ptr->Type == INTERFACE) {
				sprintf(what,"%s read byte %d 0", ptr->Name, offset);
				Tcl_Eval(output, what);
				sscanf(output->result, "%i", &result);
				return result & 0x00FF;
			} else
				return Memory[offset];
		}

	return 0xFF00;
}

//
// Little routine to set the value of a byte of memory.
// Used for memin. Does nothing if not in real memory.
//

void SetPoke(int offset, U32 value)
{
class Part *ptr;

	for (ptr=MemoryMap.First; ptr!=NULL; ptr=ptr->Next)
		if (offset>=ptr->Start && offset<=ptr->End) {
			if (ptr->Type == INTERFACE) {
				sprintf(what,"%s write byte %d", ptr->Name, offset);
				Tcl_Eval(output, what);
			} else
				Memory[offset] = value & 0x000000FF;
		}
}


void Poke(int offset, U32 value, int size, unsigned char *base)
{
int i;


	if (CheckMemory(offset,size,'w',value))
		return;

	switch (size) {
		case BYTE:	base[offset] = value & 0x000000FF;
					break;

		case WORD:	if ((offset & 0x00000001) && (CurrentModel == 68000)) {
						Exception(EXCEP_ADDR);		// data in Word Alignement on 68000
						return;
					}
								 base[offset+1] = value & 0x000000FF;
					value >>= 8; base[offset] = value & 0x000000FF;
					break;

		case LONG:	if ((offset & 0x00000001) && (CurrentModel == 68000)) {
						Exception(EXCEP_ADDR);		// data in Word Alignement on 68000
						return;
					}
								 base[offset+3] = value & 0x000000FF;
					value >>= 8; base[offset+2] = value & 0x000000FF;
					value >>= 8; base[offset+1] = value & 0x000000FF;
					value >>= 8; base[offset] = value & 0x000000FF;				
	}


	// look if poke affects memory dumping windows

	for (i=0; i<NB_DUMP; i++) {
		if (offset>= MD_start[i] && offset <= (MD_start[i]+MD_len[i])) {
			MD_where[i] = offset;
			MD_size[i] = size;
		}
	}
}



//***********************************************************************************************
//
// Error
//
//***********************************************************************************************

void Error(int type, int param, char *msg)
{
	switch (type) {
		case ERR_INVALID_EA:
			sprintf(what, ".info.text insert end \"'%s' : invalid effective address.\n\"", msg);
			Tcl_Eval(output, what);
			break;
		case ERR_INVALID_SIZE:
			sprintf(what, ".info.text insert end \"'%s' : invalid size.\n\"", msg);
			Tcl_Eval(output, what);
			break;
	}

	Exception(EXCEP_ILLEGAL);
}
