#include <stdio.h>
#include <stdlib.h>
#include <tk.h>

/*
** Types
*/

typedef unsigned int U32;
typedef int S32;
typedef unsigned short U16;
typedef short S16;
typedef unsigned char U8;
typedef char S8;


/*
** Defines
*/

#define TRUE -1
#define FALSE 0

#define BYTE 0
#define WORD 1
#define LONG 2

#define BITS(x,lo,nb) ( (x>>lo) & (0xFFFF >> (16-nb)) )


#define ERR_INVALID_EA			1
#define ERR_INVALID_SIZE		2


#define EXCEP_SSP		0
#define EXCEP_PC		1
#define EXCEP_BUS		2
#define EXCEP_ADDR		3
#define EXCEP_ILLEGAL	4
#define EXCEP_DIV		5
#define EXCEP_CHK		6
#define EXCEP_TRAPV		7
#define EXCEP_PROTECT	8
#define EXCEP_TRACE		9
#define EXCEP_LINE_A	10
#define EXCEP_LINE_F	11
					//  12-14 Reserved
#define EXCEP_NON_INIT	15
					//  16-23 Reserved
#define EXCEP_AUTO		24
					//  24-31 = 24+Level
#define EXCEP_TRAP		32
					//  32-47 = 32+Level
					//  48-63 Reserved
#define EXCEP_USER		64
					//  64_255 = user vectors


/*
** Opcodes
*/ 

class tagOpcode
{
public:

	int Model;
	U16 Mask;	// bit to keep
	U16 Value;	// matching pattern
	char *Name;
	void (*Exec)(void);
	void (*Dis)(char *);
};


extern int CurrentModel;
extern class tagOpcode Opcode_List[];
extern int Opcode_Group[];


/*
** Register
*/ 

class Register
{
public:
	U32 Value;
	U16 Changed;

public:
	virtual U32 Plus(int size);
	virtual U32 Minus(int size);
	virtual void Set(U32 value, int size);
};

class RegisterAddr : public Register
{
public:
	virtual void Set(U32 value, int size);
};

class RegisterSP : public RegisterAddr
{
public:
	virtual U32 Plus(int size);
	virtual U32 Minus(int size);
};


/*
** Status of MC68000
*/ 

class CPU
{
public:

	U32 PC;
	U32 PCTmp;

	class Register *SR;

	class Register *D[8];
	class Register *A[8];

	class Register *USP, *SSP;

	U32 VBR;

public:
	void Create(void);
	void Init(U32 pc, U32 usp, U32 ssp);
	void SetCCR(int C, int V, int Z, int N, int X);
};

extern class CPU CPU;


/*
** Memory
*/

class Part
{
public:
#define RAM        0x0000
#define SRAM	   0x0001
#define INTERFACE  0x0002

	int Type;
	U32 Start, End;
	char Name[100];
	class Part *Next;

	Part(U32 start, U32 end, int type, char *name);
	~Part(void);
};

class MemoryMap
{
public:
	class Part *First;

	MemoryMap(void);
	~MemoryMap(void);
	void Add(U32 start, U32 end, int type, char *name);
};

extern MemoryMap MemoryMap;
extern U8 *Memory;


/*
** Symbols
*/ 

class Symbol
{
public:
	class Symbol *Next;
	U32 Addr;
	U32 Name;
#define DATA_TYPE 0
#define TEXT_TYPE 1
	int Type;

	Symbol(U32 addr, U32 name, int type);
	~Symbol(void);
};

class Symbols
{
public:
	class Symbol *First;

	Symbols(void);
	~Symbols(void);
	void Clear(void);
	void Add(U32 addr, U32 name, int type);
	char *GetName(U32 addr);
	U32 GetAddr(char *name);
};

extern class Symbols Symbols;
extern char *Symbols_Name;


/*
** Breakpoints
*/ 

class Breakpoint
{
public:
	class Breakpoint *Next;
	U32 Addr;

	Breakpoint(U32 addr);
	~Breakpoint(void);
};

class Breakpoints
{
public:
	class Breakpoint *First;

	Breakpoints(void);
	~Breakpoints(void);
	void Clear(void);
	void Add(U32 addr);
	void Del(U32 addr);
};

extern class Breakpoints Breakpoints;


/*
** IPL management
*/

struct tagIPL
{
	int Vecteur : 8;
#define AUTO 0
#define VECT 1
	int Type : 1;
	int isWaiting : 1;
	int isMasked : 1;
};

extern struct tagIPL IPL[8];


/*
** Windows and their content
*/

#define NB_DUMP 2
extern U32 MD_start[NB_DUMP], MD_len[NB_DUMP], MD_where[NB_DUMP], MD_size[NB_DUMP];
extern Tcl_Interp *output;
extern char ErrorMsg[], what[];


/*
** Protocols
*/

#include "proto.h"


