	.text

|-------------------------------
| Modes d'adressages
|-------------------------------

modadr:	MOVE.L	#0xABCDEF12,D0
	MOVE.W	#0xABC,D7
	MOVE.B	#0xAB,D3

	MOVEA.W	D0,A6
	MOVEA.L	D0,A3

	MOVEA.L	#0x500,A0
	MOVEA.L	#0x600,A6

	lea	where,a0
	lea	pile,a7

	MOVE.B	D0,(A0)
	MOVE.W	D0,(A7)
	MOVE.L	D0,(A0)

	MOVE.B	D0,(A0)+
	MOVE.W	D0,(A7)+
	lea	where,a0
	MOVE.L	D0,(A0)+

	MOVE.B	D0,-(A0)
	MOVE.W	D0,-(A0)
	lea	where,a0
	MOVE.L	D0,-(A7)

	lea	space,a0
	lea	space,a7

	MOVE.B	D0,0x400(A0)
	MOVE.W	D0,0x2A0(A7)
	MOVE.L	D0,0x400(A0)

	MOVE.L	#0x124,D1
	MOVEA.L	#0x124,A1

	MOVE.B	D0,0x1A(A0,D1.W)
	MOVE.W	D0,0x26(A0,D1.L)
	MOVE.L	D0,0x34(A0,A1.W)

	MOVE.B	D0,addr
	MOVE.W	D0,addr
	MOVE.L	D0,addr

	MOVE.B	0x10(PC),D0
	MOVE.W	0x10(PC),D0
	MOVE.L	0x10(PC),D0

	MOVE.B	10(PC),D0
	MOVE.W	10(PC),D0
	MOVE.L	10(PC),D0

	MOVE.B	-10(PC),D0
	MOVE.W	-0x10(PC),D0
	MOVE.L	-0xAA(PC),D0


|-------------------------------
| arithmetique
|-------------------------------

calc:	moveq	#10,d7
	lea	arith,a0
	lea	arith,a4

	ADD.L	D7,(A0)
	ADD.L	#12345678,(A4)+

	moveq	#123,d0
	moveq	#456,d2
	moveq	#789,d6

	ADD.B	D2,D0
	ADD.W	A0,D6

	lea	arith,a5

	ADDA.W	#0x1234,A4
	ADDA.L	(A5)+,A0

	lea	arith,a2

	ADDI.B	#0x12,D7
	ADDI.W	#0xABCD,(A2)+
	ADDI.L	#0x12345678,addr


	moveq	#1234,d1
	lea	arith,a5

	ADDQ.B	#7,D1
	ADDQ.W	#2,A5
	ADDQ.L	#4,addr

	lea	where,a1

	ADDX.B	D1,D2
	ADDX.W	-(A1),-(A4)
	ADDX.L	D7,D6


	lea	arith,a0

	SUB.L	D7,(A0)
	SUB.L	#12345678,(A4)+
	SUB.B	D2,D0
	SUB.W	A0,D6


	SUBA.W	#0x1234,A4
	SUBA.L	(A5)+,A0


	SUBI.B	#0x12,D7
	SUBI.W	#0xABCD,(A2)+
	SUBI.L	#0x12345678,addr


	SUBQ.B	#7,D1
	SUBQ.W	#2,A5
	SUBQ.L	#4,addr


	SUBX.B	D1,D2
	SUBX.W	-(A1),-(A4)
	SUBX.L	D7,D6


	DIVS	addr,D1


	DIVU	addr,D1


	MULS	addr,D1


	MULU	addr,D1


	NEG.B	D1
	NEG.W	addr
	NEG.L	(A1)


	NEGX.B	D1
	NEGX.W	addr
	NEGX.L	(A1)


|-------------------------------
| comparaisons
|-------------------------------

comp:	moveq	#123,d1
	moveq	#345,d4
	moveq	#987,d7
	lea	where,a2

	CMP.B	D1,D4
	CMP.W	A2,D6
	CMP.L	addr,D7

	lea	where,a6

	CMP.W	A2,A6
	CMP.L	addr,A1

	lea	where,a1

	CMPI.B	#0xFF,(A1)
	CMPI.W	#0xFFFF,D2
	CMPI.L	#0xFFFFFFFF,addr


	CMPM.B	(A1)+,(A2)+
	CMPM.W	(A1)+,(A2)+
	CMPM.L	(A1)+,(A2)+

|-------------------------------
| tests
|-------------------------------

test:	lea	arith,a4

	TST.B	D1
	TST.W	(A4)+
	TST.L	addr

	TAS	addr


|-------------------------------
| clear
|-------------------------------

clear:	CLR.B	D2
	CLR.W	(A1)
	CLR.L	-(A2)

|-------------------------------
| extension de signe
|-------------------------------

extnd:	EXT.W	D1
	EXT.L	D6


|-------------------------------
| B.C.D.
|-------------------------------

bcd:	lea	where,a0
	lea	pile,a7
	lea	where,a1
	lea	pile,a5

	ABCD	D1,D2
	ABCD	D7,D4
	ABCD	-(A0),-(A7)
	ABCD	-(A5),-(A1)


	SBCD	D1,D2
	SBCD	D7,D4
	SBCD	-(A0),-(A7)
	SBCD	-(A5),-(A1)


	lea	arith,a4

	NBCD	D4
	NBCD	-(A4)



|-------------------------------
| Bits fonctions
|-------------------------------

bitfn:	moveq	#12,d4
	moveq	#-1,d6

	BCHG.L	D4,D6
	BCHG.B	#6,addr

	moveq	#-1,d6

	BCLR.L	D4,D6
	BCLR.B	#6,addr


	BSET.L	D4,D6
	BSET.B	#6,addr


	BTST.L	D4,D6
	BTST.B	#6,addr



|-------------------------------
| bizarre
|-------------------------------

|	CHK	(A1),D5
|	ILLEGAL
|	RESET
|	STOP	#0xFFFF
|	TRAP	#0x8
|	TRAPV



|-------------------------------
| logique
|-------------------------------

logic:	lea	where,a1
	move.l	#0xABCD3456,d5
	move.l	#0xAAAAAAAA,d2
	moveq	#-1,d4

	AND.B	(A1),D5
	AND.W	D2,addr
	AND.L	D2,D4


	lea	where,a2

	ANDI.B	#0xAB,addr
	ANDI.W	#0xABCD,D5
	ANDI.L	#0xABCDEF12,(A2)


	ANDI	#0x12,CCR


	ANDI	#0xABCD,SR


	OR.B	(A1),D5
	OR.W	D2,addr
	OR.L	D2,D4


	ORI.B	#0xAB,addr
	ORI.W	#0xABCD,D5
	ORI.L	#0xABCDEF12,(A2)


	ORI.B	#0x12,CCR


	ORI	#0xABCD,SR


	EOR.B	D2,addr
	EOR.W	D3,(A2)
	EOR.L	D6,-(A1)


	EORI.B	#0xAB,D2
	EORI.W	#0xABCD,D4
	EORI.L	#0xABCDEF12,addr


	EORI	#0x76,CCR


	EORI	#0xABCD,SR


	NOT.B	D4
	NOT.W	(A5)
	NOT.L	addr


|-------------------------------
| move(s)
|-------------------------------

bouge:	lea	where,a1

	MOVE.B	#0xea,D7
	MOVE.W	(A1),D0
	MOVE.L	A7,D4


	MOVEA.W	#0x7FFF,A0
	MOVEA.L	A1,A5


	MOVE	D2,CCR


	MOVE	SR,D7


	MOVE	D1,SR


	MOVE	A7,A0
	MOVE	A0,A7


|	MOVEC	SFC,D1
|	MOVEC	D1,DFC
|	MOVEC	D0,USP
|	MOVEC	VBR,D0


|	MOVEM	D0-D1/A0,-(A1)
|	MOVEM	(A0),D0-D2/A0


|	MOVEP.W	D0,10(A1)
|	MOVEP.L	10(A1),D0


	MOVEQ	#0x58,D7


|-------------------------------
| exchange
|-------------------------------

exg:	EXG	D1,D2
	EXG	D7,A1
	EXG	A4,A6


|-------------------------------
| ea + link
|-------------------------------

misc:	LEA	(A1),A0
	PEA	(A1)
	LINK	A0,#-0x12
	UNLK	A4


|-------------------------------
| shifts
|-------------------------------

shift:	ASL.B	D1,D2
	ASL.W	#0x8,D6
	ASL.W	addr

	ASR.B	D1,D2
	ASR.W	#0x5,D6
	ASR.W	addr

	LSL.B	D1,D2
	LSL.W	#0x5,D6
	LSL.W	addr

	LSR.B	D1,D2
	LSR.W	#0x5,D6
	LSR.W	addr

	ROL.B	D1,D2
	ROL.W	#0x1,D6
	ROL.W	addr

	ROR.B	D1,D2
	ROR.W	#0x2,D6
	ROR.W	addr

	ROXL.B	D1,D2
	ROXL.W	#0x6,D6
	ROXL.W	addr

	ROXR.B	D1,D2
	ROXR.W	#0x3,D6
	ROXR.W	addr


|-------------------------------
| swap
|-------------------------------

swap:	SWAP	D1



	.data

addr:	.long	0

arith:	.long	1234

	.long	0xFFFFFFFF
where:	.long	0x12345678
	.long	0x33557799

	.long	0x22446688
pile:	.long	0x12345678
	.long	0xAABBCCDD



space:	.space	1000,0

