set w .dialog
catch {destroy $w}
toplevel $w -class Dialog
wm minsize $w 1 1
wm title $w "Tutorial"
wm iconname $w "Tutorial"

frame $w.bottom
button $w.ok -text "Continue" -command "set tk_priv(button) 1"
frame $w.default -relief sunken -bd 1
raise $w.ok $w.default
pack $w.default -in $w.bottom -side left -expand 1 -padx 3m -pady 2m
pack $w.ok -in $w.default -padx 2m -pady 2m \
		    -ipadx 2m -ipady 1m
bind $w <Return> "$w.ok flash; set tk_priv(button) 1"
button $w.abort -text "Abort" -command "destroy $w"
pack $w.abort -in $w.bottom -side left -padx 3m -pady 3m -ipadx 2m -ipady 1m

#-yscrollcommand "$w.scroll set"
text $w.text -relief raised -bd 2 \
    -setgrid true -width 60 -height 15 -font -adobe-times-medium-r-*-*-*-140-*-*-*-*-*-*
#scrollbar $w.scroll -relief flat -command "$w.text yview"
pack $w.bottom -side bottom
#pack $w.scroll -side right -fill y
pack $w.text -side left -expand yes -fill both

# Set up display styles

$w.text tag configure tt -font -adobe-courier-medium-r-normal-*-140-*
$w.text tag configure bold -font -adobe-times-bold-r-*-*-*-140-*-*-*-*-*-*
$w.text tag configure big -font -adobe-times-medium-r-*-*-*-180-*-*-*-*-*-*
$w.text tag configure verybig -font -adobe-times-medium-r-*-*-*-240-*-*-*-*-*-*
$w.text tag configure color2 -foreground red


#------------------------------------------------------------------------------------------------
#
# Utility routines
#
#------------------------------------------------------------------------------------------------

proc pause {{clear 1}} {
global w tk_priv

    set oldFocus [focus]
    grab $w
    focus $w

    tkwait variable tk_priv(button)
    focus $oldFocus

    if {$clear == 1} {$w.text delete 1.0 end}
}

proc add {text args} {
global w

    set start [$w.text index insert]
    $w.text insert insert $text
    foreach tag [$w.text tag names $start] {
	$w.text tag remove $tag $start insert
    }
    foreach i $args {
	$w.text tag add $i $start insert
    }
}

proc addn {text args} {
global w

    set start [$w.text index insert]
    $w.text insert insert $text
    $w.text insert insert "\n"
    foreach tag [$w.text tag names $start] {
	$w.text tag remove $tag $start insert
    }
    foreach i $args {
	$w.text tag add $i $start insert
    }
}


proc center {text args} {
global w

    set i [expr 30 - [string length $text]/2]
    for {} {$i > 0} {incr i -1} { append new " " }
    append new $text
    addn $new $args
}

proc cmd {text} {
    add "\n"
    add "    " tt ; add $text tt
    add "\n\n"
}

proc title {text} {
    add $text big
    add "\n\n\n"
}



#------------------------------------------------------------------------------------------------
#
# USER DEVICE
#
#------------------------------------------------------------------------------------------------

set input 0

proc InitUser {} {
global input

    catch {destroy .user}
    toplevel .user
    wm title .user "Interface"
    wm iconname .user "User"

    button .user.go -width 10 -text "Gen IPL 2" -command \
                                                 {global interrupt ; genIPL 2 ; set interrupt 0}
    button .user.set -width 10 -text "Value set" -command {set thumb 0}
    scale .user.input -from 0 -to 255 -length 100 -orient vertical -command "set input"
    .user.input set 128

    pack .user.go .user.input .user.set -side top -padx 10 -pady 10
}

proc routine {RW size addr value} {
global input

    if {$RW == "read"} {
	return $input
    } else {
	.user.input set $value
    }
}


#------------------------------------------------------------------------------------------------
#
# WINDOWS
#
#------------------------------------------------------------------------------------------------


# Welcome
add "\n"
center "Welcome to" verybig ; center "the tutorial of Sim68k" verybig
add "\n\n"
addn "The aim of this tutorial is to show you on a simple example the
possibilities of this tools. All the steps will be discribed and you just
need to look what happend."
pause

# loading code
load $SIM68K_LIB/tutorial/tutorial.exe

title "Loading the code"
addn "To load an excutable in the simulator, just type :"
cmd "load <path>/tutorial.exe"
addn "This load the code, update the symbols table, reset
the registers, reset the exception table, and dump memory (data
section and code section)."
addn "The program counter (PC) is symbolised by the blue line."
pause

# running (moves)
runStep

title "Running one opcode"
addn "The run one opcode of the code, just click the button 'Step'
or type the command :"
cmd "runStep"
addn "This will execute the opcode pointed by the blue line (i.e. the PC)."
addn "The register affected by the instruction are hilighted with red.
Look for example at 'd0' wich contains the new value 0x20=32."
pause 0

runStep
addn "\nThe flag of the Status Register that are affected by 
the instruction are hilighted with red."
pause

title "Size of operation"
runStep
addn "The instruction can affect only the lowest word of a regsiter ..."
pause 0
runStep
addn "or even the lowest byte."
pause


# addressing modes
title "Complex addressing modes"
addn "You can use complex addressing modes."
runStep ; runStep
addn "You can see the 8 first bytes of the memory pointed
by an address register.\n"
pause 0
runStep
addn "You put -1 in 'd3'.\n"
pause 0
runStep
addn "You can see the bytes changed in memory : they are hilighted
in red. Note that the register 'a1' has been increased by 4."
pause


# arithmetic
title "Arithmetic"
addn "A simple addition.\n"
runStep
pause 0
runStep ; runStep ; runStep
addn "Just load 'd1' and 'd2' and multiply them.\n"
pause 0
addn "You can see the contents of a register in different
format : just click on his name and choose it.
For example in decimal."
ChangeDispData "%d" 2 ; refresh
pause


# bsr
title "Subroutine"
addn "When you are about to execute a BSR, JSR or TRAP instruction,
you have the choice in going into the subroutine or skipping it."
addn "You go in it by clicking 'Step' button,"
addn "you don't go in it by clicking 'Next' button.\n"
addn "We want know what does the 'bitfn' subroutine, look
into it.\n"
pause 0
runStep
addn "Here we are !"
addn "The PC is automaticaly centred in the source window."
pause


# bitfn
title "Bit functions"
runStep
addn "We swap 'd0'.\n"
pause 0
runStep
addn "We set the bit 3 of 'd0'. We can view this by choosing
to format 'd0' in binary. The binary value is output
in the default term."
ChangeDispData "bin" 0 ; refresh
pause 0
runStep
addn "And now we test the bit 24 ...\n"
ChangeDispData "0x%08X" 0 ; refresh
pause 0
add "Look at shifting functions. Before ..."
runStep ; runStep
ChangeDispData "bin" 1
pause 0
runStep
addn " after.\n"
ChangeDispData "0x%08X" 1 ; refresh
pause 0
add "Now we return from the routine. You can see the return value
in the stack (a7') : 0x0000102C. "
pause 0
runStep
addn "We are returned ..."
pause


# skipping BSR
title "Skipping a subroutine"
addn "It's very simple. Click on 'Next' button or type : "
cmd "runNoSub"
add "If we do this, we get ... "
pause 0
runNoSub
addn "the excepted result : 'a0' is cleared."
addn "You can look the code of the routine by using the scrollbar
in the source window."
pause


# bkpt in BCD
title "Setting a breakpoint"
addn "To set a breakpoint, simply click on the line contenting
the instruction. This action is a toggle : click one more
time to remove it. You can also type :"
cmd "bkpt add stop"
pause 0 ; bkpt add stop
addn "The location of the breakpoint is shown by highlighting
the text of the instruction in dark blue."
pause


# running until bkpt
title "Running until a breakpoint"
addn "You can run the code just stopping at breakpoints. To do
this click the 'Cont' (the 'Run' button will become 'Stop') :
or type :"
cmd "runGo" ;
runGo
addn "You will be stoped at the breakpoint. All the registers
changed during this execution are shown in red."
pause 0
add "\nNext instruction ... "
pause 0 ; runStep
add "next ... "
pause 0 ; runStep
add "next ... "
pause 0 ; runStep
add "next ... "
pause 0 ; runStep
addn "OK."
pause


# open peek and poke
title "Peek & Poke"
addn "You can examine/modify the memory with the peek
and poke routine."
addn "For example to change memory :"
cmd "poke 0x7000 1 2 3"
pause 0; poke 0x7000 1 2 3
addn "To poke three bytes. To poke a string (ASCII) :"
cmd "pokea 0x7000 \"Bonjour\""
pause 0; pokea 0x7000 "Bonjour"
addn "Simple !"
pause
title "Peek & Poke (2)"
addn "You can also poke words and longs with 'pokew'
 and 'pokel'."
addn "\nTo get a value, use 'peek' :"
cmd "peek 0x7000 long"
pause 0; set tmptmp [peek 0x7000 long]
global nbLineInfo
.info.text insert end $tmptmp; .info.text insert end "\n" ;
.info.text yview "end -$nbLineInfo lines"
addn "And you get the value in the information window."
pause


# save and read memory
title "Saving & Reading memory"
addn "You can read/save the memory in SRec, SWIFT, ascii
or raw format."
addn "\n\nRead the documentation for more informations."
pause


# open User window
title "Using 'interface device'"
addn "You can define addresses an 'interface memory' : when you try
to read or write them, the simulator call a routine you defined."
addn "\nFor example if you add :"
cmd "addinterface 0x10000000 0x10000000 routine"
addn "in your config file, you can do want you want when you access the
address 0x10000000."
add "\nIf we define a scale ... "
pause 0 ; InitUser
addn "we can see the value of the byte."
pause


# using user interface
title "Using the interface"
addn "You can look at the scale. When we write '3' in it ... "
pause 0
runStep ; runStep
addn "the value is updated !"
pause 0 ; runStep
pause 0 ; runStep
pause 0 ; runStep
pause 0 ; runStep
pause 0 ; runStep
pause 0 ; runStep
pause 0 ; runStep
addn "\nNow change the value in the scale by moving the thumb
with the mouse. Click on 'Value set' to continue."
grab .user ; focus .user
tkwait variable thumb
addn "\nWhen you now read the value in memory, we get ... "
pause 0 ; runStep
addn "the value you choose ! (in the lowest byte of 'd0')"
pause


# exceptions
title "Using exceptions"
addn "You can use exceptions. Now set set exception vector for
the interrut level 2, configured as vectorized : address of
vector is 0x100."
pause 0 ; runStep
addn "\nAfter this we set the value of SR register to allow all
interrupts."
pause 0 ; runStep
addn "\nWe now enter in an infinite loop. We use the auto-running
feature of the tool to execute the loop. All you need to do is
to look the code running and want you want just generate an
interrupt by clicking on 'Gen IPL 2' in the 'User' window." 
runInit
grab .user ; focus .user
tkwait variable interrupt


# exception
$w.text delete 1.0 end
title "Exception"
addn "The program indicates you that it has detected an interrupt of
the class USER. The other classes are BUS ERROR, TRAP, ..."
addn "You can see that the processor is now in supervisor state."
pause 0
add "\nNow execute the instructions ... "
pause 0 ; runStep
pause 0 ; runStep
addn "and return in the code."
pause 0 ; runStep
addn "We are now in the loop. We can execute one or two instructions
more, but we can now stop ..."
pause 0 ; runStep
pause 0 ; runStep
pause 0 ; runStep
addn "\nThis will end this short tutorial. Some features are not shown : 
saving memory in various formats, listing symbols or breakpoints, ...
Look the manuel for more details."
pause


# end
add "\n\n"
center "Thank you" verybig
add "\n\n\n\n"
addn "If you have any comments or suggestions, please contact me at :"
cmd "Laurent.Riesterer@reseau.galeode.fr"
addn "This program is shareware : if you enjoy it, just send me what you
think the program worth (even a postcard of your city with a beautiful 
stamp if possible). (address in the README file)"
pause


# quit tutorial
destroy $w
