#include "global.h"


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : bkpt ?(add|del) where?
//
// Action : add or delete a breakpoint or list them if no args
//
//-----------------------------------------------------------------------------------------------

int BreakpointCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
static char *usage = {"Usage : bkpt ?(add | del) where?"};
class Breakpoint *ptr;

int where;
char *name;


	//
	// if no args = list breakpoints
	//
	if (argc == 1) {
		for (ptr=Breakpoints.First; ptr != NULL; ptr=ptr->Next) {
			if ((name=Symbols.GetName(ptr->Addr)) != NULL)
				sprintf(what, ".info.text insert end \"Breakpoint at '%s'\n\"", name);
			else
				sprintf(what, ".info.text insert end \"Breakpoint at 0x%08X\n\"", ptr->Addr);
			Tcl_Eval(interp, what);
		}
		sprintf(interp->result, "All breakpoints listed.");
		return TCL_OK;
	} else if (argc != 3) {
		sprintf(interp->result, usage);
		return TCL_OK;
	}

	//
	// parsing where
	//
	if (!ParseAddr(interp,argv[2], &where, usage)) {
		sprintf(interp->result, ErrorMsg);
		return TCL_OK;
	}

	if (strcmp(argv[1],"add") == 0) {
		Breakpoints.Add(where);
	} else if (strcmp(argv[1],"del") == 0) {
		Breakpoints.Del(where);
	} else {
		sprintf(interp->result, usage);
		return TCL_OK;
	}

	sprintf(what, "UpdateBreakpoint \"0x%08X\" %s", where, argv[1]);
	Tcl_Eval(interp, what);

	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : BkptExist addr
//
// Action : return "yes" if breakpoint at given address exists
//
//-----------------------------------------------------------------------------------------------

int BkptExistCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
class Breakpoint *ptr;
int where;

	if (Tcl_GetInt(interp, argv[1], &where) != TCL_OK) {
		return TCL_ERROR;
	}


	for (ptr=Breakpoints.First; ptr != NULL; ptr=ptr->Next) {
		if (ptr->Addr == where) {
			sprintf(interp->result, "yes");
			return TCL_OK;
		}
	}

	sprintf(interp->result, "no");
	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : genIPL nb
//
// Action : generate a IPL interrupt at level nb
//
//-----------------------------------------------------------------------------------------------


int GenerateIPLCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
int nb;

	if (Tcl_GetInt(interp, argv[1], &nb) != TCL_OK) {
		sprintf(interp->result, "Usage : genIPL level");
		return TCL_OK;
	}

	if (nb<0 || nb>7) {
		sprintf(interp->result, "Bad level for IPL.");
		return TCL_OK;
	}

	IPL[nb].isWaiting = TRUE;

	if (*Tcl_GetVar(interp, "goOn", TCL_GLOBAL_ONLY) == '1')
		Tcl_Eval(interp, ".info.text insert end \"Interrupt demand registred.\n\"");
	return TCL_OK;
}


void TraitementIPL(int level)
{
U16 vector;
int number;

	IPL[level].isWaiting = FALSE;
	IPL[level].isMasked = FALSE;
	if (IPL[level].Type == AUTO)
		number = EXCEP_AUTO+level;
	else
		number = IPL[level].Vecteur;


	CPU.A[7] = CPU.SSP;			// switch to supervisor stack

	vector = (number*4 & 0x0FFFF);
	switch (number) {
		case EXCEP_CHK:
		case EXCEP_TRAPV:
		case EXCEP_TRACE:
		case EXCEP_DIV:
			Poke(CPU.A[7]->Minus(LONG), CPU.PC, LONG);		// instruction address
			vector |= 0x2000;
	}

	Poke(CPU.A[7]->Minus(WORD), vector, WORD);			// save format + vector
	Poke(CPU.A[7]->Minus(LONG), CPU.PCTmp, LONG);		// save context
	Poke(CPU.A[7]->Minus(WORD), CPU.SR->Value, WORD);
	
	CPU.SR->Value |= level<<8;	// set IPL level
	CPU.SR->Changed |= 0x0700;
	CPU.SR->Value |= 0x2000;	// only flag affected = S
	CPU.SR->Changed |= 0x2000;

	CPU.PC = CPU.PCTmp = Peek(number*4 , LONG);

	if (number>=EXCEP_TRAP && number<=EXCEP_TRAP+16)
		sprintf(what,".info.text insert end \"Exception TRAP.\n\"");
	else if (number>=EXCEP_AUTO && number<=EXCEP_AUTO+7)
		sprintf(what,".info.text insert end \"Exception AUTO.\n\"");
	else if (number>=EXCEP_USER)
		sprintf(what,".info.text insert end \"Exception USER.\n\"");
	else sprintf(what,".info.text insert end \"Exception %s.\n\"",
			number==EXCEP_BUS?"BUS ERROR":
			number==EXCEP_ADDR?"ADDRESS ERROR":
			number==EXCEP_ILLEGAL?"ILLEGAL":
			number==EXCEP_DIV?"DIVISION BY ZERO":
			number==EXCEP_CHK?"CHK":
			number==EXCEP_TRAPV?"TRAPV":
			number==EXCEP_PROTECT?"PRIVILEGE VIOLATION":
			number==EXCEP_LINE_A?"LINE A":
			number==EXCEP_LINE_F?"LINE F":
			number==EXCEP_TRAP?"TRAP":"????");
	Tcl_Eval(output, what);

	Tcl_Eval(output, "runStop");
}


void CheckIPL(void)
{
int i, currentIPL;


	currentIPL = (CPU.SR->Value >> 8) & 0x0007;

	// check IPL beginning with higher priority

	for (i=7; i>=0; i--) {
		if (IPL[i].isWaiting) {
			if (i==7) {
				sprintf(what, ".info.text insert end \"IPL level 7 detected. (no maskable)\n\"");
				Tcl_Eval(output, what);
				TraitementIPL(7);
				return;
			}				
			if (i>currentIPL) {
				if (IPL[i].isMasked)
					sprintf(what, ".info.text insert end \"IPL level %d was waiting. Now processing.\n\"",i);
				else
					sprintf(what, ".info.text insert end \"IPL level %d detected.  Processing.\n\"",i);
				Tcl_Eval(output, what);
				TraitementIPL(i);
				return;
			} else if (IPL[i].isMasked == FALSE) {
				sprintf(what, ".info.text insert end \"IPL level %d detected, but masked. Waiting before processing ...\n\"",i);
				Tcl_Eval(output, what);
				IPL[i].isMasked = TRUE;
				return;
			}
		}
	}
}
