#include "global.h"


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : dis start ?length?
//
// Action : disassamble from start. Length len, or 100 if omitted
//			start = 0x.....  ||  label   ||   register
//
//-----------------------------------------------------------------------------------------------


int DisassembleCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
static char *usage = {"Usage : dis start ?length?"};
extern char Text_Disassamble[];
U32 PC, stop;
int start, len;
char *result;


	if (argc < 2) {
		sprintf(interp->result, usage);
		return TCL_OK;
	}

	//
	// parsing start
	//
	if (!ParseAddr(interp,argv[1], &start, usage)) {
		sprintf(interp->result, ErrorMsg);
		return TCL_OK;
	}

	PC = (U32) start;

	//
	// get length if any
	//
	if (argc == 3) {
		if (Tcl_GetInt(interp, argv[2], &len) != TCL_OK) {
			sprintf(interp->result, "%s -> bad length", usage);
			return TCL_ERROR;
		}
	} else {
		result = Tcl_GetVar2(interp, "pref","Disassamble_Length",TCL_GLOBAL_ONLY);
		if (result == NULL)
			len = 256;
		else {
			if (Tcl_GetInt(interp, result, &len) != TCL_OK)
				len = 256;
		}
	}

	stop = PC + len;


	Tcl_Eval(interp, ".top.text.text delete 1.0 end");

	//
	// do it
	//
	while (PC < stop) {
		PC = Disassamble(PC);
		sprintf(what, ".top.text.text insert end \"%s\"", Text_Disassamble);
		Tcl_Eval(interp, what);
	}

	Tcl_Eval(interp, "UpdateSource");

	sprintf(interp->result, "Disassambled from 0x%08X to 0x%08X.", start, stop);
	return TCL_OK;
}
