#include "global.h"

static char tmp[100], s[50];


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : dump start ?length?
//
// Action : dump memory from start. Length len, or 160 if omitted
//			start = 0x.....  ||  label   ||   register
//
//-----------------------------------------------------------------------------------------------


U32 MD_start[NB_DUMP], MD_len[NB_DUMP], MD_where[NB_DUMP], MD_size[NB_DUMP];


int DumpCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
U8 c;
U16 peek;
int i, chaine, start, len;
U32 where;
int numero = (int) clientData;
char usage[100], *result;


	sprintf(usage, "Usage : md%d start ?length?", numero);

	if (argc < 2) {
		sprintf(interp->result, usage);
		return TCL_OK;
	}

	//
	// get start
	//
	if (!ParseAddr(interp,argv[1], &start, usage)) {
		sprintf(interp->result, ErrorMsg);
		return TCL_OK;
	}

	where = (U32) start;

	//
	// get length if any
	//
	if (argc == 3) {
		if (Tcl_GetInt(interp, argv[2], &len) != TCL_OK) {
			sprintf(interp->result, "%s -> bad length", usage);
			return TCL_OK;
		}
	} else {
		result = Tcl_GetVar2(interp, "pref","Dump_Length",TCL_GLOBAL_ONLY);
		if (result == NULL)
			len = 160;
		else {
			if (Tcl_GetInt(interp, result, &len) != TCL_OK)
				len = 160;
		}
	}


	i = chaine = 0;
	len = len - ((len-1)%16) + 16;	// align length

	MD_start[numero-1] = where;		// save location of dumping
	MD_len[numero-1] = len;

	//
	// clear window
	//
	sprintf(what, ".dump.md%d.text delete 1.0 end", numero);
	Tcl_Eval(interp, what);

	//
	// dump all lines
	//
	while (--len) {
		if ((i%16) == 0) {
			s[chaine] = '\0';
			chaine = 0;
			sprintf(tmp," %s\n0x%08X  ",s,where);
			sprintf(what, ".dump.md%d.text insert end \"%s\"", numero, tmp);
			Tcl_Eval(interp, what);
		}

		peek = GetPeek(where);
		c = peek & 0x00FF;
		where++;
		if (peek & 0xFF00) {
			s[chaine++] = ' ';
			sprintf(tmp,"**%s", where&1 ? "" : " ");
		} else {
			if (c != '"')
				s[chaine++] = (c>=32 && c<=127 ? c : '.');
			else {
				s[chaine++] = '\\';
				s[chaine++] = '"';
			}
			sprintf(tmp,"%02X%s",c, where&1 ? "" : " ");
		}
		i++;
		sprintf(what, ".dump.md%d.text insert end \"%s\"", numero, tmp);
		Tcl_Eval(interp, what);
	}
	sprintf(what, ".dump.md%d.text insert end \" %s\n\"", numero, s);
	Tcl_Eval(interp, what);
	sprintf(what, ".dump.md%d.text delete 1.0 2.0", numero);
	Tcl_Eval(interp, what);

	sprintf(interp->result, "Memory dumped from 0x%08X to 0x%08X in window %d.",
			MD_start[numero-1], where, numero);
	return TCL_OK;
}
