#include "global.h"


class MemoryMap MemoryMap;
U8 *Memory;
struct tagIPL IPL[8], IPLcfg[8] = {	{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE},
									{0,AUTO,FALSE,FALSE} };

int Total, Used;
extern initDone;


//-----------------------------------------------------------------------------------------------
//
// NEWS COMMANDS : addmemory start end type
//                 addinterface start end proc_name
//                 interrupt level vector
//
// Action : configure the memory & interrupts
//
//-----------------------------------------------------------------------------------------------


int AddMemoryCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
int start, end, type;

	if (argc != 4) {
		sprintf(interp->result, "Usage : addmemory start end type");
		return TCL_ERROR;
	}

	if (initDone) {
		sprintf(interp->result, "Initialiazation already done.");
		return TCL_ERROR;
	}

	//
	// parsing
	//
	if (Tcl_GetInt(interp, argv[1], &start) != TCL_OK) {
		sprintf(interp->result, "Usage : addmemory start end type");
		return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &end) != TCL_OK) {
		sprintf(interp->result, "Usage : addmemory start end type");
		return TCL_ERROR;
	}

	type = 0;
	if (strcmp(argv[3],"ram") == 0)			type = RAM;
	else if (strcmp(argv[3],"sram") == 0)	type = SRAM;
	else {
		sprintf(interp->result, "Usage : addmemory start end type -> bad type of memory");
		return TCL_ERROR;
	}

	Total = end>Total ? end : Total;
	Used += end-start+1;

	MemoryMap.Add(start,end,type,"");
	return TCL_OK;	
}

int AddInterfaceCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
int start, end;

	if (argc != 4) {
		sprintf(interp->result, "Usage : addinterface start end proc_name");
		return TCL_ERROR;
	}

	if (initDone) {
		sprintf(interp->result, "Initialiazation already done.");
		return TCL_ERROR;
	}

	//
	// parsing
	//
	if (Tcl_GetInt(interp, argv[1], &start) != TCL_OK) {
		sprintf(interp->result, "Usage : addinterface start end proc_name");
		return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &end) != TCL_OK) {
		sprintf(interp->result, "Usage : addinterface start end proc_name");
		return TCL_ERROR;
	}

	MemoryMap.Add(start,end, INTERFACE, argv[3]);
	return TCL_OK;	
}

int InterruptCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
static char *usage = {"Usage : interrupt level (auto | vector number)"};
int level, vector;

	if (argc != 3) {
		sprintf(interp->result, usage);
		return TCL_ERROR;
	}

	if (initDone) {
		sprintf(interp->result, "Initialiazation already done.");
		return TCL_ERROR;
	}

	//
	// parsing
	//
	if (Tcl_GetInt(interp, argv[1], &level) != TCL_OK) {
		sprintf(interp->result, usage);
		return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &vector) != TCL_OK) {
		if (strcmp(argv[2], "auto") != 0) {
			sprintf(interp->result, usage);
			return TCL_ERROR;
		} else {
			IPLcfg[level].Type = AUTO;
			IPLcfg[level].Vecteur = 0;
		}
	}

	IPLcfg[level].Type = VECT;
	IPLcfg[level].Vecteur = vector;
	
	return TCL_OK;	
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : start
//
// Action : allocate physical memory
//
//-----------------------------------------------------------------------------------------------

int StartsimCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
	if (!initDone) {
		Init_Memory();
	} else {
		fprintf(stderr, "Trying to reallocate the memory. Check your configuration files.\n");
	}

	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// Init memory (allocates physical memory) + init to do each time a file is loaded
//
//-----------------------------------------------------------------------------------------------

void Init_Memory(void)
{
	if (Total == 0)
		return;

	if ((Memory = (U8 *) malloc(Total+10)) == NULL) {
		fprintf(stderr, "Memory low ... plz reboot\n");
		exit(1);
	}
	memset((char *) Memory, 0, Total+10);

	initDone = TRUE;

	fprintf(stderr,"Memory configured : %d octets allocated, %d used.\n", Total+1, Used);
}


void Init_All(void)
{
int i;

	//
	// init exceptions tables
	//
	Poke(4*EXCEP_SSP      , 0x0000FF00, LONG);
	Poke(4*EXCEP_PC       , 0x00000400, LONG);
	Poke(4*EXCEP_BUS      , 0x00000400, LONG);
	Poke(4*EXCEP_ADDR     , 0x00000400, LONG);
	Poke(4*EXCEP_ILLEGAL  , 0x00000400, LONG);
	Poke(4*EXCEP_DIV      , 0x00000400, LONG);
	Poke(4*EXCEP_CHK      , 0x00000400, LONG);
	Poke(4*EXCEP_TRAPV    , 0x00000400, LONG);
	Poke(4*EXCEP_PROTECT  , 0x00000400, LONG);
	Poke(4*EXCEP_TRACE    , 0x00000400, LONG);
	Poke(4*EXCEP_LINE_A   , 0x00000400, LONG);
	Poke(4*EXCEP_LINE_F   , 0x00000400, LONG);
	Poke(4*EXCEP_NON_INIT , 0x00000400, LONG);
	for (i=0; i<8; i++)
		Poke(4*(EXCEP_AUTO+i), 0x00000400, LONG);
	for (i=0; i<16; i++)
		Poke(4*(EXCEP_TRAP+i), 0x00000400, LONG);
	for (i=0; i<192; i++)
		Poke(4*(EXCEP_USER+i), 0x00000400, LONG);

	Poke(0x00000400, 0x4E73, WORD);		// put RTE for default

	fprintf(stderr,"Exceptions initialized : all point to 0x400, address of a single RTE.\n");

	//
	// init IPL
	//
	for (i=0; i<8; i++) {
		IPL[i].Type = IPLcfg[i].Type;
		IPL[i].Vecteur = IPLcfg[i].Vecteur;
		IPL[i].isWaiting = FALSE;
		IPL[i].isMasked = FALSE;
		if (IPL[i].Type == AUTO)
			fprintf(stderr,"IPL %d = AUTO\n",i);
		else
			fprintf(stderr,"IPL %d = VECTOR %d\n",i,IPL[i].Vecteur);
	}
}



//***********************************************************************************************
//
// Memory map management
//
//***********************************************************************************************


Part::Part(U32 start, U32 end, int type, char *name)
{
	Start = start;
	End = end;
	Type = type;
	strcpy(Name, name);
	Next = NULL;
}

Part::~Part(void)
{
	delete Next;
}

MemoryMap::MemoryMap(void)
{
	First = NULL;
}

MemoryMap::~MemoryMap(void)
{
	delete First;
}

void MemoryMap::Add(U32 start, U32 end, int type, char *name)
{
class Part *ptr;

	if (First == NULL)
		First = new Part(start, end, type, name);
	else {
		for (ptr = First; ptr->Next != NULL; ptr=ptr->Next)
			if (   (start <= ptr->Start && end >= ptr->Start)
				|| (start <= ptr->End && end >= ptr->End) 
				|| (start <= ptr->Start && end >= ptr->End)) 
				fprintf(stderr,"WARNING : overlapping of memory.\n");

		ptr->Next = new Part(start, end, type, name);
	}
}
