#include "global.h"
#include <string.h>

//-----------------------------------------------------------------------------------------------


Tk_Window mainWindow;
char *display = NULL;
char *configFile = NULL;
char loadFile[200];
U32 loadDataAddr = 0;
char *cmdFile = NULL;
char *cmdLine = NULL;
int initDone;

int CurrentModel = 68000;		// model of CPU used (68000 or 68020)


//***********************************************************************************************
//
// Register new commands
//
//***********************************************************************************************

extern int DisassembleCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int DumpCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int RunCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int SRChangedCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int RegisterSetCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int AssociateCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int LoadCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int PeekCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int PokeCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int BreakpointCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int BkptExistCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int GenerateIPLCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int AddMemoryCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int AddInterfaceCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int InterruptCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int MemoutCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int MeminCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int StartsimCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int HookCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
extern int StopExecCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);

extern "C" int Sim68k_Init(Tcl_Interp *interp);

int Sim68k_Init(Tcl_Interp *interp)
{
extern int HookOpcode;
	output = interp;
	HookOpcode = TRUE;
	CPU.Create();
	Tcl_LinkVar(interp, "CurrentModel", (char *) &CurrentModel, TCL_LINK_INT);
	initDone = FALSE;


	Tcl_CreateCommand(interp, "dis", DisassembleCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "md", DumpCmd, (ClientData) 1,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "md1", DumpCmd, (ClientData) 1,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "md2", DumpCmd, (ClientData) 2,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "runStep", RunCmd, (ClientData) 0,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "runNoSub", RunCmd, (ClientData) 1,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "refresh", RunCmd, (ClientData) -1,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "assoc", AssociateCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "load", LoadCmd, (ClientData) 0,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "reload", LoadCmd, (ClientData) -1,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "peek", PeekCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "poke", PokeCmd, (ClientData) BYTE,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "pokew", PokeCmd, (ClientData) WORD,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "pokel", PokeCmd, (ClientData) LONG,
					  (Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "pokea", PokeCmd, (ClientData) -1,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "bkpt", BreakpointCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "genIPL", GenerateIPLCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "addmemory", AddMemoryCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "addinterface", AddInterfaceCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "interrupt", InterruptCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "memout", MemoutCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "memin", MeminCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "start", StartsimCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "hookOpcode", HookCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

//-----------------------------------------------------------------------------------------------
// private commands
//-----------------------------------------------------------------------------------------------
	Tcl_CreateCommand(interp, "SRChanged", SRChangedCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "RegisterSet", RegisterSetCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "BkptExist", BkptExistCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

	Tcl_CreateCommand(interp, "stopExec", StopExecCmd, (ClientData) NULL,
					  (Tcl_CmdDeleteProc *) NULL);

    return TCL_OK;
}
