#include "global.h"


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : SRChanged
//
// Action : 
//
//-----------------------------------------------------------------------------------------------

int SRChangedCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
char *set;
int ipl;
U32 sr = 0;

	set = Tcl_GetVar(interp, "flag_T", TCL_GLOBAL_ONLY);
	if (*set == 'T')  sr |= 0x8000;

	set = Tcl_GetVar(interp, "flag_S", TCL_GLOBAL_ONLY);
	if (*set == 'S')  sr |= 0x2000;

	set = Tcl_GetVar(interp, "flag_X", TCL_GLOBAL_ONLY);
	if (*set == 'X')  sr |= 0x0010;

	set = Tcl_GetVar(interp, "flag_N", TCL_GLOBAL_ONLY);
	if (*set == 'N')  sr |= 0x0008;

	set = Tcl_GetVar(interp, "flag_Z", TCL_GLOBAL_ONLY);
	if (*set == 'Z')  sr |= 0x0004;

	set = Tcl_GetVar(interp, "flag_V", TCL_GLOBAL_ONLY);
	if (*set == 'V')  sr |= 0x0002;

	set = Tcl_GetVar(interp, "flag_C", TCL_GLOBAL_ONLY);
	if (*set == 'C')  sr |= 0x0001;

	set = Tcl_GetVar(interp, "flag_IPL", TCL_GLOBAL_ONLY);
	sscanf(set, "%d", &ipl);
	sr |= ipl << 8;

	CPU.SR->Value = sr;
	if (CPU.SR->Value & 0x2000)
		CPU.A[7] = CPU.SSP;
	else
		CPU.A[7] = CPU.USP;

	Tcl_Eval(interp, "refresh");
	sprintf(interp->result, "Status Register changed.");
	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : RegisterSet
//
// Action : 
//
//-----------------------------------------------------------------------------------------------


int RegisterSetCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
int what, type, value, size;
char tmp[200];


	if (argc != 5) {
		interp->result = "wrong # args";
		return TCL_ERROR;
	}

	//
	// parsing what to be modified
	//
	if (Tcl_GetInt(interp, argv[1], &what) != TCL_OK)
		return TCL_ERROR;

	//
	// parsing type of value passed
	//
	if (Tcl_GetInt(interp, argv[2], &type) != TCL_OK)
		return TCL_ERROR;
	
	//
	// parsing new value
	//
	if (type == -1) {
		if (Tcl_GetInt(interp, argv[3], &value) != TCL_OK) {
			if ((value=Symbols.GetAddr(argv[3])) == 0)
				return TCL_ERROR; 
		}
	} else {
		if (type < 10)
			value = CPU.D[type]->Value;
		else if (type < 20)
			value = CPU.A[type-10]->Value;
		else if (type == 20)
			value = CPU.USP->Value;
		else if (type == 30)
			value = CPU.SSP->Value;
		else if (type == 40)
			value = CPU.SR->Value;
		else if (type == 41)
			value = CPU.SR->Value & 0x00FF;
		else if (type == 50)
			value = CPU.PC;
	}

	//
	// parsing the size
	//
	size = -1;
	if (strcmp(argv[4],"byte") == 0)
		size = BYTE;
	if (strcmp(argv[4],"word") == 0)
		size = WORD;
	if (strcmp(argv[4],"long") == 0)
		size = LONG;
	if (size == -1) {
		sprintf(tmp,
			".info.text insert end \"Usage : change what value ?size? -> bad size.\"");
		Tcl_Eval(interp, tmp);
		return TCL_OK;
	}

	if (what < 10)
		CPU.D[what]->Set(value, size);
	else if (what < 20)
		CPU.A[what-10]->Set(value, size);
	else if (what == 20)
		CPU.USP->Set(value, size);
	else if (what == 30)
		CPU.SSP->Set(value, size);
	else if (what == 40)
		CPU.SR->Set(value, size);
	else if (what == 41)
		CPU.SR->Set(value, size);
	else if (what == 50)
		CPU.PC = value;

	sprintf(tmp, ".info.text insert end \"Value changed.\"");
	Tcl_Eval(interp, tmp);
	return TCL_OK;
}

