#include "global.h"


void SetFlag(int nb, char *var, char *value, char *widget, Tcl_Interp *interp);
void DumpAn(U32 where, int num, Tcl_Interp *interp);
void UpdateDump(U32 where, int num, Tcl_Interp *interp);
void UpdateWindowDump(Tcl_Interp *interp);


static char tmp[100], *mem, s[50];
Tcl_Interp *output;

int goOn;


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : run or refresh
//
// Action : 
//
//-----------------------------------------------------------------------------------------------

int RunCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
extern void CheckIPL(void);
Breakpoint *ptr;
int i;
U32 stopPC;
extern char Text_Opcode[];
extern int ExceptionDetected;
	

	ExceptionDetected = FALSE;

	if (((int) clientData) == 0) {	// run one opcode
		Execute();
		if (ExceptionDetected) {
			sprintf(what, ".info.text insert end \"Stoped because of an exception.\n\"");
			Tcl_Eval(interp, what);
			Tcl_Eval(interp, "runStop");
		}
		for (ptr=Breakpoints.First; ptr != NULL; ptr=ptr->Next) {
			if (ptr->Addr == CPU.PC) {
				sprintf(what, ".info.text insert end \"Stoped because of breakpoint.\n\"");
				Tcl_Eval(interp, what);
				Tcl_Eval(interp, "runStop");
			}
		}
		CheckIPL();
	}

	if (((int) clientData) == 1) {		// run but don't go into sub routine
		CheckIPL();
		goOn = FALSE;
		stopPC = Disassamble(CPU.PC);
		if (Text_Opcode[0]=='b' && Text_Opcode[1]=='s' && Text_Opcode[2]=='r') goOn = TRUE; 
		if (Text_Opcode[0]=='j' && Text_Opcode[1]=='s' && Text_Opcode[2]=='r') goOn = TRUE; 
		if (Text_Opcode[0]=='t' && Text_Opcode[1]=='r' && Text_Opcode[2]=='a') goOn = TRUE; 

		Execute();
		while (goOn && !ExceptionDetected) {
			Execute();
			for (ptr=Breakpoints.First; ptr != NULL; ptr=ptr->Next) {
				if (ptr->Addr == CPU.PC) {
					sprintf(what, ".info.text insert end \"Stoped because of breakpoint.\n\"");
					Tcl_Eval(interp, what);
					Tcl_Eval(interp, "runStop");
				}
			}
			if (CPU.PC == stopPC)
				goOn = FALSE;
		}

		for (i=0; i<NB_DUMP; i++) {
			sprintf(what,"md%d %d %d", i, MD_start[0], MD_len[0]);
			Tcl_Eval(interp, what);
			MD_where[i] = 0;
		}
	}

	//------------------
	// Refresh interface
	//------------------

	// data register
	for (i=0; i<8; i++) {
		if (CPU.D[i]->Changed) {
			sprintf(tmp,"%d",i);
			sprintf(what,"%d",CPU.D[i]->Value);
			Tcl_SetVar2(interp, "D_val", tmp, what, TCL_GLOBAL_ONLY);
			sprintf(what, ".top.register.ad.data.regD(%d).val configure -foreground red", i);
			Tcl_Eval(interp, what);
		} else {
			sprintf(what, ".top.register.ad.data.regD(%d).val configure -foreground black", i);
			Tcl_Eval(interp, what);
		}
		CPU.D[i]->Changed = FALSE;
	}

	// address register expect A7
	for (i=0; i<7; i++) {
		if (CPU.A[i]->Changed) {
			sprintf(tmp,"%d",i);
			sprintf(what,"%d",CPU.A[i]->Value);
			Tcl_SetVar2(interp, "A_val", tmp, what, TCL_GLOBAL_ONLY);
			sprintf(what, ".top.register.ad.addr.regA(%d).val configure -foreground red", i);
			Tcl_Eval(interp, what);
		} else {
			sprintf(what, ".top.register.ad.addr.regA(%d).val configure -foreground black", i);
			Tcl_Eval(interp, what);
		}
		CPU.A[i]->Changed = FALSE;

		DumpAn(CPU.A[i]->Value, i, interp);
	}

	// A7 = USP
		if (CPU.USP->Changed) {
			sprintf(what,"%d",CPU.USP->Value);
			Tcl_SetVar2(interp, "A_val", "7", what, TCL_GLOBAL_ONLY);
			Tcl_Eval(interp, ".top.register.ad.addr.regA(7).val configure -foreground red");
		} else
			Tcl_Eval(interp, ".top.register.ad.addr.regA(7).val configure -foreground black");

		CPU.USP->Changed = FALSE;
		DumpAn(CPU.USP->Value, 7, interp);


	// A7' = SSP
		if (CPU.SSP->Changed) {
			sprintf(what,"%d",CPU.SSP->Value);
			Tcl_SetVar2(interp, "A_val", "8", what, TCL_GLOBAL_ONLY);
			Tcl_Eval(interp, ".top.register.ad.addr.regA(8).val configure -foreground red");
		} else
			Tcl_Eval(interp, ".top.register.ad.addr.regA(8).val configure -foreground black");

		CPU.SSP->Changed = FALSE;
		DumpAn(CPU.SSP->Value, 8, interp);


	// SR = Status Register
	sprintf(what,"%d", CPU.SR->Value);
	Tcl_SetVar(interp, "SR", what, TCL_GLOBAL_ONLY);
	SetFlag(0x0001, "flag_C", "C", ".top.register.status.sr.c", interp); 	//-- Carry
	SetFlag(0x0002, "flag_V", "V", ".top.register.status.sr.v", interp);	//-- Overflow
	SetFlag(0x0004, "flag_Z", "Z", ".top.register.status.sr.z", interp);	//-- Zero
	SetFlag(0x0008, "flag_N", "N", ".top.register.status.sr.n", interp);	//-- Negative
	SetFlag(0x0010, "flag_X", "X", ".top.register.status.sr.x", interp);	//-- Extend
	SetFlag(0x2000, "flag_S", "S", ".top.register.status.sr.s", interp);	//-- Supervisor
	SetFlag(0x8000, "flag_T", "T", ".top.register.status.sr.t", interp);	//-- Trace
	//-- Interrupt Level
	if (CPU.SR->Changed & 0x0100) {
		sprintf(what, "%d", (CPU.SR->Value & 0x0700)>>8);
		Tcl_SetVar(interp, "flag_IPL", what, TCL_GLOBAL_ONLY);
		Tcl_Eval(interp, ".top.register.status.sr.ipl configure -foreground red");
	} else {
		Tcl_Eval(interp, ".top.register.status.sr.ipl configure -foreground black");
	}
	CPU.SR->Changed = 0;	// SR done


	// PC = Program Counter
	sprintf(what,"%d", CPU.PC);
	Tcl_SetVar(interp, "PC", what, TCL_GLOBAL_ONLY);


	// Update dumping window if needed
	UpdateWindowDump(interp);


	// Update registers
	Tcl_Eval(interp, "UpdateRegister");
    

	Tcl_Eval(interp, ".info.text yview \"end -5 lines\"");  // WARNING def depend on nbLineInfo
	return TCL_OK;
}


void UpdateWindowDump(Tcl_Interp *interp)
{
int i, j;


	// Update dumping window if needed
	for (i=0; i<NB_DUMP; i++) {
		sprintf(what, ".dump.md%d.text tag delete poke", i+1);
		Tcl_Eval(interp, what);
		if (MD_where[i] != 0) {
			switch (MD_size[i]) {
				case BYTE:	UpdateDump(MD_where[i]  , i, interp);
							break;
				case WORD:	UpdateDump(MD_where[i]  , i, interp);
							UpdateDump(MD_where[i]+1, i, interp);
							break;
				case LONG:	UpdateDump(MD_where[i]  , i, interp);
							UpdateDump(MD_where[i]+1, i, interp);
							UpdateDump(MD_where[i]+2, i, interp);
							UpdateDump(MD_where[i]+3, i, interp);
							break;
				default:	// negative value = block of memory
							for (j=0; j<-MD_size[i]; j++)
								UpdateDump(MD_where[i]+j, i, interp);
			}			
			MD_where[i] = 0;
			sprintf(what, ".dump.md%d.text tag configure poke -foreground red", i+1);
			Tcl_Eval(interp, what);
		}
	}
}


//-----------------------------------------------------------------------------------------------
//
// Utility functions
//
//-----------------------------------------------------------------------------------------------


void SetFlag(int nb, char *var, char *value, char *widget, Tcl_Interp *interp)
{
	if (CPU.SR->Changed & nb) {
		if (CPU.SR->Value & nb)
			Tcl_SetVar(interp, var, value, TCL_GLOBAL_ONLY);
		else
			Tcl_SetVar(interp, var, ".", TCL_GLOBAL_ONLY);
		sprintf(tmp, "%s configure -foreground red", widget);
	} else {
		sprintf(tmp, "%s configure -foreground black", widget);
	}
	
	Tcl_Eval(interp, tmp);
}


void DumpAn(U32 where, int num, Tcl_Interp *interp)
{
U8 c;
U16 peek;
int len, chaine;


	len = 9;
	chaine = 0;
	mem = tmp;

	while (--len) {
		peek = GetPeek(where);
		c = peek & 0x00FF;
		where++;
		if (peek & 0xFF00) {
			s[chaine++] = ' ';
			sprintf(mem,"**%s", where&1 ? "" : " ");
		} else {
			s[chaine++] = (c>=32 && c<=127 ? c : '.');
			sprintf(mem,"%02X%s",c, where&1 ? "" : " ");
		}
 		mem = tmp + strlen(tmp);
	}
	s[chaine] = '\0';
	sprintf(what, "%s %s",tmp,s);
	sprintf(tmp, "%d", num);
	Tcl_SetVar2(interp, "A_mem", tmp, what, TCL_GLOBAL_ONLY);
}


void UpdateDump(U32 where, int num, Tcl_Interp *interp)
{
int ligne, nb, car;
static int offset_pair[]  =  {0,2, 5,7, 10,12, 15,17, 20,22, 25,27, 30,32, 35,37 };
static int offset_impair[] = {0, 3,5, 8,10, 13,15, 18,20, 23,25, 28,30, 33,35, 38};
U8 c;
int chaine = 0;


	ligne = 1 + (where - MD_start[num])/16;
	if (MD_start[num] & 0x00000001)
		nb = 12 + offset_impair[(where - MD_start[num])%16];
	else
		nb = 12 + offset_pair[(where - MD_start[num])%16];
	car = 53 + ((where - MD_start[num])%16);

	c = GetPeek(where) & 0x00FF;
	if (c != '"')
		s[chaine++] = (c>=32 && c<=127 ? c : '.');
	else {
		s[chaine++] = '\\';
		s[chaine++] = '"';
	}
	s[chaine] = '\0';

	//
	// Update hex value
	//
	sprintf(what, ".dump.md%d.text delete %d.%d %d.%d",num+1, ligne,nb,ligne,nb+2);
	Tcl_Eval(interp, what);
	sprintf(what, ".dump.md%d.text insert %d.%d \"%02X\"",num+1, ligne,nb,c);
	Tcl_Eval(interp, what);
	sprintf(what, ".dump.md%d.text tag add poke %d.%d %d.%d",num+1, ligne,nb,ligne,nb+2);
	Tcl_Eval(interp, what);

	//
	// Update character
	//
	sprintf(what, ".dump.md%d.text delete %d.%d",num+1, ligne,car);
	Tcl_Eval(interp, what);
	sprintf(what, ".dump.md%d.text insert %d.%d \"%s\"",num+1, ligne,car,s);
	Tcl_Eval(interp, what);
	sprintf(what, ".dump.md%d.text tag add poke %d.%d",num+1, ligne,car);
	Tcl_Eval(interp, what);
}

