#include "global.h"


char what[200];
char ErrorMsg[200];


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : assoc arg
//
// Action : if noarg		  ->  list all symbols
//			if  arg == label  ->  return addr
//		    if  arg == addr   ->  return label if any
//
//-----------------------------------------------------------------------------------------------

int AssociateCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
class Symbol *ptr;

int start;
char *name;

	//
	// if no argument list all symbols
	//
	if (argc == 1) {
		for (ptr=Symbols.First; ptr != NULL; ptr=ptr->Next) {
			sprintf(what, ".info.text insert end \"At 0x%08X is located '%s' (%s)\n\"",
					ptr->Addr, &Symbols_Name[ptr->Name], ptr->Type == DATA_TYPE?"data":"text");
			Tcl_Eval(interp, what);
		}
		sprintf(interp->result, "All symbols listed.");
		return TCL_OK;
	}

	if (Tcl_GetInt(interp, argv[1], &start) != TCL_OK) {
		if ((start=Symbols.GetAddr(argv[1])) == 0)
			sprintf(interp->result, "Unknow symbol '%s'.", argv[1]);
		else
			sprintf(interp->result, "Symbol '%s' located at 0x%08X.", argv[1], start);
	} else {
		if ((name=Symbols.GetName((U32) start)) == NULL)
			sprintf(interp->result, "No symbol at 0x%08X.", start);
		else
			sprintf(interp->result, "Symbol '%s' located at 0x%08X.", name, start);
	}		

	return TCL_OK;
}

//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : hookOpcode
//
// Action : set or unset the hook of opcode
//
//-----------------------------------------------------------------------------------------------

int HookCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
extern int HookOpcode;
int value;

	if (Tcl_GetInt(interp, argv[1], &value) != TCL_OK) {
		return TCL_OK;
	}

	if (value == 0) {
		HookOpcode = FALSE;
		sprintf(interp->result, "Hook desactived.");
	} else {
		HookOpcode = TRUE;
		sprintf(interp->result, "Hook actived. (procedure 'beforeOpcode' and 'afterOpcode')");
	}

	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : stopExec
//
// Action : stop execution
//
//-----------------------------------------------------------------------------------------------

int StopExecCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
extern int goOn;

	goOn = FALSE;
	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : load file
//
// Action : load file + set up symbol table + reset registers
//
//-----------------------------------------------------------------------------------------------

int LoadCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
static char *usage = {"Usage : load fileName ?dataAddr?"};
int where, default_usp, default_ssp;
U32 data;
U32 pc, start;
char *result;
extern char loadFile[];
extern U32 loadDataAddr;


	if (((int) clientData) == -1) {
		data = loadDataAddr;
		if ((result = Load_File(loadFile, &data, &start, &pc)) != NULL) {
			sprintf(what, ".info.text insert end \"%s\n\"", result);
			Tcl_Eval(interp, what);
			sprintf(interp->result, "");
			return TCL_OK;
		}
	} else {	
		if (argc < 2) {
			sprintf(interp->result, usage);
			return TCL_OK;
		}
	
		if (argc == 3) {
			if (!ParseAddr(interp,argv[2], &where, usage)) {
				sprintf(interp->result, ErrorMsg);
				return TCL_OK;
			}
		} else
			where = 0;

		loadDataAddr = data = (U32) where;
		if ((result = Load_File(argv[1], &data, &start, &pc)) != NULL) {
			sprintf(what, ".info.text insert end \"%s\n\"", result);
			Tcl_Eval(interp, what);
			sprintf(interp->result, "");
			return TCL_OK;
		}
		strcpy(loadFile, argv[1]);

		Tcl_SetVar(interp, "SourceName", argv[1], TCL_GLOBAL_ONLY);
	}

	// init CPU + exceptions tables + IPL + others
	result = Tcl_GetVar2(interp, "pref","Initial_USP",TCL_GLOBAL_ONLY);
	if (result == NULL)
		default_usp = 0x00000800;
	else {		
		if (Tcl_GetInt(interp, result, &default_usp) != TCL_OK)
			default_usp = 0x00000800;
	}
	result = Tcl_GetVar2(interp, "pref","Initial_SSP",TCL_GLOBAL_ONLY);
	if (result == NULL)
		default_ssp = 0x00000700;
	else {
		if (Tcl_GetInt(interp, result, &default_ssp) != TCL_OK)
			default_ssp = 0x00000700;
	}
	CPU.Init(pc, default_usp, default_ssp);
	Init_All();

	// resync windows with new value
	Tcl_SetVar(interp, "flag_T", ".", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_S", "S", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_IPL", "7", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_X", ".", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_N", ".", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_Z", ".", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_V", ".", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "flag_C", ".", TCL_GLOBAL_ONLY);

	sprintf(what, "%d", data);
	Tcl_SetVar(interp, "startDataSection", what, TCL_GLOBAL_ONLY);
	sprintf(what, "%d", start);
	Tcl_SetVar(interp, "startTextSection", what, TCL_GLOBAL_ONLY);

	sprintf(what, "md1 %d", data);
	Tcl_Eval(interp,what);
	sprintf(what, "md2 %d", start);
	Tcl_Eval(interp,what);
	sprintf(what, "dis %d", start);
	Tcl_Eval(interp,what);
	Tcl_Eval(interp,"refresh");

	sprintf(interp->result,"File '%s' loaded at 0x%08X (entry at 0x%08X). Data at 0x%08X.",
			loadFile, start, pc, data);
	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : poke where value ?value ...?
//
// Action : poke values in memory
//
//-----------------------------------------------------------------------------------------------

int PokeCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
static char *use[2] = {"Usage : poke where value ?value ...?","Usage : pokea where string"};
char *usage;
int size, start, i, value;
U32 where;


	size = (int) clientData;

	usage = size==-1 ? use[1] : use[0];

	if (argc < 3) {
		sprintf(interp->result, usage);
		return TCL_OK;
	}

	//
	// parsing start
	//
	if (!ParseAddr(interp,argv[1], &start, usage)) {
		sprintf(interp->result, ErrorMsg);
		return TCL_OK;
	}

	where = (U32) start;

	if (size==-1) {
		if (argc != 3) {
			sprintf(interp->result, usage);
			return TCL_OK;
		}

		for (i=0; i<strlen(argv[2]); i++) {
			Poke(where, argv[2][i], BYTE);
			where += 1;
		}
	} else {
		for (i=2; i<argc; i++) {
			if (Tcl_GetInt(interp, argv[i], &value) != TCL_OK) {
				sprintf(interp->result, "poke : error in value");
				return TCL_OK;
			}

			Poke(where, value, size);
			switch (size) {
				case BYTE:	where += 1; break;
				case WORD:	where += 2; break;
				case LONG:	where += 4; break;
			}
		}
	}

	// look if poke affects memory dumping windows

	for (i=0; i<NB_DUMP; i++) {
		if (start>=MD_start[i]  &&  start<=(MD_start[i]+MD_len[i])) {
			MD_where[i] = start;
			if (where<=(MD_start[i]+MD_len[i]))
				MD_size[i] = start-where;	// negative = block
			else
				MD_size[i] = start-(MD_start[i]+MD_len[i]);	// negative = block
		} else if (where>=MD_start[i]  &&  where<=(MD_start[i]+MD_len[i])) {
			MD_where[i] = MD_start[i];
			MD_size[i] = MD_start[i]-where;	// negative = block
		}
	}

	// update dumping windows + register dumping
	DumpAn(CPU.A[0]->Value, 0, interp);
	DumpAn(CPU.A[1]->Value, 1, interp);
	DumpAn(CPU.A[2]->Value, 2, interp);
	DumpAn(CPU.A[3]->Value, 3, interp);
	DumpAn(CPU.A[4]->Value, 4, interp);
	DumpAn(CPU.A[5]->Value, 5, interp);
	DumpAn(CPU.A[6]->Value, 6, interp);
	DumpAn(CPU.USP->Value,  7, interp);
	DumpAn(CPU.SSP->Value,  8, interp);
	UpdateWindowDump(interp);

	sprintf(interp->result, "Poked %d bytes starting at 0x%08X", where-start, start);
	return TCL_OK;
}


//-----------------------------------------------------------------------------------------------
//
// NEW COMMAND : peek where ?size?
//
// Action : peek values in memory
//
//-----------------------------------------------------------------------------------------------

int PeekCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
static char *usage = {"Usage : peek where ?size?"};
int start, format;
U32 where;
U32 result;


	if (argc < 2) {
		sprintf(interp->result, usage);
		return TCL_OK;
	}

	//
	// parsing where
	//
	if (!ParseAddr(interp,argv[1], &start, usage)) {
		sprintf(interp->result, ErrorMsg);
		return TCL_OK;
	}

	where = (U32) start;

	format = BYTE;	// default = byte

	if (argc == 3) {
		if (strcmp(argv[2], "byte") == 0)			format = BYTE;
		else if (strcmp(argv[2], "word") == 0)		format = WORD;
		else if (strcmp(argv[2], "long") == 0)		format = LONG;
		else {
			sprintf(interp->result, ErrorMsg);
			return TCL_OK;
		}
	}

	switch (format) {
		case BYTE:	result = GetPeek(where) & 0x00FF;
					sprintf(interp->result,"0x%02X",result);
					break;

		case WORD:				  result = GetPeek(where) & 0x00FF;
					result <<= 8; result |= GetPeek(where+1) & 0x00FF;
					sprintf(interp->result,"0x%04X",result);
					break;

		case LONG:				  result = GetPeek(where) & 0x00FF;
					result <<= 8; result |= GetPeek(where+1) & 0x00FF;
					result <<= 8; result |= GetPeek(where+2) & 0x00FF;
					result <<= 8; result |= GetPeek(where+3) & 0x00FF;
					sprintf(interp->result,"0x%08X",result);
					break;
	}

	return TCL_OK;
}




//***********************************************************************************************
//
// Utility routine for parsing an address.
// Format : (addr | label | register)
//
//***********************************************************************************************


int ParseAddr(Tcl_Interp *interp, char *argv, int *result, char *usage)
{
	if (Tcl_GetInt(interp, argv, result) == TCL_OK)
		return TRUE;	// was a numerical data

	if ((*result=Symbols.GetAddr(argv)) != 0)
		return TRUE;	// was a label name

	if (sscanf(argv,"a%d", result) != 0) {
		if (*result<0 || *result>7) {
			sprintf(ErrorMsg, "%s -> bad index for register a.", usage);
			return FALSE;
		}
		*result = CPU.A[*result]->Value;
		return TRUE;	// was a A? register
	}

	if (sscanf(argv,"d%d", result) != 0) {
		if (*result<0 || *result>7) {
			sprintf(ErrorMsg, "%s -> bad index for register d.", usage);
			return FALSE;
		}
		*result = CPU.D[*result]->Value;
		return TRUE;	// was a D? register
	}

	if (strcmp(argv,"pc") == 0) {
		*result = CPU.PC;
		return TRUE;	// was PC register
	}

	if (strcmp(argv,"usp") == 0) {
		*result = CPU.USP->Value;
		return TRUE;	// was USP register
	}

	if (strcmp(argv,"ssp") == 0) {
		*result = CPU.SSP->Value;
		return TRUE;	// was SSP register
	}

	sprintf(ErrorMsg, usage);
	return FALSE;		// error : not recognized
}
