/* 
 * forker.c
 * 
 * Creates a child process to received input from stdin;
 * sends input back to parent through a pipe when it has it.
 */

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
#include <stdio.h>
#include <stdlib.h>	/* free and exit */
#include <string.h>	/* strlen */
#include <sys/types.h>
#include <unistd.h>

#include <readline/readline.h>
int forker(int *pprintwfd, int *pchildpid);

extern void add_history(char *);	/* not prototyped?? */

#ifdef __cplusplus
};
#endif /* C++ */

#ifdef DEBUG 
#define DBG(a)	a
#else /* !DEBUG */
#define DBG(a)	/* nothing */
#endif /* DEBUG */

static int printrfd;

int forker(int *pprintwfd, int *pchildpid)
{   /* fork off a process to read from stdin, return the file number o
       of the readable end of a pipe where the input is coming from */
    pid_t pid;
    int fildes[2];
    int readfd, writefd;

    DBG((fprintf(stderr, "forker:entered\n")));
    DBG((fflush(stderr)));
    /* first pipe replaces stdin for parent */
    if(pipe(fildes)!=0)  {
	fprintf(stderr, "forker: pipe failed\n");
	return -1;
    }
    readfd = fildes[0];
    writefd = fildes[1];
    /* second pipe replaces stdout for prompt */
    if(pipe(fildes)!=0)  {
	fprintf(stderr, "forker: pipe2 failed\n");
	return -1;
    }
    printrfd = fildes[0];
    *pprintwfd = fildes[1];

    pid = fork();

    if(pid==-1) {
	fprintf(stderr, "forker: fork failed\n");
	return -1;
    } else if(pid == 0)  {
	/* child */
	/* endless readline loop */
	char prompt[128];
	char *line;
	int plen;

	/* wait for prompt from parent */
	plen = read(printrfd, prompt, 128-1);
	prompt[plen] = '\0';
	DBG((fprintf(stderr, "fk: got %d of prompt: %s\n", plen, prompt)));
	do {
	    /* prompt and wait for input */
	    line = readline(prompt);
	    if(line && *line)  {
		add_history(line);
		DBG((fprintf(stderr, "got '%s'\n", line)));
		write(writefd, line, strlen(line));
		/* wait for next prompt from parent */
		plen = read(printrfd, prompt, 128-1);
		prompt[plen] = '\0';
	    }
	    if(line)  free(line);
	} while( line!=NULL );

	exit(0);	/* had eol in line */

	/* don't return */
    } else {
	/* parent */
	*pchildpid = pid;
	return readfd;	/* where the main process should read */
    }
    return 0;	/* to silence compiler only */
}
