#!/usr/bin/wish
################ frames for storing our stuff ###################
frame .fore -width 4c -height 4c -relief groove -borderwidth 3
frame .back -width 4c -height 4c -relief groove -borderwidth 3
frame .sample -borderwidth 3 
label .sample.text -text "Some Sample Text"

######## entry fields that show the %02x values of the colors ### 
entry .fore.hex_val -width 10 -relief sunken -bd 2 -textvariable fore_hex
entry .back.hex_val -width 10 -relief sunken -bd 2 -textvariable back_hex

################ scales for the foreground picker ###############
label .fore.text -text Foreground
scale .fore.red -label Red -from 0 -to 255 -length 3c -orient horizontal -command NewForeColor
scale .fore.blue -label Blue -from 0 -to 255 -length 3c -orient horizontal -command NewForeColor
scale .fore.green -label Green -from 0 -to 255 -length 3c -orient horizontal -command NewForeColor

################ scales for the background picker ################
label .back.text -text Background
scale .back.red -label Red -from 0 -to 255 -length 3c -orient horizontal -command NewBackColor
scale .back.blue -label Blue -from 0 -to 255 -length 3c -orient horizontal -command NewBackColor
scale .back.green -label Green -from 0 -to 255 -length 3c -orient horizontal -command NewBackColor

pack .fore.text .back.text -side top
pack .fore.hex_val .back.hex_val -side top
pack .sample.text -anchor center -fill both -expand true
foreach f {fore back} {
	foreach s {red green blue} {
		pack .$f.$s -side top -padx 2 -pady 2
	}
}
pack .sample -pady 5 -padx 5 -expand true -fill both -side bottom 
pack .fore .back -side left -padx 5 -pady 5 -expand true 

proc NewForeColor value {
	global fore_hex
	set color [format #%02x%02x%02x [.fore.red get] [.fore.green get] [.fore.blue get]]
	.sample.text config -foreground $color
	set fore_hex $color 
}

proc NewBackColor value {
	global back_hex
	set color [format #%02x%02x%02x [.back.red get] [.back.green get] [.back.blue get]]
	.sample config -background $color
	.sample.text config -background $color
	set back_hex $color
}
